/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIValue;
import ro.sync.ecss.component.editor.ab;
import ro.sync.ecss.component.editor.x;
import ro.sync.ecss.conditions.b.c;
import ro.sync.ecss.conditions.b.d;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.ui.application.gc;
import ro.sync.ui.application.q;
import ro.sync.ui.dd;
import ro.sync.ui.theme.f;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class PopupListEditor
extends AbstractInplaceEditor {
    private static final Logger urd = Logger.getLogger((String)PopupListEditor.class.getName());
    private static final int rrd = 5;
    private final JList prd;
    private List<CIValue> trd;
    private Map<CIValue, d> wrd;
    private gc lrd;
    private KeyAdapter xrd;
    private FocusAdapter nrd;
    private ListSelectionListener krd;
    private MouseAdapter vrd;
    private int mrd;
    private java.awt.Font jrd;
    private List<String> ord;
    private x qrd = new x();
    private Comparator<CIValue> srd = new Comparator<CIValue>(){

        public int b(CIValue cIValue, CIValue cIValue2) {
            return -PopupListEditor.this.qrd.e(cIValue, cIValue2);
        }
    };

    public PopupListEditor() {
        this.prd = new JList(new DefaultListModel()){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (PopupListEditor.this.mrd >= 0) {
                    Rectangle rectangle = this.getCellBounds(PopupListEditor.this.mrd, PopupListEditor.this.mrd);
                    Color color = UIManager.getColor("List.selectionBackground");
                    if (color == null) {
                        color = Color.GRAY;
                    }
                    graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 32));
                    graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 2);
                    graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 64));
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 2, rectangle.height - 1);
                }
            }

            @Override
            public JToolTip createToolTip() {
                ro.sync.ui.c.c c2 = new ro.sync.ui.c.c();
                c2.setComponent(this);
                return c2;
            }
        };
        this.prd.getSelectionModel().setSelectionMode(0);
        this.jrd = this.prd.getFont();
        this.prd.setCellRenderer(new ro.sync.ui.application.d(this.prd.getCellRenderer()){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                d d2;
                String string = ((CIValue)object).getValue();
                if (PopupListEditor.this.ord != null && !PopupListEditor.this.ord.isEmpty()) {
                    string = (String)PopupListEditor.this.ord.get(PopupListEditor.this.trd.indexOf(object));
                }
                if (string == null || string.length() == 0) {
                    string = "[Empty]";
                }
                JComponent jComponent = (JComponent)super.getListCellRendererComponent(jList, string, n2, bl, bl2);
                if (PopupListEditor.this.wrd != null && (d2 = (d)PopupListEditor.this.wrd.get(object)) != null) {
                    JLabel jLabel = new JLabel(string){

                        @Override
                        public void paint(Graphics graphics) {
                            super.paint(graphics);
                            c.b(this, graphics, d2);
                        }
                    };
                    if (jComponent instanceof JLabel) {
                        jLabel.setFont(jComponent.getFont());
                        jLabel.setForeground(jComponent.getForeground());
                        jLabel.setBackground(jComponent.getBackground());
                    }
                    jLabel.setOpaque(true);
                    c.c(jLabel, d2, true);
                    jComponent = jLabel;
                }
                jComponent.setToolTipText(((CIValue)object).getAnnotation());
                jComponent.setBorder(q.k(jComponent.getBorder(), q.d(0, 5, 0, 5)));
                return jComponent;
            }
        });
        this.xrd = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    PopupListEditor.this.cancelEditing();
                } else if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                    keyEvent.consume();
                    PopupListEditor.this.sxc(false, true);
                }
            }
        };
        this.nrd = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PopupListEditor.this.fireCommitValue(new EditingEvent((String)PopupListEditor.this.getValue()));
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                PopupListEditor.this.prd.ensureIndexIsVisible(PopupListEditor.this.prd.getSelectedIndex());
            }
        };
        this.krd = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PopupListEditor.this.fireEditingOccured();
                }
            }
        };
        this.vrd = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    mouseEvent.consume();
                    PopupListEditor.this.stopEditing();
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n2 = PopupListEditor.this.mrd;
                PopupListEditor.this.mrd = PopupListEditor.this.prd.locationToIndex(mouseEvent.getPoint());
                if (PopupListEditor.this.mrd != -1) {
                    PopupListEditor.this.prd.repaint(PopupListEditor.this.prd.getCellBounds(PopupListEditor.this.mrd, PopupListEditor.this.mrd));
                }
                if (PopupListEditor.this.mrd != n2) {
                    PopupListEditor.this.prd.repaint(PopupListEditor.this.prd.getCellBounds(n2, n2));
                }
            }
        };
    }

    private void uxc(AuthorInplaceContext authorInplaceContext) {
        Font font;
        Object object;
        DefaultListModel defaultListModel = (DefaultListModel)this.prd.getModel();
        defaultListModel.clear();
        this.trd = (List)authorInplaceContext.getArguments().get("values");
        this.ord = (List)authorInplaceContext.getArguments().get("labels");
        List list = (List)authorInplaceContext.getArguments().get("styles");
        if (list != null) {
            this.wrd = new HashMap<CIValue, d>();
            for (int i2 = 0; i2 < this.trd.size(); ++i2) {
                object = null;
                if (i2 < list.size()) {
                    object = (d)list.get(i2);
                }
                this.wrd.put(this.trd.get(i2), (d)object);
            }
        }
        if ((font = (Font)authorInplaceContext.getArguments().get("font")) != null) {
            this.prd.setFont(new java.awt.Font(font.getName(), 0, font.getSize()));
        } else {
            this.prd.setFont(this.jrd);
        }
        object = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (object != null) {
            this.prd.setForeground(new Color(((ro.sync.exml.view.graphics.Color)object).getRed(), ((ro.sync.exml.view.graphics.Color)object).getGreen(), ((ro.sync.exml.view.graphics.Color)object).getBlue(), ((ro.sync.exml.view.graphics.Color)object).getAlpha()));
        }
        Object object2 = authorInplaceContext.getArguments().get("editorSort");
        this.qrd.d(this.trd);
        this.qrd.b(this.ord);
        if ("ascending".equals(object2)) {
            Collections.sort(this.trd, this.qrd);
            Collections.sort(this.ord, ab.c);
        } else if ("descending".equals(object2)) {
            Collections.sort(this.trd, this.srd);
            Collections.sort(this.ord, ab.b);
        }
        this.prd.addKeyListener(this.xrd);
        this.prd.addFocusListener(this.nrd);
        this.prd.getSelectionModel().addListSelectionListener(this.krd);
        this.prd.addMouseListener(this.vrd);
        this.prd.addMouseMotionListener(this.vrd);
        Border border = q.d(5, 0, 5, 0);
        int n2 = ab.d(authorInplaceContext);
        if (n2 > 0 && this.trd.size() > n2) {
            this.lrd = new gc(this.prd, 20, 31);
            this.lrd.getVerticalScrollBar().setBlockIncrement(5);
            this.lrd.getVerticalScrollBar().setUnitIncrement(5);
            ArrayList<Component> arrayList = new ArrayList<Component>();
            arrayList.add(this.prd);
            this.lrd.setFocusTraversalPolicy(new dd(this.lrd, arrayList, arrayList.isEmpty() ? null : (Component)arrayList.get(0), false));
            this.lrd.setFocusTraversalPolicyProvider(true);
            this.prd.setBorder(border);
        } else if (!ro.sync.ui.theme.d.getInstance().isHighContrastTheme()) {
            this.prd.setBorder(q.k(q.e(f.b(ro.sync.ui.theme.d.getInstance().getTextForegroundColor()), 1), border));
        }
        this.zxc(authorInplaceContext, this.trd, true);
    }

    private void zxc(AuthorInplaceContext authorInplaceContext, List<CIValue> list, boolean bl) {
        DefaultListModel defaultListModel = (DefaultListModel)this.prd.getModel();
        String string = (String)authorInplaceContext.getArguments().get("initial_value");
        if (urd.isDebugEnabled()) {
            urd.debug((Object)("initialValue " + string));
        }
        String string2 = (String)authorInplaceContext.getArguments().get("default_value");
        if (urd.isDebugEnabled()) {
            urd.debug((Object)("defaultValue " + string2));
        }
        CIValue cIValue = new CIValue(string != null ? string : string2);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            CIValue cIValue2 = list.get(i2);
            if (bl) {
                defaultListModel.addElement(cIValue2);
            }
            if (!cIValue2.getInsertString().equals(cIValue)) continue;
            cIValue = cIValue2;
            if (!bl) break;
        }
        this.prd.setSelectedValue(cIValue, true);
    }

    @Override
    public String getDescription() {
        return "A renderer that uses checkboxes to allow multiple selection.";
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, ro.sync.exml.view.graphics.Rectangle rectangle, Point point) {
        this.uxc(authorInplaceContext);
        Dimension dimension = null;
        if (this.lrd != null && this.prd.getModel().getSize() > 0) {
            Component component = this.prd.getCellRenderer().getListCellRendererComponent(this.prd, this.prd.getModel().getElementAt(0), 0, false, false);
            Dimension dimension2 = component.getPreferredSize();
            dimension = this.prd.getPreferredSize();
            int n2 = ab.d(authorInplaceContext);
            dimension.height = dimension2.height * n2 + 10;
            dimension.width += this.lrd.getVerticalScrollBar().getPreferredSize().width;
        } else {
            dimension = this.prd.getPreferredSize();
        }
        if (point != null) {
            rectangle.x = point.x;
        }
        rectangle.y += rectangle.height;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        return this.lrd != null ? this.lrd : this.prd;
    }

    @Override
    public void requestFocus() {
        this.prd.requestFocus();
    }

    @Override
    public Object getValue() {
        String string = null;
        if (this.prd.getSelectedIndex() != -1) {
            string = ((CIValue)this.prd.getSelectedValue()).getInsertString();
        }
        return string;
    }

    @Override
    public void stopEditing() {
        this.sxc(true, false);
    }

    private void sxc(boolean bl, boolean bl2) {
        this.prd.removeKeyListener(this.xrd);
        this.prd.removeFocusListener(this.nrd);
        this.prd.getSelectionModel().removeListSelectionListener(this.krd);
        this.prd.removeMouseListener(this.vrd);
        this.prd.removeMouseMotionListener(this.vrd);
        if (bl2) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent((String)this.getValue(), bl));
        }
    }

    @Override
    public void cancelEditing() {
        this.prd.removeKeyListener(this.xrd);
        this.prd.removeFocusListener(this.nrd);
        this.prd.getSelectionModel().removeListSelectionListener(this.krd);
        this.prd.removeMouseListener(this.vrd);
        this.prd.removeMouseMotionListener(this.vrd);
        this.fireEditingCanceled();
    }

    @Override
    public ro.sync.exml.view.graphics.Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.zxc(authorInplaceContext, this.trd, false);
    }
}

