/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.component.editor.cb;
import ro.sync.ecss.component.editor.y;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.ecss.extensions.commons.editor.InplaceEditorUtil;
import ro.sync.exml.m;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.yb;
import ro.sync.ui.dd;
import ro.sync.ui.h.d;
import ro.sync.ui.h.g;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DatePickerEditor
extends AbstractInplaceEditor
implements InplaceRenderer,
y {
    private static final Logger zpd = Logger.getLogger((String)DatePickerEditor.class.getName());
    protected static final yb messages = m.e();
    private String upd = "custom";
    private String xpd;
    private d spd;
    private g ypd;
    private java.awt.Font rpd;
    private String wpd;
    private DocumentListener bqd = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }
    };
    private KeyAdapter aqd;
    private Color vpd;
    private Boolean tpd;

    public DatePickerEditor() {
        this.ypd = new g(null);
        this.spd = new d(null, null, null, this.ypd, null);
        ArrayList<Component> arrayList = new ArrayList<Component>(1);
        arrayList.add(this.ypd);
        this.spd.setFocusTraversalPolicy(new dd(this.spd, arrayList, this.ypd, false));
        this.spd.setFocusTraversalPolicyProvider(true);
        this.aqd = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    DatePickerEditor.this.cancelEditing();
                } else if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                    DatePickerEditor.this.rvc(false, true);
                }
            }
        };
        this.rpd = this.spd.getFont();
        this.vpd = this.ypd.n();
    }

    @Override
    public String getDescription() {
        return "A date picker.";
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, Rectangle rectangle, Point point) {
        this.zvc(authorInplaceContext, true);
        return this.spd;
    }

    @Override
    public Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public void requestFocus() {
        this.ypd.requestFocus();
    }

    @Override
    public Object getValue() {
        String string;
        block7: {
            string = "";
            Date date = this.spd.b();
            if (date != null) {
                if (this.upd == "xs:date") {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    string = DatatypeConverter.printDate((Calendar)calendar);
                } else if (this.upd == "xs:dateTime") {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    string = DatatypeConverter.printDateTime((Calendar)calendar);
                } else {
                    java.util.Date date2 = new java.util.Date(date.getTime());
                    try {
                        string = new SimpleDateFormat(this.xpd).format(date2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!zpd.isDebugEnabled()) break block7;
                        zpd.debug((Object)illegalArgumentException, (Throwable)illegalArgumentException);
                    }
                }
            }
        }
        return string;
    }

    private void rvc(boolean bl, boolean bl2) {
        this.spd.f();
        this.spd.removeKeyListener(this.aqd);
        this.ypd.getDocument().removeDocumentListener(this.bqd);
        if (bl2) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent((String)this.getValue(), bl));
        }
    }

    @Override
    public void stopEditing() {
        this.rvc(true, false);
    }

    @Override
    public void cancelEditing() {
        this.spd.f();
        this.spd.removeKeyListener(this.aqd);
        this.ypd.getDocument().removeDocumentListener(this.bqd);
        this.fireEditingCanceled();
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.zvc(authorInplaceContext, false);
        return this.spd;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.zvc(authorInplaceContext, false);
        if (this.wpd != null) {
            return this.wpd;
        }
        Component component = this.tvc(this.spd, n2, n3);
        if (component instanceof JButton) {
            return messages.b("Click_to_edit");
        }
        return this.ypd.getText();
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.zvc(authorInplaceContext, false);
        Dimension dimension = this.ypd.getPreferredSize();
        return new RendererLayoutInfo(this.ypd.getBaseline(dimension.width, dimension.height), InplaceEditorUtil.getPreferredSize(this.spd, authorInplaceContext));
    }

    private void zvc(AuthorInplaceContext authorInplaceContext, boolean bl) {
        this.wpd = null;
        Font font = (Font)authorInplaceContext.getArguments().get("font");
        if (font != null) {
            this.spd.setFont(new java.awt.Font(font.getName(), font.getStyle(), font.getSize()));
        } else {
            this.spd.setFont(this.rpd);
        }
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            this.ypd.k(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.ypd.k(this.vpd);
        }
        this.spd.setOpaque(false);
        String string = (String)authorInplaceContext.getArguments().get("validateInput");
        Boolean bl2 = this.tpd = string == null ? null : Boolean.valueOf(string);
        if (this.tpd == null || this.tpd.booleanValue()) {
            this.ypd.g(true);
        } else {
            this.ypd.g(false);
        }
        this.upd = cb.b(authorInplaceContext);
        this.xpd = (String)authorInplaceContext.getArguments().get("format");
        String string2 = ((SimpleDateFormat)DateFormat.getDateInstance(2, this.ypd.getLocale())).toPattern();
        if (this.xpd == null) {
            this.xpd = string2;
        }
        this.wvc(authorInplaceContext);
        if (bl) {
            this.ypd.getDocument().addDocumentListener(this.bqd);
            this.ypd.addKeyListener(this.aqd);
            this.ypd.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    DatePickerEditor.this.spd.f();
                }
            });
        }
        this.ypd.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!DatePickerEditor.this.spd.g()) {
                    DatePickerEditor.this.fireCommitValue(new EditingEvent((String)DatePickerEditor.this.getValue()));
                }
            }
        });
        ro.sync.exml.view.graphics.Dimension dimension = InplaceEditorUtil.getPreferredSize(this.spd, authorInplaceContext);
        this.spd.setBounds(0, 0, dimension.width, dimension.height);
        this.ypd.doLayout();
        if (!bl) {
            int n2;
            int n3;
            Component component;
            JButton jButton = this.spd.c();
            ButtonModel buttonModel = jButton.getModel();
            buttonModel.setRollover(false);
            buttonModel.setSelected(false);
            Point point = authorInplaceContext.getRelativeMouseLocation();
            if (point != null && (component = this.tvc(this.spd, n3 = point.x, n2 = point.y)) instanceof JButton) {
                buttonModel.setRollover(true);
                buttonModel.setSelected(true);
            }
        }
    }

    private Component tvc(Component component, int n2, int n3) {
        Component component2 = component.getComponentAt(n2, n3);
        while (component2 != null && component2 != component) {
            component = component2;
            component2 = component.getComponentAt(n2 -= component2.getX(), n3 -= component2.getY());
        }
        return component2;
    }

    private void wvc(AuthorInplaceContext authorInplaceContext) {
        String string = ((SimpleDateFormat)DateFormat.getDateInstance(2, this.ypd.getLocale())).toPattern();
        String string2 = (String)authorInplaceContext.getArguments().get("initial_value");
        Long l2 = null;
        if (this.upd == "custom") {
            block17: {
                if (string2 != null) {
                    try {
                        java.util.Date date = new SimpleDateFormat(this.xpd).parse(string2);
                        l2 = date.getTime();
                    }
                    catch (Exception exception) {
                        this.wpd = exception.getMessage() + ". Expected \"" + this.xpd + "\" format.";
                        if (!zpd.isDebugEnabled()) break block17;
                        zpd.debug((Object)exception, (Throwable)exception);
                    }
                }
            }
            this.ypd.c(this.xpd);
        } else if (this.upd == "xs:date") {
            if (string2 != null) {
                try {
                    Calendar calendar = DatatypeConverter.parseDate((String)string2);
                    l2 = calendar.getTimeInMillis();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.wpd = "Invalid date: " + illegalArgumentException.getMessage() + ". Expected the xs:date format.";
                }
            }
            this.ypd.c(string);
        } else if (this.upd == "xs:dateTime") {
            Object object;
            if (string2 != null) {
                try {
                    object = DatatypeConverter.parseDateTime((String)string2);
                    l2 = ((Calendar)object).getTimeInMillis();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.wpd = "Invalid date-time: " + illegalArgumentException.getMessage() + ". Expected the xs:dateTime format.";
                }
            }
            object = ((SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3)).toPattern();
            this.ypd.c((String)object);
        }
        if (l2 != null) {
            this.spd.h(new Date(l2));
        } else {
            this.spd.h(null);
        }
        if (this.wpd != null && string2 != null) {
            this.ypd.setText(string2);
        }
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public void dump(AuthorInplaceContext authorInplaceContext, StringBuilder stringBuilder) {
        this.zvc(authorInplaceContext, false);
        stringBuilder.append("value:'").append(this.ypd.getText()).append("'");
        stringBuilder.append("color:'").append(this.ypd.getForeground()).append("'");
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.wvc(authorInplaceContext);
    }

    @Override
    public boolean insertContent(String string) {
        boolean bl = false;
        try {
            this.ypd.getDocument().insertString(this.ypd.getCaretPosition(), string, null);
            bl = true;
        }
        catch (BadLocationException badLocationException) {
            zpd.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }
}

