/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.document;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.document.DetailedExceptionDPIData;
import ro.sync.document.DocumentPositionedInfo;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.PUBLIC, methods=SkipLevel.PUBLIC)
public class DPIDetailedExceptionUtil {
    private static final Logger b = Logger.getLogger((String)DPIDetailedExceptionUtil.class.getName());

    public static void computeAndAttachDetailedMessageToDPI(Throwable throwable, DocumentPositionedInfo documentPositionedInfo) {
        if (throwable != null) {
            if (documentPositionedInfo.getData() == null) {
                documentPositionedInfo.setData(DPIDetailedExceptionUtil.getDetailedExceptionData(throwable));
            }
            if (documentPositionedInfo.getData() == null) {
                documentPositionedInfo.setData(DPIDetailedExceptionUtil.getDetailedExceptionStackTrace(throwable));
            }
        }
    }

    public static DetailedExceptionDPIData getDetailedExceptionData(Throwable throwable) {
        if (throwable != null && "ro.sync.net.protocol.http.HttpExceptionWithDetails".equals(throwable.getClass().getName())) {
            try {
                String string = (String)throwable.getClass().getMethod("getReason", null).invoke((Object)throwable, (Object[])null);
                URL uRL = (URL)throwable.getClass().getMethod("getBaseURL", null).invoke((Object)throwable, (Object[])null);
                if (string != null && string.length() > 0) {
                    return new DetailedExceptionDPIData(string, uRL);
                }
            }
            catch (Exception exception) {
                b.warn((Object)exception, (Throwable)exception);
            }
        }
        return null;
    }

    public static DetailedExceptionDPIData getDetailedExceptionStackTrace(Throwable throwable) {
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            return new DetailedExceptionDPIData(stringWriter.toString(), null);
        }
        return null;
    }
}

