/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.xsd;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.j;
import ro.sync.util.Equaler;
import ro.sync.util.Resource;
import ro.sync.util.editorvars.EditorVariables;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class XSDAdditionalSchemaInfo
implements PersistentObject {
    private static Logger logger = Logger.getLogger((String)XSDAdditionalSchemaInfo.class.getName());
    public static final String XSD_ADDITIONAL_SCHEMA_TYPE_NONE = "NONE";
    public static final String XSD_ADDITIONAL_SCHEMA_TYPE_SCHEMATRON_ISO = "Schematron ISO";
    public static final String XSD_ADDITIONAL_SCHEMA_TYPE_SCHEMATRON_15 = "Schematron 1.5";
    public static final String XSD_ADDITIONAL_SCHEMA_TYPE_USER = "User defined";
    public static final String SCHEMATRON_ISO_SCHEMA = "/builtin/iso-schematron.xsd";
    public static final String SCHEMATRON_15_SCHEMA = "/builtin/schematron1-5.xsd";
    public static final XSDAdditionalSchemaInfo DEFAULT = new XSDAdditionalSchemaInfo(null, "Schematron ISO");
    String systemID;
    String schemaType;

    public XSDAdditionalSchemaInfo() {
    }

    public XSDAdditionalSchemaInfo(String string, String string2) {
        this.systemID = string;
        this.schemaType = string2;
    }

    public URL getURL() {
        URL uRL = null;
        if (XSD_ADDITIONAL_SCHEMA_TYPE_NONE.equals(this.schemaType)) {
            return null;
        }
        if (XSD_ADDITIONAL_SCHEMA_TYPE_SCHEMATRON_15.equals(this.schemaType)) {
            return Resource.getResource(SCHEMATRON_15_SCHEMA);
        }
        if (XSD_ADDITIONAL_SCHEMA_TYPE_SCHEMATRON_ISO.equals(this.schemaType)) {
            return Resource.getResource(SCHEMATRON_ISO_SCHEMA);
        }
        if (this.systemID != null) {
            String string = EditorVariables.expandEditorVariables(this.systemID, null);
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                logger.warn((Object)malformedURLException, (Throwable)malformedURLException);
            }
        }
        return uRL;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public boolean equals(Object object) {
        if (object instanceof XSDAdditionalSchemaInfo) {
            XSDAdditionalSchemaInfo xSDAdditionalSchemaInfo = (XSDAdditionalSchemaInfo)object;
            return Equaler.verifyEquals(this.systemID, xSDAdditionalSchemaInfo.getSystemID()) && Equaler.verifyEquals(this.schemaType, xSDAdditionalSchemaInfo.getSchemaType());
        }
        return false;
    }

    public int hashCode() {
        int n2 = 1;
        if (this.systemID != null) {
            n2 += this.systemID.hashCode();
        }
        if (this.schemaType != null) {
            n2 += this.schemaType.hashCode();
        }
        return n2;
    }

    @Override
    public void checkValid() throws j {
        if (this.schemaType == null) {
            throw new j("Missing schema type in the xsl result schema");
        }
        boolean bl = this.schemaType.equals(XSD_ADDITIONAL_SCHEMA_TYPE_USER);
        if (this.systemID == null && bl) {
            throw new j("Missing systemID for used defined schema");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }
}

