/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbDir;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbCopy;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgWcToWcCopy
extends SvnNgOperationRunner<Void, SvnCopy> {
    public boolean isApplicable(SvnCopy svnCopy, SvnWcGeneration svnWcGeneration) throws SVNException {
        return this.areAllSourcesLocal(svnCopy) && svnCopy.getFirstTarget().isLocal();
    }

    private boolean areAllSourcesLocal(SvnCopy svnCopy) {
        for (SvnCopySource svnCopySource : svnCopy.getSources()) {
            if (svnCopySource.getSource().isFile() && (svnCopy.isMove() || this.isLocalRevision(svnCopySource.getRevision()) && this.isLocalRevision(svnCopySource.getSource().getResolvedPegRevision()))) continue;
            return false;
        }
        return true;
    }

    private boolean isLocalRevision(SVNRevision sVNRevision) {
        return sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.UNDEFINED;
    }

    protected Void run(SVNWCContext sVNWCContext) throws SVNException {
        boolean bl = false;
        Collection collection = ((SvnCopy)this.getOperation()).getSources();
        try {
            bl = this.tryRun(sVNWCContext, collection, this.getFirstTarget());
            Void void_ = null;
            return void_;
        }
        catch (SVNException sVNException) {
            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
            if (!(((SvnCopy)this.getOperation()).isFailWhenDstExists() || ((SvnCopy)this.getOperation()).getSources().size() != 1 || sVNErrorCode != SVNErrorCode.ENTRY_EXISTS && sVNErrorCode != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SvnCopySource svnCopySource = (SvnCopySource)collection.iterator().next();
                bl = this.tryRun(sVNWCContext, collection, new File(this.getFirstTarget(), svnCopySource.getSource().getFile().getName()));
                Void void_ = null;
                return void_;
            }
            throw sVNException;
        }
        finally {
            if (bl) {
                this.sleepForTimestamp();
            }
        }
    }

    protected boolean tryRun(SVNWCContext sVNWCContext, Collection<SvnCopySource> collection, File file) throws SVNException {
        if (((SvnCopy)this.getOperation()).isDisjoint()) {
            return this.disjointCopy(sVNWCContext, file);
        }
        return this.copy(sVNWCContext, collection, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disjointCopy(SVNWCContext sVNWCContext, File file) throws SVNException {
        file = new File(file.getAbsolutePath().replace(File.separatorChar, '/'));
        File file2 = file.getParentFile();
        this.checkForDisjointCopyPossibility(sVNWCContext, file, file2);
        sVNWCContext.getDb().close();
        File file3 = sVNWCContext.getDb().getWCRoot(file2);
        File file4 = new File(this.getAdminDirectory(file3), "tmp");
        SVNFileUtil.ensureDirectoryExists((File)file4);
        File file5 = SVNFileUtil.createUniqueDir((File)file4, (String)"disjoint-copy", (String)"tmp", (boolean)true);
        this.moveWcDb(file, file5);
        this.copyPristineFiles(file, file3, true);
        SVNFileUtil.deleteAll((File)this.getAdminDirectory(file), (boolean)true);
        sVNWCContext.getDb().forgetDirectoryTemp(file);
        File file6 = null;
        try {
            file6 = sVNWCContext.acquireWriteLock(file3, true, true);
            this.copy(sVNWCContext, file5, file, true);
        }
        finally {
            if (file6 != null) {
                sVNWCContext.releaseWriteLock(file6);
            }
        }
        return true;
    }

    private void checkForDisjointCopyPossibility(SVNWCContext sVNWCContext, File file, File file2) throws SVNException {
        SVNErrorMessage sVNErrorMessage;
        File file3;
        SVNErrorMessage sVNErrorMessage2;
        SVNWCContext.ScheduleInternalInfo scheduleInternalInfo;
        SVNErrorMessage sVNErrorMessage3;
        SVNErrorMessage sVNErrorMessage4;
        SVNFileType sVNFileType = SVNFileType.getType((File)file);
        if (sVNFileType != SVNFileType.DIRECTORY) {
            sVNErrorMessage4 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"This kind of copy can be run on a root of a disjoint wc directory only");
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage4, (SVNLogType)SVNLogType.WC);
        }
        if (file2 == null) {
            sVNErrorMessage4 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"{0} seems to be not a disjoint wc since it has no parent", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage4, (SVNLogType)SVNLogType.WC);
        }
        if (!(sVNWCContext.getDb() instanceof SVNWCDb)) {
            sVNErrorMessage4 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"Unsupported working copy format", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage4, (SVNLogType)SVNLogType.WC);
        }
        if (this.hasMetadataInParentWc((SVNWCDb)(sVNErrorMessage4 = (SVNWCDb)sVNWCContext.getDb()), file, file2)) {
            sVNErrorMessage3 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_EXISTS, (String)"Entry ''{0}'' already exists in parent directory", (Object)file.getName());
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage3, (SVNLogType)SVNLogType.WC);
        }
        sVNErrorMessage3 = sVNWCContext.getDb().getBaseInfo(file, new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath});
        ISVNWCDb.WCDbBaseInfo wCDbBaseInfo = sVNWCContext.getDb().getBaseInfo(file2, new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath});
        if (sVNErrorMessage3.reposRootUrl != null && wCDbBaseInfo.reposRootUrl != null && !sVNErrorMessage3.reposRootUrl.equals((Object)wCDbBaseInfo.reposRootUrl)) {
            scheduleInternalInfo = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_INVALID_SCHEDULE, (String)"Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", (Object[])new Object[]{file2, sVNErrorMessage3.reposRootUrl, sVNErrorMessage3.reposRootUrl});
            SVNErrorManager.error((SVNErrorMessage)scheduleInternalInfo, (SVNLogType)SVNLogType.WC);
        }
        scheduleInternalInfo = sVNWCContext.getNodeScheduleInternal(file2, true, true);
        if (scheduleInternalInfo.schedule == SVNWCContext.SVNWCSchedule.delete) {
            sVNErrorMessage2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_INVALID_SCHEDULE, (String)"Cannot copy to ''{0}'', as it is scheduled for deletion", (Object)file2);
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage2, (SVNLogType)SVNLogType.WC);
        }
        sVNErrorMessage2 = sVNWCContext.getNodeScheduleInternal(file, true, true);
        if (sVNErrorMessage2.schedule == SVNWCContext.SVNWCSchedule.delete) {
            file3 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_INVALID_SCHEDULE, (String)"Cannot copy ''{0}'', as it is scheduled for deletion", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)file3, (SVNLogType)SVNLogType.WC);
        }
        file3 = sVNErrorMessage3.reposRelPath;
        File file4 = wCDbBaseInfo.reposRelPath;
        if (file3 == null || file4 == null) {
            sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_INVALID_SCHEDULE, (String)"Cannot copy ''{0}'': cannot resolve its relative path, perhaps it is obstructed", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
        }
        if (SVNPathUtil.isAncestor((String)file3.getPath(), (String)file4.getPath())) {
            sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"Cannot copy path ''{0}'' into its own child ''{1}''", (Object[])new Object[]{file, file2});
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
        }
        if (sVNErrorMessage2.schedule == SVNWCContext.SVNWCSchedule.add && !sVNErrorMessage2.copied || sVNWCContext.getNodeUrl(file) == null) {
            sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_EXISTS, (String)"Cannot copy or move ''{0}'': it is not in repository yet; try committing first", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
        }
    }

    private void moveWcDb(File file, File file2) throws SVNException {
        File file3 = this.getWCDbFile(file);
        File file4 = this.getWCDbFile(file2);
        SVNFileUtil.ensureDirectoryExists((File)file4.getParentFile());
        SVNFileUtil.rename((File)file3, (File)file4);
    }

    private void copyPristineFiles(File file, File file2, boolean bl) throws SVNException {
        File file3 = this.getPristineDirectory(file);
        File file4 = this.getPristineDirectory(file2);
        File[] fileArray = SVNFileListUtil.listFiles((File)file3);
        if (fileArray != null) {
            for (File file5 : fileArray) {
                File file6 = new File(file4, file5.getName());
                SVNFileUtil.ensureDirectoryExists((File)file6);
                File[] fileArray2 = SVNFileListUtil.listFiles((File)file5);
                if (fileArray2 == null) continue;
                for (File file7 : fileArray2) {
                    File file8 = new File(file6, file7.getName());
                    if (file8.exists()) continue;
                    if (bl) {
                        SVNFileUtil.rename((File)file7, (File)file8);
                        continue;
                    }
                    SVNFileUtil.copyFile((File)file7, (File)file8, (boolean)false);
                }
            }
        }
        SVNFileUtil.deleteAll((File)file3, (boolean)true);
    }

    private File getPristineDirectory(File file) {
        return new File(this.getAdminDirectory(file), "pristine");
    }

    private File getWCDbFile(File file) {
        return new File(this.getAdminDirectory(file), "wc.db");
    }

    private File getAdminDirectory(File file) {
        String string = SVNFileUtil.getAdminDirectoryName();
        return new File(file, string);
    }

    private boolean hasMetadataInParentWc(SVNWCDb sVNWCDb, File file, File file2) throws SVNException {
        SVNWCDbRoot sVNWCDbRoot;
        SVNWCDb.DirParsedInfo dirParsedInfo = sVNWCDb.obtainWcRoot(file2);
        SVNWCDbDir sVNWCDbDir = dirParsedInfo == null ? null : dirParsedInfo.wcDbDir;
        SVNWCDbRoot sVNWCDbRoot2 = sVNWCDbRoot = sVNWCDbDir == null ? null : sVNWCDbDir.getWCRoot();
        if (sVNWCDbRoot == null) {
            return false;
        }
        try {
            sVNWCDb.readInfo(sVNWCDbRoot, new File(SVNPathUtil.getRelativePath((String)file2.getPath(), (String)file.getPath())), new ISVNWCDb.WCDbInfo.InfoField[0]);
            return true;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                return false;
            }
            throw sVNException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(SVNWCContext sVNWCContext, Collection<SvnCopySource> collection, File file) throws SVNException {
        SVNErrorMessage sVNErrorMessage;
        Object object;
        Object object3;
        boolean bl = false;
        ArrayList<SvnCopyPair> arrayList = new ArrayList<SvnCopyPair>();
        if (collection.size() > 1) {
            if (((SvnCopy)this.getOperation()).isFailWhenDstExists()) {
                object3 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
                SVNErrorManager.error((SVNErrorMessage)object3, (SVNLogType)SVNLogType.DEFAULT);
            }
            for (SvnCopySource object4 : collection) {
                SvnCopyPair svnCopyPair = new SvnCopyPair();
                svnCopyPair.source = object4.getSource().getFile();
                object = svnCopyPair.source.getName();
                svnCopyPair.dst = new File(file, (String)object);
                arrayList.add(svnCopyPair);
            }
        } else if (collection.size() == 1) {
            object3 = new SvnCopyPair();
            SvnCopySource svnCopySource = collection.iterator().next();
            ((SvnCopyPair)object3).source = new File(SVNPathUtil.validateFilePath((String)svnCopySource.getSource().getFile().getAbsolutePath()));
            ((SvnCopyPair)object3).dst = file;
            arrayList.add((SvnCopyPair)object3);
        }
        for (SvnCopyPair svnCopyPair : arrayList) {
            File file2 = svnCopyPair.source;
            object = svnCopyPair.dst;
            if (((SvnCopy)this.getOperation()).isMove() && file2.getAbsolutePath().equals(((File)object).getAbsolutePath())) {
                sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"Cannot move path ''{0}'' into itself", (Object)file2);
                SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
            }
            if (!SVNWCUtils.isChild((File)file2, (File)object)) continue;
            sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"Cannot copy path ''{0}'' into its own child ''{1}''", (Object[])new Object[]{file2, object});
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
        }
        if (((SvnCopy)this.getOperation()).isMove()) {
            for (SvnCopyPair svnCopyPair : arrayList) {
                File file3 = svnCopyPair.source;
                try {
                    object = SvnWcDbExternals.readExternal((SVNWCContext)sVNWCContext, (File)file3, (File)file3, (StructureFields.ExternalNodeInfo[])new StructureFields.ExternalNodeInfo[]{StructureFields.ExternalNodeInfo.kind, StructureFields.ExternalNodeInfo.definingAbsPath});
                    if (!object.hasValue((Enum)StructureFields.ExternalNodeInfo.kind) || object.get((Enum)StructureFields.ExternalNodeInfo.kind) == SVNNodeKind.NONE) continue;
                    sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_CANNOT_MOVE_FILE_EXTERNAL, (String)"Cannot move the external at ''{0}''; please edit the svn:externals property on ''{1}''.", (Object[])new Object[]{file3, object.get((Enum)StructureFields.ExternalNodeInfo.definingAbsPath)});
                    SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                    throw sVNException;
                }
            }
        }
        this.verifyPaths(arrayList, ((SvnCopy)this.getOperation()).isMakeParents(), ((SvnCopy)this.getOperation()).isMove());
        if (((SvnCopy)this.getOperation()).isMove()) {
            bl = this.move(arrayList);
        } else {
            object3 = null;
            if (arrayList.size() >= 1) {
                object3 = ((SvnCopyPair)arrayList.iterator().next()).dst;
            }
            if (arrayList.size() > 1 && object3 != null) {
                object3 = SVNFileUtil.getParentFile((File)object3);
            }
            object3 = ((File)object3).getAbsoluteFile();
            object3 = sVNWCContext.acquireWriteLock((File)object3, false, true);
            try {
                for (SvnCopyPair svnCopyPair : arrayList) {
                    this.checkCancelled();
                    object = SVNFileUtil.createFilePath((File)svnCopyPair.dstParent, (String)svnCopyPair.baseName);
                    bl = bl || this.copy(sVNWCContext, svnCopyPair.source, (File)object, ((SvnCopy)this.getOperation()).isMetadataOnly() || ((SvnCopy)this.getOperation()).isVirtual());
                }
            }
            finally {
                sVNWCContext.releaseWriteLock((File)object3);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean move(Collection<SvnCopyPair> collection) throws SVNException {
        for (SvnCopyPair svnCopyPair : collection) {
            HashSet<File> hashSet = new HashSet<File>();
            HashSet<File> hashSet2 = new HashSet<File>();
            this.checkCancelled();
            File file = new File(SVNPathUtil.validateFilePath((String)SVNFileUtil.getParentFile((File)svnCopyPair.source).getAbsolutePath()));
            if (file.equals(svnCopyPair.dstParent) || SVNWCUtils.isChild((File)file, (File)svnCopyPair.dstParent)) {
                hashSet.add(file);
            } else if (SVNWCUtils.isChild((File)svnCopyPair.dstParent, (File)file)) {
                hashSet.add(svnCopyPair.dstParent);
            } else {
                hashSet.add(file);
                hashSet.add(svnCopyPair.dstParent);
            }
            try {
                for (File file2 : hashSet) {
                    hashSet2.add(this.getWcContext().acquireWriteLock(file2, false, true));
                }
                this.move(this.getWcContext(), svnCopyPair.source, SVNFileUtil.createFilePath((File)svnCopyPair.dstParent, (String)svnCopyPair.baseName), ((SvnCopy)this.getOperation()).isMetadataOnly() || ((SvnCopy)this.getOperation()).isVirtual());
            }
            finally {
                for (File file2 : hashSet2) {
                    this.getWcContext().releaseWriteLock(file2);
                }
            }
        }
        return false;
    }

    private void verifyPaths(Collection<SvnCopyPair> collection, boolean bl, boolean bl2) throws SVNException {
        for (SvnCopyPair svnCopyPair : collection) {
            SVNErrorMessage sVNErrorMessage;
            SVNFileType sVNFileType;
            SVNFileType sVNFileType2;
            SVNNodeKind sVNNodeKind = SvnWcDbCopy.readKind((ISVNWCDb)this.getWcContext().getDb(), (File)svnCopyPair.dst, (boolean)false, (boolean)true);
            if (sVNNodeKind != SVNNodeKind.NONE) {
                sVNFileType2 = this.getWcContext().getNodePresence(svnCopyPair.dst, false);
                if (sVNFileType2.isExcluded || sVNFileType2.isServerExcluded) {
                    sVNFileType = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_OBSTRUCTED_UPDATE, (String)"Path ''{0}'' exists, but is excluded", (Object)svnCopyPair.dst);
                    SVNErrorManager.error((SVNErrorMessage)sVNFileType, (SVNLogType)SVNLogType.WC);
                } else {
                    sVNFileType = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_EXISTS, (String)"Path ''{0}'' already exists", (Object)svnCopyPair.dst);
                    SVNErrorManager.error((SVNErrorMessage)sVNFileType, (SVNLogType)SVNLogType.WC);
                }
            }
            sVNFileType2 = SVNFileType.getType((File)svnCopyPair.source);
            sVNFileType = SVNFileType.getType((File)svnCopyPair.dst);
            if (!((SvnCopy)this.getOperation()).isMetadataOnly()) {
                if (((SvnCopy)this.getOperation()).isVirtual()) {
                    this.verifyPathsExistenceForVirtualCopy(svnCopyPair.source, svnCopyPair.dst, sVNFileType2, sVNFileType, svnCopyPair, bl2);
                } else {
                    boolean bl3 = this.verifyPaths(sVNFileType2, sVNFileType, svnCopyPair, collection.size(), bl2);
                    if (bl3) {
                        return;
                    }
                }
            }
            svnCopyPair.dstParent = new File(SVNPathUtil.validateFilePath((String)SVNFileUtil.getParentFile((File)svnCopyPair.dst).getAbsolutePath()));
            svnCopyPair.baseName = SVNFileUtil.getFileName((File)svnCopyPair.dst);
            SVNNodeKind sVNNodeKind2 = SvnWcDbCopy.readKind((ISVNWCDb)this.getWcContext().getDb(), (File)svnCopyPair.dstParent, (boolean)false, (boolean)true);
            if (bl && (sVNNodeKind2 == SVNNodeKind.NONE || ((SvnCopy)this.getOperation()).isVirtual())) {
                SVNFileUtil.ensureDirectoryExists((File)svnCopyPair.dstParent);
                sVNErrorMessage = ((SvnCopy)this.getOperation()).getOperationFactory().createScheduleForAddition();
                sVNErrorMessage.setSingleTarget(SvnTarget.fromFile((File)svnCopyPair.dstParent));
                sVNErrorMessage.setDepth(((SvnCopy)this.getOperation()).isVirtual() ? SVNDepth.EMPTY : SVNDepth.INFINITY);
                sVNErrorMessage.setIncludeIgnored(true);
                sVNErrorMessage.setForce(false);
                sVNErrorMessage.setAddParents(true);
                sVNErrorMessage.setSleepForTimestamp(false);
                try {
                    sVNErrorMessage.run();
                }
                catch (SVNException sVNException) {
                    if (sVNNodeKind2 == SVNNodeKind.NONE) {
                        SVNFileUtil.deleteAll((File)svnCopyPair.dstParent, (boolean)true);
                    }
                    throw sVNException;
                }
            } else if (sVNNodeKind2 != SVNNodeKind.DIR) {
                sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_PATH_NOT_FOUND, (String)"Path ''{0}'' is not a directory", (Object)svnCopyPair.dstParent);
                SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
            }
            if ((sVNNodeKind2 = SVNFileType.getNodeKind((SVNFileType)SVNFileType.getType((File)svnCopyPair.dstParent))) == SVNNodeKind.DIR) continue;
            sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_MISSING, (String)"Path ''{0}'' is not a directory", (Object)svnCopyPair.dstParent);
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
        }
    }

    private boolean verifyPaths(SVNFileType sVNFileType, SVNFileType sVNFileType2, SvnCopyPair svnCopyPair, int n2, boolean bl) throws SVNException {
        Object object;
        if (sVNFileType == SVNFileType.NONE) {
            object = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.NODE_UNKNOWN_KIND, (String)"Path ''{0}'' does not exist", (Object)svnCopyPair.source);
            SVNErrorManager.error((SVNErrorMessage)object, (SVNLogType)SVNLogType.WC);
        }
        if (sVNFileType2 != SVNFileType.NONE) {
            File file;
            if (bl && n2 == 1 && ((File)(object = SVNFileUtil.getFileDir((File)svnCopyPair.source))).equals(file = SVNFileUtil.getFileDir((File)svnCopyPair.dst)) && svnCopyPair.source.getName().equalsIgnoreCase(svnCopyPair.dst.getName())) {
                svnCopyPair.dstParent = new File(SVNPathUtil.validateFilePath((String)file.getAbsolutePath()));
                svnCopyPair.baseName = SVNFileUtil.getFileName((File)svnCopyPair.dst);
                return true;
            }
            object = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_EXISTS, (String)"Path ''{0}'' already exists", (Object)svnCopyPair.dst);
            SVNErrorManager.error((SVNErrorMessage)object, (SVNLogType)SVNLogType.WC);
        }
        return false;
    }

    private void verifyPathsExistenceForVirtualCopy(File file, File file2, SVNFileType sVNFileType, SVNFileType sVNFileType2, SvnCopyPair svnCopyPair, boolean bl) throws SVNException {
        SvnStatus svnStatus;
        SvnStatus svnStatus2;
        String string;
        String string2 = string = bl ? "move" : "copy";
        if (bl && sVNFileType != SVNFileType.NONE) {
            svnStatus2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_EXISTS, (String)"Cannot perform 'virtual' {0}: ''{1}'' still exists", (Object[])new Object[]{string, svnCopyPair.source});
            SVNErrorManager.error((SVNErrorMessage)svnStatus2, (SVNLogType)SVNLogType.WC);
        }
        if (sVNFileType2 == SVNFileType.NONE) {
            svnStatus2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_NOT_FOUND, (String)"Cannot perform 'virtual' {0}: ''{1}'' does not exist", (Object[])new Object[]{string, svnCopyPair.dst});
            SVNErrorManager.error((SVNErrorMessage)svnStatus2, (SVNLogType)SVNLogType.WC);
        }
        if (sVNFileType2 == SVNFileType.DIRECTORY) {
            svnStatus2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ILLEGAL_TARGET, (String)"Cannot perform 'virtual' {0}: ''{1}'' is a directory", (Object[])new Object[]{string, svnCopyPair.dst});
            SVNErrorManager.error((SVNErrorMessage)svnStatus2, (SVNLogType)SVNLogType.WC);
        }
        if (!bl && sVNFileType == SVNFileType.DIRECTORY) {
            svnStatus2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ILLEGAL_TARGET, (String)"Cannot perform 'virtual' {0}: ''{1}'' is a directory", (Object[])new Object[]{string, svnCopyPair.source});
            SVNErrorManager.error((SVNErrorMessage)svnStatus2, (SVNLogType)SVNLogType.WC);
        }
        if ((svnStatus2 = this.getStatus(file2)) != null && svnStatus2.getNodeStatus() != SVNStatusType.STATUS_UNVERSIONED && svnStatus2.getNodeStatus() != SVNStatusType.STATUS_ADDED && svnStatus2.getNodeStatus() != SVNStatusType.STATUS_REPLACED) {
            svnStatus = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, (String)"Cannot perform 'virtual' {0}: ''{1}'' is scheduled neither for addition nor for replacement", (Object[])new Object[]{string, file2});
            SVNErrorManager.error((SVNErrorMessage)svnStatus, (SVNLogType)SVNLogType.WC);
        }
        if ((svnStatus = this.getStatus(file)) == null || svnStatus.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_NOT_FOUND, (String)"''{0}'' is not under version control", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
        }
    }

    private SvnStatus getStatus(File file) throws SVNException {
        final String string = SVNFileUtil.getFilePath((File)file);
        final SvnStatus[] svnStatusArray = new SvnStatus[1];
        SvnOperationFactory svnOperationFactory = ((SvnCopy)this.getOperation()).getOperationFactory();
        SvnGetStatus svnGetStatus = svnOperationFactory.createGetStatus();
        svnGetStatus.setDepth(SVNDepth.INFINITY);
        svnGetStatus.setRemote(false);
        svnGetStatus.setReportAll(true);
        svnGetStatus.setReportIgnored(true);
        svnGetStatus.setReportExternals(false);
        svnGetStatus.setApplicalbeChangelists(null);
        svnGetStatus.addTarget(SvnTarget.fromFile((File)file.getParentFile()));
        svnGetStatus.setReceiver((ISvnObjectReceiver)new ISvnObjectReceiver<SvnStatus>(){

            public void receive(SvnTarget svnTarget, SvnStatus svnStatus) throws SVNException {
                if (svnStatus == null) {
                    return;
                }
                File file = svnStatus.getPath();
                if (file == null) {
                    return;
                }
                String string2 = SVNFileUtil.getFilePath((File)file);
                if (string2.equals(string)) {
                    svnStatusArray[0] = svnStatus;
                }
            }
        });
        svnGetStatus.run();
        return svnStatusArray[0];
    }

    public void move(SVNWCContext sVNWCContext, File file, File file2, boolean bl) throws SVNException {
        Structure structure;
        boolean bl2 = this.copy(sVNWCContext, file, file2, true);
        if (!bl) {
            SVNFileUtil.rename((File)file, (File)file2);
        }
        if ((structure = sVNWCContext.getDb().readInfo(file, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.kind, StructureFields.NodeInfo.conflicted})).get((Enum)StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir) {
            this.removeAllConflictMarkers(sVNWCContext.getDb(), file, file2);
        }
        if (structure.is((Enum)StructureFields.NodeInfo.conflicted)) {
            this.removeAllConflictMarkers(sVNWCContext.getDb(), file, file2);
        }
        SvnNgRemove.delete((SVNWCContext)this.getWcContext(), (File)file, (File)(bl2 ? null : file2), (boolean)true, (boolean)false, (ISVNEventHandler)this);
    }

    private void removeAllConflictMarkers(ISVNWCDb iSVNWCDb, File file, File file2) throws SVNException {
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        iSVNWCDb.readChildren(file, hashMap, hashSet);
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            ISVNWCDb.SVNWCDbInfo sVNWCDbInfo = (ISVNWCDb.SVNWCDbInfo)entry.getValue();
            if (sVNWCDbInfo.conflicted) {
                this.removeNodeConflictMarkers(iSVNWCDb, SVNFileUtil.createFilePath((File)file, (String)string), SVNFileUtil.createFilePath((File)file2, (String)string));
            }
            if (sVNWCDbInfo.kind != ISVNWCDb.SVNWCDbKind.Dir) continue;
            this.removeAllConflictMarkers(iSVNWCDb, SVNFileUtil.createFilePath((File)file, (String)string), SVNFileUtil.createFilePath((File)file2, (String)string));
        }
    }

    private void removeNodeConflictMarkers(ISVNWCDb iSVNWCDb, File file, File file2) throws SVNException {
        SVNSkel sVNSkel = iSVNWCDb.readConflict(file);
        if (sVNSkel != null) {
            File file3 = SVNFileUtil.getParentFile((File)file);
            File file4 = SVNFileUtil.getParentFile((File)file2);
            List list = SvnWcDbConflicts.readConflictMarkers((SVNWCDb)((SVNWCDb)iSVNWCDb), (File)file, (SVNSkel)sVNSkel);
            if (list != null) {
                for (File file5 : list) {
                    File file6 = SVNFileUtil.skipAncestor((File)file3, (File)file5);
                    if (file6 == null) continue;
                    File file7 = SVNFileUtil.createFilePath((File)file4, (File)file6);
                    SVNFileUtil.deleteFile((File)file7);
                }
            }
        }
    }

    protected boolean copy(SVNWCContext sVNWCContext, File file, File file2, boolean bl) throws SVNException {
        Object object;
        ISVNWCDb.SVNWCDbStatus sVNWCDbStatus;
        Object object2;
        File file3;
        ISVNWCDb.SVNWCDbStatus sVNWCDbStatus2;
        File file4;
        Structure structure;
        File file5;
        boolean bl2;
        boolean bl3;
        block40: {
            Object object3;
            SVNErrorMessage sVNErrorMessage;
            block39: {
                Object object4;
                SvnCopy svnCopy = (SvnCopy)this.getOperation();
                bl3 = svnCopy != null && svnCopy.isMove();
                bl2 = svnCopy == null || svnCopy.isAllowMixedRevisions();
                file5 = SVNFileUtil.getParentFile((File)file2);
                structure = null;
                try {
                    structure = sVNWCContext.getDb().readInfo(file, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.conflicted});
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_NOT_FOUND, (String)"''{0}'' is not under version control", (Object)file);
                        SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage2, (SVNLogType)SVNLogType.WC);
                    }
                    throw sVNException;
                }
                file4 = sVNWCContext.getDb().getWCRoot(file);
                sVNWCDbStatus2 = (ISVNWCDb.SVNWCDbStatus)structure.get((Enum)StructureFields.NodeInfo.status);
                switch (sVNWCDbStatus2) {
                    case Deleted: {
                        if (bl) break;
                        object4 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, (String)"Deleted node ''{0}'' can''t be copied.", (Object)file);
                        SVNErrorManager.error((SVNErrorMessage)object4, (SVNLogType)SVNLogType.WC);
                        break;
                    }
                    case Excluded: 
                    case ServerExcluded: 
                    case NotPresent: {
                        object4 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_PATH_NOT_FOUND, (String)"The node ''{0}'' was not found.", (Object)file);
                        SVNErrorManager.error((SVNErrorMessage)object4, (SVNLogType)SVNLogType.WC);
                    }
                }
                if (bl3 && file.equals(file4)) {
                    object4 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, (String)"''{0}'' is the root of a working copy and cannot be moved", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)object4, (SVNLogType)SVNLogType.WC);
                }
                object4 = (File)structure.get((Enum)StructureFields.NodeInfo.reposRelPath);
                if (bl3 && object4 != null && "".equals(SVNFileUtil.getFilePath((File)object4))) {
                    sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, (String)"''{0}'' represents the repository root and cannot be moved", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
                }
                sVNErrorMessage = null;
                try {
                    sVNErrorMessage = sVNWCContext.getDb().readInfo(file5, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.status, StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid});
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) break block39;
                    object3 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_NOT_FOUND, (String)"''{0}'' is not under version control", (Object)file5);
                    SVNErrorManager.error((SVNErrorMessage)object3, (SVNLogType)SVNLogType.WC);
                }
            }
            SVNURL sVNURL = (SVNURL)sVNErrorMessage.get((Enum)StructureFields.NodeInfo.reposRootUrl);
            object3 = (String)sVNErrorMessage.get((Enum)StructureFields.NodeInfo.reposUuid);
            ISVNWCDb.SVNWCDbStatus sVNWCDbStatus3 = (ISVNWCDb.SVNWCDbStatus)sVNErrorMessage.get((Enum)StructureFields.NodeInfo.status);
            sVNErrorMessage.release();
            SVNURL sVNURL2 = (SVNURL)structure.get((Enum)StructureFields.NodeInfo.reposRootUrl);
            String string = (String)structure.get((Enum)StructureFields.NodeInfo.reposUuid);
            file3 = sVNWCContext.getDb().getWCRoot(file5);
            if (sVNURL2 == null) {
                if (sVNWCDbStatus2 == ISVNWCDb.SVNWCDbStatus.Added) {
                    object2 = SvnWcDbShared.scanAddition((SVNWCDb)((SVNWCDb)sVNWCContext.getDb()), (File)file);
                    sVNURL2 = (SVNURL)object2.get((Enum)StructureFields.AdditionInfo.reposRootUrl);
                    string = (String)object2.get((Enum)StructureFields.AdditionInfo.reposUuid);
                    object2.release();
                } else {
                    object2 = sVNWCContext.getDb().scanBaseRepository(file, new ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[]{ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid});
                    sVNURL2 = object2.rootUrl;
                    string = object2.uuid;
                }
            }
            if (sVNURL == null) {
                if (sVNWCDbStatus3 == ISVNWCDb.SVNWCDbStatus.Added) {
                    object2 = SvnWcDbShared.scanAddition((SVNWCDb)((SVNWCDb)sVNWCContext.getDb()), (File)file5);
                    sVNURL = (SVNURL)object2.get((Enum)StructureFields.AdditionInfo.reposRootUrl);
                    object3 = (String)object2.get((Enum)StructureFields.AdditionInfo.reposUuid);
                    object2.release();
                } else {
                    object2 = sVNWCContext.getDb().scanBaseRepository(file5, new ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField[]{ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.rootUrl, ISVNWCDb.WCDbRepositoryInfo.RepositoryInfoField.uuid});
                    sVNURL = object2.rootUrl;
                    object3 = object2.uuid;
                }
            }
            if (sVNURL2 != null && sVNURL != null && !sVNURL2.equals((Object)sVNURL) || string != null && object3 != null && !string.equals(object3)) {
                object2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_INVALID_SCHEDULE, (String)"Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", (Object[])new Object[]{file2, sVNURL2, sVNURL});
                SVNErrorManager.error((SVNErrorMessage)object2, (SVNLogType)SVNLogType.WC);
            }
            if (sVNWCDbStatus3 == ISVNWCDb.SVNWCDbStatus.Deleted) {
                object2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_INVALID_SCHEDULE, (String)"Cannot copy to ''{0}'', as it is scheduled for deletion", (Object)file2);
                SVNErrorManager.error((SVNErrorMessage)object2, (SVNLogType)SVNLogType.WC);
            }
            try {
                object2 = sVNWCContext.getDb().readInfo(file2, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.status});
                sVNWCDbStatus = (ISVNWCDb.SVNWCDbStatus)object2.get((Enum)StructureFields.NodeInfo.status);
                switch (sVNWCDbStatus) {
                    case Excluded: {
                        SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_EXISTS, (String)"''{0}'' is already under version control but is excluded.", (Object)file2);
                        SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage3, (SVNLogType)SVNLogType.WC);
                        break;
                    }
                    case ServerExcluded: {
                        object = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_EXISTS, (String)"''{0}'' is already under version control", (Object)file2);
                        SVNErrorManager.error((SVNErrorMessage)object, (SVNLogType)SVNLogType.WC);
                        break;
                    }
                    case Deleted: 
                    case NotPresent: {
                        break;
                    }
                    default: {
                        if (bl) break;
                        SVNErrorMessage sVNErrorMessage4 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_EXISTS, (String)"There is already a versioned item ''{0}''", (Object)file2);
                        SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage4, (SVNLogType)SVNLogType.WC);
                        break;
                    }
                }
                object2.release();
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block40;
                throw sVNException;
            }
        }
        if (!bl && (object2 = SVNFileType.getType((File)file2)) != SVNFileType.NONE) {
            sVNWCDbStatus = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_EXISTS, (String)"''{0}'' already exists and is in the way", (Object)file2);
            SVNErrorManager.error((SVNErrorMessage)sVNWCDbStatus, (SVNLogType)SVNLogType.WC);
        }
        object2 = sVNWCContext.getDb().getWCRootTempDir(file5);
        boolean bl4 = file4.equals(file3);
        boolean bl5 = false;
        if (bl3 && !bl4) {
            bl5 = true;
            bl3 = false;
        }
        if (!bl4) {
            SvnWcDbPristines.transferPristine((SVNWCDb)((SVNWCDb)sVNWCContext.getDb()), (File)file, (File)file3);
        }
        if (structure.get((Enum)StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.File || structure.get((Enum)StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Symlink) {
            boolean bl6 = this.shouldCopyBaseData(sVNWCContext, file, bl, sVNWCDbStatus2);
            if (bl6 && ((SvnCopy)this.getOperation()).isVirtual()) {
                this.copyBaseDataOfFile(sVNWCContext, file, file2);
            } else {
                this.copyVersionedFile(sVNWCContext, file, file2, file2, (File)object2, bl, structure.is((Enum)StructureFields.NodeInfo.conflicted), bl3, true);
            }
        } else {
            if (bl3 && sVNWCDbStatus2 == ISVNWCDb.SVNWCDbStatus.Normal) {
                object = sVNWCContext.getDb().minMaxRevisions(file, false);
                SVNErrorMessage sVNErrorMessage = object[0];
                SVNErrorMessage sVNErrorMessage5 = object[1];
                if (SVNRevision.isValidRevisionNumber((long)sVNErrorMessage) && SVNRevision.isValidRevisionNumber((long)sVNErrorMessage5) && sVNErrorMessage != sVNErrorMessage5) {
                    if (!bl2) {
                        SVNErrorMessage sVNErrorMessage6 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_MIXED_REVISIONS, (String)"Cannot move mixed-revision subtree ''{0}'' [{1}:{2}]; try updating it first", (Object[])new Object[]{file, (long)sVNErrorMessage, (long)sVNErrorMessage5});
                        SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage6, (SVNLogType)SVNLogType.WC);
                    }
                    bl3 = false;
                    bl5 = true;
                }
            }
            if (sVNWCDbStatus2 == ISVNWCDb.SVNWCDbStatus.Deleted && bl) {
                object = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ILLEGAL_TARGET, (String)"Cannot perform 'virtual' {0}: ''{1}'' is a directory", (Object[])new Object[]{bl3 ? "move" : "copy", file});
                SVNErrorManager.error((SVNErrorMessage)object, (SVNLogType)SVNLogType.WC);
            } else {
                this.copyVersionedDirectory(sVNWCContext, file, file2, file2, (File)object2, bl, bl3, true);
            }
        }
        if (bl3) {
            sVNWCContext.getDb().opHandleMoveBack(file2, file, null);
        }
        sVNWCContext.wqRun(file2);
        return bl5;
    }

    private boolean shouldCopyBaseData(SVNWCContext sVNWCContext, File file, boolean bl, ISVNWCDb.SVNWCDbStatus sVNWCDbStatus) throws SVNException {
        if (!bl) {
            return false;
        }
        if (sVNWCDbStatus == ISVNWCDb.SVNWCDbStatus.Deleted) {
            return true;
        }
        SvnStatus svnStatus = SVNStatusEditor17.internalStatus((SVNWCContext)sVNWCContext, (File)file);
        return svnStatus != null && svnStatus.getNodeStatus() == SVNStatusType.STATUS_REPLACED;
    }

    private void copyBaseDataOfFile(SVNWCContext sVNWCContext, File file, File file2) throws SVNException {
        SVNProperties sVNProperties = sVNWCContext.getPristineProps(file);
        ISVNWCDb.WCDbBaseInfo wCDbBaseInfo = sVNWCContext.getDb().getBaseInfo(file, new ISVNWCDb.WCDbBaseInfo.BaseInfoField[]{ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedAuthor, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedDate, ISVNWCDb.WCDbBaseInfo.BaseInfoField.changedRev, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposUuid});
        String string = wCDbBaseInfo.changedAuthor;
        SVNDate sVNDate = wCDbBaseInfo.changedDate;
        long l2 = wCDbBaseInfo.changedRev;
        SvnChecksum svnChecksum = wCDbBaseInfo.checksum;
        long l3 = wCDbBaseInfo.revision;
        SVNURL sVNURL = wCDbBaseInfo.reposRootUrl;
        String string2 = wCDbBaseInfo.reposUuid;
        sVNWCContext.getDb().opCopyFile(file2, sVNProperties, l2, sVNDate, string, sVNWCContext.getNodeReposRelPath(file.getAbsoluteFile()), sVNURL, string2, l3, svnChecksum, false, null, null, null);
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent((File)file2, (SVNNodeKind)SVNNodeKind.FILE, null, (long)-1L, (SVNEventAction)SVNEventAction.COPY, null, null, null);
        this.handleEvent(sVNEvent);
    }

    private void copyVersionedDirectory(SVNWCContext sVNWCContext, File file, File file2, File file3, File file4, boolean bl, boolean bl2, boolean bl3) throws SVNException {
        SVNErrorMessage sVNErrorMessage;
        Object object;
        File file5;
        Object object2;
        Object object32;
        Object object4;
        Object object5;
        SVNSkel sVNSkel = null;
        File file6 = SVNFileUtil.getParentFile((File)file2);
        SVNNodeKind sVNNodeKind = SVNNodeKind.UNKNOWN;
        if (!bl) {
            object5 = this.copyToTmpDir(file, file2, file4, false, false);
            sVNSkel = ((CopyToTmpDir)object5).workItem;
            sVNNodeKind = ((CopyToTmpDir)object5).kind;
        }
        sVNWCContext.getDb().opCopy(file, file2, file3, bl2, sVNSkel);
        if (bl3 && sVNWCContext.getEventHandler() != null) {
            object5 = SVNEventFactory.createSVNEvent((File)file2, (SVNNodeKind)SVNNodeKind.DIR, null, (long)-1L, (SVNEventAction)SVNEventAction.ADD, (SVNEventAction)SVNEventAction.ADD, null, null);
            if (sVNSkel != null) {
                sVNWCContext.wqRun(file6);
            }
            sVNWCContext.getEventHandler().handleEvent((SVNEvent)object5, -1.0);
        }
        object5 = null;
        if (!bl && sVNNodeKind == SVNNodeKind.DIR) {
            object4 = SVNFileListUtil.listFiles((File)file);
            if (object4 != null) {
                object5 = new HashSet();
                for (Object object32 : object4) {
                    object5.add(SVNFileUtil.getFileName((File)object32));
                }
            } else {
                object5 = null;
            }
        } else {
            object5 = null;
        }
        object4 = new HashMap();
        Object object6 = new HashSet();
        sVNWCContext.getDb().readChildren(file, (Map)object4, (Set)object6);
        for (Map.Entry entry : object4.entrySet()) {
            if (sVNWCContext.getEventHandler() != null) {
                sVNWCContext.getEventHandler().checkCancelled();
            }
            object32 = (String)entry.getKey();
            object2 = (ISVNWCDb.SVNWCDbInfo)entry.getValue();
            file5 = SVNFileUtil.createFilePath((File)file, (String)object32);
            object = SVNFileUtil.createFilePath((File)file2, (String)object32);
            if (object2.opRoot) {
                sVNWCContext.getDb().opCopyShadowedLayer(file5, (File)object, bl2);
            }
            if (object2.status == ISVNWCDb.SVNWCDbStatus.Normal || object2.status == ISVNWCDb.SVNWCDbStatus.Added) {
                if (object2.kind == ISVNWCDb.SVNWCDbKind.File) {
                    if (!object2.fileExternal) {
                        this.copyVersionedFile(sVNWCContext, file5, (File)object, file3, file4, bl, object2.conflicted, bl2, false);
                    }
                } else if (object2.kind == ISVNWCDb.SVNWCDbKind.Dir) {
                    this.copyVersionedDirectory(sVNWCContext, file5, (File)object, file3, file4, bl, bl2, false);
                } else {
                    sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.NODE_UNEXPECTED_KIND, (String)"cannot handle node kind for ''{0}''", (Object)file5);
                    SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
                }
            } else if (object2.status == ISVNWCDb.SVNWCDbStatus.Deleted || object2.status == ISVNWCDb.SVNWCDbStatus.NotPresent || object2.status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                sVNWCContext.getDb().opCopy(file5, (File)object, file3, bl2, null);
            } else if (object2.status == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, (String)"Cannot handle status of ''{0}''", (Object)file5);
                SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
            } else {
                assert (object2.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded);
                sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, (String)"Cannot copy ''{0}'' excluded by server", (Object)file5);
                SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
            }
            if (object5 == null || object2.status != ISVNWCDb.SVNWCDbStatus.Normal && object2.status != ISVNWCDb.SVNWCDbStatus.Added) continue;
            object5.remove(object32);
        }
        if (object5 != null && object5.size() > 0) {
            List list = sVNWCContext.getDb().getConflictMarkerFiles(file);
            sVNSkel = null;
            Iterator iterator = object5.iterator();
            while (iterator.hasNext()) {
                object32 = (String)iterator.next();
                if (((String)(object32 = SVNPathUtil.tail((String)object32))).equals(SVNFileUtil.getAdminDirectoryName())) continue;
                if (sVNWCContext.getEventHandler() != null) {
                    sVNWCContext.getEventHandler().checkCancelled();
                }
                object2 = SVNFileUtil.createFilePath((File)file, (String)object32);
                file5 = SVNFileUtil.createFilePath((File)file2, (String)object32);
                if (list != null && list.contains(object2)) continue;
                object = this.copyToTmpDir((File)object2, file5, file4, true, true);
                sVNErrorMessage = ((CopyToTmpDir)object).workItem;
                if (sVNErrorMessage == null) continue;
                sVNSkel = SVNWCContext.wqMerge((SVNSkel)sVNSkel, (SVNSkel)sVNErrorMessage);
            }
            sVNWCContext.getDb().addWorkQueue(file2, sVNSkel);
        }
    }

    private void copyVersionedFile(SVNWCContext sVNWCContext, File file, File file2, File file3, File file4, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SVNException {
        File file5;
        SVNSkel sVNSkel = null;
        if (!bl) {
            Object object;
            file5 = file;
            boolean bl5 = false;
            if (bl2) {
                File file6;
                object = sVNWCContext.getDb().readConflict(file);
                try {
                    Structure structure = SvnWcDbConflicts.readTextConflict((ISVNWCDb)sVNWCContext.getDb(), (File)file, (SVNSkel)object);
                    file6 = (File)structure.get((Enum)SvnWcDbConflicts.TextConflictInfo.mineAbsPath);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_MISSING) {
                        throw sVNException;
                    }
                    file6 = null;
                }
                if (file6 != null && SVNFileType.getType((File)file6) == SVNFileType.FILE) {
                    bl5 = true;
                    file5 = file6;
                }
            }
            object = this.copyToTmpDir(file5, file2, file4, true, bl5);
            sVNSkel = object.workItem;
        }
        sVNWCContext.getDb().opCopy(file, file2, file3, bl3, sVNSkel);
        sVNWCContext.wqRun(SVNFileUtil.getParentFile((File)file2));
        if (bl4) {
            if (sVNSkel != null) {
                this.getWcContext().wqRun(file2);
            }
            file5 = SVNEventFactory.createSVNEvent((File)file2, (SVNNodeKind)SVNNodeKind.FILE, null, (long)-1L, (SVNEventAction)SVNEventAction.ADD, (SVNEventAction)SVNEventAction.ADD, null, null, (long)1L, (long)1L);
            this.handleEvent((SVNEvent)file5, -1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CopyToTmpDir copyToTmpDir(File file, File file2, File file3, boolean bl, boolean bl2) throws SVNException {
        Object object;
        boolean bl3;
        boolean bl4 = false;
        CopyToTmpDir copyToTmpDir = new CopyToTmpDir();
        copyToTmpDir.workItem = null;
        SVNFileType sVNFileType = SVNFileType.getType((File)file);
        copyToTmpDir.kind = SVNFileType.getNodeKind((SVNFileType)sVNFileType);
        boolean bl5 = bl3 = sVNFileType == SVNFileType.SYMLINK;
        if (copyToTmpDir.kind == SVNNodeKind.NONE) {
            return copyToTmpDir;
        }
        if (copyToTmpDir.kind == SVNNodeKind.UNKNOWN) {
            object = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.NODE_UNEXPECTED_KIND, (String)"Source ''{0}'' is unexpected kind", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, (SVNLogType)SVNLogType.WC);
        } else {
            bl4 = copyToTmpDir.kind == SVNNodeKind.DIR;
        }
        object = null;
        try {
            if (bl && !bl2) {
                boolean bl6;
                boolean bl7 = bl6 = this.getWcContext().isTextModified(file, false) || this.getWcContext().isPropsModified(file);
                if (!bl6) {
                    copyToTmpDir.workItem = this.getWcContext().wqBuildFileInstall(file2, null, false, true);
                    CopyToTmpDir copyToTmpDir2 = copyToTmpDir;
                    return copyToTmpDir2;
                }
            }
            File file4 = object = copyToTmpDir.kind == SVNNodeKind.DIR ? SVNFileUtil.createUniqueDir((File)file3, (String)SVNFileUtil.getFileName((File)file), (String)".tmp", (boolean)false) : SVNFileUtil.createUniqueFile((File)file3, (String)SVNFileUtil.getFileName((File)file), (String)".tmp", (boolean)false);
            if (copyToTmpDir.kind == SVNNodeKind.DIR) {
                if (bl) {
                    SVNFileUtil.copyDirectory((File)file, (File)object, (boolean)false, (ISVNEventHandler)((SvnCopy)this.getOperation()).getEventHandler());
                } else {
                    SVNFileUtil.ensureDirectoryExists((File)object);
                }
            } else if (!bl3) {
                SVNFileUtil.copyFile((File)file, (File)object, (boolean)false, (boolean)true);
            } else {
                SVNFileUtil.deleteFile((File)object);
                SVNFileUtil.copySymlink((File)file, (File)object);
            }
            if (bl) {
                SVNFileUtil.setReadonly((File)object, (boolean)false);
            }
            copyToTmpDir.workItem = this.getWcContext().wqBuildFileMove(file2, (File)object, file2);
            CopyToTmpDir copyToTmpDir3 = copyToTmpDir;
            return copyToTmpDir3;
        }
        finally {
            if (object != null && bl4 && copyToTmpDir.kind == SVNNodeKind.FILE) {
                SVNFileUtil.deleteFile((File)object);
            }
        }
    }

    private static class SvnCopyPair {
        File source;
        File dst;
        File dstParent;
        String baseName;

        private SvnCopyPair() {
        }
    }

    private static class CopyToTmpDir {
        SVNSkel workItem;
        SVNNodeKind kind;

        private CopyToTmpDir() {
        }
    }
}

