/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SVNHashMapOriginal
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object NULL_KEY = new Object();
    private static final int INITIAL_CAPACITY = 16;
    private static boolean ourIsCompatibilityMode = Boolean.getBoolean("svnkit.compatibleHash");
    private transient TableEntry[] myTable;
    private transient int myEntryCount;
    private transient int myModCount;
    private volatile transient Set myKeySet;
    private volatile transient Set myEntrySet;
    private volatile transient Collection myValueCollection;

    public SVNHashMapOriginal() {
        this(null);
    }

    public SVNHashMapOriginal(Map map) {
        this.init();
        this.putAll(map);
    }

    protected void init() {
        this.myTable = new TableEntry[16];
        this.myEntryCount = 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.myTable, null);
        this.myEntryCount = 0;
        ++this.myModCount;
    }

    @Override
    public boolean isEmpty() {
        return this.myEntryCount == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        if (this.isEmpty()) {
            return false;
        }
        object = object == null ? NULL_KEY : object;
        int n2 = SVNHashMapOriginal.hashCode(object);
        int n3 = this.indexForHash(n2);
        TableEntry tableEntry = this.myTable[n3];
        while (tableEntry != null) {
            if (tableEntry.hash == n2 && SVNHashMapOriginal.eq(object, tableEntry.key)) {
                return true;
            }
            tableEntry = tableEntry.next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (this.isEmpty()) {
            return false;
        }
        if (object == null) {
            return this.containsNullValue();
        }
        for (int i2 = 0; i2 < this.myTable.length; ++i2) {
            TableEntry tableEntry = this.myTable[i2];
            while (tableEntry != null) {
                if (object.equals(tableEntry.getValue())) {
                    return true;
                }
                tableEntry = tableEntry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        for (int i2 = 0; i2 < this.myTable.length; ++i2) {
            TableEntry tableEntry = this.myTable[i2];
            while (tableEntry != null) {
                if (tableEntry.getValue() == null) {
                    return true;
                }
                tableEntry = tableEntry.next;
            }
        }
        return false;
    }

    public Object get(Object object) {
        object = object == null ? NULL_KEY : object;
        int n2 = SVNHashMapOriginal.hashCode(object);
        int n3 = this.indexForHash(n2);
        TableEntry tableEntry = this.myTable[n3];
        while (tableEntry != null) {
            if (n2 == tableEntry.hash && SVNHashMapOriginal.eq(object, tableEntry.key)) {
                return tableEntry.getValue();
            }
            tableEntry = tableEntry.next;
        }
        return null;
    }

    @Override
    public int size() {
        return this.myEntryCount;
    }

    public Object put(Object object, Object object2) {
        object = object == null ? NULL_KEY : object;
        int n2 = SVNHashMapOriginal.hashCode(object);
        int n3 = this.indexForHash(n2);
        TableEntry tableEntry = this.myTable[n3];
        TableEntry tableEntry2 = null;
        while (tableEntry != null) {
            if (tableEntry.hash == n2 && tableEntry.key.equals(object)) {
                ++this.myModCount;
                return tableEntry.setValue(object2);
            }
            tableEntry2 = tableEntry;
            tableEntry = tableEntry.next;
        }
        TableEntry tableEntry3 = this.createTableEntry(object, object2, n2);
        if (tableEntry2 != null) {
            tableEntry2.next = tableEntry3;
        } else {
            this.myTable[n3] = tableEntry3;
        }
        ++this.myEntryCount;
        ++this.myModCount;
        if (this.myEntryCount >= this.myTable.length) {
            this.resize(this.myTable.length * 2);
        }
        return null;
    }

    protected TableEntry createTableEntry(Object object, Object object2, int n2) {
        return new TableEntry(object, object2, n2);
    }

    public Object remove(Object object) {
        if (this.isEmpty()) {
            return null;
        }
        object = object == null ? NULL_KEY : object;
        int n2 = SVNHashMapOriginal.hashCode(object);
        int n3 = this.indexForHash(n2);
        TableEntry tableEntry = this.myTable[n3];
        TableEntry tableEntry2 = null;
        while (tableEntry != null) {
            if (tableEntry.hash == n2 && tableEntry.key.equals(object)) {
                if (tableEntry2 != null) {
                    tableEntry2.next = tableEntry.next;
                } else {
                    this.myTable[n3] = tableEntry.next;
                }
                --this.myEntryCount;
                ++this.myModCount;
                return tableEntry.getValue();
            }
            tableEntry2 = tableEntry;
            tableEntry = tableEntry.next;
        }
        return null;
    }

    public void putAll(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (this.myEntryCount + map.size() >= this.myTable.length) {
            this.resize((this.myEntryCount + map.size()) * 2);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set keySet() {
        if (this.myKeySet == null) {
            this.myKeySet = new KeySet();
        }
        return this.myKeySet;
    }

    public Set entrySet() {
        if (this.myEntrySet == null) {
            this.myEntrySet = new EntrySet();
        }
        return this.myEntrySet;
    }

    public Collection values() {
        if (this.myValueCollection == null) {
            this.myValueCollection = new ValueCollection();
        }
        return this.myValueCollection;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry entry : this.entrySet()) {
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                if (!(v2 == null ? map.get(k2) != null || !map.containsKey(k2) : !v2.equals(map.get(k2)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n2 += iterator.next().hashCode();
        }
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        SVNHashMapOriginal sVNHashMapOriginal = new SVNHashMapOriginal();
        sVNHashMapOriginal.myTable = new TableEntry[this.myTable.length];
        sVNHashMapOriginal.myEntryCount = this.myEntryCount;
        sVNHashMapOriginal.myModCount = this.myModCount;
        sVNHashMapOriginal.putAll((Map)this);
        return sVNHashMapOriginal;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Iterator iterator = this.myEntryCount > 0 ? this.entrySet().iterator() : null;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.myTable.length);
        objectOutputStream.writeInt(this.myEntryCount);
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.myTable = new TableEntry[n2];
        int n3 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Iterator iterator = this.entrySet().iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k2 = entry.getKey();
            Object v2 = entry.getValue();
            stringBuffer.append((Object)(k2 == this ? "(this Map)" : k2));
            stringBuffer.append("=");
            stringBuffer.append((Object)(v2 == this ? "(this Map)" : v2));
            bl = iterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private int indexForHash(int n2) {
        return this.myTable.length - 1 & n2;
    }

    private static int hashCode(Object object) {
        if (ourIsCompatibilityMode && String.class == object.getClass()) {
            int n2 = 0;
            String string = (String)object;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                n2 = n2 * 33 + string.charAt(i2);
            }
            return n2;
        }
        if (object.getClass() == File.class) {
            return SVNHashMapOriginal.hashCode(((File)object).getPath());
        }
        return object.hashCode();
    }

    private void resize(int n2) {
        TableEntry[] tableEntryArray = this.myTable;
        this.myTable = new TableEntry[n2];
        for (int i2 = 0; i2 < tableEntryArray.length; ++i2) {
            TableEntry tableEntry = tableEntryArray[i2];
            while (tableEntry != null) {
                int n3 = this.indexForHash(tableEntry.hash);
                TableEntry tableEntry2 = this.myTable[n3];
                if (tableEntry2 == null) {
                    this.myTable[n3] = tableEntry;
                } else {
                    while (tableEntry2.next != null) {
                        tableEntry2 = tableEntry2.next;
                    }
                    tableEntry2.next = tableEntry;
                }
                TableEntry tableEntry3 = tableEntry.next;
                tableEntry.next = null;
                tableEntry = tableEntry3;
            }
        }
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    protected static class TableEntry
    implements Map.Entry {
        private TableEntry next;
        private Object key;
        private Object value;
        private int hash;

        protected TableEntry() {
        }

        public TableEntry(Object object, Object object2, int n2) {
            this.init(object, object2, n2);
        }

        protected void init(Object object, Object object2, int n2) {
            this.key = object;
            this.setValue(object2);
            this.hash = n2;
        }

        public Object setValue(Object object) {
            Object object2 = this.getValue();
            this.value = object;
            return object2;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getKey() {
            return this.key == NULL_KEY ? null : this.key;
        }

        @Override
        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            Object object2;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object3 = this.getKey();
            return (object3 == (k2 = entry.getKey()) || object3 != null && object3.equals(k2)) && ((object2 = this.getValue()) == (v2 = entry.getValue()) || object2 != null && object2.equals(v2));
        }
    }

    private class ValueIterator
    extends TableIterator {
        private ValueIterator() {
        }

        @Override
        public Object next() {
            TableEntry tableEntry = (TableEntry)super.next();
            return tableEntry.getValue();
        }
    }

    private class KeyIterator
    extends TableIterator {
        private KeyIterator() {
        }

        @Override
        public Object next() {
            TableEntry tableEntry = (TableEntry)super.next();
            return tableEntry.getKey();
        }
    }

    private class TableIterator
    implements Iterator {
        private int index = 0;
        private TableEntry entry = null;
        private TableEntry previous;
        private int modCount;

        public TableIterator() {
            this.modCount = SVNHashMapOriginal.this.myModCount;
            while (this.index < SVNHashMapOriginal.this.myTable.length && this.entry == null) {
                this.entry = SVNHashMapOriginal.this.myTable[this.index];
                ++this.index;
            }
        }

        @Override
        public boolean hasNext() {
            return this.entry != null;
        }

        public Object next() {
            if (SVNHashMapOriginal.this.myModCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            this.previous = this.entry;
            this.entry = this.entry.next;
            while (this.entry == null && this.index < SVNHashMapOriginal.this.myTable.length) {
                this.entry = SVNHashMapOriginal.this.myTable[this.index];
                ++this.index;
            }
            return this.previous;
        }

        @Override
        public void remove() {
            if (SVNHashMapOriginal.this.myModCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            SVNHashMapOriginal.this.remove(this.previous.getKey());
            this.previous = null;
            this.modCount = SVNHashMapOriginal.this.myModCount;
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return SVNHashMapOriginal.this.myEntryCount;
        }

        @Override
        public boolean contains(Object object) {
            return SVNHashMapOriginal.this.containsValue(object);
        }

        @Override
        public void clear() {
            SVNHashMapOriginal.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new TableIterator();
        }

        @Override
        public int size() {
            return SVNHashMapOriginal.this.myEntryCount;
        }

        @Override
        public boolean contains(Object object) {
            Map.Entry entry;
            if (object instanceof Map.Entry && SVNHashMapOriginal.this.containsKey((entry = (Map.Entry)object).getKey())) {
                Object object2 = SVNHashMapOriginal.this.get(entry.getKey());
                if (object2 == null) {
                    return entry.getValue() == null;
                }
                return object2.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                Map.Entry entry = (Map.Entry)object;
                return SVNHashMapOriginal.this.remove(entry.getKey()) != null;
            }
            return false;
        }

        @Override
        public void clear() {
            SVNHashMapOriginal.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SVNHashMapOriginal.this.myEntryCount;
        }

        @Override
        public boolean contains(Object object) {
            return SVNHashMapOriginal.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return SVNHashMapOriginal.this.remove(object) != null;
        }

        @Override
        public void clear() {
            SVNHashMapOriginal.this.clear();
        }
    }
}

