/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.resolver.BasicResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.ditang.relaxng.defaults.RNCDefaultValues;
import org.ditang.relaxng.defaults.RNGDefaultValues;
import org.ditang.relaxng.defaults.RelaxNGDefaultValues;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RelaxNGDefaultsComponent
implements XMLDocumentHandler,
XMLComponent,
XMLDocumentSource {
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String[] RECOGNIZED_FEATURES = new String[0];
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[0];
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/entity-resolver"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null, null};
    private XMLDocumentHandler documentHandler;
    private XMLDocumentSource documentSource;
    private boolean detecting = false;
    private String schema = null;
    private String type = null;
    private String baseSystemId = null;
    private RelaxNGDefaultValues defaults;
    private NamespaceContext context;
    private SymbolTable fSymbolTable;
    private XMLEntityResolver fResolver;
    public static boolean DEBUG = false;
    private Resolver resolver;

    public RelaxNGDefaultsComponent(Resolver resolver) {
        this.resolver = resolver;
        if (this.resolver == null) {
            this.resolver = new Resolver(){

                public void resolve(Identifier identifier, Input input) throws IOException, ResolverException {
                    if (RelaxNGDefaultsComponent.this.fResolver != null) {
                        String string = identifier.getUriReference();
                        try {
                            string = new URL(new URL(identifier.getBase()), identifier.getUriReference()).toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        XMLResourceIdentifierImpl xMLResourceIdentifierImpl = new XMLResourceIdentifierImpl(null, identifier.getUriReference(), identifier.getBase(), string);
                        XMLInputSource xMLInputSource = RelaxNGDefaultsComponent.this.fResolver.resolveEntity((XMLResourceIdentifier)xMLResourceIdentifierImpl);
                        if (xMLInputSource != null) {
                            input.setUri(xMLInputSource.getSystemId());
                            input.setByteStream(xMLInputSource.getByteStream());
                            input.setCharacterStream(xMLInputSource.getCharacterStream());
                            input.setEncoding(xMLInputSource.getEncoding());
                        }
                    }
                }

                public void open(Input input) throws IOException, ResolverException {
                    BasicResolver.getInstance().open(input);
                }
            };
        }
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.baseSystemId = null;
        this.detecting = false;
        this.schema = null;
        this.type = null;
        this.context = null;
        this.defaults = null;
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fResolver = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_RESOLVER);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.context = namespaceContext;
        this.baseSystemId = xMLLocator.getBaseSystemId();
        this.detecting = true;
        this.schema = null;
        this.type = null;
        if (this.documentHandler != null) {
            this.documentHandler.startDocument(xMLLocator, string, namespaceContext, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.onStartElement(qName, xMLAttributes);
        if (this.documentHandler != null) {
            this.documentHandler.startElement(qName, xMLAttributes, augmentations);
        }
    }

    private void onStartElement(QName qName, XMLAttributes xMLAttributes) {
        if (this.detecting) {
            this.detecting = false;
            this.loadDefaults();
        }
        if (this.defaults != null) {
            this.checkAndAddDefaults(qName, xMLAttributes);
        }
    }

    private void loadDefaults() {
        block15: {
            this.defaults = null;
            ErrorHandler errorHandler = new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                    if (DEBUG) {
                        sAXParseException.printStackTrace();
                    }
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                    if (DEBUG) {
                        sAXParseException.printStackTrace();
                    }
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    if (DEBUG) {
                        sAXParseException.printStackTrace();
                    }
                }
            };
            if (this.schema != null) {
                if ("xml".equals(this.type)) {
                    this.defaults = new RNGDefaultValues(this.resolver, errorHandler);
                }
                if ("compact".equals(this.type)) {
                    this.defaults = new RNCDefaultValues(this.resolver, errorHandler);
                }
                if (this.defaults != null) {
                    Input input;
                    block14: {
                        Identifier identifier = new Identifier(this.schema, this.baseSystemId);
                        input = new Input();
                        try {
                            this.resolver.resolve(identifier, input);
                        }
                        catch (IOException iOException) {
                            if (DEBUG) {
                                iOException.printStackTrace();
                            }
                        }
                        catch (ResolverException resolverException) {
                            if (!DEBUG) break block14;
                            resolverException.printStackTrace();
                        }
                    }
                    InputSource inputSource = null;
                    if (input.isResolved()) {
                        inputSource = new InputSource(input.getUri());
                        inputSource.setByteStream(input.getByteStream());
                        inputSource.setCharacterStream(input.getCharacterStream());
                        inputSource.setEncoding(input.getEncoding());
                    } else {
                        String string = this.schema;
                        try {
                            string = new URL(new URL(this.baseSystemId), this.schema).toString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        inputSource = new InputSource(string);
                    }
                    try {
                        this.defaults.update(inputSource);
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block15;
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    private void checkAndAddDefaults(QName qName, XMLAttributes xMLAttributes) {
        List<RelaxNGDefaultValues.Attribute> list = this.defaults.getDefaultAttributes(qName.localpart, qName.uri);
        if (list != null) {
            for (RelaxNGDefaultValues.Attribute attribute : list) {
                boolean bl = false;
                boolean bl2 = bl = xMLAttributes.getIndex(attribute.namespace, attribute.localName) >= 0;
                if (!bl && "".equals(attribute.namespace)) {
                    boolean bl3 = bl = xMLAttributes.getIndex(null, attribute.localName) >= 0;
                }
                if (bl) continue;
                String string = null;
                String string2 = attribute.localName;
                if (attribute.namespace != null && attribute.namespace.length() > 0) {
                    String string3;
                    int n2;
                    string = this.context.getPrefix(attribute.namespace);
                    if (string == null) {
                        for (n2 = 0; n2 < xMLAttributes.getLength(); ++n2) {
                            string3 = xMLAttributes.getQName(n2);
                            if (!string3.startsWith("xmlns:") || !attribute.namespace.equals(xMLAttributes.getValue(n2))) continue;
                            string = string3.substring(6);
                        }
                    }
                    if (string != null && string.length() > 0) {
                        string2 = string + ":" + attribute.localName;
                        if (xMLAttributes.getIndex(string2) >= 0) continue;
                        QName qName2 = new QName(this.fSymbolTable.addSymbol(string), this.fSymbolTable.addSymbol(attribute.localName), this.fSymbolTable.addSymbol(string2), this.fSymbolTable.addSymbol(attribute.namespace));
                        xMLAttributes.addAttribute(qName2, "CDATA", attribute.value);
                        int n3 = xMLAttributes.getIndex(qName2.uri, qName2.localpart);
                        xMLAttributes.setSpecified(n3, false);
                        continue;
                    }
                    n2 = 1;
                    string = "http://dita.oasis-open.org/architecture/2005/".equals(attribute.namespace) ? "ditaarch" : "ns" + n2;
                    while (this.context.getURI(string) != null || xMLAttributes.getValue("xmlns:" + string) != null) {
                        string = "ns" + ++n2;
                    }
                    string2 = string + ":" + attribute.localName;
                    string3 = new QName(this.fSymbolTable.addSymbol("xmlns"), this.fSymbolTable.addSymbol(string), this.fSymbolTable.addSymbol("xmlns:" + string), this.fSymbolTable.addSymbol("http://www.w3.org/2000/xmlns/"));
                    xMLAttributes.addAttribute((QName)string3, "CDATA", attribute.namespace);
                    this.context.declarePrefix(string, attribute.namespace);
                    QName qName3 = new QName(this.fSymbolTable.addSymbol(string), this.fSymbolTable.addSymbol(attribute.localName), this.fSymbolTable.addSymbol(string2), this.fSymbolTable.addSymbol(attribute.namespace));
                    xMLAttributes.addAttribute(qName3, "CDATA", attribute.value);
                    int n4 = xMLAttributes.getIndex(qName3.uri, qName3.localpart);
                    xMLAttributes.setSpecified(n4, false);
                    continue;
                }
                String string4 = this.fSymbolTable.addSymbol(attribute.localName);
                QName qName4 = new QName(null, string4, string4, null);
                xMLAttributes.addAttribute(qName4, "CDATA", attribute.value);
                int n5 = xMLAttributes.getIndex(string4);
                xMLAttributes.setSpecified(n5, false);
            }
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.doctypeDecl(string, string2, string3, augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        String string2;
        if (this.detecting && this.schema == null && "oxygen".equals(string)) {
            string2 = xMLString.toString();
            this.schema = this.getFromPIDataPseudoAttribute(string2, "RNGSchema", true);
            this.type = this.getFromPIDataPseudoAttribute(string2, "type", true);
        }
        if (this.detecting && this.schema == null && "xml-model".equals(string)) {
            string2 = xMLString.toString();
            this.schema = this.getFromPIDataPseudoAttribute(string2, "href", true);
            this.type = this.getFromPIDataPseudoAttribute(string2, "type", true);
            String string3 = this.getFromPIDataPseudoAttribute(string2, "schematypens", true);
            if (this.schema != null) {
                if (this.schema.toLowerCase().endsWith(".rng")) {
                    if (this.nullOrValue(string3, "http://relaxng.org/ns/structure/1.0") && this.nullOrValue(this.type, "application/xml")) {
                        this.type = "xml";
                    } else {
                        this.schema = null;
                    }
                } else if (this.schema.toLowerCase().endsWith(".rnc")) {
                    if (this.nullOrValue(string3, "http://relaxng.org/ns/structure/1.0") && this.nullOrValue(this.type, "application/relax-ng-compact-syntax")) {
                        this.type = "compact";
                    } else {
                        this.schema = null;
                    }
                } else if ("http://relaxng.org/ns/structure/1.0".equals(string3) && this.nullOrValue(this.type, "application/xml")) {
                    this.type = "xml";
                } else if ("application/relax-ng-compact-syntax".equals(this.type) && this.nullOrValue(string3, "http://relaxng.org/ns/structure/1.0")) {
                    this.type = "compact";
                } else {
                    this.schema = null;
                }
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.processingInstruction(string, xMLString, augmentations);
        }
    }

    private boolean nullOrValue(String string, String string2) {
        if (string == null) {
            return true;
        }
        return string.equals(string2);
    }

    private String getFromPIDataPseudoAttribute(String string, String string2, boolean bl) {
        int n2 = 0;
        while (n2 <= string.length() - 4) {
            int n3;
            int n4 = -1;
            for (n3 = n2; n3 < string.length(); ++n3) {
                if (string.charAt(n3) != '\"' && string.charAt(n3) != '\'') continue;
                n4 = n3;
                break;
            }
            if (n4 < 0) {
                return null;
            }
            n3 = string.indexOf(string.charAt(n4), n4 + 1);
            if (n3 < 0) {
                return null;
            }
            int n5 = string.indexOf(string2, n2);
            if (n5 < 0) {
                return null;
            }
            if (n5 < n4) {
                boolean bl2 = true;
                for (int i2 = n5 + string2.length(); i2 < n4; ++i2) {
                    char c2 = string.charAt(i2);
                    if (Character.isWhitespace(c2) || c2 == '=') continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    String string3 = string.substring(n4 + 1, n3);
                    return bl ? this.unescape(string3) : string3;
                }
            }
            n2 = n3 + 1;
        }
        return null;
    }

    private String unescape(String string) {
        if (string.indexOf(38) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '&') {
                if (i2 + 2 < string.length() && string.charAt(i2 + 1) == '#') {
                    int n2;
                    int n3;
                    int n4;
                    if (string.charAt(i2 + 2) == 'x') {
                        n4 = 0;
                        for (n3 = i2 + 3; n3 < string.length() && string.charAt(n3) != ';'; ++n3) {
                            n2 = "0123456789abcdef".indexOf(string.charAt(n3));
                            if (n2 < 0) {
                                n2 = "0123456789ABCDEF".indexOf(string.charAt(n3));
                            }
                            if (n2 < 0) {
                                return null;
                            }
                            n4 = n4 * 16 + n2;
                        }
                        n2 = n4;
                        stringBuilder.append((char)n2);
                        i2 = n3;
                        continue;
                    }
                    n4 = 0;
                    for (n3 = i2 + 2; n3 < string.length() && string.charAt(n3) != ';'; ++n3) {
                        n2 = "0123456789".indexOf(string.charAt(n3));
                        if (n2 < 0) {
                            return null;
                        }
                        n4 = n4 * 10 + n2;
                    }
                    n2 = (char)n4;
                    stringBuilder.append((char)n2);
                    i2 = n3;
                    continue;
                }
                if (string.substring(i2 + 1).startsWith("lt;")) {
                    stringBuilder.append('<');
                    i2 += 3;
                    continue;
                }
                if (string.substring(i2 + 1).startsWith("gt;")) {
                    stringBuilder.append('>');
                    i2 += 3;
                    continue;
                }
                if (string.substring(i2 + 1).startsWith("amp;")) {
                    stringBuilder.append('&');
                    i2 += 4;
                    continue;
                }
                if (string.substring(i2 + 1).startsWith("quot;")) {
                    stringBuilder.append('\"');
                    i2 += 5;
                    continue;
                }
                if (string.substring(i2 + 1).startsWith("apos;")) {
                    stringBuilder.append('\'');
                    i2 += 5;
                    continue;
                }
                return null;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.onStartElement(qName, xMLAttributes);
        if (this.documentHandler != null) {
            this.documentHandler.emptyElement(qName, xMLAttributes, augmentations);
        }
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endGeneralEntity(string, augmentations);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.characters(xMLString, augmentations);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(xMLString, augmentations);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endElement(qName, augmentations);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endCDATA(augmentations);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        if (this.documentHandler != null) {
            this.documentHandler.endDocument(augmentations);
        }
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.documentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.documentSource;
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            int n2 = string.length() - "http://apache.org/xml/properties/".length();
            if (n2 == "internal/symbol-table".length() && string.endsWith("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
            } else if (n2 == "internal/entity-resolver".length() && string.endsWith("internal/entity-resolver")) {
                this.fResolver = (XMLEntityResolver)object;
            }
        }
    }

    public Boolean getFeatureDefault(String string) {
        for (int i2 = 0; i2 < RECOGNIZED_FEATURES.length; ++i2) {
            if (!RECOGNIZED_FEATURES[i2].equals(string)) continue;
            return FEATURE_DEFAULTS[i2];
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        for (int i2 = 0; i2 < RECOGNIZED_PROPERTIES.length; ++i2) {
            if (!RECOGNIZED_PROPERTIES[i2].equals(string)) continue;
            return PROPERTY_DEFAULTS[i2];
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.documentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }
}

