/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.tools;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.util.URI;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolverXerces;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import ro.sync.io.e;

public class CatalogResolver
extends CatalogResolverXerces
implements LSResourceResolver {
    private static final Logger logger = Logger.getLogger((String)CatalogResolver.class.getName());

    public CatalogResolver() {
    }

    public CatalogResolver(boolean bl) {
        super(bl);
    }

    public CatalogResolver(CatalogManager catalogManager) {
        super(catalogManager);
    }

    @Override
    protected void setEntityResolver(SAXSource sAXSource) throws TransformerException {
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            xMLReader = this.createNewReader();
        }
        xMLReader.setEntityResolver(this);
        sAXSource.setXMLReader(xMLReader);
    }

    protected XMLReader createNewReader() throws TransformerException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformerException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        String string3 = this.getResolvedEntity(string, string2);
        if (string3 != null) {
            try {
                InputSource inputSource = new InputSource(string3);
                inputSource.setPublicId(string);
                URL uRL = new URL(string3);
                e e2 = new e(uRL);
                inputSource.setByteStream(e2);
                return inputSource;
            }
            catch (Exception exception) {
                this.catalogManager.debug.message(1, "Failed to create InputSource (" + exception.toString() + ")", string3);
                return null;
            }
        }
        return null;
    }

    @Override
    public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        try {
            if (string5 != null) {
                try {
                    URI uRI = new URI(new URI(string5), string4);
                    string4 = uRI.toString();
                }
                catch (URI.MalformedURIException malformedURIException) {
                    // empty catch block
                }
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(string)) {
                string6 = this.getCatalog().resolveURI(string4);
            }
            if (string6 == null && string2 != null) {
                string6 = this.getCatalog().resolveURI(string2);
            }
            if (string6 == null) {
                string6 = this.getResolvedEntity(string3, string4);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string6 != null) {
            return new DOMInputImpl(string3, string6, string5);
        }
        return null;
    }
}

