/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.helpers;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.xml.resolver.helpers.FileURL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BootstrapResolver
implements EntityResolver,
URIResolver {
    public static final String XML_CATALOG_1_0_XSD = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.xsd";
    public static final String XML_CATALOG_1_1_XSD = "http://www.oasis-open.org/committees/entity/release/1.1/catalog.xsd";
    public static final String XML_CATALOG_1_0_RNG = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.rng";
    public static final String XML_CATALOG_1_1_RNG = "http://www.oasis-open.org/committees/entity/release/1.1/catalog.rng";
    public static final String XML_CATALOG_1_0_PUBLIC_ID = "-//OASIS//DTD XML Catalogs V1.0//EN";
    public static final String XML_CATALOG_1_1_PUBLIC_ID = "-//OASIS//DTD XML Catalogs V1.1//EN";
    public static final String XML_CATALOG_1_0_DTD = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd";
    public static final String XML_CATALOG_1_1_DTD = "http://www.oasis-open.org/committees/entity/release/1.1/catalog.dtd";
    public static final String XCATALOG_PUBLIC_ID = "-//DTD XCatalog//EN";
    private Hashtable publicMap = new Hashtable();
    private Hashtable systemMap = new Hashtable();
    private Hashtable uriMap = new Hashtable();

    public BootstrapResolver() {
        URL uRL = this.getClass().getResource("/builtin/catalog.dtd");
        if (uRL != null) {
            this.publicMap.put(XML_CATALOG_1_0_PUBLIC_ID, uRL.toString());
            this.publicMap.put(XML_CATALOG_1_1_PUBLIC_ID, uRL.toString());
            this.systemMap.put(XML_CATALOG_1_0_DTD, uRL.toString());
            this.systemMap.put(XML_CATALOG_1_1_DTD, uRL.toString());
        }
        if ((uRL = this.getClass().getResource("/builtin/catalog.rng")) != null) {
            this.uriMap.put(XML_CATALOG_1_0_RNG, uRL.toString());
            this.uriMap.put(XML_CATALOG_1_1_RNG, uRL.toString());
        }
        if ((uRL = this.getClass().getResource("/builtin/catalog.xsd")) != null) {
            this.uriMap.put(XML_CATALOG_1_0_XSD, uRL.toString());
            this.uriMap.put(XML_CATALOG_1_1_XSD, uRL.toString());
        }
        if ((uRL = this.getClass().getResource("/org/apache/xml/resolver/etc/xcatalog.dtd")) != null) {
            this.publicMap.put(XCATALOG_PUBLIC_ID, uRL.toString());
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        String string3 = null;
        if (string2 != null && this.systemMap.containsKey(string2)) {
            string3 = (String)this.systemMap.get(string2);
        } else if (string != null && this.publicMap.containsKey(string)) {
            string3 = (String)this.publicMap.get(string);
        }
        if (string3 != null) {
            try {
                InputSource inputSource = new InputSource(string3);
                inputSource.setPublicId(string);
                URL uRL = new URL(string3);
                InputStream inputStream = uRL.openStream();
                inputSource.setByteStream(inputStream);
                return inputSource;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Source resolve(String string, String string2) throws TransformerException {
        Object object;
        String string3 = string;
        int n2 = string.indexOf("#");
        if (n2 >= 0) {
            string3 = string.substring(0, n2);
        }
        String string4 = null;
        if (string != null && this.uriMap.containsKey(string)) {
            string4 = (String)this.uriMap.get(string);
        }
        if (string4 == null) {
            try {
                object = null;
                if (string2 == null) {
                    object = new URL(string3);
                    string4 = ((URL)object).toString();
                } else {
                    URL uRL = new URL(string2);
                    object = string.length() == 0 ? uRL : new URL(uRL, string3);
                    string4 = ((URL)object).toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                String string5 = this.makeAbsolute(string2);
                if (!string5.equals(string2)) {
                    return this.resolve(string, string5);
                }
                throw new TransformerException("Malformed URL " + string + "(base " + string2 + ")", malformedURLException);
            }
        }
        object = new SAXSource();
        ((SAXSource)object).setInputSource(new InputSource(string4));
        return object;
    }

    private String makeAbsolute(String string) {
        if (string == null) {
            string = "";
        }
        try {
            URL uRL = new URL(string);
            return uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                URL uRL = FileURL.makeURL((String)string);
                return uRL.toString();
            }
            catch (MalformedURLException malformedURLException2) {
                return string;
            }
        }
    }
}

