/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.ArrayList;
import java.util.Vector;
import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAnnotationImpl;
import org.apache.xerces.impl.xs.traversers.WrapperXSObject;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XSDSimpleTypeTraverser
extends XSDAbstractTraverser {
    private boolean fIsBuiltIn = false;

    XSDSimpleTypeTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
    }

    XSSimpleType traverseGlobal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object object;
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, true, xSDocumentInfo);
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        if (string == null) {
            objectArray[XSAttributeChecker.ATTIDX_NAME] = "(no name)";
        }
        XSSimpleType xSSimpleType = this.traverseSimpleTypeDecl(element, objectArray, xSDocumentInfo, schemaGrammar);
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (string == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, SchemaSymbols.ATT_NAME}, element);
            xSSimpleType = null;
        }
        if (xSSimpleType != null) {
            if (DOMUtil.getLocalName((Node)DOMUtil.getParent((Element)element)).equals(SchemaSymbols.ELT_REDEFINE)) {
                if (this.fSchemaHandler.fSchemaVersion == 4 && (object = xSSimpleType.getBaseType()) instanceof XSSimpleTypeDecl) {
                    ((XSSimpleTypeDecl)object).setContext((XSObject)xSSimpleType);
                }
                schemaGrammar.addGlobalSimpleTypeDecl(xSSimpleType);
            }
            if (schemaGrammar.getGlobalTypeDecl(xSSimpleType.getName()) == null) {
                schemaGrammar.addGlobalSimpleTypeDecl(xSSimpleType);
            }
            object = this.fSchemaHandler.schemaDocument2SystemId(xSDocumentInfo);
            XSTypeDefinition xSTypeDefinition = schemaGrammar.getGlobalTypeDecl(xSSimpleType.getName(), (String)object);
            if (xSTypeDefinition == null) {
                schemaGrammar.addGlobalSimpleTypeDecl(xSSimpleType, (String)object);
            }
            if (this.fSchemaHandler.fTolerateDuplicates) {
                if (xSTypeDefinition != null && xSTypeDefinition instanceof XSSimpleType) {
                    xSSimpleType = (XSSimpleType)xSTypeDefinition;
                }
                this.fSchemaHandler.addGlobalTypeDecl((XSTypeDefinition)xSSimpleType);
            }
        }
        if (xSSimpleType != null) {
            object = xSSimpleType.getAnnotations();
            if (object.size() == 0) {
                object = new XSObjectListImpl();
                ((XSSimpleTypeDecl)xSSimpleType).setAnnotations((XSObjectList)object);
            }
            ((XSObjectListImpl)object).addXSObject((XSObject)new WrapperXSObject(element));
        }
        return xSSimpleType;
    }

    XSSimpleType traverseLocal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar, XSObject xSObject) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        String string = this.genAnonTypeName(element);
        XSSimpleType xSSimpleType = this.getSimpleType(string, element, objectArray, xSDocumentInfo, schemaGrammar);
        if (xSSimpleType instanceof XSSimpleTypeDecl) {
            ((XSSimpleTypeDecl)xSSimpleType).setAnonymous(true);
            if (xSObject != null && this.fSchemaHandler.fSchemaVersion == 4) {
                ((XSSimpleTypeDecl)xSSimpleType).setContext(xSObject);
            }
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSSimpleType;
    }

    private XSSimpleType traverseSimpleTypeDecl(Element element, Object[] objectArray, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        return this.getSimpleType(string, element, objectArray, xSDocumentInfo, schemaGrammar);
    }

    private String genAnonTypeName(Element element) {
        StringBuffer stringBuffer = new StringBuffer("#AnonType_");
        Element element2 = DOMUtil.getParent((Element)element);
        while (element2 != null && element2 != DOMUtil.getRoot((Document)DOMUtil.getDocument((Node)element2))) {
            stringBuffer.append(element2.getAttribute(SchemaSymbols.ATT_NAME));
            element2 = DOMUtil.getParent((Element)element2);
        }
        return stringBuffer.toString();
    }

    private XSSimpleType getSimpleType(String string, Element element, Object[] objectArray, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        XSObjectList xSObjectList;
        int n2;
        XSSimpleType xSSimpleType;
        Object object;
        String string2;
        String string3;
        XInt xInt = (XInt)objectArray[XSAttributeChecker.ATTIDX_FINAL];
        int n3 = xInt == null ? xSDocumentInfo.fFinalDefault : xInt.intValue();
        Element element2 = DOMUtil.getFirstChildElement((Node)element);
        XSAnnotationImpl[] xSAnnotationImplArray = null;
        if (element2 != null && DOMUtil.getLocalName((Node)element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            string3 = this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
            if (string3 != null) {
                xSAnnotationImplArray = new XSAnnotationImpl[]{string3};
            }
            element2 = DOMUtil.getNextSiblingElement((Node)element2);
        } else {
            string3 = DOMUtil.getSyntheticAnnotation((Node)element);
            if (string3 != null) {
                XSAnnotationImpl xSAnnotationImpl = this.traverseSyntheticAnnotation(element, string3, objectArray, false, xSDocumentInfo);
                xSAnnotationImplArray = new XSAnnotationImpl[]{xSAnnotationImpl};
            }
        }
        if (element2 == null) {
            this.reportSchemaError("s4s-elt-must-match.2", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))"}, element);
            return this.errorType(string, xSDocumentInfo.fTargetNamespace, (short)2);
        }
        string3 = DOMUtil.getLocalName((Node)element2);
        short s2 = 2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string3.equals(SchemaSymbols.ELT_RESTRICTION)) {
            s2 = 2;
            bl = true;
        } else if (string3.equals(SchemaSymbols.ELT_LIST)) {
            s2 = 16;
            bl2 = true;
        } else if (string3.equals(SchemaSymbols.ELT_UNION)) {
            s2 = 8;
            bl3 = true;
        } else {
            this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))", string3}, element);
            return this.errorType(string, xSDocumentInfo.fTargetNamespace, (short)2);
        }
        Element element3 = DOMUtil.getNextSiblingElement((Node)element2);
        if (element3 != null) {
            this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, "(annotation?, (restriction | list | union))", DOMUtil.getLocalName((Node)element3)}, element3);
        }
        Object[] objectArray2 = this.fAttrChecker.checkAttributes(element2, false, xSDocumentInfo);
        QName qName = (QName)objectArray2[bl ? XSAttributeChecker.ATTIDX_BASE : XSAttributeChecker.ATTIDX_ITEMTYPE];
        Vector vector = (Vector)objectArray2[XSAttributeChecker.ATTIDX_MEMBERTYPES];
        Element element4 = DOMUtil.getFirstChildElement((Node)element2);
        if (element4 != null && DOMUtil.getLocalName((Node)element4).equals(SchemaSymbols.ELT_ANNOTATION)) {
            string2 = this.traverseAnnotationDecl(element4, objectArray2, false, xSDocumentInfo);
            if (string2 != null) {
                if (xSAnnotationImplArray == null) {
                    xSAnnotationImplArray = new XSAnnotationImpl[]{string2};
                } else {
                    object = new XSAnnotationImpl[2];
                    object[0] = xSAnnotationImplArray[0];
                    xSAnnotationImplArray = object;
                    xSAnnotationImplArray[1] = string2;
                }
            }
            element4 = DOMUtil.getNextSiblingElement((Node)element4);
        } else {
            string2 = DOMUtil.getSyntheticAnnotation((Node)element2);
            if (string2 != null) {
                object = this.traverseSyntheticAnnotation(element2, string2, objectArray2, false, xSDocumentInfo);
                if (xSAnnotationImplArray == null) {
                    xSAnnotationImplArray = new XSAnnotationImpl[]{object};
                } else {
                    xSSimpleType = new XSAnnotationImpl[2];
                    xSSimpleType[0] = xSAnnotationImplArray[0];
                    xSAnnotationImplArray = xSSimpleType;
                    xSAnnotationImplArray[1] = object;
                }
            }
        }
        string2 = null;
        if ((bl || bl2) && qName != null && (string2 = this.findDTValidator(element2, string, qName, s2, xSDocumentInfo)) == null && this.fIsBuiltIn) {
            this.fIsBuiltIn = false;
            return null;
        }
        object = null;
        xSSimpleType = null;
        if (bl3 && vector != null && vector.size() > 0) {
            int n4 = vector.size();
            object = new ArrayList(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                xSSimpleType = this.findDTValidator(element2, string, (QName)vector.elementAt(n2), (short)8, xSDocumentInfo);
                if (xSSimpleType == null) continue;
                if (xSSimpleType.getVariety() == 3 && this.fSchemaHandler.fSchemaVersion < 4) {
                    xSObjectList = xSSimpleType.getMemberTypes();
                    for (int i2 = 0; i2 < xSObjectList.getLength(); ++i2) {
                        ((ArrayList)object).add(xSObjectList.item(i2));
                    }
                    continue;
                }
                ((ArrayList)object).add(xSSimpleType);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        if (element4 != null && DOMUtil.getLocalName((Node)element4).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            if (bl || bl2) {
                if (qName != null) {
                    this.reportSchemaError(bl2 ? "src-simple-type.3.a" : "src-simple-type.2.a", null, element4);
                }
                if (string2 == null) {
                    string2 = this.traverseLocal(element4, xSDocumentInfo, schemaGrammar, null);
                    if (this.fSchemaHandler.fSchemaVersion == 4 && string2 instanceof XSSimpleTypeDecl) {
                        arrayList.add(string2);
                    }
                }
                element4 = DOMUtil.getNextSiblingElement((Node)element4);
            } else if (bl3) {
                if (object == null) {
                    object = new ArrayList(2);
                }
                do {
                    if ((xSSimpleType = this.traverseLocal(element4, xSDocumentInfo, schemaGrammar, null)) == null) continue;
                    if (this.fSchemaHandler.fSchemaVersion == 4) {
                        ((ArrayList)object).add(xSSimpleType);
                        if (!(xSSimpleType instanceof XSSimpleTypeDecl)) continue;
                        arrayList.add((String)xSSimpleType);
                        continue;
                    }
                    if (xSSimpleType.getVariety() == 3) {
                        xSObjectList = xSSimpleType.getMemberTypes();
                        for (n2 = 0; n2 < xSObjectList.getLength(); ++n2) {
                            ((ArrayList)object).add(xSObjectList.item(n2));
                        }
                    } else {
                        ((ArrayList)object).add(xSSimpleType);
                    }
                } while ((element4 = DOMUtil.getNextSiblingElement((Node)element4)) != null && DOMUtil.getLocalName((Node)element4).equals(SchemaSymbols.ELT_SIMPLETYPE));
            }
        } else if ((bl || bl2) && qName == null) {
            this.reportSchemaError(bl2 ? "src-simple-type.3.b" : "src-simple-type.2.b", null, element2);
        } else if (bl3 && (vector == null || vector.size() == 0)) {
            this.reportSchemaError("src-union-memberTypes-or-simpleTypes", null, element2);
        }
        if ((bl || bl2) && string2 == null) {
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            return this.errorType(string, xSDocumentInfo.fTargetNamespace, bl ? (short)2 : 16);
        }
        if (bl3 && (object == null || ((ArrayList)object).size() == 0)) {
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            return this.errorType(string, xSDocumentInfo.fTargetNamespace, (short)8);
        }
        if (bl2 && this.isListDatatype((XSSimpleType)string2)) {
            this.reportSchemaError("cos-st-restricts.2.1", new Object[]{string, string2.getName()}, element2);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            return this.errorType(string, xSDocumentInfo.fTargetNamespace, (short)16);
        }
        XSSimpleType xSSimpleType2 = null;
        if (bl) {
            xSSimpleType2 = this.fSchemaHandler.fDVFactory.createTypeRestriction(string, xSDocumentInfo.fTargetNamespace, (short)n3, (XSSimpleType)string2, (XSObjectList)(xSAnnotationImplArray == null ? null : new XSObjectListImpl((XSObject[])xSAnnotationImplArray, xSAnnotationImplArray.length)));
        } else if (bl2) {
            xSSimpleType2 = this.fSchemaHandler.fDVFactory.createTypeList(string, xSDocumentInfo.fTargetNamespace, (short)n3, (XSSimpleType)string2, (XSObjectList)(xSAnnotationImplArray == null ? null : new XSObjectListImpl((XSObject[])xSAnnotationImplArray, xSAnnotationImplArray.length)));
        } else if (bl3) {
            XSSimpleType[] xSSimpleTypeArray = ((ArrayList)object).toArray(new XSSimpleType[((ArrayList)object).size()]);
            xSSimpleType2 = this.fSchemaHandler.fDVFactory.createTypeUnion(string, xSDocumentInfo.fTargetNamespace, (short)n3, xSSimpleTypeArray, (XSObjectList)(xSAnnotationImplArray == null ? null : new XSObjectListImpl((XSObject[])xSAnnotationImplArray, xSAnnotationImplArray.length)));
        }
        if (bl && element4 != null) {
            XSDAbstractTraverser.FacetInfo facetInfo = this.traverseFacets(element4, (XSTypeDefinition)xSSimpleType2, (XSSimpleType)string2, xSDocumentInfo);
            element4 = facetInfo.nodeAfterFacets;
            try {
                this.fValidationState.setNamespaceSupport((NamespaceContext)xSDocumentInfo.fNamespaceSupport);
                this.fValidationState.setDatatypeXMLVersion(xSDocumentInfo.fDatatypeXMLVersion);
                xSSimpleType2.applyFacets(facetInfo.facetdata, (int)facetInfo.fPresentFacets, (int)facetInfo.fFixedFacets, (ValidationContext)this.fValidationState);
            }
            catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
                this.reportSchemaError(invalidDatatypeFacetException.getKey(), invalidDatatypeFacetException.getArgs(), element2);
                xSSimpleType2 = this.fSchemaHandler.fDVFactory.createTypeRestriction(string, xSDocumentInfo.fTargetNamespace, (short)n3, (XSSimpleType)string2, (XSObjectList)(xSAnnotationImplArray == null ? null : new XSObjectListImpl((XSObject[])xSAnnotationImplArray, xSAnnotationImplArray.length)));
            }
        }
        int n5 = arrayList.size();
        for (int i3 = 0; i3 < n5; ++i3) {
            ((XSSimpleTypeDecl)arrayList.get(i3)).setContext((XSObject)xSSimpleType2);
        }
        if (element4 != null) {
            if (bl) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_RESTRICTION, "(annotation?, (simpleType?, (minExclusive | minInclusive | maxExclusive | maxInclusive | totalDigits | fractionDigits | length | minLength | maxLength | enumeration | whiteSpace | pattern)*))", DOMUtil.getLocalName((Node)element4)}, element4);
            } else if (bl2) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_LIST, "(annotation?, (simpleType?))", DOMUtil.getLocalName((Node)element4)}, element4);
            } else if (bl3) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_UNION, "(annotation?, (simpleType*))", DOMUtil.getLocalName((Node)element4)}, element4);
            }
        }
        this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
        return xSSimpleType2;
    }

    private XSSimpleType findDTValidator(Element element, String string, QName qName, short s2, XSDocumentInfo xSDocumentInfo) {
        if (qName == null) {
            return null;
        }
        XSTypeDefinition xSTypeDefinition = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 7, qName, element);
        if (xSTypeDefinition == null) {
            return null;
        }
        if (xSTypeDefinition.getTypeCategory() != 16) {
            this.reportSchemaError("cos-st-restricts.1.1", new Object[]{qName.rawname, string}, element);
            return null;
        }
        if (xSTypeDefinition == SchemaGrammar.fAnySimpleType || xSTypeDefinition == SchemaGrammar.fAnyAtomicType) {
            if (s2 == 2) {
                if (this.checkBuiltIn(string, xSDocumentInfo.fTargetNamespace)) {
                    return null;
                }
                this.reportSchemaError("cos-st-restricts.1.1", new Object[]{qName.rawname, string}, element);
                return null;
            }
            if (this.fSchemaHandler.fSchemaVersion == 4) {
                String string2 = s2 == 16 ? "xs:list" : "xs:union";
                this.reportSchemaError("st-props-correct.1", new Object[]{string, string2}, element);
                return null;
            }
        }
        if ((xSTypeDefinition.getFinal() & s2) != 0) {
            if (s2 == 2) {
                this.reportSchemaError("st-props-correct.3", new Object[]{string, qName.rawname}, element);
            } else if (s2 == 16) {
                this.reportSchemaError("cos-st-restricts.2.3.1.1", new Object[]{qName.rawname, string}, element);
            } else if (s2 == 8) {
                this.reportSchemaError("cos-st-restricts.3.3.1.1", new Object[]{qName.rawname, string}, element);
            }
            return null;
        }
        return (XSSimpleType)xSTypeDefinition;
    }

    private final boolean checkBuiltIn(String string, String string2) {
        if (string2 != SchemaSymbols.URI_SCHEMAFORSCHEMA) {
            return false;
        }
        if (this.fSchemaHandler.fSchemaVersion == 2 && (string.equals("duration") || string.equals("yearMonthDuration") || string.equals("dayTimeDuration"))) {
            return false;
        }
        SchemaGrammar schemaGrammar = SchemaGrammar.getS4SGrammar((short)this.fSchemaHandler.fSchemaVersion);
        if (schemaGrammar.getGlobalTypeDecl(string) != null) {
            this.fIsBuiltIn = true;
        }
        return this.fIsBuiltIn;
    }

    private boolean isListDatatype(XSSimpleType xSSimpleType) {
        if (xSSimpleType.getVariety() == 2) {
            return true;
        }
        if (xSSimpleType.getVariety() == 3) {
            XSObjectList xSObjectList = xSSimpleType.getMemberTypes();
            for (int i2 = 0; i2 < xSObjectList.getLength(); ++i2) {
                if (((XSSimpleType)xSObjectList.item(i2)).getVariety() == 2) {
                    return true;
                }
                if (this.fSchemaHandler.fSchemaVersion != 4 || ((XSSimpleType)xSObjectList.item(i2)).getVariety() != 3 || !this.isListDatatype((XSSimpleType)xSObjectList.item(i2))) continue;
                return true;
            }
        }
        return false;
    }

    private XSSimpleType errorType(String string, String string2, short s2) {
        XSSimpleType xSSimpleType = (XSSimpleType)SchemaGrammar.getS4SGrammar((short)this.fSchemaHandler.fSchemaVersion).getTypeDefinition("string");
        switch (s2) {
            case 2: {
                return this.fSchemaHandler.fDVFactory.createTypeRestriction(string, string2, (short)0, xSSimpleType, null);
            }
            case 16: {
                return this.fSchemaHandler.fDVFactory.createTypeList(string, string2, (short)0, xSSimpleType, null);
            }
            case 8: {
                return this.fSchemaHandler.fDVFactory.createTypeUnion(string, string2, (short)0, new XSSimpleType[]{xSSimpleType}, null);
            }
        }
        return null;
    }
}

