/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.opti;

import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.xerces.impl.xs.opti.AttrImpl;
import org.apache.xerces.impl.xs.opti.DefaultDocument;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.impl.xs.opti.NodeImpl;
import org.apache.xerces.impl.xs.opti.SchemaDOMImplementation;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    NodeImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;
    boolean inCDATA;
    private StringBuffer fAnnotationBuffer = null;

    public SchemaDOM() {
        this.reset();
    }

    public ElementImpl startElement(QName qName, XMLAttributes xMLAttributes, int n2, int n3, int n4) {
        ElementImpl elementImpl = new ElementImpl(n2, n3, n4);
        this.processElement(qName, xMLAttributes, elementImpl);
        this.parent = elementImpl;
        return elementImpl;
    }

    public ElementImpl emptyElement(QName qName, XMLAttributes xMLAttributes, int n2, int n3, int n4) {
        ElementImpl elementImpl = new ElementImpl(n2, n3, n4);
        this.processElement(qName, xMLAttributes, elementImpl);
        return elementImpl;
    }

    public ElementImpl startElement(QName qName, XMLAttributes xMLAttributes, int n2, int n3) {
        return this.startElement(qName, xMLAttributes, n2, n3, -1);
    }

    public ElementImpl emptyElement(QName qName, XMLAttributes xMLAttributes, int n2, int n3) {
        return this.emptyElement(qName, xMLAttributes, n2, n3, -1);
    }

    private void processElement(QName qName, XMLAttributes xMLAttributes, ElementImpl elementImpl) {
        int n2;
        elementImpl.prefix = qName.prefix;
        elementImpl.localpart = qName.localpart;
        elementImpl.rawname = qName.rawname;
        elementImpl.uri = qName.uri;
        elementImpl.schemaDOM = this;
        Attr[] attrArray = new Attr[xMLAttributes.getLength()];
        for (n2 = 0; n2 < xMLAttributes.getLength(); ++n2) {
            attrArray[n2] = new AttrImpl((Element)((Object)elementImpl), xMLAttributes.getPrefix(n2), xMLAttributes.getLocalName(n2), xMLAttributes.getQName(n2), xMLAttributes.getURI(n2), xMLAttributes.getValue(n2));
        }
        elementImpl.attrs = attrArray;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        n2 = 0;
        int n3 = 1;
        for (n3 = 1; n3 < this.relations[this.currLoc].length; ++n3) {
            if (this.relations[this.currLoc][n3] != null) continue;
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][n3] = elementImpl;
        this.parent.parentRow = this.currLoc;
        elementImpl.row = this.currLoc;
        elementImpl.col = n3;
    }

    public void endElement() {
        this.currLoc = this.parent.row;
        this.parent = (ElementImpl)this.relations[this.currLoc][0];
    }

    void comment(XMLString xMLString) {
        this.fAnnotationBuffer.append("<!--");
        if (xMLString.length > 0) {
            this.fAnnotationBuffer.append(xMLString.ch, xMLString.offset, xMLString.length);
        }
        this.fAnnotationBuffer.append("-->");
    }

    void processingInstruction(String string, XMLString xMLString) {
        this.fAnnotationBuffer.append("<?").append(string);
        if (xMLString.length > 0) {
            this.fAnnotationBuffer.append(' ').append(xMLString.ch, xMLString.offset, xMLString.length);
        }
        this.fAnnotationBuffer.append("?>");
    }

    void characters(XMLString xMLString) {
        if (!this.inCDATA) {
            StringBuffer stringBuffer = this.fAnnotationBuffer;
            for (int i2 = xMLString.offset; i2 < xMLString.offset + xMLString.length; ++i2) {
                char c2 = xMLString.ch[i2];
                if (c2 == '&') {
                    stringBuffer.append("&amp;");
                    continue;
                }
                if (c2 == '<') {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (c2 == '>') {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if (c2 == '\r') {
                    stringBuffer.append("&#xD;");
                    continue;
                }
                stringBuffer.append(c2);
            }
        } else {
            this.fAnnotationBuffer.append(xMLString.ch, xMLString.offset, xMLString.length);
        }
    }

    void charactersRaw(String string) {
        this.fAnnotationBuffer.append(string);
    }

    void endAnnotation(QName qName, ElementImpl elementImpl) {
        this.fAnnotationBuffer.append("\n</").append(qName.rawname).append(">");
        elementImpl.fAnnotation = this.fAnnotationBuffer.toString();
        this.fAnnotationBuffer = null;
    }

    void endAnnotationElement(QName qName) {
        this.endAnnotationElement(qName.rawname);
    }

    void endAnnotationElement(String string) {
        this.fAnnotationBuffer.append("</").append(string).append(">");
    }

    void endSyntheticAnnotationElement(QName qName, boolean bl) {
        this.endSyntheticAnnotationElement(qName.rawname, bl);
    }

    void endSyntheticAnnotationElement(String string, boolean bl) {
        if (bl) {
            this.fAnnotationBuffer.append("\n</").append(string).append(">");
            this.parent.fSyntheticAnnotation = this.fAnnotationBuffer.toString();
            this.fAnnotationBuffer = null;
        } else {
            this.fAnnotationBuffer.append("</").append(string).append(">");
        }
    }

    void startAnnotationCDATA() {
        this.inCDATA = true;
        this.fAnnotationBuffer.append("<![CDATA[");
    }

    void endAnnotationCDATA() {
        this.fAnnotationBuffer.append("]]>");
        this.inCDATA = false;
    }

    private void resizeRelations() {
        NodeImpl[][] nodeImplArrayArray = new NodeImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, nodeImplArrayArray, 0, this.relations.length);
        for (int i2 = this.relations.length; i2 < nodeImplArrayArray.length; ++i2) {
            nodeImplArrayArray[i2] = new NodeImpl[10];
        }
        this.relations = nodeImplArrayArray;
    }

    private void resizeRelations(int n2) {
        NodeImpl[] nodeImplArray = new NodeImpl[this.relations[n2].length + 10];
        System.arraycopy(this.relations[n2], 0, nodeImplArray, 0, this.relations[n2].length);
        this.relations[n2] = nodeImplArray;
    }

    public void reset() {
        int n2;
        if (this.relations != null) {
            for (n2 = 0; n2 < this.relations.length; ++n2) {
                for (int i2 = 0; i2 < this.relations[n2].length; ++i2) {
                    this.relations[n2][i2] = null;
                }
            }
        }
        this.relations = new NodeImpl[15][];
        this.parent = new ElementImpl(0, 0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        this.inCDATA = false;
        for (n2 = 0; n2 < 15; ++n2) {
            this.relations[n2] = new NodeImpl[10];
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    public void printDOM() {
    }

    public static void traverse(Node node, int n2) {
        Object object;
        SchemaDOM.indent(n2);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (int i2 = 0; i2 < object.getLength(); ++i2) {
                System.out.print("  " + ((Attr)object.item(i2)).getName() + "=\"" + ((Attr)object.item(i2)).getValue() + "\"");
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            n2 += 4;
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                SchemaDOM.traverse((Node)object, n2);
            }
            SchemaDOM.indent(n2 -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    public static void indent(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            System.out.print(' ');
        }
    }

    public Element getDocumentElement() {
        return (ElementImpl)this.relations[0][1];
    }

    public DOMImplementation getImplementation() {
        return SchemaDOMImplementation.getDOMImplementation();
    }

    void startAnnotation(QName qName, XMLAttributes xMLAttributes, NamespaceContext namespaceContext) {
        this.startAnnotation(qName.rawname, xMLAttributes, namespaceContext);
    }

    void startAnnotation(String string, XMLAttributes xMLAttributes, NamespaceContext namespaceContext) {
        String string2;
        String string3;
        if (this.fAnnotationBuffer == null) {
            this.fAnnotationBuffer = new StringBuffer(256);
        }
        this.fAnnotationBuffer.append("<").append(string).append(" ");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < xMLAttributes.getLength(); ++i2) {
            string3 = xMLAttributes.getValue(i2);
            string2 = xMLAttributes.getPrefix(i2);
            String string4 = xMLAttributes.getQName(i2);
            if (string2 == XMLSymbols.PREFIX_XMLNS || string4 == XMLSymbols.PREFIX_XMLNS) {
                arrayList.add(string2 == XMLSymbols.PREFIX_XMLNS ? xMLAttributes.getLocalName(i2) : XMLSymbols.EMPTY_STRING);
            }
            this.fAnnotationBuffer.append(string4).append("=\"").append(SchemaDOM.processAttValue(string3)).append("\" ");
        }
        Enumeration enumeration = namespaceContext.getAllPrefixes();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = namespaceContext.getURI(string3);
            if (string2 == null) {
                string2 = XMLSymbols.EMPTY_STRING;
            }
            if (arrayList.contains(string3)) continue;
            if (string3 == XMLSymbols.EMPTY_STRING) {
                this.fAnnotationBuffer.append("xmlns").append("=\"").append(SchemaDOM.processAttValue(string2)).append("\" ");
                continue;
            }
            this.fAnnotationBuffer.append("xmlns:").append(string3).append("=\"").append(SchemaDOM.processAttValue(string2)).append("\" ");
        }
        this.fAnnotationBuffer.append(">\n");
    }

    void startAnnotationElement(QName qName, XMLAttributes xMLAttributes) {
        this.startAnnotationElement(qName.rawname, xMLAttributes);
    }

    void startAnnotationElement(String string, XMLAttributes xMLAttributes) {
        this.fAnnotationBuffer.append("<").append(string);
        for (int i2 = 0; i2 < xMLAttributes.getLength(); ++i2) {
            String string2 = xMLAttributes.getValue(i2);
            this.fAnnotationBuffer.append(" ").append(xMLAttributes.getQName(i2)).append("=\"").append(SchemaDOM.processAttValue(string2)).append("\"");
        }
        this.fAnnotationBuffer.append(">");
    }

    private static String processAttValue(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '\"' && c2 != '<' && c2 != '&' && c2 != '\t' && c2 != '\n' && c2 != '\r') continue;
            return SchemaDOM.escapeAttValue(string, i2);
        }
        return string;
    }

    private static String escapeAttValue(String string, int n2) {
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3);
        stringBuffer.append(string.substring(0, n2));
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c2 == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c2 == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c2 == '\t') {
                stringBuffer.append("&#x9;");
                continue;
            }
            if (c2 == '\n') {
                stringBuffer.append("&#xA;");
                continue;
            }
            if (c2 == '\r') {
                stringBuffer.append("&#xD;");
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }
}

