/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd.models;

import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.xni.QName;

public class SimpleContentModel
implements ContentModelValidator {
    public static final short CHOICE = -1;
    public static final short SEQUENCE = -1;
    private final QName fFirstChild = new QName();
    private final QName fSecondChild = new QName();
    private final int fOperator;

    public SimpleContentModel(short s2, QName qName, QName qName2) {
        this.fFirstChild.setValues(qName);
        if (qName2 != null) {
            this.fSecondChild.setValues(qName2);
        } else {
            this.fSecondChild.clear();
        }
        this.fOperator = s2;
    }

    public int validate(QName[] qNameArray, int n2, int n3) {
        switch (this.fOperator) {
            case 0: {
                if (n3 == 0) {
                    return 0;
                }
                if (qNameArray[n2].rawname != this.fFirstChild.rawname) {
                    return 0;
                }
                if (n3 <= 1) break;
                return 1;
            }
            case 1: {
                if (n3 < 1) break;
                if (qNameArray[n2].rawname != this.fFirstChild.rawname) {
                    return 0;
                }
                if (n3 <= 1) break;
                return 1;
            }
            case 2: {
                if (n3 <= 0) break;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (qNameArray[n2 + i2].rawname == this.fFirstChild.rawname) continue;
                    return i2;
                }
                break;
            }
            case 3: {
                if (n3 == 0) {
                    return 0;
                }
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (qNameArray[n2 + i3].rawname == this.fFirstChild.rawname) continue;
                    return i3;
                }
                break;
            }
            case 4: {
                if (n3 == 0) {
                    return 0;
                }
                if (qNameArray[n2].rawname != this.fFirstChild.rawname && qNameArray[n2].rawname != this.fSecondChild.rawname) {
                    return 0;
                }
                if (n3 <= 1) break;
                return 1;
            }
            case 5: {
                if (n3 == 0) {
                    return 0;
                }
                if (n3 == 1) {
                    if (qNameArray[n2].rawname != this.fFirstChild.rawname) {
                        return 0;
                    }
                    return n3;
                }
                if (n3 < 2) break;
                if (qNameArray[n2].rawname != this.fFirstChild.rawname) {
                    return 0;
                }
                if (qNameArray[n2 + 1].rawname != this.fSecondChild.rawname) {
                    return 1;
                }
                if (n3 <= 2) break;
                return 2;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return -1;
    }
}

