/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.io.UCSReader;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;

public class XMLEntityScannerXerces
implements XMLLocator {
    private static final boolean DEBUG_ENCODINGS = false;
    protected static final boolean DEBUG_BUFFER = false;
    private static final EOFException END_OF_DOCUMENT_ENTITY = new EOFException(){
        private static final long serialVersionUID = 980337771224675268L;

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    };
    private XMLEntityManager fEntityManager = null;
    protected XMLEntityManager.ScannedEntity fCurrentEntity = null;
    protected SymbolTable fSymbolTable = null;
    protected int fBufferSize = 2048;
    protected XMLErrorReporter fErrorReporter;

    public final String getBaseSystemId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getExpandedSystemId() : null;
    }

    public final void setEncoding(String string) throws IOException {
        if (!(this.fCurrentEntity.stream == null || this.fCurrentEntity.encoding != null && this.fCurrentEntity.encoding.equals(string))) {
            if (this.fCurrentEntity.encoding != null && this.fCurrentEntity.encoding.startsWith("UTF-16")) {
                String string2 = string.toUpperCase(Locale.ENGLISH);
                if (string2.equals("UTF-16")) {
                    return;
                }
                if (string2.equals("ISO-10646-UCS-4")) {
                    this.fCurrentEntity.reader = this.fCurrentEntity.encoding.equals("UTF-16BE") ? new UCSReader(this.fCurrentEntity.stream, 8) : new UCSReader(this.fCurrentEntity.stream, 4);
                    return;
                }
                if (string2.equals("ISO-10646-UCS-2")) {
                    this.fCurrentEntity.reader = this.fCurrentEntity.encoding.equals("UTF-16BE") ? new UCSReader(this.fCurrentEntity.stream, 2) : new UCSReader(this.fCurrentEntity.stream, 1);
                    return;
                }
            }
            this.fCurrentEntity.setReader(this.fCurrentEntity.stream, string, null);
            this.fCurrentEntity.encoding = string;
        }
    }

    public final void setXMLVersion(String string) {
        this.fCurrentEntity.xmlVersion = string;
    }

    public final boolean isExternal() {
        return this.fCurrentEntity.isExternal();
    }

    public int peekChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int n2 = this.fCurrentEntity.ch[this.fCurrentEntity.position];
        if (this.fCurrentEntity.isExternal()) {
            return n2 != 13 ? n2 : 10;
        }
        return n2;
    }

    public int scanChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int n2 = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
        boolean bl = false;
        if (n2 == 10 || n2 == 13 && (bl = this.fCurrentEntity.isExternal())) {
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = (char)n2;
                this.load(1, false);
            }
            if (n2 == 13 && bl) {
                if (this.fCurrentEntity.ch[this.fCurrentEntity.position++] != '\n') {
                    --this.fCurrentEntity.position;
                }
                n2 = 10;
            }
        }
        ++this.fCurrentEntity.columnNumber;
        return n2;
    }

    public String scanNmtoken() throws IOException {
        Object object;
        int n2;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int n3 = this.fCurrentEntity.position;
        while (XMLChar.isName((int)this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
            if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            n2 = this.fCurrentEntity.position - n3;
            if (n2 == this.fCurrentEntity.ch.length) {
                object = new char[this.fCurrentEntity.ch.length << 1];
                System.arraycopy(this.fCurrentEntity.ch, n3, object, 0, n2);
                this.fCurrentEntity.ch = (char[])object;
            } else {
                System.arraycopy(this.fCurrentEntity.ch, n3, this.fCurrentEntity.ch, 0, n2);
            }
            n3 = 0;
            if (!this.load(n2, false)) continue;
            break;
        }
        n2 = this.fCurrentEntity.position - n3;
        this.fCurrentEntity.columnNumber += n2;
        object = null;
        if (n2 > 0) {
            object = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n3, n2);
        }
        return object;
    }

    public String scanName() throws IOException {
        Object object;
        int n2;
        int n3;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if (XMLChar.isNameStart((int)this.fCurrentEntity.ch[n3 = this.fCurrentEntity.position++])) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[n3];
                n3 = 0;
                if (this.load(1, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String string = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    return string;
                }
            }
            while (XMLChar.isName((int)this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                n2 = this.fCurrentEntity.position - n3;
                if (n2 == this.fCurrentEntity.ch.length) {
                    object = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, n3, object, 0, n2);
                    this.fCurrentEntity.ch = (char[])object;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, n3, this.fCurrentEntity.ch, 0, n2);
                }
                n3 = 0;
                if (!this.load(n2, false)) continue;
                break;
            }
        }
        n2 = this.fCurrentEntity.position - n3;
        this.fCurrentEntity.columnNumber += n2;
        object = null;
        if (n2 > 0) {
            object = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n3, n2);
        }
        return object;
    }

    public String scanNCName() throws IOException {
        Object object;
        int n2;
        int n3;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if (XMLChar.isNCNameStart((int)this.fCurrentEntity.ch[n3 = this.fCurrentEntity.position++])) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[n3];
                n3 = 0;
                if (this.load(1, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String string = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    return string;
                }
            }
            while (XMLChar.isNCName((int)this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                n2 = this.fCurrentEntity.position - n3;
                if (n2 == this.fCurrentEntity.ch.length) {
                    object = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, n3, object, 0, n2);
                    this.fCurrentEntity.ch = (char[])object;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, n3, this.fCurrentEntity.ch, 0, n2);
                }
                n3 = 0;
                if (!this.load(n2, false)) continue;
                break;
            }
        }
        n2 = this.fCurrentEntity.position - n3;
        this.fCurrentEntity.columnNumber += n2;
        object = null;
        if (n2 > 0) {
            object = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n3, n2);
        }
        return object;
    }

    public boolean scanQName(QName qName) throws IOException {
        int n2;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if (XMLChar.isNCNameStart((int)this.fCurrentEntity.ch[n2 = this.fCurrentEntity.position++])) {
            Object object;
            int n3;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[n2];
                n2 = 0;
                if (this.load(1, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String string = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    qName.setValues(null, string, string, null);
                    return true;
                }
            }
            int n4 = -1;
            while (XMLChar.isName((int)this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
                n3 = this.fCurrentEntity.ch[this.fCurrentEntity.position];
                if (n3 == 58) {
                    if (n4 != -1) break;
                    n4 = this.fCurrentEntity.position;
                }
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                int n5 = this.fCurrentEntity.position - n2;
                if (n5 == this.fCurrentEntity.ch.length) {
                    object = new char[this.fCurrentEntity.ch.length << 1];
                    System.arraycopy(this.fCurrentEntity.ch, n2, object, 0, n5);
                    this.fCurrentEntity.ch = (char[])object;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, n2, this.fCurrentEntity.ch, 0, n5);
                }
                if (n4 != -1) {
                    n4 -= n2;
                }
                n2 = 0;
                if (!this.load(n5, false)) continue;
                break;
            }
            n3 = this.fCurrentEntity.position - n2;
            this.fCurrentEntity.columnNumber += n3;
            if (n3 > 0) {
                String string = null;
                object = null;
                String string2 = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n2, n3);
                if (n4 != -1) {
                    int n6 = n4 - n2;
                    string = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n2, n6);
                    int n7 = n3 - n6 - 1;
                    int n8 = n4 + 1;
                    if (!XMLChar.isNCNameStart((int)this.fCurrentEntity.ch[n8])) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "IllegalQName", null, (short)2);
                    }
                    object = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n8, n7);
                } else {
                    object = string2;
                }
                qName.setValues(string, (String)object, string2, null);
                return true;
            }
        }
        return false;
    }

    public int scanContent(XMLString xMLString) throws IOException {
        int n2;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
            this.fCurrentEntity.startPosition = 0;
        }
        int n3 = this.fCurrentEntity.position;
        int n4 = this.fCurrentEntity.ch[n3];
        int n5 = 0;
        boolean bl = this.fCurrentEntity.isExternal();
        if (n4 == 10 || n4 == 13 && bl) {
            do {
                if ((n4 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && bl) {
                    ++n5;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        n3 = 0;
                        this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                        this.fCurrentEntity.position = n5;
                        this.fCurrentEntity.startPosition = n5;
                        if (this.load(n5, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++n3;
                        continue;
                    }
                    ++n5;
                    continue;
                }
                if (n4 == 10) {
                    ++n5;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    n3 = 0;
                    this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                    this.fCurrentEntity.position = n5;
                    this.fCurrentEntity.startPosition = n5;
                    if (!this.load(n5, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            for (n2 = n3; n2 < this.fCurrentEntity.position; ++n2) {
                this.fCurrentEntity.ch[n2] = 10;
            }
            n2 = this.fCurrentEntity.position - n3;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                xMLString.setValues(this.fCurrentEntity.ch, n3, n2);
                return -1;
            }
        }
        while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
            if (XMLChar.isContent((int)(n4 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]))) continue;
            --this.fCurrentEntity.position;
            break;
        }
        n2 = this.fCurrentEntity.position - n3;
        this.fCurrentEntity.columnNumber += n2 - n5;
        xMLString.setValues(this.fCurrentEntity.ch, n3, n2);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            n4 = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (n4 == 13 && bl) {
                n4 = 10;
            }
        } else {
            n4 = -1;
        }
        return n4;
    }

    public int scanLiteral(int n2, XMLString xMLString) throws IOException {
        int n3;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
            this.fCurrentEntity.startPosition = 0;
        }
        int n4 = this.fCurrentEntity.position;
        int n5 = this.fCurrentEntity.ch[n4];
        int n6 = 0;
        boolean bl = this.fCurrentEntity.isExternal();
        if (n5 == 10 || n5 == 13 && bl) {
            do {
                if ((n5 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && bl) {
                    ++n6;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        n4 = 0;
                        this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                        this.fCurrentEntity.position = n6;
                        this.fCurrentEntity.startPosition = n6;
                        if (this.load(n6, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++n4;
                        continue;
                    }
                    ++n6;
                    continue;
                }
                if (n5 == 10) {
                    ++n6;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    n4 = 0;
                    this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                    this.fCurrentEntity.position = n6;
                    this.fCurrentEntity.startPosition = n6;
                    if (!this.load(n6, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            for (n3 = n4; n3 < this.fCurrentEntity.position; ++n3) {
                this.fCurrentEntity.ch[n3] = 10;
            }
            n3 = this.fCurrentEntity.position - n4;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                xMLString.setValues(this.fCurrentEntity.ch, n4, n3);
                return -1;
            }
        }
        while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
            if (((n5 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != n2 || this.fCurrentEntity.literal && !bl) && n5 != 37 && XMLChar.isContent((int)n5)) continue;
            --this.fCurrentEntity.position;
            break;
        }
        n3 = this.fCurrentEntity.position - n4;
        this.fCurrentEntity.columnNumber += n3 - n6;
        xMLString.setValues(this.fCurrentEntity.ch, n4, n3);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            n5 = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (n5 == n2 && this.fCurrentEntity.literal) {
                n5 = -1;
            }
        } else {
            n5 = -1;
        }
        return n5;
    }

    public boolean scanData(String string, XMLStringBuffer xMLStringBuffer) throws IOException {
        int n2;
        boolean bl = false;
        int n3 = string.length();
        char c2 = string.charAt(0);
        boolean bl2 = this.fCurrentEntity.isExternal();
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        boolean bl3 = false;
        while (this.fCurrentEntity.position > this.fCurrentEntity.count - n3 && !bl3) {
            System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.position, this.fCurrentEntity.ch, 0, this.fCurrentEntity.count - this.fCurrentEntity.position);
            bl3 = this.load(this.fCurrentEntity.count - this.fCurrentEntity.position, false);
            this.fCurrentEntity.position = 0;
            this.fCurrentEntity.startPosition = 0;
        }
        if (this.fCurrentEntity.position > this.fCurrentEntity.count - n3) {
            int n4 = this.fCurrentEntity.count - this.fCurrentEntity.position;
            xMLStringBuffer.append(this.fCurrentEntity.ch, this.fCurrentEntity.position, n4);
            this.fCurrentEntity.columnNumber += this.fCurrentEntity.count;
            this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
            this.fCurrentEntity.position = this.fCurrentEntity.count;
            this.fCurrentEntity.startPosition = this.fCurrentEntity.count;
            this.load(0, true);
            return false;
        }
        int n5 = this.fCurrentEntity.position;
        char c3 = this.fCurrentEntity.ch[n5];
        int n6 = 0;
        if (c3 == '\n' || c3 == '\r' && bl2) {
            do {
                if ((c3 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == '\r' && bl2) {
                    ++n6;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        n5 = 0;
                        this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                        this.fCurrentEntity.position = n6;
                        this.fCurrentEntity.startPosition = n6;
                        if (this.load(n6, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++n5;
                        continue;
                    }
                    ++n6;
                    continue;
                }
                if (c3 == '\n') {
                    ++n6;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    n5 = 0;
                    this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                    this.fCurrentEntity.position = n6;
                    this.fCurrentEntity.startPosition = n6;
                    this.fCurrentEntity.count = n6;
                    if (!this.load(n6, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            for (n2 = n5; n2 < this.fCurrentEntity.position; ++n2) {
                this.fCurrentEntity.ch[n2] = 10;
            }
            n2 = this.fCurrentEntity.position - n5;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                xMLStringBuffer.append(this.fCurrentEntity.ch, n5, n2);
                return true;
            }
        }
        block3: while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
            if ((c3 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == c2) {
                n2 = this.fCurrentEntity.position - 1;
                for (int i2 = 1; i2 < n3; ++i2) {
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        this.fCurrentEntity.position -= i2;
                        break block3;
                    }
                    c3 = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
                    if (string.charAt(i2) == c3) continue;
                    --this.fCurrentEntity.position;
                    break;
                }
                if (this.fCurrentEntity.position != n2 + n3) continue;
                bl = true;
                break;
            }
            if (c3 == '\n' || bl2 && c3 == '\r') {
                --this.fCurrentEntity.position;
                break;
            }
            if (!XMLChar.isInvalid((int)c3)) continue;
            --this.fCurrentEntity.position;
            n2 = this.fCurrentEntity.position - n5;
            this.fCurrentEntity.columnNumber += n2 - n6;
            xMLStringBuffer.append(this.fCurrentEntity.ch, n5, n2);
            return true;
        }
        n2 = this.fCurrentEntity.position - n5;
        this.fCurrentEntity.columnNumber += n2 - n6;
        if (bl) {
            n2 -= n3;
        }
        xMLStringBuffer.append(this.fCurrentEntity.ch, n5, n2);
        return !bl;
    }

    public boolean skipChar(int n2) throws IOException {
        char c2;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if ((c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]) == n2) {
            ++this.fCurrentEntity.position;
            if (n2 == 10) {
                ++this.fCurrentEntity.lineNumber;
                this.fCurrentEntity.columnNumber = 1;
            } else {
                ++this.fCurrentEntity.columnNumber;
            }
            return true;
        }
        if (n2 == 10 && c2 == '\r' && this.fCurrentEntity.isExternal()) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = c2;
                this.load(1, false);
            }
            ++this.fCurrentEntity.position;
            if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                ++this.fCurrentEntity.position;
            }
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            return true;
        }
        return false;
    }

    public boolean skipSpaces() throws IOException {
        char c2;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if (XMLChar.isSpace((int)(c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]))) {
            boolean bl = this.fCurrentEntity.isExternal();
            do {
                boolean bl2 = false;
                if (c2 == '\n' || bl && c2 == '\r') {
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                        this.fCurrentEntity.ch[0] = c2;
                        bl2 = this.load(1, true);
                        if (!bl2) {
                            this.fCurrentEntity.position = 0;
                            this.fCurrentEntity.startPosition = 0;
                        }
                    }
                    if (c2 == '\r' && bl && this.fCurrentEntity.ch[++this.fCurrentEntity.position] != '\n') {
                        --this.fCurrentEntity.position;
                    }
                } else {
                    ++this.fCurrentEntity.columnNumber;
                }
                if (!bl2) {
                    ++this.fCurrentEntity.position;
                }
                if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                this.load(0, true);
            } while (XMLChar.isSpace((int)(c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position])));
            return true;
        }
        return false;
    }

    public final boolean skipDeclSpaces() throws IOException {
        char c2;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if (XMLChar.isSpace((int)(c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]))) {
            boolean bl = this.fCurrentEntity.isExternal();
            do {
                boolean bl2 = false;
                if (c2 == '\n' || bl && c2 == '\r') {
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                        this.fCurrentEntity.ch[0] = c2;
                        bl2 = this.load(1, true);
                        if (!bl2) {
                            this.fCurrentEntity.position = 0;
                            this.fCurrentEntity.startPosition = 0;
                        }
                    }
                    if (c2 == '\r' && bl && this.fCurrentEntity.ch[++this.fCurrentEntity.position] != '\n') {
                        --this.fCurrentEntity.position;
                    }
                } else {
                    ++this.fCurrentEntity.columnNumber;
                }
                if (!bl2) {
                    ++this.fCurrentEntity.position;
                }
                if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                this.load(0, true);
            } while (XMLChar.isSpace((int)(c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position])));
            return true;
        }
        return false;
    }

    public boolean skipString(String string) throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2;
            if ((c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != string.charAt(i2)) {
                this.fCurrentEntity.position -= i2 + 1;
                return false;
            }
            if (i2 >= n2 - 1 || this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.count - i2 - 1, this.fCurrentEntity.ch, 0, i2 + 1);
            if (!this.load(i2 + 1, false)) continue;
            this.fCurrentEntity.startPosition -= i2 + 1;
            this.fCurrentEntity.position -= i2 + 1;
            return false;
        }
        this.fCurrentEntity.columnNumber += n2;
        return true;
    }

    public final String getPublicId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getPublicId() : null;
    }

    public final String getExpandedSystemId() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.entityLocation != null && this.fCurrentEntity.entityLocation.getExpandedSystemId() != null) {
                return this.fCurrentEntity.entityLocation.getExpandedSystemId();
            }
            return this.fCurrentEntity.getExpandedSystemId();
        }
        return null;
    }

    public final String getLiteralSystemId() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.entityLocation != null && this.fCurrentEntity.entityLocation.getLiteralSystemId() != null) {
                return this.fCurrentEntity.entityLocation.getLiteralSystemId();
            }
            return this.fCurrentEntity.getLiteralSystemId();
        }
        return null;
    }

    public final int getLineNumber() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.isExternal()) {
                return this.fCurrentEntity.lineNumber;
            }
            return this.fCurrentEntity.getLineNumber();
        }
        return -1;
    }

    public final int getColumnNumber() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.isExternal()) {
                return this.fCurrentEntity.columnNumber;
            }
            return this.fCurrentEntity.getColumnNumber();
        }
        return -1;
    }

    public final int getCharacterOffset() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.isExternal()) {
                return this.fCurrentEntity.baseCharOffset + (this.fCurrentEntity.position - this.fCurrentEntity.startPosition);
            }
            return this.fCurrentEntity.getCharacterOffset();
        }
        return -1;
    }

    public final String getEncoding() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.isExternal()) {
                return this.fCurrentEntity.encoding;
            }
            return this.fCurrentEntity.getEncoding();
        }
        return null;
    }

    public final String getXMLVersion() {
        if (this.fCurrentEntity != null) {
            if (this.fCurrentEntity.isExternal()) {
                return this.fCurrentEntity.xmlVersion;
            }
            return this.fCurrentEntity.getXMLVersion();
        }
        return null;
    }

    public final void setCurrentEntity(XMLEntityManager.ScannedEntity scannedEntity) {
        this.fCurrentEntity = scannedEntity;
    }

    public final void setBufferSize(int n2) {
        this.fBufferSize = n2;
    }

    public final void reset(SymbolTable symbolTable, XMLEntityManager xMLEntityManager, XMLErrorReporter xMLErrorReporter) {
        this.fCurrentEntity = null;
        this.fSymbolTable = symbolTable;
        this.fEntityManager = xMLEntityManager;
        this.fErrorReporter = xMLErrorReporter;
    }

    final boolean load(int n2, boolean bl) throws IOException {
        this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
        int n3 = this.fCurrentEntity.ch.length - n2;
        if (!this.fCurrentEntity.mayReadChunks && n3 > 64) {
            n3 = 64;
        }
        int n4 = this.fCurrentEntity.reader.read(this.fCurrentEntity.ch, n2, n3);
        boolean bl2 = false;
        if (n4 != -1) {
            if (n4 != 0) {
                this.fCurrentEntity.count = n4 + n2;
                this.fCurrentEntity.position = n2;
                this.fCurrentEntity.startPosition = n2;
            }
        } else {
            this.fCurrentEntity.count = n2;
            this.fCurrentEntity.position = n2;
            this.fCurrentEntity.startPosition = n2;
            bl2 = true;
            if (bl) {
                this.fEntityManager.endEntity();
                if (this.fCurrentEntity == null) {
                    throw END_OF_DOCUMENT_ENTITY;
                }
                if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                    this.load(0, true);
                }
            }
        }
        return bl2;
    }
}

