/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyAxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public abstract class AbstractNodeWrapper
implements NodeInfo,
VirtualNode {
    public final NodeInfo head() {
        return this;
    }

    public SequenceIterator<NodeInfo> iterate() {
        return SingletonIterator.makeIterator((Item)this);
    }

    public final Object getRealNode() {
        return this.getUnderlyingNode();
    }

    public Configuration getConfiguration() {
        return this.getDocumentRoot().getConfiguration();
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    public AtomicSequence atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        SchemaType schemaType = this.getSchemaType();
        return schemaType == null ? -1 : schemaType.getFingerprint();
    }

    public SchemaType getSchemaType() {
        if (this.getNodeKind() == 2) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return Untyped.getInstance();
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof AbstractNodeWrapper)) {
            return false;
        }
        AbstractNodeWrapper abstractNodeWrapper = (AbstractNodeWrapper)nodeInfo;
        return this.getUnderlyingNode().equals(abstractNodeWrapper.getUnderlyingNode());
    }

    public boolean equals(Object object) {
        return object instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)object);
    }

    public int hashCode() {
        return this.getUnderlyingNode().hashCode();
    }

    public String getSystemId() {
        return this.getDocumentRoot().getSystemId();
    }

    public void setSystemId(String string) {
        this.getDocumentRoot().setSystemId(string);
    }

    public String getBaseURI() {
        return Navigator.getBaseURI((NodeInfo)this);
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int comparePosition(NodeInfo nodeInfo) {
        return Navigator.comparePosition((NodeInfo)this, (NodeInfo)nodeInfo);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public int getNameCode() {
        switch (this.getNodeKind()) {
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                return this.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    public int getFingerprint() {
        int n2 = this.getNameCode();
        if (n2 == -1) {
            return -1;
        }
        return n2 & 0xFFFFF;
    }

    public String getDisplayName() {
        String string = this.getPrefix();
        String string2 = this.getLocalPart();
        if (string.length() == 0) {
            return string2;
        }
        return string + ":" + string2;
    }

    public String getAttributeValue(String string, String string2) {
        return null;
    }

    public AxisIterator iterateAxis(byte by) {
        return this.iterateAxis(by, (NodeTest)AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        int n2 = this.getNodeKind();
        switch (by) {
            case 0: {
                if (n2 == 9) {
                    return EmptyAxisIterator.emptyAxisIterator();
                }
                return new Navigator.AxisFilter((AxisIterator)new Navigator.AncestorEnumeration((NodeInfo)this, false), nodeTest);
            }
            case 1: {
                if (n2 == 9) {
                    return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
                }
                return new Navigator.AxisFilter((AxisIterator)new Navigator.AncestorEnumeration((NodeInfo)this, true), nodeTest);
            }
            case 2: {
                if (n2 != 1) {
                    return EmptyAxisIterator.emptyAxisIterator();
                }
                return this.iterateAttributes(nodeTest);
            }
            case 3: {
                if (n2 == 1 || n2 == 9) {
                    return this.iterateChildren(nodeTest);
                }
                return EmptyAxisIterator.emptyAxisIterator();
            }
            case 4: {
                if (n2 == 1 || n2 == 9) {
                    return this.iterateDescendants(nodeTest, false);
                }
                return EmptyAxisIterator.emptyAxisIterator();
            }
            case 5: {
                if (n2 == 1 || n2 == 9) {
                    return this.iterateDescendants(nodeTest, true);
                }
                return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.FollowingEnumeration((NodeInfo)this), nodeTest);
            }
            case 7: {
                switch (n2) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyAxisIterator.emptyAxisIterator();
                    }
                }
                return this.iterateSiblings(nodeTest, true);
            }
            case 8: {
                if (n2 != 1) {
                    return EmptyAxisIterator.emptyAxisIterator();
                }
                return NamespaceNode.makeIterator((NodeInfo)this, (NodeTest)nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton((NodeInfo)this.getParent(), (NodeTest)nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.PrecedingEnumeration((NodeInfo)this, false), nodeTest);
            }
            case 11: {
                switch (n2) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyAxisIterator.emptyAxisIterator();
                    }
                }
                return this.iterateSiblings(nodeTest, false);
            }
            case 12: {
                return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.PrecedingEnumeration((NodeInfo)this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    protected abstract AxisIterator<NodeInfo> iterateAttributes(NodeTest var1);

    protected abstract AxisIterator<NodeInfo> iterateChildren(NodeTest var1);

    protected abstract AxisIterator<NodeInfo> iterateSiblings(NodeTest var1, boolean var2);

    protected abstract AxisIterator<NodeInfo> iterateDescendants(NodeTest var1, boolean var2);

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        return new NamespaceBinding[0];
    }

    public NodeInfo getRoot() {
        return this.getDocumentRoot();
    }

    public boolean hasChildNodes() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                return this.iterateAxis((byte)3).moveNext();
            }
        }
        return false;
    }

    public long getDocumentNumber() {
        return this.getDocumentRoot().getDocumentNumber();
    }

    public void copy(Receiver receiver, int n2, int n3) throws XPathException {
        Navigator.copy((NodeInfo)this, (Receiver)receiver, (int)n2, (int)n3);
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        return false;
    }

    public boolean isNilled() {
        return false;
    }
}

