/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.style.CollationDeclaration;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetFunctionLibrary;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntIterator;

public class PrincipalStylesheetModule
extends StylesheetModule {
    private static final boolean TIMING = false;
    private PreparedStylesheet preparedStylesheet;
    private HashSet<String> schemaIndex = new HashSet(10);
    private XQueryFunctionLibrary queryFunctions;
    private FunctionLibraryList functionLibrary;
    private String version;
    private HashMap<StructuredQName, Declaration> globalVariableIndex = new HashMap(20);
    private HashMap<StructuredQName, Declaration> templateIndex = new HashMap(20);
    private IntHashMap<HashMap<StructuredQName, Declaration>> functionIndex = new IntHashMap(8);
    private HashMap<StructuredQName, Integer> localParameterNumbers = null;
    private int numberOfAliases = 0;
    private List<Declaration> namespaceAliasList = new ArrayList<Declaration>(5);
    private HashMap<String, NamespaceBinding> namespaceAliasMap;
    private Set<String> aliasResultUriSet;
    private boolean needsDynamicOutputProperties = false;
    private int largestPatternStackFrame = 0;
    private HashMap<DocumentURI, XSLStylesheet> moduleCache = new HashMap(4);

    public PrincipalStylesheetModule(XSLStylesheet xSLStylesheet, int n2) {
        super(xSLStylesheet, n2);
    }

    public void setPreparedStylesheet(PreparedStylesheet preparedStylesheet) {
        this.preparedStylesheet = preparedStylesheet;
    }

    public PreparedStylesheet getPreparedStylesheet() {
        return this.preparedStylesheet;
    }

    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this;
    }

    public FunctionLibraryList createFunctionLibrary(CompilerInfo compilerInfo) {
        Configuration configuration = this.getPreparedStylesheet().getConfiguration();
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        int n2 = 3;
        if ("3.0".equals(this.getVersion())) {
            n2 |= 0x50;
        }
        functionLibraryList.addFunctionLibrary((FunctionLibrary)SystemFunctionLibrary.getSystemFunctionLibrary((int)n2));
        functionLibraryList.addFunctionLibrary((FunctionLibrary)new StylesheetFunctionLibrary(this, true));
        functionLibraryList.addFunctionLibrary((FunctionLibrary)configuration.getVendorFunctionLibrary());
        functionLibraryList.addFunctionLibrary((FunctionLibrary)new ConstructorFunctionLibrary(configuration));
        if (compilerInfo.getExtensionFunctionLibrary() != null) {
            functionLibraryList.addFunctionLibrary(compilerInfo.getExtensionFunctionLibrary());
        }
        this.queryFunctions = new XQueryFunctionLibrary(configuration);
        functionLibraryList.addFunctionLibrary((FunctionLibrary)this.queryFunctions);
        functionLibraryList.addFunctionLibrary((FunctionLibrary)configuration.getIntegratedFunctionLibrary());
        configuration.addExtensionBinders(functionLibraryList);
        functionLibraryList.addFunctionLibrary((FunctionLibrary)new StylesheetFunctionLibrary(this, false));
        if (this.getPreparedStylesheet().getAccumulatorManager() != null) {
            functionLibraryList.addFunctionLibrary(this.getPreparedStylesheet().getAccumulatorManager().getAccumulatorFunctionLibrary());
        }
        this.functionLibrary = functionLibraryList;
        return this.functionLibrary;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void declareXQueryFunction(XQueryFunction xQueryFunction) throws XPathException {
        this.queryFunctions.declareFunction(xQueryFunction);
    }

    public void putStylesheetDocument(DocumentURI documentURI, XSLStylesheet xSLStylesheet) {
        this.moduleCache.put(documentURI, xSLStylesheet);
    }

    public XSLStylesheet getStylesheetDocument(DocumentURI documentURI) {
        XSLStylesheet xSLStylesheet = this.moduleCache.get(documentURI);
        if (xSLStylesheet != null) {
            TransformerException transformerException = new TransformerException("Stylesheet module " + documentURI + " is included or imported more than once. " + "This is permitted, but may lead to errors or unexpected behavior");
            this.getPreparedStylesheet().reportWarning(transformerException);
        }
        return xSLStylesheet;
    }

    public void preprocess() throws XPathException {
        Declaration declaration2;
        this.spliceIncludes();
        this.buildIndexes();
        this.checkForSchemaAwareness();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        for (Declaration declaration2 : this.topLevel) {
            StyleElement styleElement = declaration2.getSourceElement();
            if (styleElement.isActionCompleted(16)) continue;
            styleElement.setActionCompleted(16);
            styleElement.fixupReferences();
        }
        XSLStylesheet xSLStylesheet = this.getSourceElement();
        this.setInputTypeAnnotations(xSLStylesheet.getInputTypeAnnotationsAttribute());
        declaration2 = new Declaration((StylesheetModule)this, (StyleElement)xSLStylesheet);
        if (!xSLStylesheet.isActionCompleted(1)) {
            xSLStylesheet.setActionCompleted(1);
            xSLStylesheet.validate(declaration2);
            for (Declaration declaration3 : this.topLevel) {
                declaration3.getSourceElement().validateSubtree(declaration3);
            }
        }
    }

    private void buildIndexes() throws XPathException {
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            Declaration declaration = (Declaration)this.topLevel.get(i2);
            declaration.getSourceElement().index(declaration, this);
        }
        Configuration configuration = this.getPreparedStylesheet().getConfiguration();
        for (String string : this.schemaIndex) {
            configuration.sealNamespace(string);
        }
    }

    public void processAllAttributes() throws XPathException {
        this.getSourceElement().processDefaultCollationAttribute();
        this.getSourceElement().prepareAttributes();
        for (Declaration declaration : this.topLevel) {
            StyleElement styleElement = declaration.getSourceElement();
            if (styleElement.isActionCompleted(32)) continue;
            styleElement.setActionCompleted(32);
            try {
                styleElement.processAllAttributes();
            }
            catch (XPathException xPathException) {
                declaration.getSourceElement().compileError(xPathException);
            }
        }
    }

    protected void indexFunction(Declaration declaration) throws XPathException {
        int n2;
        XSLFunction xSLFunction = (XSLFunction)declaration.getSourceElement();
        StructuredQName structuredQName = xSLFunction.getObjectName();
        Declaration declaration2 = this.getFunctionDeclaration(structuredQName, n2 = xSLFunction.getNumberOfArguments());
        if (declaration2 == null) {
            this.putFunction(declaration);
        } else {
            int n3;
            int n4 = declaration.getPrecedence();
            if (n4 == (n3 = declaration2.getPrecedence())) {
                StyleElement styleElement = declaration2.getSourceElement();
                if (declaration.getSourceElement() == styleElement) {
                    xSLFunction.compileError("Function " + structuredQName.getDisplayName() + " is declared more than once " + "(caused by including the containing module more than once)", "XTSE0770");
                } else {
                    xSLFunction.compileError("Duplicate function declaration (see line " + styleElement.getLineNumber() + " of " + styleElement.getSystemId() + ')', "XTSE0770");
                }
            } else if (n4 >= n3) {
                this.putFunction(declaration);
            }
        }
    }

    protected Declaration getFunctionDeclaration(StructuredQName structuredQName, int n2) {
        HashMap hashMap = (HashMap)this.functionIndex.get(n2);
        return hashMap == null ? null : (Declaration)hashMap.get(structuredQName);
    }

    public XSLFunction getFunction(StructuredQName structuredQName, int n2) {
        if (n2 == -1) {
            IntIterator intIterator = this.functionIndex.keyIterator();
            while (intIterator.hasNext()) {
                int n3 = intIterator.next();
                Declaration declaration = this.getFunctionDeclaration(structuredQName, n3);
                if (declaration == null) continue;
                return (XSLFunction)declaration.getSourceElement();
            }
            return null;
        }
        Declaration declaration = this.getFunctionDeclaration(structuredQName, n2);
        return declaration == null ? null : (XSLFunction)declaration.getSourceElement();
    }

    protected void putFunction(Declaration declaration) {
        XSLFunction xSLFunction = (XSLFunction)declaration.getSourceElement();
        StructuredQName structuredQName = xSLFunction.getObjectName();
        int n2 = xSLFunction.getNumberOfArguments();
        HashMap<StructuredQName, Declaration> hashMap = (HashMap<StructuredQName, Declaration>)this.functionIndex.get(n2);
        if (hashMap == null) {
            hashMap = new HashMap<StructuredQName, Declaration>();
            this.functionIndex.put(n2, hashMap);
        }
        hashMap.put(structuredQName, declaration);
    }

    protected void indexVariableDeclaration(Declaration declaration) throws XPathException {
        XSLGlobalVariable xSLGlobalVariable = (XSLGlobalVariable)declaration.getSourceElement();
        StructuredQName structuredQName = xSLGlobalVariable.getSourceBinding().getVariableQName();
        if (structuredQName != null) {
            Declaration declaration2 = this.globalVariableIndex.get(structuredQName);
            if (declaration2 == null) {
                this.globalVariableIndex.put(structuredQName, declaration);
            } else {
                int n2;
                int n3 = declaration.getPrecedence();
                if (n3 == (n2 = declaration2.getPrecedence())) {
                    StyleElement styleElement = declaration2.getSourceElement();
                    if (styleElement == xSLGlobalVariable) {
                        xSLGlobalVariable.compileError("Global variable " + structuredQName.getDisplayName() + " is declared more than once " + "(caused by including the containing module more than once)", "XTSE0630");
                    } else {
                        xSLGlobalVariable.compileError("Duplicate global variable declaration (see line " + styleElement.getLineNumber() + " of " + styleElement.getSystemId() + ')', "XTSE0630");
                    }
                } else if (n3 < n2 && xSLGlobalVariable != declaration2.getSourceElement()) {
                    xSLGlobalVariable.setRedundant(true);
                } else if (xSLGlobalVariable != declaration2.getSourceElement()) {
                    ((XSLGlobalVariable)declaration2.getSourceElement()).setRedundant(true);
                    this.globalVariableIndex.put(structuredQName, declaration);
                }
            }
        }
    }

    public SourceBinding getGlobalVariable(StructuredQName structuredQName) {
        Declaration declaration = this.globalVariableIndex.get(structuredQName);
        return declaration == null ? null : ((XSLGlobalVariable)declaration.getSourceElement()).getSourceBinding();
    }

    public int allocateUniqueParameterNumber(StructuredQName structuredQName) {
        Integer n2;
        HashMap<StructuredQName, Integer> hashMap = this.localParameterNumbers;
        if (hashMap == null) {
            hashMap = this.localParameterNumbers = new HashMap(50);
        }
        if ((n2 = hashMap.get(structuredQName)) == null) {
            n2 = hashMap.size();
            hashMap.put(structuredQName, n2);
        }
        return n2;
    }

    protected void indexNamedTemplate(Declaration declaration) throws XPathException {
        XSLTemplate xSLTemplate = (XSLTemplate)declaration.getSourceElement();
        StructuredQName structuredQName = xSLTemplate.getTemplateName();
        if (structuredQName != null) {
            Declaration declaration2 = this.templateIndex.get(structuredQName);
            if (declaration2 == null) {
                this.templateIndex.put(structuredQName, declaration);
                this.getPreparedStylesheet().putNamedTemplate(structuredQName, xSLTemplate.getCompiledTemplate());
            } else {
                int n2;
                int n3 = declaration.getPrecedence();
                if (n3 == (n2 = declaration2.getPrecedence())) {
                    StyleElement styleElement = declaration2.getSourceElement();
                    xSLTemplate.compileError("Duplicate named template (see line " + styleElement.getLineNumber() + " of " + styleElement.getSystemId() + ')', "XTSE0660");
                } else if (n3 >= n2) {
                    this.templateIndex.put(structuredQName, declaration);
                    this.getPreparedStylesheet().putNamedTemplate(structuredQName, xSLTemplate.getCompiledTemplate());
                }
            }
        }
    }

    public XSLTemplate getNamedTemplate(StructuredQName structuredQName) {
        Declaration declaration = this.templateIndex.get(structuredQName);
        return declaration == null ? null : (XSLTemplate)declaration.getSourceElement();
    }

    private void checkForSchemaAwareness() {
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        if (!preparedStylesheet.isSchemaAware() && preparedStylesheet.getConfiguration().isLicensedFeature(2)) {
            for (Declaration declaration : this.topLevel) {
                StyleElement styleElement = declaration.getSourceElement();
                if (!(styleElement instanceof XSLImportSchema)) continue;
                preparedStylesheet.setSchemaAware(true);
                return;
            }
        }
    }

    protected void addNamespaceAlias(Declaration declaration) {
        this.namespaceAliasList.add(declaration);
        ++this.numberOfAliases;
    }

    protected NamespaceBinding getNamespaceAlias(String string) {
        return this.namespaceAliasMap.get(string);
    }

    protected boolean isAliasResultNamespace(String string) {
        return this.aliasResultUriSet.contains(string);
    }

    private void collectNamespaceAliases() throws XPathException {
        this.namespaceAliasMap = new HashMap(this.numberOfAliases);
        this.aliasResultUriSet = new HashSet<String>(this.numberOfAliases);
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = -1;
        for (int i2 = 0; i2 < this.numberOfAliases; ++i2) {
            Declaration declaration = this.namespaceAliasList.get(i2);
            XSLNamespaceAlias xSLNamespaceAlias = (XSLNamespaceAlias)declaration.getSourceElement();
            String string = xSLNamespaceAlias.getStylesheetURI();
            NamespaceBinding namespaceBinding = xSLNamespaceAlias.getResultNamespaceBinding();
            int n3 = declaration.getPrecedence();
            if (n2 != n3) {
                n2 = n3;
                hashSet.clear();
            }
            if (hashSet.contains(string) && !this.namespaceAliasMap.get(string).getURI().equals(namespaceBinding.getURI())) {
                xSLNamespaceAlias.compileError("More than one alias is defined for the same namespace", "XTSE0810");
            }
            if (this.namespaceAliasMap.get(string) == null) {
                this.namespaceAliasMap.put(string, namespaceBinding);
                this.aliasResultUriSet.add(namespaceBinding.getURI());
            }
            hashSet.add(string);
        }
        this.namespaceAliasList = null;
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    public CollationMap getCollationMap() {
        return this.getPreparedStylesheet().getCollationTable();
    }

    public void setCollation(String string, StringCollator stringCollator) {
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        if (preparedStylesheet.getCollationTable() == null) {
            preparedStylesheet.setCollationMap(new CollationMap(preparedStylesheet.getConfiguration()));
        }
        preparedStylesheet.getCollationTable().setNamedCollation(string, stringCollator);
    }

    public StringCollator findCollation(String string, String string2) {
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        Configuration configuration = preparedStylesheet.getConfiguration();
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        StringCollator stringCollator = null;
        if (preparedStylesheet.getCollationTable() != null) {
            stringCollator = preparedStylesheet.getCollationTable().getNamedCollation(string);
        }
        if (stringCollator != null) {
            return stringCollator;
        }
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            CollationDeclaration collationDeclaration;
            Declaration declaration = (Declaration)this.topLevel.get(i2);
            if (!(declaration.getSourceElement() instanceof CollationDeclaration) || !(collationDeclaration = (CollationDeclaration)declaration.getSourceElement()).getCollationName().equals(string)) continue;
            return collationDeclaration.getCollator();
        }
        return configuration.getCollationURIResolver().resolve(string, string2, configuration);
    }

    public Properties gatherOutputProperties(StructuredQName structuredQName) throws XPathException {
        boolean bl = structuredQName == null;
        Configuration configuration = this.getPreparedStylesheet().getConfiguration();
        Properties properties = new Properties(configuration.getDefaultSerializationProperties());
        HashMap hashMap = new HashMap(10);
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            Declaration declaration = (Declaration)this.topLevel.get(i2);
            if (!(declaration.getSourceElement() instanceof XSLOutput)) continue;
            XSLOutput xSLOutput = (XSLOutput)declaration.getSourceElement();
            if (!(structuredQName == null ? xSLOutput.getFormatQName() == null : structuredQName.equals((Object)xSLOutput.getFormatQName()))) continue;
            bl = true;
            xSLOutput.gatherOutputProperties(properties, hashMap, declaration.getPrecedence());
        }
        if (!bl) {
            this.compileError("Requested output format " + structuredQName.getDisplayName() + " has not been defined", "XTDE1460");
        }
        return properties;
    }

    public void compileStylesheet() throws XPathException {
        block26: {
            try {
                CharacterMap characterMap2;
                Object object;
                Object object2;
                StyleElement styleElement2;
                Object object32;
                Object object42;
                Object object5;
                PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
                Configuration configuration = preparedStylesheet.getConfiguration();
                try {
                    object5 = this.queryFunctions.getFunctionDefinitions();
                    while (object5.hasNext()) {
                        object42 = (XQueryFunction)object5.next();
                        object42.fixupReferences();
                    }
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                for (Object object42 : this.topLevel) {
                    object32 = object42.getSourceElement();
                    if (!(object32 instanceof XSLTemplate)) continue;
                    ((XSLTemplate)object32).register((Declaration)object42);
                }
                for (Object object42 : this.topLevel) {
                    object32 = object42.getSourceElement();
                    if (object32.isActionCompleted(2)) continue;
                    object32.setActionCompleted(2);
                    object32.compileDeclaration((Executable)preparedStylesheet, (Declaration)object42);
                }
                object5 = this.functionIndex.keyIterator();
                while (object5.hasNext()) {
                    for (Object object32 : ((HashMap)this.functionIndex.get(object5.next())).values()) {
                        styleElement2 = object32.getSourceElement();
                        if (styleElement2.isActionCompleted(4)) continue;
                        styleElement2.setActionCompleted(4);
                        ((XSLFunction)styleElement2).typeCheckBody();
                    }
                }
                if (this.getPreparedStylesheet().getErrorCount() > 0) {
                    return;
                }
                for (Object object42 : this.topLevel) {
                    object32 = object42.getSourceElement();
                    if (!(object32 instanceof StylesheetProcedure) || object32 instanceof XSLFunction || object32.isActionCompleted(8)) continue;
                    object32.setActionCompleted(8);
                    ((StylesheetProcedure)object32).optimize((Declaration)object42);
                }
                object5 = this.functionIndex.keyIterator();
                while (object5.hasNext()) {
                    for (Object object32 : ((HashMap)this.functionIndex.get(object5.next())).values()) {
                        styleElement2 = object32.getSourceElement();
                        if (styleElement2.isActionCompleted(8)) continue;
                        styleElement2.setActionCompleted(8);
                        ((StylesheetProcedure)styleElement2).optimize((Declaration)object32);
                    }
                }
                if (configuration.isTiming() && configuration.isGenerateByteCode(50)) {
                    configuration.getStandardErrorOutput().println("Generating byte code...");
                }
                preparedStylesheet.setStripsWhitespace(this.stripsWhitespace());
                object5 = this.gatherOutputProperties(null);
                ((Properties)object5).setProperty("{http://saxon.sf.net/}stylesheet-version", this.getVersion());
                preparedStylesheet.setDefaultOutputProperties((Properties)object5);
                object42 = new HashSet(5);
                for (StyleElement styleElement2 : this.topLevel) {
                    if (!(styleElement2.getSourceElement() instanceof XSLOutput) || (object2 = (object = (XSLOutput)styleElement2.getSourceElement()).getFormatQName()) == null) continue;
                    ((HashSet)object42).add(object2);
                }
                if (((HashSet)object42).isEmpty()) {
                    if (this.needsDynamicOutputProperties) {
                        this.compileError("The stylesheet contains xsl:result-document instructions that calculate the output format name at run-time, but there are no named xsl:output declarations", "XTDE1460");
                    }
                } else {
                    object32 = ((HashSet)object42).iterator();
                    while (object32.hasNext()) {
                        styleElement2 = (StructuredQName)object32.next();
                        object = this.gatherOutputProperties((StructuredQName)styleElement2);
                        if (!this.needsDynamicOutputProperties) continue;
                        preparedStylesheet.setOutputProperties((StructuredQName)styleElement2, (Properties)object);
                    }
                }
                preparedStylesheet.setPatternSlotSpace(this.largestPatternStackFrame);
                preparedStylesheet.setStripsInputTypeAnnotations(this.getInputTypeAnnotations() == 1);
                for (StyleElement styleElement2 : this.topLevel) {
                    if (!(styleElement2.getSourceElement() instanceof XSLCharacterMap) || (object = (XSLCharacterMap)styleElement2.getSourceElement()).isRedundant()) continue;
                    object2 = object.getCharacterMapName();
                    Object object6 = new IntHashMap();
                    object.assemble((IntHashMap)object6);
                    characterMap2 = new CharacterMap((IntHashMap)object6);
                    if (preparedStylesheet.getCharacterMapIndex() == null) {
                        preparedStylesheet.setCharacterMapIndex(new CharacterMapIndex());
                    }
                    preparedStylesheet.getCharacterMapIndex().putCharacterMap((StructuredQName)object2, characterMap2);
                }
                preparedStylesheet.getDecimalFormatManager().checkConsistency();
                object32 = this.getPreparedStylesheet().getRuleManager();
                object32.computeRankings();
                object32.invertStreamableTemplates(configuration.obtainOptimizer());
                styleElement2 = new ExecutableFunctionLibrary(configuration);
                object = new ExecutableFunctionLibrary(configuration);
                for (Object object6 : this.topLevel) {
                    if (!(object6.getSourceElement() instanceof XSLFunction)) continue;
                    characterMap2 = (XSLFunction)object6.getSourceElement();
                    if (characterMap2.isOverriding()) {
                        styleElement2.addFunction(characterMap2.getCompiledFunction());
                        continue;
                    }
                    object.addFunction(characterMap2.getCompiledFunction());
                }
                object2 = new FunctionLibraryList();
                for (CharacterMap characterMap2 : this.functionLibrary.getLibraryList()) {
                    if (characterMap2 instanceof StylesheetFunctionLibrary) {
                        if (((StylesheetFunctionLibrary)characterMap2).isOverriding()) {
                            object2.addFunctionLibrary((FunctionLibrary)styleElement2);
                            continue;
                        }
                        object2.addFunctionLibrary((FunctionLibrary)object);
                        continue;
                    }
                    object2.addFunctionLibrary((FunctionLibrary)characterMap2);
                }
                preparedStylesheet.setFunctionLibrary((FunctionLibraryList)object2);
            }
            catch (RuntimeException runtimeException) {
                if (this.getPreparedStylesheet().getErrorCount() != 0) break block26;
                throw runtimeException;
            }
        }
    }

    protected boolean isImportedSchema(String string) {
        return this.schemaIndex.contains(string);
    }

    protected void addImportedSchema(String string) {
        this.schemaIndex.add(string);
    }

    protected HashSet<String> getImportedSchemaTable() {
        return this.schemaIndex;
    }

    protected boolean getAttributeSets(StructuredQName structuredQName, List<Declaration> list) throws XPathException {
        boolean bl = false;
        for (Declaration declaration : this.topLevel) {
            XSLAttributeSet xSLAttributeSet;
            if (!(declaration.getSourceElement() instanceof XSLAttributeSet) || !(xSLAttributeSet = (XSLAttributeSet)declaration.getSourceElement()).getAttributeSetName().equals((Object)structuredQName)) continue;
            xSLAttributeSet.incrementReferenceCount();
            list.add(declaration);
            bl = true;
        }
        return bl;
    }

    public boolean stripsWhitespace() {
        for (Declaration declaration : this.topLevel) {
            StyleElement styleElement = declaration.getSourceElement();
            if (styleElement.getFingerprint() != 198) continue;
            return true;
        }
        return false;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setNeedsDynamicOutputProperties(boolean bl) {
        this.needsDynamicOutputProperties = bl;
    }

    public Declaration getCharacterMap(StructuredQName structuredQName) {
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            XSLCharacterMap xSLCharacterMap;
            Declaration declaration = (Declaration)this.topLevel.get(i2);
            if (!(declaration.getSourceElement() instanceof XSLCharacterMap) || !(xSLCharacterMap = (XSLCharacterMap)declaration.getSourceElement()).getCharacterMapName().equals((Object)structuredQName)) continue;
            return declaration;
        }
        return null;
    }

    public void allocatePatternSlots(int n2) {
        if (n2 > this.largestPatternStackFrame) {
            this.largestPatternStackFrame = n2;
        }
    }

    protected void compileError(String string, String string2) throws XPathException {
        XPathException xPathException = new XPathException(string);
        xPathException.setErrorCode(string2);
        this.compileError(xPathException);
    }

    protected void compileError(XPathException xPathException) throws XPathException {
        xPathException.setIsStaticError(true);
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        try {
            if (preparedStylesheet == null) {
                throw xPathException;
            }
            preparedStylesheet.reportError((TransformerException)((Object)xPathException));
        }
        catch (TransformerException transformerException) {
            throw XPathException.makeXPathException((TransformerException)transformerException);
        }
    }

    public List<XSLGeneralVariable> getGlobalVariables() {
        ArrayList<XSLGeneralVariable> arrayList = null;
        if (this.globalVariableIndex != null) {
            arrayList = new ArrayList<XSLGeneralVariable>(this.globalVariableIndex.size());
            for (Declaration declaration : this.globalVariableIndex.values()) {
                StyleElement styleElement = declaration.getSourceElement();
                if (!(styleElement instanceof XSLGeneralVariable)) continue;
                XSLGeneralVariable xSLGeneralVariable = (XSLGeneralVariable)styleElement;
                arrayList.add(xSLGeneralVariable);
            }
        }
        return arrayList;
    }
}

