/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.instruct.Procedure;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import ro.sync.exml.editor.xmleditor.transform.b.f;
import ro.sync.xml.transformer.hb;

public class Template
extends Procedure
implements RuleTarget {
    private Pattern matchPattern;
    private StructuredQName templateName;
    private boolean hasRequiredParams;
    private boolean bodyIsTailCallReturner;
    private SequenceType requiredType;
    private boolean declaredStreamable;
    private StructuredQName[] modeNames;
    private boolean initialized = false;
    private f stopHandler;

    public Template() {
        this.setHostLanguage(50);
    }

    public void setTemplateName(StructuredQName structuredQName) {
        this.templateName = structuredQName;
    }

    public void setMatchPattern(Pattern pattern) {
        this.matchPattern = pattern;
    }

    public Pattern getMatchPattern() {
        return this.matchPattern;
    }

    public void setBody(Expression expression) {
        super.setBody(expression);
        this.bodyIsTailCallReturner = expression instanceof TailCallReturner;
    }

    public StructuredQName getTemplateName() {
        return this.templateName;
    }

    public StructuredQName getObjectName() {
        return this.templateName;
    }

    public void setHasRequiredParams(boolean bl) {
        this.hasRequiredParams = bl;
    }

    public boolean hasRequiredParams() {
        return this.hasRequiredParams;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.requiredType;
    }

    public void setModeNames(StructuredQName[] structuredQNameArray) {
        this.modeNames = structuredQNameArray;
    }

    public StructuredQName[] getModeNames() {
        return this.modeNames;
    }

    public void setDeclaredStreamable(boolean bl) {
        this.declaredStreamable = bl;
    }

    public boolean isDeclaredStreamable() {
        return this.declaredStreamable;
    }

    public LocalParam getLocalParam(int n2) {
        Iterator iterator = this.body.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            if (!(expression instanceof LocalParamSetter) || ((LocalParamSetter)expression).getBinding().getParameterId() != n2) continue;
            return ((LocalParamSetter)expression).getBinding();
        }
        return null;
    }

    public void apply(XPathContextMajor xPathContextMajor) throws XPathException {
        for (TailCall tailCall = this.applyLeavingTail(xPathContextMajor); tailCall != null; tailCall = tailCall.processLeavingTail()) {
        }
    }

    public TailCall applyLeavingTail(XPathContextMajor xPathContextMajor) throws XPathException {
        this.checkStop();
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)this.body).processLeavingTail((XPathContext)xPathContextMajor);
        }
        this.checkStop();
        this.body.process((XPathContext)xPathContextMajor);
        this.checkStop();
        return null;
    }

    private void checkStop() {
        if (!this.initialized && this.getExecutable() != null) {
            Object object = this.getExecutable().getConfiguration().getConfigurationProperty("STOP_HANDLER");
            if (object instanceof f) {
                this.stopHandler = (f)object;
            }
            this.initialized = true;
        }
        if (this.stopHandler != null && this.stopHandler.sic()) {
            throw new hb();
        }
    }

    public TailCall expand(XPathContext xPathContext) throws XPathException {
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)this.body).processLeavingTail(xPathContext);
        }
        if (this.body != null) {
            this.body.process(xPathContext);
        }
        return null;
    }

    public int getConstructType() {
        return 2008;
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.emitAttribute("line", this.getLineNumber() + "");
        expressionPresenter.emitAttribute("module", this.getSystemId());
        if (this.isDeclaredStreamable()) {
            expressionPresenter.emitAttribute("streamable", "true");
        }
        if (this.getBody() != null) {
            this.getBody().explain(expressionPresenter);
        }
    }

    public boolean isActuallyStreamable(boolean bl, List<String> list) {
        if (this.body == null) {
            if (list != null) {
                list.add("The template has no body");
            }
            return false;
        }
        int n2 = this.body.getStreamability(0, bl, list);
        return n2 == 2 || n2 == 0;
    }
}

