/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;

public abstract class SaxonInstruction
extends Expression
implements SourceLocator,
TailCallReturner {
    public int getImplementationMethod() {
        return 4;
    }

    public int getInstructionNameCode() {
        return -1;
    }

    public String getInstructionName() {
        return this.getClass().getName();
    }

    public String getExpressionName() {
        int n2 = this.getInstructionNameCode();
        if (n2 < 0) {
            return this.getClass().getName();
        }
        if (n2 < 1024) {
            return StandardNames.getDisplayName((int)n2);
        }
        return this.getInstructionName();
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.ITEM_TYPE;
    }

    public int computeCardinality() {
        return 57344;
    }

    public abstract TailCall processLeavingTail(XPathContext var1) throws XPathException;

    public void process(XPathContext xPathContext) throws XPathException {
        try {
            for (TailCall tailCall = this.processLeavingTail(xPathContext); tailCall != null; tailCall = tailCall.processLeavingTail()) {
            }
        }
        catch (XPathException xPathException) {
            xPathException.maybeSetLocation((SourceLocator)this);
            throw xPathException;
        }
    }

    public SourceLocator getSourceLocator() {
        return this;
    }

    protected static XPathException dynamicError(SourceLocator sourceLocator, XPathException xPathException, XPathContext xPathContext) {
        if (xPathException instanceof TerminationException) {
            return xPathException;
        }
        xPathException.maybeSetLocation(sourceLocator);
        xPathException.maybeSetContext(xPathContext);
        return xPathException;
    }

    public static ParameterSet assembleParams(XPathContext xPathContext, WithParam[] withParamArray) throws XPathException {
        if (withParamArray == null || withParamArray.length == 0) {
            return null;
        }
        ParameterSet parameterSet = new ParameterSet(withParamArray.length);
        for (WithParam withParam : withParamArray) {
            parameterSet.put(withParam.getParameterId(), withParam.getSelectValue(xPathContext), withParam.isTypeChecked());
        }
        return parameterSet;
    }

    public static ParameterSet assembleTunnelParams(XPathContext xPathContext, WithParam[] withParamArray) throws XPathException {
        ParameterSet parameterSet = xPathContext.getTunnelParameters();
        if (parameterSet == null) {
            return SaxonInstruction.assembleParams(xPathContext, withParamArray);
        }
        ParameterSet parameterSet2 = new ParameterSet(parameterSet, withParamArray == null ? 0 : withParamArray.length);
        if (withParamArray == null || withParamArray.length == 0) {
            return parameterSet2;
        }
        for (WithParam withParam : withParamArray) {
            parameterSet2.put(withParam.getParameterId(), withParam.getSelectValue(xPathContext), false);
        }
        return parameterSet2;
    }

    public abstract Expression simplify(ExpressionVisitor var1) throws XPathException;

    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        if (this.createsNewNodes()) {
            return n2;
        }
        return n2 | 0x400000;
    }

    public boolean createsNewNodes() {
        return false;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
    }

    public Expression promote(PromotionOffer promotionOffer, Expression expression) throws XPathException {
        Expression expression2 = promotionOffer.accept(expression, (Expression)this);
        if (expression2 != null) {
            return expression2;
        }
        this.promoteInst(promotionOffer);
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        int n2 = this.getImplementationMethod();
        if ((n2 & 1) != 0) {
            throw new AssertionError((Object)("evaluateItem() is not implemented in the subclass " + this.getClass()));
        }
        if ((n2 & 2) != 0) {
            return this.iterate(xPathContext).next();
        }
        Controller controller = xPathContext.getController();
        assert (controller != null);
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        SequenceOutputter sequenceOutputter = controller.allocateSequenceOutputter(1);
        sequenceOutputter.getPipelineConfiguration().setHostLanguage(this.getHostLanguage());
        xPathContext.setReceiver((SequenceReceiver)sequenceOutputter);
        this.process(xPathContext);
        xPathContext.setReceiver(sequenceReceiver);
        sequenceOutputter.close();
        Item item = sequenceOutputter.getFirstItem();
        sequenceOutputter.reset();
        return item;
    }

    public SequenceIterator<? extends Item> iterate(XPathContext xPathContext) throws XPathException {
        int n2 = this.getImplementationMethod();
        if ((n2 & 1) != 0) {
            Item item = this.evaluateItem(xPathContext);
            if (item == null) {
                return EmptyIterator.emptyIterator();
            }
            return SingletonIterator.makeIterator((Item)item);
        }
        if ((n2 & 2) != 0) {
            throw new AssertionError((Object)("iterate() is not implemented in the subclass " + this.getClass()));
        }
        return this.getIteratorFromProcessMethod(xPathContext);
    }

    protected final SequenceIterator<? extends Item> getIteratorFromProcessMethod(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        SequenceOutputter sequenceOutputter = controller.allocateSequenceOutputter(20);
        sequenceOutputter.getPipelineConfiguration().setHostLanguage(this.getHostLanguage());
        xPathContext.setReceiver((SequenceReceiver)sequenceOutputter);
        this.process(xPathContext);
        xPathContext.setReceiver(sequenceReceiver);
        sequenceOutputter.close();
        return sequenceOutputter.iterate();
    }

    public final CharSequence evaluateAsString(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        if (item == null) {
            return "";
        }
        return item.getStringValue();
    }

    public int getConstructType() {
        return this.getInstructionNameCode();
    }

    public boolean isXSLT() {
        return this.getHostLanguage() == 50;
    }
}

