/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DOMAttributeMap
implements NamedNodeMap {
    private NodeInfo parent;
    private int numberOfNamespaces = -1;

    public DOMAttributeMap(NodeInfo nodeInfo) {
        this.parent = nodeInfo;
    }

    @Override
    public Node getNamedItem(String string) {
        NodeInfo nodeInfo;
        if (string.equals("xmlns")) {
            NamespaceBinding[] namespaceBindingArray = this.parent.getDeclaredNamespaces(null);
            for (int i2 = 0; i2 < namespaceBindingArray.length; ++i2) {
                if (namespaceBindingArray[i2] == null) {
                    return null;
                }
                if (namespaceBindingArray[i2].getPrefix().length() != 0) continue;
                NamespaceNode namespaceNode = new NamespaceNode(this.parent, namespaceBindingArray[i2], i2 + 1);
                return NodeOverNodeInfo.wrap((NodeInfo)namespaceNode);
            }
            return null;
        }
        if (string.startsWith("xmlns:")) {
            String string2 = string.substring(6);
            if (string2.equals("xml")) {
                NamespaceNode namespaceNode = new NamespaceNode(this.parent, NamespaceBinding.XML, 0);
                return NodeOverNodeInfo.wrap((NodeInfo)namespaceNode);
            }
            NamespaceBinding[] namespaceBindingArray = new NamespaceBinding[8];
            NamespaceBinding[] namespaceBindingArray2 = this.parent.getDeclaredNamespaces(namespaceBindingArray);
            for (int i3 = 0; i3 < namespaceBindingArray2.length; ++i3) {
                if (namespaceBindingArray2[i3] == null) {
                    return null;
                }
                if (!string2.equals(namespaceBindingArray2[i3].getPrefix())) continue;
                NamespaceNode namespaceNode = new NamespaceNode(this.parent, namespaceBindingArray2[i3], i3 + 1);
                return NodeOverNodeInfo.wrap((NodeInfo)namespaceNode);
            }
            return null;
        }
        AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
        do {
            if ((nodeInfo = axisIterator.next()) != null) continue;
            return null;
        } while (!string.equals(nodeInfo.getDisplayName()));
        return NodeOverNodeInfo.wrap((NodeInfo)nodeInfo);
    }

    @Override
    public Node item(int n2) {
        if (n2 < 0) {
            return null;
        }
        if (n2 == 0) {
            NamespaceNode namespaceNode = new NamespaceNode(this.parent, NamespaceBinding.XML, 0);
            return NodeOverNodeInfo.wrap((NodeInfo)namespaceNode);
        }
        int n3 = this.getNumberOfNamespaces();
        if (n2 < n3) {
            NamespaceBinding[] namespaceBindingArray = new NamespaceBinding[8];
            NamespaceBinding[] namespaceBindingArray2 = this.parent.getDeclaredNamespaces(namespaceBindingArray);
            NamespaceBinding namespaceBinding = namespaceBindingArray2[n2 - 1];
            NamespaceNode namespaceNode = new NamespaceNode(this.parent, namespaceBinding, n2);
            return NodeOverNodeInfo.wrap((NodeInfo)namespaceNode);
        }
        int n4 = 0;
        int n5 = n2 - n3;
        AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
        NodeInfo nodeInfo;
        while ((nodeInfo = axisIterator.next()) != null) {
            if (n4 == n5) {
                return NodeOverNodeInfo.wrap((NodeInfo)nodeInfo);
            }
            ++n4;
        }
        return null;
    }

    private int getNumberOfNamespaces() {
        if (this.numberOfNamespaces == -1) {
            NamespaceBinding[] namespaceBindingArray = new NamespaceBinding[8];
            NamespaceBinding[] namespaceBindingArray2 = this.parent.getDeclaredNamespaces(namespaceBindingArray);
            int n2 = namespaceBindingArray2 != null ? namespaceBindingArray2.length : 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (namespaceBindingArray2[i2] != null) continue;
                n2 = i2;
                break;
            }
            this.numberOfNamespaces = n2 + 1;
        }
        return this.numberOfNamespaces;
    }

    @Override
    public int getLength() {
        int n2 = 0;
        AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
        while (axisIterator.next() != null) {
            ++n2;
        }
        return this.getNumberOfNamespaces() + n2;
    }

    @Override
    public Node getNamedItemNS(String string, String string2) {
        NodeInfo nodeInfo;
        if (string == null) {
            string = "";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return this.getNamedItem("xmlns:" + string2);
        }
        if (string.equals("") && string2.equals("xmlns")) {
            return this.getNamedItem("xmlns");
        }
        AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
        do {
            if ((nodeInfo = axisIterator.next()) != null) continue;
            return null;
        } while (!string.equals(nodeInfo.getURI()) || !string2.equals(nodeInfo.getLocalPart()));
        return NodeOverNodeInfo.wrap((NodeInfo)nodeInfo);
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Node removeNamedItem(String string) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    @Override
    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }
}

