/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.io.util.LEDataOutputStream;
import de.schlichtherle.util.zip.BasicZipOutputStreamTrueZip;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class BasicZipOutputStream
extends BasicZipOutputStreamTrueZip {
    public BasicZipOutputStream(OutputStream outputStream) throws NullPointerException {
        super(outputStream);
    }

    public BasicZipOutputStream(OutputStream outputStream, String string) throws NullPointerException, UnsupportedEncodingException {
        super(outputStream, string);
    }

    @Override
    protected void writeCentralFileHeader(ZipEntry zipEntry) throws IOException {
        assert (zipEntry != null);
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        lEDataOutputStream.writeInt(33639248);
        lEDataOutputStream.writeShort(zipEntry.getPlatform() << 8 | 0x3F);
        lEDataOutputStream.writeShort(zipEntry.getGeneralBit(3) ? 20 : 10);
        lEDataOutputStream.writeShort(zipEntry.getGeneral());
        lEDataOutputStream.writeShort(zipEntry.getMethod());
        lEDataOutputStream.writeInt((int)zipEntry.getDosTime());
        lEDataOutputStream.writeInt((int)zipEntry.getCrc());
        lEDataOutputStream.writeInt((int)zipEntry.getCompressedSize());
        lEDataOutputStream.writeInt((int)zipEntry.getSize());
        byte[] byArray = zipEntry.getName().getBytes(this.charset);
        lEDataOutputStream.writeShort(byArray.length);
        byte[] byArray2 = zipEntry.getExtra();
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        lEDataOutputStream.writeShort(byArray2.length);
        String string = zipEntry.getComment();
        if (string == null) {
            string = "";
        }
        byte[] byArray3 = string.getBytes(this.charset);
        lEDataOutputStream.writeShort(byArray3.length);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(0);
        if (zipEntry.isDirectory()) {
            lEDataOutputStream.writeInt(16);
        } else {
            lEDataOutputStream.writeInt(0);
        }
        lEDataOutputStream.writeInt((int)zipEntry.offset);
        lEDataOutputStream.write(byArray);
        lEDataOutputStream.write(byArray2);
        lEDataOutputStream.write(byArray3);
    }
}

