/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveBusyException;
import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveFileSystem;
import de.schlichtherle.io.ContainsFileException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileBusyException;
import de.schlichtherle.io.IORunnable;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.Streams;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.RfsEntry;
import de.schlichtherle.io.util.Paths;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.log4j.Logger;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.editor.bd;
import ro.sync.exml.m;
import ro.sync.exml.r;
import ro.sync.exml.yb;

final class Files {
    protected static final yb messages = m.e();
    private static final CopyLock copyLock = new CopyLock();
    private static Logger logger = Logger.getLogger((String)Files.class.getName());

    protected Files() {
    }

    public static boolean contains(java.io.File file, java.io.File file2) {
        file = Files.getCanOrAbsFile(file);
        file2 = Files.getCanOrAbsFile(file2);
        return Files.contains(file.getPath(), file2.getPath());
    }

    static boolean contains(String string, String string2) {
        int n2;
        if (File.separatorChar == '\\') {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (!string2.startsWith(string)) {
            return false;
        }
        int n3 = string.length();
        if (n3 == (n2 = string2.length())) {
            return true;
        }
        if (n3 < n2) {
            return string2.charAt(n3) == File.separatorChar;
        }
        return false;
    }

    public static java.io.File getCanOrAbsFile(java.io.File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            java.io.File file2 = file.getParentFile();
            return Files.normalize(file2 != null ? new java.io.File(Files.getCanOrAbsFile(file2), file.getName()) : file.getAbsoluteFile());
        }
    }

    public static java.io.File normalize(java.io.File file) {
        String string = file.getPath();
        String string2 = Paths.normalize((String)string, (char)File.separatorChar);
        return string2 != string ? new java.io.File(string2) : file;
    }

    public static boolean isWritableOrCreatable(java.io.File file) {
        try {
            if (!file.exists()) {
                boolean bl = file.createNewFile();
                boolean bl2 = Files.isWritableOrCreatable(file);
                if (bl && !file.delete()) {
                    bl2 = false;
                }
                return bl2;
            }
            return file.canWrite();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static final boolean mv(java.io.File file, java.io.File file2, ArchiveDetector archiveDetector) {
        return !Files.contains(file, file2) && Files.mv0(file, file2, archiveDetector);
    }

    private static boolean mv0(java.io.File file, java.io.File file2, ArchiveDetector archiveDetector) {
        boolean bl = true;
        if (file.isDirectory()) {
            boolean bl2;
            long l2 = file.lastModified();
            boolean bl3 = file instanceof File && ((File)file).getInnerArchive() != null;
            boolean bl4 = file2 instanceof File && ((File)file2).getInnerArchive() != null;
            boolean bl5 = bl2 = bl3 && l2 <= 0L;
            if (!(bl2 && bl4 && File.isLenient())) {
                file2.mkdir();
            }
            Object[] objectArray = file.list();
            if (!bl3 && bl4) {
                Arrays.sort(objectArray);
            }
            for (Object object : objectArray) {
                bl &= Files.mv0((java.io.File)archiveDetector.createFile(file, (String)object), (java.io.File)archiveDetector.createFile(file2, (String)object), archiveDetector);
            }
            if (!bl2) {
                bl &= file2.setLastModified(l2);
            }
        } else if (file.isFile()) {
            try {
                Files.cp(true, file, file2);
            }
            catch (IOException iOException) {
                String string = messages.b("Errors");
                r.getInstance().addProblemsResults(string, new DocumentPositionedInfo(2, iOException.getMessage()), bd.j, true);
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl && file.delete();
    }

    public static final void cp_r(boolean bl, java.io.File file, java.io.File file2, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) throws IOException {
        if (Files.contains(file, file2)) {
            throw new ContainsFileException(file, file2);
        }
        Files.cp_r0(bl, file, file2, archiveDetector, archiveDetector2);
    }

    private static void cp_r0(boolean bl, java.io.File file, java.io.File file2, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) throws IOException {
        if (file.isDirectory()) {
            boolean bl2;
            long l2 = file.lastModified();
            boolean bl3 = file instanceof File && ((File)file).getInnerArchive() != null;
            boolean bl4 = file2 instanceof File && ((File)file2).getInnerArchive() != null;
            boolean bl5 = bl2 = bl3 && l2 <= 0L;
            if (!(bl2 && bl4 && File.isLenient() || file2.mkdir() || file2.isDirectory())) {
                throw new IOException("destination is not a directory");
            }
            Object[] objectArray = file.list();
            if (!bl3 && bl4) {
                Arrays.sort(objectArray);
            }
            for (Object object : objectArray) {
                Files.cp_r0(bl, (java.io.File)archiveDetector.createFile(file, (String)object), (java.io.File)archiveDetector2.createFile(file2, (String)object), archiveDetector, archiveDetector2);
            }
            if (bl && !bl2 && !file2.setLastModified(l2)) {
                throw new IOException("cannot set last modification time");
            }
        } else if (file.isFile() && (!file2.exists() || file2.isFile())) {
            Files.cp0(bl, file, file2);
        } else {
            throw new IOException("cannot copy non-existent or special files");
        }
    }

    public static final void cp(boolean bl, java.io.File file, java.io.File file2) throws IOException {
        if (Files.contains(file, file2)) {
            throw new ContainsFileException(file, file2);
        }
        Files.cp0(bl, file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(boolean bl, java.io.File file, java.io.File file2) throws IOException {
        assert (file != null);
        assert (file2 != null);
        try {
            Object object;
            try {
                if (file instanceof File) {
                    object = (File)file;
                    object.ensureNotVirtualRoot("cannot read");
                    String string = object.getEnclEntryName();
                    if (string != null) {
                        Files.cp0(bl, object.getEnclArchive().getArchiveController(), string, file2);
                        return;
                    }
                }
            }
            catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
                // empty catch block
            }
            object = new FileInputStream(file);
            try {
                Files.cp0(bl, file, (InputStream)object, file2);
            }
            finally {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    throw new InputIOException(iOException);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (ArchiveBusyException archiveBusyException) {
            throw new FileBusyException(archiveBusyException);
        }
        catch (ArchiveFileSystem.ArchiveFileSystemException archiveFileSystemException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(archiveFileSystemException.toString());
            fileNotFoundException.initCause(archiveFileSystemException);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            file2.delete();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(boolean bl, java.io.File file, InputStream inputStream, java.io.File file2) throws IOException {
        Object object;
        try {
            if (file2 instanceof File) {
                object = (File)file2;
                object.ensureNotVirtualRoot("cannot write");
                String string = object.getEnclEntryName();
                if (string != null) {
                    Files.cp0(bl, file, inputStream, object.getEnclArchive().getArchiveController(), string);
                    return;
                }
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        object = new FileOutputStream(file2);
        try {
            Streams.cat((InputStream)inputStream, (OutputStream)object);
        }
        finally {
            ((OutputStream)object).close();
        }
        if (bl && !file2.setLastModified(file.lastModified())) {
            throw new IOException(file2.getPath() + " (cannot preserve last modification time)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(boolean bl, ArchiveController archiveController, String string, java.io.File file) throws IOException {
        try {
            FileOutputStream fileOutputStream;
            long l2;
            Object object;
            block15: {
                try {
                    if (file instanceof File) {
                        object = (File)file;
                        object.ensureNotVirtualRoot("cannot write");
                        String string2 = object.getEnclEntryName();
                        if (string2 != null) {
                            Files.cp0(bl, archiveController, string, object.getEnclArchive().getArchiveController(), string2);
                            return;
                        }
                    }
                }
                catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
                    if (rfsEntryFalsePositiveException.getController() != archiveController) break block15;
                    throw rfsEntryFalsePositiveException;
                }
            }
            archiveController.readLock().lock();
            try {
                object = archiveController.createInputStream0(string);
                l2 = archiveController.lastModified(string);
            }
            finally {
                archiveController.readLock().unlock();
            }
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException2) {
                    throw new InputIOException(iOException2);
                }
                throw iOException;
            }
            Files.cp((InputStream)object, fileOutputStream);
            if (bl && !file.setLastModified(l2)) {
                throw new IOException(file.getPath() + " (cannot preserve last modification time)");
            }
        }
        catch (ArchiveController.ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            assert (archiveController == archiveEntryFalsePositiveException.getController());
            Files.cp0(bl, archiveController.getEnclController(), archiveController.enclEntryName(string), file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(final boolean bl, final ArchiveController archiveController, final String string, final ArchiveController archiveController2, final String string2) throws IOException {
        try {
            class IOStreamCreator
            implements IORunnable {
                InputStream in;
                OutputStream out;

                IOStreamCreator() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    ArchiveEntry archiveEntry;
                    ArchiveFileSystem.Delta delta;
                    ArchiveEntry archiveEntry2;
                    class SrcControllerUpdater
                    implements IORunnable {
                        SrcControllerUpdater() {
                        }

                        public void run() throws IOException {
                            archiveController.autoUmount(string);
                            archiveController.readLock().lock();
                        }
                    }
                    archiveController.runWriteLocked((IORunnable)new SrcControllerUpdater());
                    try {
                        archiveController2.autoUmount(string2);
                        ArchiveFileSystem archiveFileSystem = archiveController.autoMount(false);
                        archiveEntry2 = archiveFileSystem.get(string);
                        boolean bl2 = File.isLenient();
                        ArchiveFileSystem archiveFileSystem2 = archiveController2.autoMount(bl2);
                        delta = archiveFileSystem2.link(string2, bl2, (ArchiveEntry)(bl ? archiveEntry2 : null));
                        archiveEntry = delta.getEntry();
                        this.in = archiveController.createInputStream(archiveEntry2, archiveEntry);
                    }
                    finally {
                        archiveController.readLock().unlock();
                    }
                    try {
                        this.out = archiveController2.createOutputStream(archiveEntry, archiveEntry2);
                        try {
                            delta.commit();
                        }
                        catch (IOException iOException) {
                            this.out.close();
                            throw iOException;
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            this.in.close();
                        }
                        catch (IOException iOException2) {
                            throw new InputIOException(iOException2);
                        }
                        throw iOException;
                    }
                }
            }
            IOStreamCreator iOStreamCreator = new IOStreamCreator();
            CopyLock copyLock = Files.copyLock;
            synchronized (copyLock) {
                archiveController2.runWriteLocked((IORunnable)iOStreamCreator);
            }
            Files.cp(iOStreamCreator.in, iOStreamCreator.out);
        }
        catch (ArchiveController.ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            if (archiveController2 != archiveEntryFalsePositiveException.getController()) {
                throw archiveEntryFalsePositiveException;
            }
            Files.cp0(bl, archiveController, string, archiveController2.getEnclController(), archiveController2.enclEntryName(string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void cp0(final boolean bl, final java.io.File file, InputStream inputStream, final ArchiveController archiveController, final String string) throws IOException {
        try {
            class OStreamCreator
            implements IORunnable {
                OutputStream out;

                OStreamCreator() {
                }

                public void run() throws IOException {
                    archiveController.autoUmount(string);
                    boolean bl2 = File.isLenient();
                    RfsEntry rfsEntry = new RfsEntry(file);
                    ArchiveFileSystem archiveFileSystem = archiveController.autoMount(bl2);
                    ArchiveFileSystem.Delta delta = archiveFileSystem.link(string, bl2, (ArchiveEntry)(bl ? rfsEntry : null));
                    ArchiveEntry archiveEntry = delta.getEntry();
                    this.out = archiveController.createOutputStream(archiveEntry, (ArchiveEntry)rfsEntry);
                    delta.commit();
                }
            }
            OStreamCreator oStreamCreator = new OStreamCreator();
            archiveController.runWriteLocked((IORunnable)oStreamCreator);
            OutputStream outputStream = oStreamCreator.out;
            try {
                Streams.cat((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        catch (ArchiveController.ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            assert (archiveController == archiveEntryFalsePositiveException.getController());
            Files.cp0(bl, file, inputStream, archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cp(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            try {
                Streams.cat((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new InputIOException(iOException);
            }
        }
    }

    public static boolean rm_r(java.io.File file) {
        boolean bl = true;
        if (file.isDirectory()) {
            java.io.File[] fileArray = file.listFiles();
            int n2 = fileArray.length;
            while (--n2 >= 0) {
                bl &= Files.rm_r(fileArray[n2]);
            }
        }
        return bl && file.delete();
    }

    private static class CopyLock {
        private CopyLock() {
        }
    }
}

