/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.EmptyPattern;
import com.thaiopensource.relaxng.pattern.ErrorPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NotAllowedPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import ro.sync.contentcompletion.xml.CIValue;
import ro.sync.xml.ProxyNamespaceMapping;

public class OxygenContentCompletionValuesExtractor
implements PatternFunction<VoidValue> {
    private final Vector patternList = new Vector();
    private final Hashtable patternTable = new Hashtable();
    List values = new ArrayList();
    boolean isListValue = false;
    boolean anyURIDetected = false;
    boolean anyURIListDetected = false;
    boolean entityRefDetected = false;
    private final ProxyNamespaceMapping proxyNamespaceMapping;

    public OxygenContentCompletionValuesExtractor(ProxyNamespaceMapping proxyNamespaceMapping) {
        this.proxyNamespaceMapping = proxyNamespaceMapping;
    }

    public List getValues() {
        return this.values;
    }

    public boolean isAnyURIDetected() {
        return this.anyURIDetected;
    }

    public boolean isEntityRefDetected() {
        return this.entityRefDetected;
    }

    public boolean isAnyURIListDetected() {
        return this.anyURIListDetected;
    }

    private String getName(Pattern pattern) {
        String string = (String)this.patternTable.get(pattern);
        if (string == null) {
            string = "p" + this.patternList.size();
            this.patternList.addElement(pattern);
            this.patternTable.put(pattern, string);
        }
        return string;
    }

    public void parsePattern(Pattern pattern) {
        this.values.clear();
        pattern.apply((PatternFunction)this);
        for (int i2 = 0; i2 < this.patternList.size(); ++i2) {
            Pattern pattern2 = (Pattern)this.patternList.elementAt(i2);
            this.getName(pattern2);
            pattern2.apply((PatternFunction)this);
        }
    }

    public VoidValue caseError(ErrorPattern errorPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseEmpty(EmptyPattern emptyPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseNotAllowed(NotAllowedPattern notAllowedPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseGroup(GroupPattern groupPattern) {
        groupPattern.getOperand1().apply((PatternFunction)this);
        groupPattern.getOperand2().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseInterleave(InterleavePattern interleavePattern) {
        interleavePattern.getOperand1().apply((PatternFunction)this);
        interleavePattern.getOperand2().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseChoice(ChoicePattern choicePattern) {
        choicePattern.getOperand1().apply((PatternFunction)this);
        choicePattern.getOperand2().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        oneOrMorePattern.getOperand().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseElement(ElementPattern elementPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseAttribute(AttributePattern attributePattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseData(DataPattern dataPattern) {
        if (dataPattern.getDatatype().getClass().getName().endsWith(".AnyUriDatatype")) {
            this.anyURIDetected = true;
            this.anyURIListDetected = this.anyURIListDetected || this.isListValue;
        } else if (dataPattern.getDatatype().getClass().getName().endsWith(".EntityDatatype")) {
            this.entityRefDetected = true;
        } else if (dataPattern.getDatatype().getClass().getName().endsWith(".BooleanDatatype")) {
            CIValue cIValue = new CIValue("true");
            CIValue cIValue2 = new CIValue("false");
            if (this.isListValue) {
                cIValue.setListValue();
                cIValue2.setListValue();
            }
            if (!this.values.contains(cIValue)) {
                this.values.add(cIValue);
            }
            if (!this.values.contains(cIValue2)) {
                this.values.add(cIValue2);
            }
        }
        return VoidValue.VOID;
    }

    public VoidValue caseDataExcept(DataExceptPattern dataExceptPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseValue(ValuePattern valuePattern) {
        CIValue cIValue = null;
        if (valuePattern.getValue() instanceof Name) {
            Name name = (Name)valuePattern.getValue();
            String string = this.proxyNamespaceMapping.getPrefixForNamespace(name.getNamespaceUri());
            if (string != null) {
                cIValue = new CIValue(string.length() == 0 ? name.getLocalName() : string + ":" + name.getLocalName());
            }
        } else {
            cIValue = new CIValue(valuePattern.getValue().toString());
        }
        if (cIValue != null) {
            if (this.isListValue) {
                cIValue.setListValue();
            }
            if (!this.values.contains(cIValue)) {
                this.values.add(cIValue);
            }
        }
        return VoidValue.VOID;
    }

    public VoidValue caseText(TextPattern textPattern) {
        return VoidValue.VOID;
    }

    public VoidValue caseList(ListPattern listPattern) {
        boolean bl = this.isListValue;
        this.isListValue = true;
        listPattern.getOperand().apply((PatternFunction)this);
        this.isListValue = bl;
        return VoidValue.VOID;
    }

    public VoidValue caseAfter(AfterPattern afterPattern) {
        afterPattern.getOperand1().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseRef(RefPattern refPattern) {
        refPattern.getPattern().apply((PatternFunction)this);
        return VoidValue.VOID;
    }
}

