/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.IdTypeMap;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.xml.util.Name;
import com.thaiopensource.xml.util.StringSplitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ro.sync.exml.m.c.i;
import ro.sync.exml.m.c.l;
import ro.sync.xml.parser.IDValue;
import ro.sync.xml.parser.b;

public class IdSoundnessChecker {
    private final IdTypeMap idTypeMap;
    private final ErrorHandler eh;
    private final Map<String, Entry> map = new HashMap<String, Entry>();
    private List<IDValue> idValues;
    private b annotationsExtractor = new b();
    private List<IDValue> currentElementIDValues = null;

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler errorHandler, List<IDValue> list) {
        this.idTypeMap = idTypeMap;
        this.eh = errorHandler;
        this.idValues = list;
    }

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler errorHandler) {
        this.idTypeMap = idTypeMap;
        this.eh = errorHandler;
    }

    public void reset() {
        this.map.clear();
        this.currentElementIDValues = null;
    }

    public void endDocument() throws SAXException {
        for (String string : this.map.keySet()) {
            Entry entry = this.map.get(string);
            if (entry.hadId) continue;
            for (l l2 : entry.idrefLocs) {
                this.error("missing_id", string, l2, l2.b());
            }
        }
    }

    public void attribute(Name name, Name name2, String string, String string2, Locator locator) throws SAXException {
        int n2 = this.idTypeMap.getIdType(name, name2);
        if (n2 != 0) {
            String[] stringArray = StringSplitter.split((String)string2);
            switch (n2) {
                case 1: {
                    if (stringArray.length == 1) {
                        this.id(stringArray[0], locator, string);
                        break;
                    }
                    if (stringArray.length == 0) {
                        this.error("id_no_tokens", locator, string);
                        break;
                    }
                    this.error("id_multiple_tokens", locator, string);
                    break;
                }
                case 2: {
                    if (stringArray.length == 1) {
                        this.idref(stringArray[0], locator, string);
                        break;
                    }
                    if (stringArray.length == 0) {
                        this.error("idref_no_tokens", locator, string);
                        break;
                    }
                    this.error("idref_multiple_tokens", locator, string);
                    break;
                }
                case 3: {
                    if (stringArray.length > 0) {
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            this.idref(stringArray[i2], locator, string);
                        }
                        break;
                    }
                    this.error("idrefs_no_tokens", locator, string);
                }
            }
        }
    }

    private void id(String string, Locator locator, String string2) throws SAXException {
        Entry entry;
        if (this.idValues != null) {
            if (this.currentElementIDValues == null) {
                this.currentElementIDValues = new ArrayList<IDValue>(1);
            }
            this.currentElementIDValues.add(new IDValue(string, locator != null ? locator.getSystemId() : null));
        }
        if ((entry = this.map.get(string)) == null) {
            entry = new Entry();
            this.map.put(string, entry);
        } else if (entry.hadId) {
            this.error("duplicate_id", string, locator, string2);
            this.error("first_id", string, entry.idLoc, string2);
            return;
        }
        entry.idLoc = new l(locator, string2);
        entry.hadId = true;
    }

    private void idref(String string, Locator locator, String string2) {
        Entry entry = this.map.get(string);
        if (entry == null) {
            entry = new Entry();
            this.map.put(string, entry);
        }
        if (entry.hadId) {
            return;
        }
        if (entry.idrefLocs == null) {
            entry.idrefLocs = new ArrayList<l>();
        }
        entry.idrefLocs.add(new l(locator, string2));
    }

    private void error(String string, Locator locator, String string2) throws SAXException {
        this.eh.error(new i(new SAXParseException(SchemaBuilderImpl.localizer.message(string), locator), string, new String[]{string2}));
    }

    private void error(String string, String string2, Locator locator, String string3) throws SAXException {
        this.eh.error(new i(new SAXParseException(SchemaBuilderImpl.localizer.message(string, (Object)string2), locator), string, new String[]{string3}));
    }

    public void characters(char[] cArray, int n2, int n3) {
        this.annotationsExtractor.c(cArray, n2, n3);
    }

    public void endElement() {
        this.annotationsExtractor.b();
    }

    public void startElement() {
        this.currentElementIDValues = null;
    }

    public void startElementFinished() {
        this.annotationsExtractor.d(this.currentElementIDValues);
        if (this.currentElementIDValues != null && this.idValues != null) {
            this.idValues.addAll(this.currentElementIDValues);
        }
    }

    private static class Entry {
        l idLoc;
        List<l> idrefLocs;
        boolean hadId;

        private Entry() {
        }
    }
}

