/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.Emitter;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentHandlerProxySaxon
extends Emitter
implements Locator {
    protected ContentHandler handler;
    protected LexicalHandler lexicalHandler;
    protected Locator locator = this;
    private int depth = 0;
    protected boolean requireWellFormed = true;

    public void setUnderlyingContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setRequireWellFormed(boolean bl) {
        this.requireWellFormed = bl;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws TransformerException {
        if (this.handler == null) {
            throw new TransformerException("ContentHandlerProxy.startDocument(): no underlying handler provided");
        }
        try {
            this.handler.setDocumentLocator(this.locator);
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        this.depth = 0;
    }

    public void endDocument() throws TransformerException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void startElement(int n2, Attributes attributes, int[] nArray, int n3) throws TransformerException {
        ++this.depth;
        try {
            if (this.depth <= 0 && this.requireWellFormed) {
                this.notifyNotWellFormed();
            }
            if (this.depth > 0 || !this.requireWellFormed) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    String string = this.namePool.getPrefixFromNamespaceCode(nArray[i2]);
                    String string2 = this.namePool.getURIFromNamespaceCode(nArray[i2]);
                    this.handler.startPrefixMapping(string, string2);
                }
                this.handler.startElement(this.namePool.getURI(n2), this.namePool.getLocalName(n2), this.namePool.getDisplayName(n2), attributes);
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void endElement(int n2) throws TransformerException {
        if (this.depth > 0) {
            try {
                this.handler.endElement(this.namePool.getURI(n2), this.namePool.getLocalName(n2), this.namePool.getDisplayName(n2));
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
        }
        --this.depth;
        if (this.requireWellFormed && this.depth <= 0) {
            this.depth = Integer.MIN_VALUE;
        }
    }

    public void characters(char[] cArray, int n2, int n3) throws TransformerException {
        try {
            if (this.depth <= 0 && this.requireWellFormed) {
                boolean bl;
                boolean bl2 = bl = new String(cArray, n2, n3).trim().length() == 0;
                if (!bl) {
                    this.notifyNotWellFormed();
                    if (!this.requireWellFormed) {
                        this.handler.characters(cArray, n2, n3);
                    }
                }
            } else {
                this.handler.characters(cArray, n2, n3);
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    protected void notifyNotWellFormed() throws SAXException {
        try {
            this.handler.processingInstruction("saxon:warning", "Output suppressed because it is not well-formed");
        }
        catch (SAXException sAXException) {
            if (sAXException.getMessage().equals("continue")) {
                this.requireWellFormed = false;
            }
            throw sAXException;
        }
    }

    public void processingInstruction(String string, String string2) throws TransformerException {
        try {
            this.handler.processingInstruction(string, string2);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void comment(char[] cArray, int n2, int n3) throws TransformerException {
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(cArray, n2, n3);
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void setEscaping(boolean bl) {
        try {
            this.handler.processingInstruction(bl ? "javax.xml.transform.enable-output-escaping" : "javax.xml.transform.disable-output-escaping", "");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }
}

