/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ZipEntry
implements Cloneable {
    private static final byte NAME = 0;
    private static final byte PLATFORM = 1;
    private static final byte GENERAL = 2;
    private static final byte METHOD = 3;
    private static final byte DOS_TIME = 4;
    private static final byte CRC = 5;
    private static final byte CSIZE = 6;
    private static final byte SIZE = 7;
    public static final byte UNKNOWN = -1;
    public static final short PLATFORM_FAT = 0;
    public static final short PLATFORM_UNIX = 3;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    public static final long MIN_DOS_TIME = 0x210000L;
    private byte init;
    private String name;
    private byte platform = (byte)-1;
    private short general = (short)-1;
    private short method = (short)-1;
    private int dosTime = -1;
    private int crc = -1;
    private int csize = -1;
    private int size = -1;
    private byte[] extra;
    private String comment;
    long offset = -1L;
    private static final ThreadLocal calendar;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipEntry(String string) {
        this.setName0(string);
    }

    public ZipEntry(ZipEntry zipEntry) {
        this.init = zipEntry.init;
        this.name = zipEntry.name;
        this.platform = zipEntry.platform;
        this.general = zipEntry.general;
        this.method = zipEntry.method;
        this.dosTime = zipEntry.dosTime;
        this.crc = zipEntry.crc;
        this.csize = zipEntry.csize;
        this.size = zipEntry.size;
        this.extra = zipEntry.extra;
        this.comment = zipEntry.comment;
        this.offset = zipEntry.offset;
        this.setInit((byte)0, false);
    }

    public Object clone() {
        try {
            ZipEntry zipEntry = (ZipEntry)super.clone();
            zipEntry.setInit((byte)0, false);
            return zipEntry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    private final boolean isInit(byte by) {
        if (!($assertionsDisabled || 0 <= by && by < 8)) {
            throw new AssertionError((Object)("bit index out of range" + by));
        }
        return (this.init & 1 << by) != 0;
    }

    private final void setInit(byte by, boolean bl) {
        if (!($assertionsDisabled || 0 <= by && by < 8)) {
            throw new AssertionError((Object)("bit index out of range" + by));
        }
        this.init = bl ? (byte)(this.init | 1 << by) : (byte)(this.init & ~(1 << by));
    }

    public String getName() {
        return this.name;
    }

    final int getNameLength(String string) throws UnsupportedEncodingException {
        return this.name != null ? this.name.getBytes(string).length : 0;
    }

    protected void setName(String string) {
        this.setName0(string);
    }

    private void setName0(String string) {
        if (this.isInit((byte)0)) {
            throw new IllegalStateException("name has already been set");
        }
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
        if (string.length() > 65535) {
            throw new IllegalArgumentException("name too long");
        }
        this.setInit((byte)0, true);
        this.name = string;
    }

    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public short getPlatform() {
        return this.isInit((byte)1) ? (short)(this.platform & 0xFF) : (short)-1;
    }

    public void setPlatform(short s) {
        if (s < -1 || 255 < s) {
            throw new IllegalArgumentException(this.name + ": invalid platform: " + s);
        }
        this.setInit((byte)1, s != -1);
        this.platform = (byte)s;
    }

    int getGeneral() {
        return this.isInit((byte)2) ? this.general & 0xFFFF : -1;
    }

    void setGeneral(int n) {
        if (n < -1 || 65535 < n) {
            throw new IllegalArgumentException(this.name + ": invalid general purpose bit flag: " + n);
        }
        this.setInit((byte)2, n != -1);
        this.general = (short)n;
    }

    final boolean getGeneralBit(int n) {
        if (!this.isInit((byte)2)) {
            throw new IllegalStateException(this.name + ": general purpose bit flag not initialized");
        }
        if (n < 0 || 15 < n) {
            throw new IllegalArgumentException(this.name + ": general purpose bit index out of range: " + n);
        }
        return (this.general & 1 << n) != 0;
    }

    final void setGeneralBit(int n, boolean bl) {
        if (n < 0 || 15 < n) {
            throw new IllegalArgumentException(this.name + ": general purpose bit index out of range: " + n);
        }
        this.setInit((byte)2, true);
        this.general = bl ? (short)(this.general | 1 << n) : (short)(this.general & ~(1 << n));
    }

    public int getMethod() {
        return this.isInit((byte)3) ? this.method & 0xFFFF : -1;
    }

    public void setMethod(int n) {
        if (n < -1 || 65535 < n) {
            throw new IllegalArgumentException(this.name + ": invalid compression method: " + n);
        }
        this.setInit((byte)3, n != -1);
        this.method = (short)n;
    }

    protected long getDosTime() {
        return this.isInit((byte)4) ? (long)this.dosTime & 0xFFFFFFFFL : -1L;
    }

    protected void setDosTime(long l) {
        if (l < -1L || 0xFFFFFFFFL < l) {
            throw new IllegalArgumentException(this.name + ": invalid DOS date/time field value: " + l);
        }
        this.setInit((byte)4, l != -1L);
        this.dosTime = (int)l;
    }

    public long getTime() {
        return this.isInit((byte)4) ? ZipEntry.dos2javaTime((long)this.dosTime & 0xFFFFFFFFL) : -1L;
    }

    public void setTime(long l) {
        this.setDosTime(l != -1L ? ZipEntry.java2dosTime(l) : -1L);
    }

    public long getCrc() {
        return this.isInit((byte)5) ? (long)this.crc & 0xFFFFFFFFL : -1L;
    }

    public void setCrc(long l) {
        if (l < -1L || 0xFFFFFFFFL < l) {
            throw new IllegalArgumentException(this.name + ": invalid CRC-32: " + l);
        }
        this.setInit((byte)5, l != -1L);
        this.crc = (int)l;
    }

    public long getCompressedSize() {
        return this.isInit((byte)6) ? (long)this.csize & 0xFFFFFFFFL : -1L;
    }

    public void setCompressedSize(long l) {
        if (l < -1L || 0xFFFFFFFFL < l) {
            throw new IllegalArgumentException(this.name + ": invalid compressed size: " + l);
        }
        this.setInit((byte)6, l != -1L);
        this.csize = (int)l;
    }

    public long getSize() {
        return this.isInit((byte)7) ? (long)this.size & 0xFFFFFFFFL : -1L;
    }

    public void setSize(long l) {
        if (l < -1L || 0xFFFFFFFFL < l) {
            throw new IllegalArgumentException(this.name + ": invalid size: " + l);
        }
        this.setInit((byte)7, l != -1L);
        this.size = (int)l;
    }

    public byte[] getExtra() {
        return this.extra != null ? (byte[])this.extra.clone() : null;
    }

    final int getExtraLength() {
        return this.extra != null ? this.extra.length : 0;
    }

    public void setExtra(byte[] byArray) {
        if (byArray != null && 65535 < byArray.length) {
            throw new IllegalArgumentException(this.name + ": extra field length too long: " + byArray.length);
        }
        this.extra = byArray != null ? (byte[])byArray.clone() : null;
    }

    public String getComment() {
        return this.comment;
    }

    final int getCommentLength(String string) throws UnsupportedEncodingException {
        return this.comment != null ? this.comment.getBytes(string).length : 0;
    }

    public void setComment(String string) {
        if (string != null && 65535 < string.length()) {
            throw new IllegalArgumentException(this.name + ": comment length too long: " + string.length());
        }
        this.comment = string;
    }

    public String toString() {
        return this.getName();
    }

    protected static long dos2javaTime(long l) {
        if (l < 0L || 0xFFFFFFFFL < l) {
            throw new IllegalArgumentException("invalid DOS date/time field value: " + l);
        }
        int n = (int)l;
        Calendar calendar = (Calendar)ZipEntry.calendar.get();
        calendar.set(1, (n >> 25 & 0xFF) + 1980);
        calendar.set(2, (n >> 21 & 0xF) - 1);
        calendar.set(5, n >> 16 & 0x1F);
        calendar.set(11, n >> 11 & 0x1F);
        calendar.set(12, n >> 5 & 0x3F);
        calendar.set(13, n << 1 & 0x3E);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    protected static long java2dosTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid modification time: " + l);
        }
        Calendar calendar = (Calendar)ZipEntry.calendar.get();
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        if (n < 1980) {
            return 0x210000L;
        }
        long l2 = (n - 1980 & 0xFF) << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
        if (!$assertionsDisabled && l2 < 0x210000L) {
            throw new AssertionError();
        }
        return l2;
    }

    static {
        $assertionsDisabled = !ZipEntry.class.desiredAssertionStatus();
        calendar = new ThreadLocal(){

            protected Object initialValue() {
                return new GregorianCalendar();
            }
        };
    }
}

