/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.io.rof.BufferedReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import de.schlichtherle.util.zip.CRC32Exception;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class BasicZipFile {
    private static final long LONG_MSB = Long.MIN_VALUE;
    private static final int LFH_FILE_NAME_LENGTH_OFFSET = 26;
    private static final int EOCD_NUM_ENTRIES_OFFSET = 10;
    private static final int EOCD_CD_SIZE_OFFSET = 12;
    private static final int EOCD_CD_LOCATION_OFFSET = 16;
    private static final int EOCD_COMMENT_OFFSET = 20;
    private static final Set allocatedInflaters;
    private static final List releasedInflaters;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final String charset;
    private String comment;
    private final Map entries = new LinkedHashMap();
    private ReadOnlyFile archive;
    private int openStreams;
    private long preamble;
    private long postamble;
    private OffsetMapper mapper;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicZipFile(String string) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.charset = DEFAULT_CHARSET;
        try {
            this.init(null, new File(string), true, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public BasicZipFile(String string, String string2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = string2;
        this.init(null, new File(string), true, false);
    }

    public BasicZipFile(String string, String string2, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = string2;
        this.init(null, new File(string), bl, bl2);
    }

    public BasicZipFile(File file) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.charset = DEFAULT_CHARSET;
        try {
            this.init(null, file, true, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public BasicZipFile(File file, String string) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = string;
        this.init(null, file, true, false);
    }

    public BasicZipFile(File file, String string, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = string;
        this.init(null, file, bl, bl2);
    }

    public BasicZipFile(ReadOnlyFile readOnlyFile) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.charset = DEFAULT_CHARSET;
        try {
            this.init(readOnlyFile, null, true, false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public BasicZipFile(ReadOnlyFile readOnlyFile, String string) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = string;
        this.init(readOnlyFile, null, true, false);
    }

    public BasicZipFile(ReadOnlyFile readOnlyFile, String string, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = string;
        this.init(readOnlyFile, null, bl, bl2);
    }

    private void init(ReadOnlyFile readOnlyFile, File file, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        if (this.charset == null) {
            throw new NullPointerException("charset");
        }
        new String(new byte[0], this.charset);
        if (readOnlyFile == null) {
            if (file == null) {
                throw new NullPointerException();
            }
            readOnlyFile = this.createReadOnlyFile(file);
        } else if (!$assertionsDisabled && file != null) {
            throw new AssertionError();
        }
        this.archive = readOnlyFile;
        try {
            BufferedReadOnlyFile bufferedReadOnlyFile = this.archive instanceof BufferedReadOnlyFile ? (BufferedReadOnlyFile)this.archive : new BufferedReadOnlyFile(this.archive);
            this.mountCentralDirectory(bufferedReadOnlyFile, bl, bl2);
        }
        catch (IOException iOException) {
            if (file != null) {
                readOnlyFile.close();
            }
            throw iOException;
        }
        if (!$assertionsDisabled && this.mapper == null) {
            throw new AssertionError();
        }
    }

    protected ReadOnlyFile createReadOnlyFile(File file) throws FileNotFoundException, IOException {
        return new SimpleReadOnlyFile(file);
    }

    private void mountCentralDirectory(ReadOnlyFile readOnlyFile, boolean bl, boolean bl2) throws ZipException, IOException {
        int n = this.findCentralDirectory(readOnlyFile, bl, bl2);
        if (!$assertionsDisabled && this.mapper == null) {
            throw new AssertionError();
        }
        this.preamble = Long.MAX_VALUE;
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[46 - byArray.length];
        while (true) {
            readOnlyFile.readFully(byArray);
            if (BasicZipFile.readUInt(byArray, 0) != 33639248L) break;
            readOnlyFile.readFully(byArray2);
            int n2 = BasicZipFile.readUShort(byArray2, 4);
            int n3 = BasicZipFile.readUShort(byArray2, 24);
            byte[] byArray3 = new byte[n3];
            readOnlyFile.readFully(byArray3);
            boolean bl3 = (n2 & 0x800) != 0;
            String string = bl3 ? DEFAULT_CHARSET : this.charset;
            ZipEntry zipEntry = this.createZipEntry(new String(byArray3, string));
            try {
                byte[] byArray4;
                int n4 = 0;
                int n5 = BasicZipFile.readUShort(byArray2, n4);
                n4 += 2;
                zipEntry.setPlatform((short)(n5 >> 8));
                n4 += 2;
                zipEntry.setGeneral(n2);
                n4 += 2;
                if (!$assertionsDisabled && zipEntry.getGeneralBit(11) != bl3) {
                    throw new AssertionError();
                }
                int n6 = BasicZipFile.readUShort(byArray2, n4);
                n4 += 2;
                if (n6 != 0 && n6 != 8) {
                    throw new ZipException(zipEntry.getName() + ": unsupported compression method: " + n6);
                }
                zipEntry.setMethod(n6);
                zipEntry.setDosTime(BasicZipFile.readUInt(byArray2, n4));
                zipEntry.setCrc(BasicZipFile.readUInt(byArray2, n4 += 4));
                zipEntry.setCompressedSize(BasicZipFile.readUInt(byArray2, n4 += 4));
                zipEntry.setSize(BasicZipFile.readUInt(byArray2, n4 += 4));
                n4 += 4;
                int n7 = BasicZipFile.readUShort(byArray2, n4 += 2);
                int n8 = BasicZipFile.readUShort(byArray2, n4 += 2);
                n4 += 2;
                n4 += 2;
                n4 += 2;
                long l = this.mapper.location(BasicZipFile.readUInt(byArray2, n4 += 4));
                zipEntry.offset = l | Long.MIN_VALUE;
                if (l < this.preamble) {
                    this.preamble = l;
                }
                if (n7 > 0) {
                    byArray4 = new byte[n7];
                    readOnlyFile.readFully(byArray4);
                    zipEntry.setExtra(byArray4);
                }
                if (n8 > 0) {
                    byArray4 = new byte[n8];
                    readOnlyFile.readFully(byArray4);
                    zipEntry.setComment(new String(byArray4, string));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ZipException zipException = new ZipException(zipEntry.getName());
                zipException.initCause(illegalArgumentException);
                throw zipException;
            }
            this.entries.put(zipEntry.getName(), zipEntry);
            --n;
        }
        if (n % 65536 != 0) {
            throw new ZipException("expected " + Math.abs(n) + (n > 0 ? " more" : " less") + " entries in the Central Directory");
        }
        if (this.preamble == Long.MAX_VALUE) {
            this.preamble = 0L;
        }
    }

    private int findCentralDirectory(ReadOnlyFile readOnlyFile, boolean bl, boolean bl2) throws ZipException, IOException {
        long l;
        byte[] byArray = new byte[4];
        if (!bl) {
            readOnlyFile.seek(0L);
            readOnlyFile.readFully(byArray);
            l = BasicZipFile.readUInt(byArray, 0);
            boolean bl3 = bl = l == 67324752L || l == 101010256L;
        }
        if (bl) {
            l = readOnlyFile.length();
            long l2 = l - 22L;
            long l3 = !bl2 && l2 >= 65535L ? l2 - 65535L : 0L;
            for (long i = l2; i >= l3; --i) {
                readOnlyFile.seek(i);
                readOnlyFile.readFully(byArray);
                if (BasicZipFile.readUInt(byArray, 0) != 101010256L) continue;
                byte[] byArray2 = new byte[22 - byArray.length];
                readOnlyFile.readFully(byArray2);
                int n = BasicZipFile.readUShort(byArray2, 10 - byArray.length);
                long l4 = BasicZipFile.readUInt(byArray2, 12 - byArray.length);
                long l5 = BasicZipFile.readUInt(byArray2, 16 - byArray.length);
                int n2 = BasicZipFile.readUShort(byArray2, 20 - byArray.length);
                if (n2 > 0) {
                    byte[] byArray3 = new byte[n2];
                    readOnlyFile.readFully(byArray3);
                    this.setComment(new String(byArray3, this.charset));
                }
                this.postamble = l - readOnlyFile.getFilePointer();
                long l6 = i - l4;
                readOnlyFile.seek(l6);
                this.mapper = (l6 -= l5) != 0L ? new IrregularOffsetMapper(l6) : new OffsetMapper();
                return n;
            }
        }
        throw new ZipException("expected End Of Central Directory signature");
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }

    public String getComment() {
        return this.comment;
    }

    private void setComment(String string) {
        this.comment = string;
    }

    public boolean busy() {
        return this.openStreams > 0;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getEncoding() {
        return this.getCharset();
    }

    public Enumeration entries() {
        return Collections.enumeration(this.entries.values());
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.entries.get(string);
    }

    public int size() {
        return this.entries.size();
    }

    public long length() throws IOException {
        this.ensureOpen();
        return this.archive.length();
    }

    public long getPreambleLength() {
        return this.preamble;
    }

    public InputStream getPreambleInputStream() throws IOException {
        this.ensureOpen();
        return new IntervalInputStream(0L, this.preamble);
    }

    public long getPostambleLength() {
        return this.postamble;
    }

    public InputStream getPostambleInputStream() throws IOException {
        this.ensureOpen();
        return new IntervalInputStream(this.archive.length() - this.postamble, this.postamble);
    }

    public boolean offsetsConsiderPreamble() {
        if (!$assertionsDisabled && this.mapper == null) {
            throw new AssertionError();
        }
        return this.mapper.location(0L) == 0L;
    }

    public final InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, false, true);
    }

    public final InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.getName(), false, true);
    }

    public final InputStream getCheckedInputStream(String string) throws IOException {
        return this.getInputStream(string, true, true);
    }

    public final InputStream getCheckedInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.getName(), true, true);
    }

    public InputStream getInputStream(String string, boolean bl) throws IOException {
        return this.getInputStream(string, false, bl);
    }

    public final InputStream getInputStream(ZipEntry zipEntry, boolean bl) throws IOException {
        return this.getInputStream(zipEntry.getName(), false, bl);
    }

    protected InputStream getInputStream(String string, boolean bl, boolean bl2) throws IOException {
        Object object;
        this.ensureOpen();
        if (string == null) {
            throw new NullPointerException();
        }
        ZipEntry zipEntry = (ZipEntry)this.entries.get(string);
        if (zipEntry == null) {
            return null;
        }
        long l = zipEntry.offset;
        if (!$assertionsDisabled && l == -1L) {
            throw new AssertionError();
        }
        if (l < 0L) {
            this.archive.seek(l &= Long.MAX_VALUE);
            object = new byte[30];
            this.archive.readFully((byte[])object);
            long l2 = BasicZipFile.readUInt((byte[])object, 0);
            if (l2 != 67324752L) {
                throw new ZipException(string + ": expected Local File Header signature");
            }
            l += (long)(30 + BasicZipFile.readUShort((byte[])object, 26) + BasicZipFile.readUShort((byte[])object, 28));
            if (bl) {
                long l3;
                if (zipEntry.getGeneralBit(3)) {
                    byte[] byArray = new byte[8];
                    this.archive.seek(l + zipEntry.getCompressedSize());
                    this.archive.readFully(byArray);
                    long l4 = BasicZipFile.readUInt(byArray, 0);
                    l3 = l4 == 134695760L ? BasicZipFile.readUInt(byArray, 4) : l4;
                } else {
                    l3 = BasicZipFile.readUInt((byte[])object, 14);
                }
                if (zipEntry.getCrc() != l3) {
                    throw new CRC32Exception(string, zipEntry.getCrc(), l3);
                }
            }
            zipEntry.offset = l;
        }
        object = new IntervalInputStream(l, zipEntry.getCompressedSize());
        int n = BasicZipFile.getBufferSize(zipEntry);
        Object object2 = object;
        switch (zipEntry.getMethod()) {
            case 8: {
                if (bl2) {
                    ((IntervalInputStream)object).addDummy();
                    object2 = new PooledInflaterInputStream((InputStream)object2, n);
                    if (!bl) break;
                    object2 = new CheckedInputStream((InputStream)object2, zipEntry, n);
                    break;
                }
                if (!bl) break;
                object2 = new RawCheckedInputStream((InputStream)object2, zipEntry, n);
                break;
            }
            case 0: {
                if (!bl) break;
                object2 = new CheckedInputStream((InputStream)object2, zipEntry, n);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"this should already have been checked by mountCentralDirectory()");
                }
                break;
            }
        }
        return object2;
    }

    private static final int getBufferSize(ZipEntry zipEntry) {
        long l = zipEntry.getSize();
        if (l > 65536L) {
            l = 65536L;
        } else if (l < 8192L) {
            l = 8192L;
        }
        return (int)l;
    }

    private final void ensureOpen() throws ZipException {
        if (this.archive == null) {
            throw new ZipException("ZIP file has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Inflater allocateInflater() {
        Inflater inflater = null;
        List list = releasedInflaters;
        synchronized (list) {
            Iterator iterator = releasedInflaters.iterator();
            while (iterator.hasNext()) {
                inflater = (Inflater)((Reference)iterator.next()).get();
                iterator.remove();
                if (inflater == null) continue;
            }
            if (inflater == null) {
                inflater = new Inflater(true);
            }
            allocatedInflaters.add(inflater);
        }
        return inflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseInflater(Inflater inflater) {
        inflater.reset();
        List list = releasedInflaters;
        synchronized (list) {
            releasedInflaters.add(new SoftReference<Inflater>(inflater));
            allocatedInflaters.remove(inflater);
        }
    }

    private static long skipWithBuffer(InputStream inputStream, long l, byte[] byArray) throws IOException {
        long l2;
        long l3 = 0L;
        while ((l2 = l - l3) > 0L && (l2 = (long)inputStream.read(byArray, 0, l2 < (long)byArray.length ? (int)l2 : byArray.length)) >= 0L) {
            l3 += l2;
        }
        return l3;
    }

    public void close() throws IOException {
        if (this.archive != null) {
            ReadOnlyFile readOnlyFile = this.archive;
            this.archive = null;
            readOnlyFile.close();
        }
    }

    private static final int readUShort(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    private static final long readUInt(byte[] byArray, int n) {
        n += 3;
        long l = (long)byArray[n--] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[n--] & 0xFFL;
        l <<= 8;
        l |= (long)byArray[n--] & 0xFFL;
        l <<= 8;
        return l |= (long)byArray[n] & 0xFFL;
    }

    static {
        $assertionsDisabled = !BasicZipFile.class.desiredAssertionStatus();
        allocatedInflaters = new HashSet();
        releasedInflaters = new LinkedList();
    }

    private static class IrregularOffsetMapper
    extends OffsetMapper {
        final long start;

        IrregularOffsetMapper(long l) {
            this.start = l;
        }

        long location(long l) {
            return this.start + l;
        }
    }

    private static class OffsetMapper {
        private OffsetMapper() {
        }

        long location(long l) {
            return l;
        }
    }

    private abstract class AccountedInputStream
    extends InputStream {
        private boolean closed;

        public AccountedInputStream() {
            BasicZipFile.this.openStreams++;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                BasicZipFile.this.openStreams--;
                super.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private class IntervalInputStream
    extends AccountedInputStream {
        private long remaining;
        private long fp;
        private boolean addDummyByte;
        static final /* synthetic */ boolean $assertionsDisabled;

        IntervalInputStream(long l, long l2) {
            if (!$assertionsDisabled && l < 0L) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && l2 < 0L) {
                throw new AssertionError();
            }
            this.remaining = l2;
            this.fp = l;
        }

        public int read() throws IOException {
            BasicZipFile.this.ensureOpen();
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            BasicZipFile.this.archive.seek(this.fp);
            int n = BasicZipFile.this.archive.read();
            if (n >= 0) {
                ++this.fp;
                --this.remaining;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 <= 0) {
                if (n2 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                return 0;
            }
            BasicZipFile.this.ensureOpen();
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    byArray[n] = 0;
                    return 1;
                }
                return -1;
            }
            if ((long)n2 > this.remaining) {
                n2 = (int)this.remaining;
            }
            BasicZipFile.this.archive.seek(this.fp);
            int n3 = BasicZipFile.this.archive.read(byArray, n, n2);
            if (n3 > 0) {
                this.fp += (long)n3;
                this.remaining -= (long)n3;
            }
            return n3;
        }

        void addDummy() {
            this.addDummyByte = true;
        }

        public int available() throws IOException {
            BasicZipFile.this.ensureOpen();
            long l = this.remaining;
            if (this.addDummyByte) {
                ++l;
            }
            return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$util$zip$BasicZipFile == null ? (class$de$schlichtherle$util$zip$BasicZipFile = BasicZipFile.class$("de.schlichtherle.util.zip.BasicZipFile")) : class$de$schlichtherle$util$zip$BasicZipFile).desiredAssertionStatus();
        }
    }

    private static final class RawCheckedInputStream
    extends FilterInputStream {
        private final Checksum crc = new CRC32();
        private final byte[] singleByteBuf = new byte[1];
        private final Inflater inf = BasicZipFile.access$100();
        private final byte[] infBuf;
        private final ZipEntry entry;
        private boolean closed;
        static final /* synthetic */ boolean $assertionsDisabled;

        public RawCheckedInputStream(InputStream inputStream, ZipEntry zipEntry, int n) {
            super(inputStream);
            this.infBuf = new byte[n];
            this.entry = zipEntry;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("input stream has been closed");
            }
        }

        public int read() throws IOException {
            int n;
            while ((n = this.read(this.singleByteBuf, 0, 1)) == 0) {
            }
            return n > 0 ? this.singleByteBuf[0] & 0xFF : -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            this.ensureOpen();
            if (byArray == null) {
                throw new NullPointerException();
            }
            int n3 = n + n2;
            if ((n | n2 | n3 | byArray.length - n3) < 0) {
                throw new IndexOutOfBoundsException();
            }
            int n4 = this.in.read(byArray, n, n2);
            if (n4 >= 0) {
                this.inf.setInput(byArray, n, n4);
            } else {
                byArray[n] = 0;
                this.inf.setInput(byArray, n, 1);
            }
            try {
                int n5;
                while ((n5 = this.inf.inflate(this.infBuf, 0, this.infBuf.length)) > 0) {
                    this.crc.update(this.infBuf, 0, n5);
                }
            }
            catch (DataFormatException dataFormatException) {
                IOException iOException = new IOException(dataFormatException.toString());
                iOException.initCause(dataFormatException);
                throw iOException;
            }
            if (!$assertionsDisabled && n4 < 0 && !this.inf.finished()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n4 >= 0 && !this.inf.needsInput()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.inf.needsDictionary()) {
                throw new AssertionError();
            }
            return n4;
        }

        public long skip(long l) throws IOException {
            return BasicZipFile.skipWithBuffer(this, l, new byte[this.infBuf.length]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            long l;
            if (this.closed) {
                return;
            }
            try {
                while (this.skip(Long.MAX_VALUE) > 0L) {
                }
            }
            finally {
                this.closed = true;
                BasicZipFile.releaseInflater(this.inf);
                super.close();
            }
            long l2 = this.entry.getCrc();
            if (l2 != (l = this.crc.getValue())) {
                throw new CRC32Exception(this.entry.getName(), l2, l);
            }
        }

        public void mark(int n) {
        }

        public void reset() throws IOException {
            throw new IOException("mark()/reset() not supported");
        }

        public boolean markSupported() {
            return false;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$util$zip$BasicZipFile == null ? (class$de$schlichtherle$util$zip$BasicZipFile = BasicZipFile.class$("de.schlichtherle.util.zip.BasicZipFile")) : class$de$schlichtherle$util$zip$BasicZipFile).desiredAssertionStatus();
        }
    }

    private static final class CheckedInputStream
    extends java.util.zip.CheckedInputStream {
        private final ZipEntry entry;
        private final int size;

        public CheckedInputStream(InputStream inputStream, ZipEntry zipEntry, int n) {
            super(inputStream, new CRC32());
            this.entry = zipEntry;
            this.size = n;
        }

        public long skip(long l) throws IOException {
            return BasicZipFile.skipWithBuffer(this, l, new byte[this.size]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            long l;
            try {
                while (this.skip(Long.MAX_VALUE) > 0L) {
                }
            }
            finally {
                super.close();
            }
            long l2 = this.entry.getCrc();
            if (l2 != (l = this.getChecksum().getValue())) {
                throw new CRC32Exception(this.entry.getName(), l2, l);
            }
        }
    }

    private static final class PooledInflaterInputStream
    extends InflaterInputStream {
        private boolean closed;

        public PooledInflaterInputStream(InputStream inputStream, int n) {
            super(inputStream, BasicZipFile.allocateInflater(), n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
            }
            finally {
                BasicZipFile.releaseInflater(this.inf);
            }
        }
    }
}

