/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.spi;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import javax.swing.Icon;

public abstract class AbstractArchiveDriver
implements ArchiveDriver,
Serializable {
    private static final long serialVersionUID = 6546816846546846516L;
    private final String charset;
    private final Icon openIcon;
    private final Icon closedIcon;
    private transient ThreadLocalEncoder encoder;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractArchiveDriver(String string, Icon icon, Icon icon2) {
        this.charset = string;
        this.encoder = new ThreadLocalEncoder();
        this.openIcon = icon;
        this.closedIcon = icon2;
        UnsupportedEncodingException unsupportedEncodingException = AbstractArchiveDriver.testJSE11Support(string);
        UnsupportedCharsetException unsupportedCharsetException = AbstractArchiveDriver.testJSE14Support(string);
        if (unsupportedEncodingException != null || unsupportedCharsetException != null) {
            if (unsupportedEncodingException == null) {
                throw new InconsistentCharsetSupportError(string, unsupportedCharsetException);
            }
            if (unsupportedCharsetException == null) {
                throw new InconsistentCharsetSupportError(string, unsupportedEncodingException);
            }
            throw unsupportedCharsetException;
        }
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    private static UnsupportedEncodingException testJSE11Support(String string) {
        try {
            new String(new byte[0], string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return unsupportedEncodingException;
        }
        return null;
    }

    private static UnsupportedCharsetException testJSE14Support(String string) {
        try {
            Charset.forName(string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return unsupportedCharsetException;
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!$assertionsDisabled && this.encoder != null) {
            throw new AssertionError();
        }
        this.encoder = new ThreadLocalEncoder();
        try {
            this.invariants();
        }
        catch (AssertionError assertionError) {
            throw (InvalidObjectException)new InvalidObjectException(((Throwable)((Object)assertionError)).toString()).initCause((Throwable)((Object)assertionError));
        }
    }

    private boolean invariants() {
        if (this.charset == null) {
            throw new AssertionError((Object)"character set not initialized");
        }
        try {
            this.ensureEncodable("");
        }
        catch (CharConversionException charConversionException) {
            throw new AssertionError((Object)charConversionException);
        }
        return true;
    }

    protected final void ensureEncodable(String string) throws CharConversionException {
        if (!this.encoder.canEncode(string)) {
            throw new CharConversionException(string + " (illegal characters in entry name)");
        }
    }

    public final String getCharset() {
        return this.charset;
    }

    public final String getEncoding() {
        return this.charset;
    }

    public final Icon getOpenIcon(Archive archive) {
        return this.openIcon;
    }

    public final Icon getClosedIcon(Archive archive) {
        return this.closedIcon;
    }

    static {
        $assertionsDisabled = !AbstractArchiveDriver.class.desiredAssertionStatus();
    }

    protected static final class InconsistentCharsetSupportError
    extends Error {
        static final /* synthetic */ boolean $assertionsDisabled;

        private InconsistentCharsetSupportError(String string, Exception exception) {
            super(InconsistentCharsetSupportError.message(string, exception), exception);
        }

        private static String message(String string, Exception exception) {
            String[] stringArray;
            if (!($assertionsDisabled || exception instanceof UnsupportedEncodingException || exception instanceof UnsupportedCharsetException)) {
                throw new AssertionError();
            }
            if (exception instanceof UnsupportedEncodingException) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "J2SE 1.4";
                stringArray = stringArray2;
                stringArray2[1] = "JSE 1.1";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "JSE 1.1";
                stringArray = stringArray3;
                stringArray3[1] = "J2SE 1.4";
            }
            String[] stringArray4 = stringArray;
            return "The character set '" + string + "' is supported by the " + stringArray4[0] + " API, but not the " + stringArray4[1] + " API." + "\nThis requires fixing the Java Runtime Environment!" + "\nPlease read the Javadoc of this error class for more information.";
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$archive$spi$AbstractArchiveDriver == null ? (class$de$schlichtherle$io$archive$spi$AbstractArchiveDriver = AbstractArchiveDriver.class$("de.schlichtherle.io.archive.spi.AbstractArchiveDriver")) : class$de$schlichtherle$io$archive$spi$AbstractArchiveDriver).desiredAssertionStatus();
        }
    }

    private final class ThreadLocalEncoder
    extends ThreadLocal {
        private ThreadLocalEncoder() {
        }

        protected Object initialValue() {
            return Charset.forName(AbstractArchiveDriver.this.charset).newEncoder();
        }

        boolean canEncode(CharSequence charSequence) {
            return ((CharsetEncoder)this.get()).canEncode(charSequence);
        }
    }
}

