/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveDriverRegistry;
import de.schlichtherle.io.File;
import de.schlichtherle.io.util.SuffixSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

final class GlobalArchiveDriverRegistry
extends ArchiveDriverRegistry {
    private static final long serialVersionUID = 1579600190374703884L;
    private static final String CLASS_NAME;
    private static final Logger logger;
    private static final String KWD_NULL = "NULL";
    private static final String KWD_ALL = "ALL";
    private static final String PROP_KEY_DEFAULT_SUFFIXES = "de.schlichtherle.io.default";
    private static final String PROP_KEY_REGISTRY = "de.schlichtherle.io.registry";
    public static final GlobalArchiveDriverRegistry INSTANCE;
    public final String defaultSuffixes;
    public final String allSuffixes;
    static final /* synthetic */ boolean $assertionsDisabled;

    private GlobalArchiveDriverRegistry() {
        this.registerArchiveDrivers();
        this.defaultSuffixes = this.defaultSuffixes().toString();
        this.allSuffixes = this.suffixes().toString();
        this.logConfiguration();
    }

    private static final String[] getServices() {
        return System.getProperty(PROP_KEY_REGISTRY, "META-INF/services/de.schlichtherle.io.registry.properties" + File.pathSeparator + "META-INF/services/" + CLASS_NAME + ".properties" + File.pathSeparator + "META-INF/services/de.schlichtherle.io.archive.spi.ArchiveDriver.properties").split("\\" + File.pathSeparator);
    }

    private void registerArchiveDrivers() {
        ArchiveDriverRegistry archiveDriverRegistry = new ArchiveDriverRegistry();
        String[] stringArray = GlobalArchiveDriverRegistry.getServices();
        int n = stringArray.length;
        while (--n >= 0) {
            GlobalArchiveDriverRegistry.registerArchiveDrivers(stringArray[n], (ArchiveDriverRegistry)this, archiveDriverRegistry);
        }
        this.putAll(archiveDriverRegistry);
    }

    private static void registerArchiveDrivers(String string, ArchiveDriverRegistry archiveDriverRegistry, ArchiveDriverRegistry archiveDriverRegistry2) {
        Enumeration<URL> enumeration;
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveDriverRegistry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveDriverRegistry2 == null) {
            throw new AssertionError();
        }
        try {
            enumeration = Thread.currentThread().getContextClassLoader().getResources(string);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "lookup.ex", iOException);
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            GlobalArchiveDriverRegistry.registerArchiveDrivers(uRL, archiveDriverRegistry, archiveDriverRegistry2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerArchiveDrivers(URL uRL, ArchiveDriverRegistry archiveDriverRegistry, ArchiveDriverRegistry archiveDriverRegistry2) {
        if (!$assertionsDisabled && uRL == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveDriverRegistry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveDriverRegistry2 == null) {
            throw new AssertionError();
        }
        logger.log(Level.CONFIG, "loading", uRL);
        Properties properties = new Properties();
        try {
            InputStream inputStream = uRL.openStream();
            try {
                properties.load(inputStream);
                GlobalArchiveDriverRegistry.registerArchiveDrivers(properties, archiveDriverRegistry, archiveDriverRegistry2);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "loading.ex", iOException);
        }
    }

    private static void registerArchiveDrivers(Map map, ArchiveDriverRegistry archiveDriverRegistry, ArchiveDriverRegistry archiveDriverRegistry2) {
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveDriverRegistry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveDriverRegistry2 == null) {
            throw new AssertionError();
        }
        String string = (String)map.remove("DRIVER");
        boolean bl = Boolean.TRUE.equals(Boolean.valueOf(string));
        (bl ? archiveDriverRegistry : archiveDriverRegistry2).registerArchiveDrivers(map, false);
    }

    private SuffixSet defaultSuffixes() {
        SuffixSet suffixSet;
        String string = System.getProperty(PROP_KEY_DEFAULT_SUFFIXES);
        if (string != null) {
            suffixSet = new SuffixSet(string);
        } else {
            suffixSet = (SuffixSet)this.remove("DEFAULT");
            if (suffixSet == null) {
                return new SuffixSet();
            }
        }
        SuffixSet suffixSet2 = this.suffixes();
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = suffixSet.originalIterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (KWD_NULL.equals(string2)) {
                iterator.remove();
                bl = true;
                continue;
            }
            if (KWD_ALL.equals(string2)) {
                iterator.remove();
                bl2 = true;
                continue;
            }
            if (suffixSet2.contains(string2)) continue;
            iterator.remove();
            logger.log(Level.WARNING, "unknownSuffix", string2);
        }
        if (bl) {
            suffixSet.clear();
        } else if (bl2) {
            suffixSet.addAll(suffixSet2);
        }
        return suffixSet;
    }

    private void logConfiguration() {
        Iterator iterator = this.entrySet().iterator();
        if (iterator.hasNext()) {
            do {
                Map.Entry entry = iterator.next();
                logger.log(Level.CONFIG, "driverRegistered", new Object[]{entry.getKey(), entry.getValue()});
            } while (iterator.hasNext());
            logger.log(Level.CONFIG, "allSuffixList", this.allSuffixes);
            if (this.defaultSuffixes.length() > 0) {
                logger.log(Level.CONFIG, "defaultSuffixList", this.defaultSuffixes);
            } else {
                logger.config("noDefaultSuffixes");
            }
        } else {
            logger.warning("noDriversRegistered");
        }
    }

    static {
        $assertionsDisabled = !GlobalArchiveDriverRegistry.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/GlobalArchiveDriverRegistry".replace('/', '.');
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
        INSTANCE = new GlobalArchiveDriverRegistry();
        logger.config("banner");
    }
}

