/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Comparator;

public class ChainableIOException
extends IOException
implements Cloneable {
    static final Comparator PRIORITY_COMP = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = ((ChainableIOException)object).getPriority() - ((ChainableIOException)object2).getPriority();
            return n != 0 ? n : APPEARANCE_COMP.compare(object, object2);
        }
    };
    static final Comparator APPEARANCE_COMP = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((ChainableIOException)object).getAppearance() - ((ChainableIOException)object2).getAppearance();
        }
    };
    private static int maxPrintExceptions = 3;
    private ChainableIOException prior;
    private final int appearance;
    int maxAppearance;

    public ChainableIOException(ChainableIOException chainableIOException) {
        this(chainableIOException, null, null);
    }

    public ChainableIOException(ChainableIOException chainableIOException, String string) {
        this(chainableIOException, string, null);
    }

    public ChainableIOException(ChainableIOException chainableIOException, IOException iOException) {
        this(chainableIOException, null, iOException);
    }

    public ChainableIOException(ChainableIOException chainableIOException, String string, IOException iOException) {
        super(string);
        this.prior = chainableIOException;
        if (iOException != null) {
            this.initCause(iOException);
        }
        this.maxAppearance = chainableIOException != null ? chainableIOException.maxAppearance + 1 : 0;
        this.appearance = this.maxAppearance;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public int getPriority() {
        return 0;
    }

    public final int getAppearance() {
        return this.appearance;
    }

    public ChainableIOException getPrior() {
        return this.prior;
    }

    public ChainableIOException sortPriority() {
        return this.sort(PRIORITY_COMP);
    }

    public ChainableIOException sortAppearance() {
        return this.sort(APPEARANCE_COMP);
    }

    private ChainableIOException sort(Comparator comparator) {
        if (this.prior != null) {
            ChainableIOException chainableIOException = this.prior.sort(comparator);
            if (chainableIOException == this.prior && comparator.compare(this, this.prior) >= 0) {
                return this;
            }
            return chainableIOException.insert((ChainableIOException)this.clone(), comparator);
        }
        return this;
    }

    private ChainableIOException insert(ChainableIOException chainableIOException, Comparator comparator) {
        if (comparator.compare(chainableIOException, this) >= 0) {
            chainableIOException.prior = this;
            chainableIOException.maxAppearance = Math.max(chainableIOException.appearance, this.maxAppearance);
            return chainableIOException;
        }
        ChainableIOException chainableIOException2 = (ChainableIOException)this.clone();
        if (this.prior != null) {
            chainableIOException2.prior = this.prior.insert(chainableIOException, comparator);
            chainableIOException2.maxAppearance = Math.max(chainableIOException2.appearance, chainableIOException2.prior.maxAppearance);
        } else {
            chainableIOException.prior = null;
            chainableIOException2.prior = chainableIOException;
            chainableIOException2.maxAppearance = chainableIOException.maxAppearance;
        }
        return chainableIOException2;
    }

    public final Throwable initCause(Throwable throwable) {
        return this.initCause((IOException)throwable);
    }

    public Throwable initCause(IOException iOException) {
        return super.initCause(iOException);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(printStream, ChainableIOException.getMaxPrintExceptions());
    }

    public void printStackTrace(PrintStream printStream, int n) {
        --n;
        if (this.prior != null) {
            if (n > 0) {
                this.prior.printStackTrace(printStream, n);
                printStream.println("Followed, but not caused by:");
            } else {
                printStream.println("(Omitting " + this.prior.getNumExceptions() + " exception(s) at the start of this list)");
            }
        }
        super.printStackTrace(printStream);
    }

    private int getNumExceptions() {
        return this.prior != null ? this.prior.getNumExceptions() + 1 : 1;
    }

    public void printStackTrace(PrintWriter printWriter) {
        this.printStackTrace(printWriter, ChainableIOException.getMaxPrintExceptions());
    }

    public void printStackTrace(PrintWriter printWriter, int n) {
        --n;
        if (this.prior != null) {
            if (n > 0) {
                this.prior.printStackTrace(printWriter, n);
                printWriter.println("Followed, but not caused by:");
            } else {
                printWriter.println("(Omitting " + this.prior.getNumExceptions() + " exception(s) at the start of this list)");
            }
        }
        super.printStackTrace(printWriter);
    }

    public static int getMaxPrintExceptions() {
        return maxPrintExceptions;
    }

    public static void setMaxPrintExceptions(int n) {
        maxPrintExceptions = n;
    }
}

