/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.raes;

import de.schlichtherle.crypto.SeekableBlockCipher;
import de.schlichtherle.crypto.io.raes.RaesAuthenticationException;
import de.schlichtherle.crypto.io.raes.RaesException;
import de.schlichtherle.crypto.io.raes.RaesKeyException;
import de.schlichtherle.crypto.io.raes.RaesOutputStream;
import de.schlichtherle.crypto.io.raes.RaesReadOnlyFile;
import de.schlichtherle.crypto.io.raes.Type0RaesParameters;
import de.schlichtherle.crypto.modes.SICSeekableBlockCipher;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.util.Arrays;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

class Type0RaesReadOnlyFile
extends RaesReadOnlyFile {
    private static final long MIN_KEY_RETRY_DELAY = 3000L;
    private final int keyStrength;
    private final CipherParameters macParam;
    private final byte[] footer;
    static final /* synthetic */ boolean $assertionsDisabled;

    Type0RaesReadOnlyFile(ReadOnlyFile readOnlyFile, Type0RaesParameters type0RaesParameters) throws NullPointerException, FileNotFoundException, RaesException, RaesKeyException, IOException {
        super(readOnlyFile);
        CipherParameters cipherParameters;
        ParametersWithIV parametersWithIV;
        Object object;
        if (!$assertionsDisabled && readOnlyFile == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && type0RaesParameters == null) {
            throw new AssertionError();
        }
        byte[] byArray = new byte[8];
        long l = readOnlyFile.length();
        readOnlyFile.seek(0L);
        readOnlyFile.readFully(byArray);
        this.keyStrength = Type0RaesReadOnlyFile.readUByte(byArray, 5);
        if (this.keyStrength != 0 && this.keyStrength != 1 && this.keyStrength != 2) {
            throw new RaesException("Unknown index for cipher key strength: " + this.keyStrength + "!");
        }
        int n = 16 + this.keyStrength * 8;
        int n2 = n * 8;
        int n3 = Type0RaesReadOnlyFile.readUShort(byArray, 6);
        if (n3 < 1024) {
            throw new RaesException("Iteration count must be 1024 or greater, but is " + n3 + "!");
        }
        long l2 = byArray.length + n;
        byte[] byArray2 = new byte[n];
        readOnlyFile.readFully(byArray2);
        SHA256Digest sHA256Digest = new SHA256Digest();
        this.footer = new byte[sHA256Digest.getDigestSize()];
        long l3 = l - (long)this.footer.length;
        readOnlyFile.seek(l3);
        readOnlyFile.readFully(this.footer);
        if (this.rof.read() != -1) {
            throw new RaesException("Expected end of file after data envelope trailer!");
        }
        long l4 = l - (long)this.footer.length - l2;
        PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator((Digest)sHA256Digest);
        long l5 = 0L;
        while (true) {
            if ((object = type0RaesParameters.getOpenPasswd()) == null) {
                throw new RaesKeyException();
            }
            byte[] byArray3 = PBEParametersGenerator.PKCS12PasswordToBytes((char[])object);
            int n4 = ((char[])object).length;
            while (--n4 >= 0) {
                object[n4] = '\u0000';
            }
            pKCS12ParametersGenerator.init(byArray3, byArray2, n3);
            parametersWithIV = (ParametersWithIV)pKCS12ParametersGenerator.generateDerivedParameters(n2, 128);
            cipherParameters = pKCS12ParametersGenerator.generateDerivedMacParameters(n2);
            n4 = byArray3.length;
            while (--n4 >= 0) {
                byArray3[n4] = 0;
            }
            HMac hMac = new HMac((Digest)sHA256Digest);
            hMac.init(cipherParameters);
            byte[] byArray4 = ((KeyParameter)parametersWithIV.getParameters()).getKey();
            hMac.update(byArray4, 0, byArray4.length);
            byte[] byArray5 = new byte[hMac.getMacSize()];
            RaesOutputStream.klac((Mac)hMac, l4, byArray5);
            sHA256Digest.reset();
            l5 = Type0RaesReadOnlyFile.enforceSuspensionPenalty(l5);
            if (Arrays.equals(this.footer, 0, byArray5, 0, byArray5.length / 2)) break;
            type0RaesParameters.invalidOpenPasswd();
        }
        type0RaesParameters.setKeyStrength(this.keyStrength);
        this.macParam = cipherParameters;
        object = new SICSeekableBlockCipher((BlockCipher)new AESFastEngine());
        object.init(false, (CipherParameters)parametersWithIV);
        this.init((SeekableBlockCipher)object, l2, l4);
    }

    private static long enforceSuspensionPenalty(long l) {
        long l2;
        InterruptedException interruptedException = null;
        while ((l2 = System.currentTimeMillis() - l) < 3000L) {
            try {
                Thread.sleep(3000L - l2);
            }
            catch (InterruptedException interruptedException2) {
                interruptedException = interruptedException2;
            }
        }
        if (interruptedException != null) {
            Thread.currentThread().interrupt();
        }
        return l + l2;
    }

    public int getKeySizeBits() {
        return 128 + this.keyStrength * 64;
    }

    public void authenticate() throws RaesAuthenticationException, IOException {
        HMac hMac = new HMac((Digest)new SHA256Digest());
        hMac.init(this.macParam);
        byte[] byArray = this.computeMac((Mac)hMac);
        if (!Arrays.equals(this.footer, this.footer.length / 2, byArray, 0, byArray.length / 2)) {
            throw new RaesAuthenticationException();
        }
    }

    static {
        $assertionsDisabled = !Type0RaesReadOnlyFile.class.desiredAssertionStatus();
    }
}

