/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.raes;

import de.schlichtherle.crypto.generators.DigestRandom;
import de.schlichtherle.crypto.io.raes.RaesKeyException;
import de.schlichtherle.crypto.io.raes.RaesOutputStream;
import de.schlichtherle.crypto.io.raes.Type0RaesParameters;
import de.schlichtherle.crypto.modes.SICSeekableBlockCipher;
import de.schlichtherle.io.util.LEDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.io.MacOutputStream;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

class Type0RaesOutputStream
extends RaesOutputStream {
    static final int ITERATION_COUNT = 2005;
    private int keyStrengthBits;
    private Mac mac;
    private Mac klac;
    private LEDataOutputStream dos;
    private long start;
    private boolean closed;
    static final /* synthetic */ boolean $assertionsDisabled;

    Type0RaesOutputStream(OutputStream outputStream, Type0RaesParameters type0RaesParameters) throws NullPointerException, IllegalArgumentException, RaesKeyException, IOException {
        super(outputStream, null);
        if (!$assertionsDisabled && outputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && type0RaesParameters == null) {
            throw new AssertionError();
        }
        char[] cArray = type0RaesParameters.getCreatePasswd();
        if (cArray == null) {
            throw new RaesKeyException();
        }
        int n = type0RaesParameters.getKeyStrength();
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Illegal cipher key strength: " + n + "!");
        }
        SHA256Digest sHA256Digest = new SHA256Digest();
        int n2 = 16 + n * 8;
        this.keyStrengthBits = n2 * 8;
        if (!$assertionsDisabled && sHA256Digest.getDigestSize() < n2) {
            throw new AssertionError();
        }
        byte[] byArray = new byte[n2];
        new DigestRandom((Digest)sHA256Digest).nextBytes(byArray);
        PKCS12ParametersGenerator pKCS12ParametersGenerator = new PKCS12ParametersGenerator((Digest)sHA256Digest);
        byte[] byArray2 = PBEParametersGenerator.PKCS12PasswordToBytes((char[])cArray);
        int n3 = cArray.length;
        while (--n3 >= 0) {
            cArray[n3] = '\u0000';
        }
        pKCS12ParametersGenerator.init(byArray2, byArray, 2005);
        ParametersWithIV parametersWithIV = (ParametersWithIV)pKCS12ParametersGenerator.generateDerivedParameters(this.keyStrengthBits, 128);
        CipherParameters cipherParameters = pKCS12ParametersGenerator.generateDerivedMacParameters(this.keyStrengthBits);
        int n4 = byArray2.length;
        while (--n4 >= 0) {
            byArray2[n4] = 0;
        }
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher((BlockCipher)new SICSeekableBlockCipher((BlockCipher)new AESFastEngine()));
        bufferedBlockCipher.init(true, (CipherParameters)parametersWithIV);
        this.mac = new HMac((Digest)new SHA256Digest());
        this.mac.init(cipherParameters);
        this.klac = new HMac((Digest)sHA256Digest);
        this.klac.init(cipherParameters);
        byte[] byArray3 = ((KeyParameter)parametersWithIV.getParameters()).getKey();
        this.klac.update(byArray3, 0, byArray3.length);
        this.dos = new LEDataOutputStream(outputStream);
        this.out = new MacOutputStream((OutputStream)this.dos, this.mac);
        this.dos.writeInt(1397047634);
        this.dos.writeByte(0);
        this.dos.writeByte(n);
        this.dos.writeShort(2005);
        this.dos.write(byArray);
        this.start = this.dos.size();
        if (!$assertionsDisabled && this.start != (long)(8 + byArray.length)) {
            throw new AssertionError();
        }
        this.cipher = bufferedBlockCipher;
    }

    public int getKeySizeBits() {
        return this.keyStrengthBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.finish();
                long l = this.dos.size();
                if (!$assertionsDisabled && this.mac.getMacSize() != this.klac.getMacSize()) {
                    throw new AssertionError();
                }
                byte[] byArray = new byte[this.mac.getMacSize()];
                long l2 = l - this.start;
                Type0RaesOutputStream.klac(this.klac, l2, byArray);
                this.dos.write(byArray, 0, byArray.length / 2);
                int n = this.mac.doFinal(byArray, 0);
                if (!$assertionsDisabled && n != byArray.length) {
                    throw new AssertionError();
                }
                this.dos.write(byArray, 0, byArray.length / 2);
                if (!$assertionsDisabled && this.dos.size() - l != (long)byArray.length) {
                    throw new AssertionError();
                }
            }
            finally {
                super.close();
            }
        }
    }

    static {
        $assertionsDisabled = !Type0RaesOutputStream.class.desiredAssertionStatus();
    }
}

