/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

public class ColorUtils {
    static final float b = 180.0f;
    static final float c = 100.0f;

    public static Color getDerivedColor(Color color, float f2) {
        if (color != null) {
            float[] fArray = ColorUtils.RGBtoHSL(color);
            if ((double)fArray[2] < 0.4) {
                fArray[2] = 0.4f;
            }
            fArray[2] = (double)f2 > 0.5 ? (float)((double)fArray[2] + (double)((1.0f - fArray[2]) * 2.0f) * ((double)f2 - 0.5)) : (float)((double)fArray[2] - (double)(fArray[2] * 2.0f) * (0.5 - (double)f2));
            int n2 = ColorUtils.HSLtoRGB(fArray);
            return new ColorUIResource(n2);
        }
        return null;
    }

    public static float[] RGBtoHSL(Color color) {
        float f2;
        float f3;
        float f4;
        float f5 = (float)color.getRed() / 256.0f;
        float f6 = (float)color.getGreen() / 256.0f;
        float f7 = (float)color.getBlue() / 256.0f;
        float f8 = Math.max(f5, Math.max(f6, f7));
        float f9 = Math.min(f5, Math.min(f6, f7));
        if (f5 == f6 && f6 == f7) {
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = f5;
        } else {
            f2 = (f9 + f8) / 2.0f;
            f3 = (double)f2 < 0.5 ? (f8 - f9) / (f8 + f9) : (f8 - f9) / (2.0f - f8 - f9);
            f4 = f5 == f8 ? (f6 - f7) / (f8 - f9) : (f6 == f8 ? 2.0f + (f7 - f5) / (f8 - f9) : 4.0f + (f5 - f6) / (f8 - f9));
            if ((f4 /= 6.0f) < 0.0f) {
                f4 += 1.0f;
            }
        }
        float[] fArray = new float[]{f4, f3, f2};
        return fArray;
    }

    public static int HSLtoRGB(float[] fArray) {
        float f2;
        float f3;
        float f4;
        float f5 = fArray[0];
        float f6 = fArray[1];
        float f7 = fArray[2];
        if (f6 == 0.0f) {
            f3 = f4 = f7;
            f2 = f4;
        } else {
            float f8 = (double)f7 < 0.5 ? f7 * (1.0f + f6) : f7 + f6 - f7 * f6;
            float f9 = 2.0f * f7 - f8;
            float f10 = f5 + 0.33333334f;
            if (f10 > 1.0f) {
                f10 -= 1.0f;
            }
            float f11 = f5;
            float f12 = f5 - 0.33333334f;
            if (f12 < 0.0f) {
                f12 += 1.0f;
            }
            f2 = (double)f10 < 0.16666666666666666 ? f9 + (f8 - f9) * 6.0f * f10 : ((double)f10 < 0.5 ? f8 : ((double)f10 < 0.6666666666666666 ? f9 + (f8 - f9) * (0.6666667f - f10) * 6.0f : f9));
            f3 = (double)f11 < 0.16666666666666666 ? f9 + (f8 - f9) * 6.0f * f11 : ((double)f11 < 0.5 ? f8 : ((double)f11 < 0.6666666666666666 ? f9 + (f8 - f9) * (0.6666667f - f11) * 6.0f : f9));
            f4 = (double)f12 < 0.16666666666666666 ? f9 + (f8 - f9) * 6.0f * f12 : ((double)f12 < 0.5 ? f8 : ((double)f12 < 0.6666666666666666 ? f9 + (f8 - f9) * (0.6666667f - f12) * 6.0f : f9));
        }
        int n2 = 0;
        n2 += ((int)(f2 * 255.0f) & 0xFF) << 16;
        n2 += ((int)(f3 * 255.0f) & 0xFF) << 8;
        return n2 += (int)(f4 * 255.0f) & 0xFF;
    }

    public static int[] calculateDifferent(float[] fArray, float[] fArray2) {
        int[] nArray = new int[]{ColorUtils.b(fArray[0], fArray2[0], 180.0f, true), ColorUtils.b(fArray[1], fArray2[1], 100.0f, false), ColorUtils.b(fArray[2], fArray2[2], 100.0f, false)};
        return nArray;
    }

    public static float[] applyDifference(float[] fArray, int[] nArray) {
        float[] fArray2 = new float[]{ColorUtils.c(fArray[0], nArray[0], 180.0f, true), ColorUtils.c(fArray[1], nArray[1], 100.0f, false), ColorUtils.c(fArray[2], nArray[2], 100.0f, false)};
        return fArray2;
    }

    private static int b(float f2, float f3, float f4, boolean bl) {
        if (bl) {
            int n2 = (int)((f3 - f2) * 2.0f * f4);
            if ((float)n2 > f4) {
                return n2 - (int)(2.0f * f4);
            }
            if ((float)n2 < -f4) {
                return n2 + (int)(2.0f * f4);
            }
            return n2;
        }
        if (f2 != 0.0f) {
            return (int)((f3 - f2) * f4 / f2);
        }
        return (int)((f3 - f2) * f4);
    }

    private static float c(float f2, int n2, float f3, boolean bl) {
        if (bl) {
            float f4 = f2 + (float)n2 / (2.0f * f3);
            if (f4 < 0.0f) {
                return f4 + 1.0f;
            }
            if (f4 > 1.0f) {
                return f4 - 1.0f;
            }
            return f4;
        }
        if (n2 > 0) {
            return f2 + (1.0f - f2) * (float)n2 / f3;
        }
        return f2 + f2 * (float)n2 / f3;
    }

    public static Color[] toColors(boolean bl, int ... nArray) {
        Color[] colorArray = new Color[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            colorArray[i2] = new Color(nArray[i2], bl);
        }
        return colorArray;
    }

    public static Color toGrayscale(Color color) {
        int n2 = (int)((double)color.getRed() * 0.3 + (double)color.getGreen() * 0.59 + (double)color.getBlue() * 0.11);
        return new Color(n2, n2, n2);
    }
}

