/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSearchable
extends Searchable
implements TreeModelListener,
PropertyChangeListener {
    private boolean rb = false;
    private transient List<TreePath> sb;

    public TreeSearchable(JTree jTree) {
        super(jTree);
        if (jTree.getModel() != null) {
            jTree.getModel().addTreeModelListener(this);
        }
        jTree.addPropertyChangeListener("model", this);
    }

    public boolean isRecursive() {
        return this.rb;
    }

    public void setRecursive(boolean bl) {
        this.rb = bl;
        this.resetTreePathes();
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTree && ((JTree)this._component).getModel() != null) {
            ((JTree)this._component).getModel().removeTreeModelListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    @Override
    protected void setSelectedIndex(int n2, boolean bl) {
        if (!this.isRecursive()) {
            if (bl) {
                ((JTree)this._component).addSelectionInterval(n2, n2);
            } else {
                ((JTree)this._component).setSelectionRow(n2);
            }
            ((JTree)this._component).scrollRowToVisible(n2);
        } else {
            Object object = this.getElementAt(n2);
            if (object instanceof TreePath) {
                TreePath treePath = (TreePath)object;
                if (bl) {
                    ((JTree)this._component).addSelectionPath(treePath);
                } else {
                    ((JTree)this._component).setSelectionPath(treePath);
                }
                ((JTree)this._component).scrollPathToVisible(treePath);
            }
        }
    }

    @Override
    protected int getSelectedIndex() {
        if (!this.isRecursive()) {
            int[] nArray = ((JTree)this._component).getSelectionRows();
            return nArray != null && nArray.length != 0 ? nArray[0] : -1;
        }
        TreePath[] treePathArray = ((JTree)this._component).getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            return this.getTreePathes().indexOf(treePathArray[0]);
        }
        return -1;
    }

    @Override
    protected Object getElementAt(int n2) {
        if (n2 == -1) {
            return null;
        }
        if (!this.isRecursive()) {
            return ((JTree)this._component).getPathForRow(n2);
        }
        return this.getTreePathes().get(n2);
    }

    @Override
    protected int getElementCount() {
        if (!this.isRecursive()) {
            return ((JTree)this._component).getRowCount();
        }
        return this.getTreePathes().size();
    }

    protected void populateTreePaths() {
        this.sb = new ArrayList<TreePath>();
        Object object = ((JTree)this._component).getModel().getRoot();
        this.r(object, new TreePath(object), ((JTree)this._component).getModel());
    }

    private void r(Object object, TreePath treePath, TreeModel treeModel) {
        if (((JTree)this._component).isRootVisible() || treePath.getLastPathComponent() != ((JTree)this._component).getModel().getRoot()) {
            this.sb.add(treePath);
        }
        for (int i2 = 0; i2 < treeModel.getChildCount(object); ++i2) {
            Object object2 = treeModel.getChild(object, i2);
            this.r(object2, treePath.pathByAddingChild(object2), treeModel);
        }
    }

    protected void resetTreePathes() {
        this.sb = null;
    }

    protected List<TreePath> getTreePathes() {
        if (this.sb == null) {
            this.populateTreePaths();
        }
        return this.sb;
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object instanceof TreePath) {
            Object object2 = ((TreePath)object).getLastPathComponent();
            if (this.getComponent() instanceof JTree) {
                JTree jTree = (JTree)this.getComponent();
                TreePath[] treePathArray = jTree.getSelectionPaths();
                boolean bl = false;
                if (treePathArray != null) {
                    for (TreePath treePath : treePathArray) {
                        if (treePath != object) continue;
                        bl = true;
                        break;
                    }
                }
                return jTree.convertValueToText(object2, bl, jTree.isExpanded((TreePath)object), jTree.getModel().isLeaf(object2), jTree.getRowForPath((TreePath)object), jTree.hasFocus() && jTree.getLeadSelectionPath() == object);
            }
            return object2.toString();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof TreeModel) {
                ((TreeModel)propertyChangeEvent.getOldValue()).removeTreeModelListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof TreeModel) {
                ((TreeModel)propertyChangeEvent.getNewValue()).addTreeModelListener(this);
            }
            this.resetTreePathes();
        }
    }
}

