/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.ShadowRenderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;

public class ShadowFactory
implements ShadowRenderer {
    public static final String KEY_BLUR_QUALITY = "blur_quality";
    public static final String VALUE_BLUR_QUALITY_FAST = "fast";
    public static final String VALUE_BLUR_QUALITY_HIGH = "high";
    public static final String SIZE_CHANGED_PROPERTY = "shadow_size";
    public static final String OPACITY_CHANGED_PROPERTY = "shadow_opacity";
    public static final String COLOR_CHANGED_PROPERTY = "shadow_color";
    private int f = 5;
    private float e = 0.5f;
    private Color c = Color.BLACK;
    private HashMap b = new HashMap();
    private PropertyChangeSupport d;

    public ShadowFactory() {
        this(5, 0.5f, Color.BLACK);
    }

    public ShadowFactory(int n2, float f2, Color color) {
        this.b.put(KEY_BLUR_QUALITY, VALUE_BLUR_QUALITY_FAST);
        this.d = new PropertyChangeSupport(this);
        this.setSize(n2);
        this.setOpacity(f2);
        this.setColor(color);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d.removePropertyChangeListener(propertyChangeListener);
    }

    public void setRenderingHint(Object object, Object object2) {
        this.b.put(object, object2);
    }

    public Color getColor() {
        return this.c;
    }

    public void setColor(Color color) {
        if (color != null) {
            Color color2 = this.c;
            this.c = color;
            this.d.firePropertyChange(COLOR_CHANGED_PROPERTY, color2, this.c);
        }
    }

    public float getOpacity() {
        return this.e;
    }

    public void setOpacity(float f2) {
        float f3 = this.e;
        this.e = (double)f2 < 0.0 ? 0.0f : (f2 > 1.0f ? 1.0f : f2);
        this.d.firePropertyChange(OPACITY_CHANGED_PROPERTY, Float.valueOf(f3), Float.valueOf(this.e));
    }

    public int getSize() {
        return this.f;
    }

    public void setSize(int n2) {
        int n3 = this.f;
        this.f = n2 < 0 ? 0 : n2;
        this.d.firePropertyChange(SIZE_CHANGED_PROPERTY, new Integer(n3), new Integer(this.f));
    }

    public BufferedImage createShadow(BufferedImage bufferedImage) {
        if (this.b.get(KEY_BLUR_QUALITY) == VALUE_BLUR_QUALITY_HIGH) {
            BufferedImage bufferedImage2 = this.b(bufferedImage);
            BufferedImage bufferedImage3 = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
            BufferedImage bufferedImage4 = this.e(bufferedImage2);
            this.d(this.f).filter(bufferedImage4, bufferedImage3);
            return bufferedImage3;
        }
        return this.c(bufferedImage);
    }

    private BufferedImage b(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth() + this.f * 2, bufferedImage.getHeight() + this.f * 2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, this.f, this.f);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private BufferedImage c(BufferedImage bufferedImage) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.f;
        int n8 = bufferedImage.getWidth();
        int n9 = bufferedImage.getHeight();
        int n10 = n8 + this.f;
        int n11 = n9 + this.f;
        int n12 = n7 - 1 >> 1;
        int n13 = n7 - n12;
        int n14 = n11 - n13;
        BufferedImage bufferedImage2 = new BufferedImage(n10, n11, 2);
        int n15 = this.c.getRGB() & 0xFFFFFF;
        int[] nArray = new int[n7];
        ColorModel colorModel = bufferedImage.getColorModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray2 = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
        int n16 = n13 * n10;
        float f2 = 1.0f / (float)this.f;
        float f3 = this.e / (float)this.f;
        int n17 = n12 * n10;
        for (n6 = 0; n6 < n9; ++n6) {
            n5 = 0;
            while (n5 < n7) {
                nArray[n5++] = 0;
            }
            n4 = 0;
            n5 = 0;
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = (int)((float)n4 * f2);
                nArray2[n17++] = n2 << 24;
                n4 -= nArray[n5];
                nArray[n5] = n2 = colorModel.getAlpha(writableRaster.getDataElements(n3, n6, null));
                n4 += n2;
                if (++n5 < n7) continue;
                n5 -= n7;
            }
            for (n3 = 0; n3 < n7; ++n3) {
                n2 = (int)((float)n4 * f2);
                nArray2[n17++] = n2 << 24;
                n4 -= nArray[n5];
                if (++n5 < n7) continue;
                n5 -= n7;
            }
        }
        n6 = 0;
        n17 = 0;
        while (n6 < n10) {
            n4 = 0;
            n5 = 0;
            while (n5 < n12) {
                nArray[n5++] = 0;
            }
            n3 = 0;
            while (n3 < n13) {
                n2 = nArray2[n17] >>> 24;
                nArray[n5++] = n2;
                n4 += n2;
                ++n3;
                n17 += n10;
            }
            n17 = n6;
            n5 = 0;
            n3 = 0;
            while (n3 < n14) {
                n2 = (int)((float)n4 * f3);
                nArray2[n17] = n2 << 24 | n15;
                n4 -= nArray[n5];
                nArray[n5] = n2 = nArray2[n17 + n16] >>> 24;
                n4 += n2;
                if (++n5 >= n7) {
                    n5 -= n7;
                }
                ++n3;
                n17 += n10;
            }
            n3 = n14;
            while (n3 < n11) {
                n2 = (int)((float)n4 * f3);
                nArray2[n17] = n2 << 24 | n15;
                n4 -= nArray[n5];
                if (++n5 >= n7) {
                    n5 -= n7;
                }
                ++n3;
                n17 += n10;
            }
            n17 = ++n6;
        }
        return bufferedImage2;
    }

    private BufferedImage e(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.getInstance(5, this.e));
        graphics2D.setColor(this.c);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
        return bufferedImage2;
    }

    private ConvolveOp d(int n2) {
        float[] fArray = new float[n2 * n2];
        float f2 = 1.0f / (float)(n2 * n2);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = f2;
        }
        return new ConvolveOp(new Kernel(n2, n2, fArray));
    }
}

