/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;

public class ScrollPaneOverview
extends JComponent {
    private static final int c = 400;
    private static final int i = 20;
    private Component g;
    private JScrollPane e;
    private Component n;
    protected JPopupMenu _popupMenu;
    private BufferedImage j;
    private Rectangle m;
    private Rectangle l;
    private Point d;
    private double h;
    private int k;
    private int f;
    private Color b = Color.BLACK;

    public ScrollPaneOverview(JScrollPane jScrollPane, Component component) {
        this.e = jScrollPane;
        this.g = component;
        this.j = null;
        this.m = null;
        this.l = null;
        this.d = null;
        this.h = 0.0;
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(13));
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (ScrollPaneOverview.this.d != null) {
                    Point point = mouseEvent.getPoint();
                    int n2 = (int)((double)(point.x - ((ScrollPaneOverview)ScrollPaneOverview.this).d.x) / ScrollPaneOverview.this.h);
                    int n3 = (int)((double)(point.y - ((ScrollPaneOverview)ScrollPaneOverview.this).d.y) / ScrollPaneOverview.this.h);
                    ScrollPaneOverview.this.i(n2, n3);
                }
                ScrollPaneOverview.this.d = null;
                ScrollPaneOverview.this.m = ScrollPaneOverview.this.l;
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (ScrollPaneOverview.this.d == null) {
                    ScrollPaneOverview.this.d = new Point(((ScrollPaneOverview)ScrollPaneOverview.this).l.x + ((ScrollPaneOverview)ScrollPaneOverview.this).l.width / 2, ((ScrollPaneOverview)ScrollPaneOverview.this).l.y + ((ScrollPaneOverview)ScrollPaneOverview.this).l.height / 2);
                }
                Point point = mouseEvent.getPoint();
                ScrollPaneOverview.this.d(point.x - ((ScrollPaneOverview)ScrollPaneOverview.this).d.x, point.y - ((ScrollPaneOverview)ScrollPaneOverview.this).d.y);
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this._popupMenu = new JPopupMenu();
        this._popupMenu.setLayout(new BorderLayout());
        this._popupMenu.add((Component)this, "Center");
    }

    public void setSelectionBorderColor(Color color) {
        this.b = color;
    }

    public Color getSelectionBorder() {
        return this.b;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.j == null || this.l == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.getInsets();
        int n2 = insets.left;
        int n3 = insets.top;
        graphics.setColor(this.e.getViewport().getView().getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.j, n2, n3, null);
        int n4 = this.getWidth() - insets.left - insets.right;
        int n5 = this.getHeight() - insets.top - insets.bottom;
        Area area = new Area(new Rectangle(n2, n3, n4, n5));
        area.subtract(new Area(this.l));
        graphics.setColor(new Color(255, 255, 255, 128));
        graphics2D.fill(area);
        Color color = graphics.getColor();
        graphics.setColor(this.b);
        graphics.drawRect(this.l.x, this.l.y, this.l.width, this.l.height);
        graphics.setColor(color);
    }

    public Dimension getPreferredSize() {
        if (this.j == null || this.l == null) {
            return new Dimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this.j.getWidth(null) + insets.left + insets.right, this.j.getHeight(null) + insets.top + insets.bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display() {
        this.n = this.e.getViewport().getView();
        if (this.n == null) {
            return;
        }
        int n2 = Math.max(400, Math.max(this.e.getWidth(), this.e.getHeight()) / 2);
        int n3 = Math.min(this.n.getWidth(), this.e.getViewport().getWidth() * 20);
        if (n3 <= 0) {
            return;
        }
        int n4 = Math.min(this.n.getHeight(), this.e.getViewport().getHeight() * 20);
        if (n4 <= 0) {
            return;
        }
        double d2 = (double)n2 / (double)n3;
        double d3 = (double)n2 / (double)n4;
        this.h = Math.max(0.05, Math.min(d2, d3));
        this.j = new BufferedImage((int)((double)n3 * this.h), (int)((double)n4 * this.h), 1);
        Graphics2D graphics2D = this.j.createGraphics();
        graphics2D.scale(this.h, this.h);
        graphics2D.setClip(this.k, this.f, n3, n4);
        boolean bl = this.n.isDoubleBuffered();
        try {
            if (this.n instanceof JComponent) {
                ((JComponent)this.n).setDoubleBuffered(false);
            }
            this.n.paint(graphics2D);
        }
        finally {
            if (this.n instanceof JComponent) {
                ((JComponent)this.n).setDoubleBuffered(bl);
            }
            graphics2D.dispose();
        }
        this.m = this.e.getViewport().getViewRect();
        Insets insets = this.getInsets();
        this.m.x = (int)(this.h * (double)this.m.x + (double)insets.left);
        this.m.y = (int)(this.h * (double)this.m.y + (double)insets.right);
        this.m.width = (int)((double)this.m.width * this.h);
        this.m.height = (int)((double)this.m.height * this.h);
        this.l = this.m;
        Point point = new Point(this.l.x + this.l.width / 2, this.l.y + this.l.height / 2);
        this.showPopup(-point.x, -point.y, this.g);
    }

    protected void showPopup(int n2, int n3, Component component) {
        this._popupMenu.show(component, n2, n3);
    }

    private void d(int n2, int n3) {
        if (this.m == null) {
            return;
        }
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(this.m);
        rectangle.x += n2;
        rectangle.y += n3;
        rectangle.x = Math.min(Math.max(rectangle.x, insets.left), this.getWidth() - insets.right - rectangle.width);
        rectangle.y = Math.min(Math.max(rectangle.y, insets.right), this.getHeight() - insets.bottom - rectangle.height);
        Rectangle rectangle2 = new Rectangle();
        Rectangle.union(this.l, rectangle, rectangle2);
        rectangle2.grow(2, 2);
        this.l = rectangle;
        this.paintImmediately(rectangle2);
    }

    private void i(int n2, int n3) {
        JComponent jComponent = (JComponent)this.e.getViewport().getView();
        Rectangle rectangle = jComponent.getVisibleRect();
        rectangle.x += this.k + n2;
        rectangle.y += this.f + n3;
        jComponent.scrollRectToVisible(rectangle);
        this._popupMenu.setVisible(false);
    }
}

