/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Resizable;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.ResizableSupport;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class ResizableFrame
extends JFrame
implements ResizableSupport {
    protected ResizablePanel _resizablePanel;
    private boolean b;

    public ResizableFrame() throws HeadlessException {
        this.initComponents();
    }

    public ResizableFrame(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.initComponents();
    }

    public ResizableFrame(String string) throws HeadlessException {
        super(string);
        this.initComponents();
    }

    public ResizableFrame(String string, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        this.initComponents();
    }

    protected void initComponents() {
        this.setUndecorated(true);
        this._resizablePanel = new ResizablePanel(){

            protected Resizable createResizable() {
                return new Resizable(this){

                    public void resizing(int n2, int n3, int n4, int n5, int n6) {
                        Container container = ResizableFrame.this.getContentPane();
                        PortingUtils.setPreferredSize(container, new Dimension(n5, n6));
                        if (ResizableFrame.this.isUndecorated()) {
                            ResizableFrame.this.setBounds(n3, n4, n5, n6);
                        }
                        ResizableFrame.this.resizing();
                    }

                    public void beginResizing(int n2) {
                        super.beginResizing(n2);
                        ResizableFrame.this.beginResizing();
                    }

                    public void endResizing(int n2) {
                        super.endResizing(n2);
                        ResizableFrame.this.endResizing();
                    }

                    public boolean isTopLevel() {
                        return true;
                    }
                };
            }

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl) {
                Component component;
                boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n2, bl);
                if (bl2 || keyEvent.isConsumed() || !ResizableFrame.this.isRoutingKeyStrokes()) {
                    return bl2;
                }
                if (keyEvent.getSource() instanceof JComponent) {
                    Class<?> clazz;
                    component = ((JComponent)keyEvent.getSource()).getRootPane();
                    for (clazz = component.getClass(); clazz != JComponent.class && clazz != null; clazz = clazz.getSuperclass()) {
                    }
                    try {
                        if (clazz != null) {
                            Method method = clazz.getDeclaredMethod("processKeyBinding", KeyStroke.class, KeyEvent.class, Integer.TYPE, Boolean.TYPE);
                            method.setAccessible(true);
                            bl2 = (Boolean)method.invoke((Object)component, keyStroke, keyEvent, 2, bl);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                }
                if (bl2 || keyEvent.isConsumed()) {
                    return bl2;
                }
                component = ResizableFrame.this.getRoutingComponent();
                if (component == null) {
                    return false;
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(component, keyEvent);
                return keyEvent.isConsumed();
            }
        };
        this.setContentPane(this._resizablePanel);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ResizableFrame.this._resizablePanel.setSize(ResizableFrame.this.getSize());
            }
        });
    }

    protected void beginResizing() {
    }

    protected void resizing() {
    }

    protected void endResizing() {
    }

    public void setBorder(Border border) {
        this._resizablePanel.setBorder(border);
    }

    public Border getBorder() {
        return this._resizablePanel.getBorder();
    }

    public Resizable getResizable() {
        return this._resizablePanel.getResizable();
    }

    public Component getRoutingComponent() {
        return this.getOwner();
    }

    public void setRoutingKeyStrokes(boolean bl) {
        this.b = bl;
    }

    public boolean isRoutingKeyStrokes() {
        return this.b;
    }
}

