/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Contour;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSplitPaneLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JideSplitPane
extends JPanel
implements ContainerListener,
ComponentListener,
Accessible {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String PROPERTY_DIVIDER_LOCATION = "dividerLocation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String GRIPPER_PROPERTY = "gripper";
    public static final String PROPORTIONAL_LAYOUT_PROPERTY = "proportionalLayout";
    public static final String PROPORTIONS_PROPERTY = "proportions";
    public static final String PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED = "heavyweightComponentEnabled";
    private int d;
    private int r = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    private HeavyweightWrapper l;
    private boolean h = false;
    private Container m;
    private boolean c = false;
    private boolean q = false;
    private double[] o;
    private boolean j = true;
    private boolean f = false;
    public WindowAdapter _windowDeactivatedListener;
    private int i = 0;
    private boolean n = true;
    private boolean p = false;
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    private boolean g = false;
    private int k = 8;
    private ImageIcon s = null;
    private ImageIcon e = null;

    public JideSplitPane() {
        this(1);
    }

    public JideSplitPane(int n2) {
        this.d = n2;
        if (this.d != 1 && this.d != 0) {
            throw new IllegalArgumentException("cannot create JideSplitPane, orientation must be one of JideSplitPane.HORIZONTAL_SPLIT or JideSplitPane.VERTICAL_SPLIT");
        }
        JideSplitPaneLayout jideSplitPaneLayout = this.d == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        super.setLayout(jideSplitPaneLayout);
        this.setOpaque(false);
        this.b();
    }

    public int getDividerStepSize() {
        return this.i;
    }

    public void setDividerStepSize(int n2) {
        if (n2 < 0) {
            return;
        }
        this.i = n2;
    }

    public void updateUI() {
        if (UIDefaultsLookup.get("JideSplitPane.dividerSize") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
    }

    private void b() {
        this.addContainerListener(this);
    }

    public void setDividerSize(int n2) {
        int n3 = this.r;
        if (n3 != n2) {
            this.r = n2;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, n3, n2);
            this.invalidate();
        }
    }

    public int getDividerSize() {
        return this.r;
    }

    public Component insertPane(Component component, int n2) {
        return this.insertPane(component, null, n2);
    }

    public Component insertPane(Component component, Object object, int n2) {
        if (n2 <= 0) {
            this.addImpl(component, object, 0);
        } else if (n2 >= this.getPaneCount()) {
            this.addImpl(component, object, -1);
        } else {
            this.addImpl(component, object, (n2 << 1) - 1);
        }
        return component;
    }

    public Component addPane(Component component) {
        if (component == null) {
            return null;
        }
        return super.add(component);
    }

    public void removePane(Component component) {
        this.removePane(this.indexOfPane(component));
    }

    public void setPaneAt(Component component, int n2) {
        this.setPaneAt(component, null, n2);
    }

    public void setPaneAt(Component component, Object object, int n2) {
        double[] dArray = this.o;
        this.o = null;
        this.removePane(n2);
        this.insertPane(component, object, n2);
        this.o = dArray;
        this.validate();
    }

    public void removePane(int n2) {
        if (n2 == 0) {
            super.remove(0);
        } else {
            super.remove(n2 << 1);
        }
    }

    public void setOrientation(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("JideSplitPane: orientation must be one of JideSplitPane.VERTICAL_SPLIT or JideSplitPane.HORIZONTAL_SPLIT");
        }
        if (this.d == n2) {
            return;
        }
        int n3 = this.d;
        this.d = n2;
        JideSplitPaneLayout jideSplitPaneLayout = this.d == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        Component[] componentArray = this.getComponents();
        LayoutManager layoutManager = this.getLayout();
        Map<Component, Object> map = null;
        if (layoutManager instanceof JideSplitPaneLayout) {
            map = ((JideSplitPaneLayout)layoutManager).getConstraintMap();
        }
        if (componentArray != null && map != null) {
            for (Component component : componentArray) {
                jideSplitPaneLayout.addLayoutComponent(component, map.get(component));
            }
        }
        super.setLayout(jideSplitPaneLayout);
        this.doLayout();
        this.firePropertyChange(ORIENTATION_PROPERTY, n3, n2);
    }

    public int getOrientation() {
        return this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetToPreferredSizes() {
        if (this.getLayout() instanceof JideBoxLayout) {
            boolean bl = ((JideBoxLayout)this.getLayout()).isResetWhenInvalidate();
            try {
                ((JideBoxLayout)this.getLayout()).setResetWhenInvalidate(true);
                ((JideBoxLayout)this.getLayout()).invalidateLayout(this);
            }
            finally {
                ((JideBoxLayout)this.getLayout()).setResetWhenInvalidate(bl);
            }
        }
        this.doLayout();
    }

    public void setProportionalLayout(boolean bl) {
        if (bl == this.q) {
            return;
        }
        this.q = bl;
        this.revalidate();
        this.firePropertyChange(PROPORTIONAL_LAYOUT_PROPERTY, !bl, bl);
        if (!bl) {
            this.setProportions(null);
        }
    }

    public boolean isProportionalLayout() {
        return this.q;
    }

    void d(double[] dArray) {
        this.o = dArray;
    }

    public void setProportions(double[] dArray) {
        int n2;
        if (!this.q && dArray != null) {
            throw new IllegalStateException("Can't set proportions on a non-proportional split pane");
        }
        if (Arrays.equals(dArray, this.o)) {
            return;
        }
        if (dArray != null && dArray.length != this.getPaneCount() - 1) {
            throw new IllegalArgumentException("Must provide one fewer proportions than there are panes: got " + dArray.length + ", expected " + (this.getPaneCount() - 1));
        }
        if (dArray != null) {
            double d2 = 0.0;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                if (dArray[n2] < 0.0) {
                    dArray[n2] = 0.0;
                }
                if (dArray[n2] > 1.0) {
                    dArray[n2] = 1.0;
                }
                d2 += dArray[n2];
            }
            if (d2 > 1.0) {
                throw new IllegalArgumentException("Sum of proportions must be no more than 1, got " + d2);
            }
        }
        double[] dArray2 = this.o;
        this.o = dArray == null ? null : (double[])dArray.clone();
        LayoutManager layoutManager = this.getLayout();
        n2 = 0;
        if (layoutManager instanceof JideBoxLayout) {
            n2 = ((JideBoxLayout)layoutManager).isResetWhenInvalidate() ? 1 : 0;
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
        }
        this.revalidate();
        if (n2 != 0) {
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(n2 != 0);
        }
        this.firePropertyChange(PROPORTIONS_PROPERTY, dArray2, dArray);
    }

    public double[] getProportions() {
        double[] dArray = this.o;
        if (dArray != null) {
            dArray = (double[])dArray.clone();
        }
        return dArray;
    }

    public void setInitiallyEven(boolean bl) {
        this.j = bl;
    }

    public boolean isInitiallyEven() {
        return this.j;
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected void startDragging(JideSplitPaneDivider jideSplitPaneDivider) {
        if (!this.isContinuousLayout()) {
            Container container = this.getTopLevelAncestor();
            if (this._windowDeactivatedListener == null) {
                this._windowDeactivatedListener = new WindowAdapter(){

                    public void windowDeactivated(WindowEvent windowEvent) {
                        JideSplitPane.this.c();
                        if (windowEvent.getWindow() != null) {
                            windowEvent.getWindow().removeWindowListener(JideSplitPane.this._windowDeactivatedListener);
                        }
                    }
                };
            }
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this._windowDeactivatedListener);
            }
            if (container instanceof RootPaneContainer) {
                Serializable serializable;
                this.m = ((RootPaneContainer)((Object)container)).getLayeredPane();
                if (this.l == null) {
                    serializable = new _c();
                    this.l = new _b((Component)serializable);
                    this.l.setHeavyweight(this.isHeavyweightComponentEnabled());
                }
                this.l.delegateSetCursor(this.d == 1 ? JideSplitPaneDivider.c : JideSplitPaneDivider.i);
                this.l.delegateSetVisible(false);
                this.l.delegateAdd(this.m, JLayeredPane.DRAG_LAYER);
                serializable = this.getVisibleRect();
                Rectangle rectangle = SwingUtilities.convertRectangle(this, (Rectangle)serializable, this.m);
                int n2 = Math.min(4, this.getDividerSize());
                if (this.getOrientation() == 1) {
                    this.l.delegateSetBounds(rectangle.x, rectangle.y, n2, rectangle.height);
                } else {
                    this.l.delegateSetBounds(rectangle.x, rectangle.y, rectangle.width, n2);
                }
            }
        }
    }

    private void c() {
        if (!this.isContinuousLayout() && this.m != null && this.l != null) {
            Component[] componentArray;
            this.l.delegateSetVisible(false);
            this.l.delegateRemove(this.m);
            this.l.delegateSetNull();
            this.l = null;
            for (Component component : componentArray = this.m.getComponents()) {
                if (!(component instanceof _c) && !(component instanceof _b)) continue;
                this.m.remove(component);
            }
        }
    }

    protected void dragDividerTo(JideSplitPaneDivider jideSplitPaneDivider, int n2) {
        if (this.m == null || this.isContinuousLayout()) {
            this.setDividerLocation(jideSplitPaneDivider, n2);
        } else if (this.l != null) {
            Point point;
            Dimension dimension = new Dimension();
            Rectangle rectangle = this.getVisibleRect();
            int n3 = Math.min(4, this.getDividerSize());
            Rectangle rectangle2 = SwingUtilities.convertRectangle(this, rectangle, this.m);
            if (this.getOrientation() == 1) {
                point = SwingUtilities.convertPoint(this, n2, rectangle.y, this.m);
                point.x += this.getDividerSize() - n3 >> 1;
                dimension.width = n3;
                dimension.height = rectangle2.height;
            } else {
                point = SwingUtilities.convertPoint(this, rectangle.x, n2, this.m);
                point.y += this.getDividerSize() - n3 >> 1;
                dimension.width = rectangle2.width;
                dimension.height = n3;
            }
            this.l.delegateSetBounds(new Rectangle(point, dimension));
            this.l.delegateSetVisible(true);
        }
    }

    protected void finishDraggingTo(JideSplitPaneDivider jideSplitPaneDivider, int n2) {
        if (this.isContinuousLayout() || this.l != null) {
            this.c();
            this.setDividerLocation(jideSplitPaneDivider, n2);
        }
    }

    public int indexOfDivider(JideSplitPaneDivider jideSplitPaneDivider) {
        int n2 = this.indexOf(jideSplitPaneDivider);
        if (n2 == -1) {
            return n2;
        }
        if (n2 % 2 == 0) {
            System.err.println("Warning: divider's index is even. (index = " + n2 + ")");
        }
        return (n2 - 1) / 2;
    }

    public int indexOfPane(Component component) {
        int n2 = this.indexOf(component);
        if (n2 == -1) {
            return -1;
        }
        if (n2 % 2 != 0) {
            System.err.println("Warning: pane's index is odd. (index = " + n2 + ")");
        }
        return n2 >> 1;
    }

    public int indexOf(Component component) {
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            if (!this.getComponent(i2).equals(component)) continue;
            return i2;
        }
        return -1;
    }

    public JideSplitPaneDivider getDividerAt(int n2) {
        if (n2 < 0 || n2 * 2 + 1 >= this.getComponentCount()) {
            return null;
        }
        return (JideSplitPaneDivider)this.getComponent(n2 * 2 + 1);
    }

    public Component getPaneAt(int n2) {
        if (n2 < 0 || n2 << 1 >= this.getComponentCount()) {
            return null;
        }
        return this.getComponent(n2 << 1);
    }

    public int getPaneCount() {
        return this.getComponentCount() + 1 >> 1;
    }

    public void setDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, int n2) {
        this.setDividerLocation(this.indexOfDivider(jideSplitPaneDivider), n2);
    }

    public void setDividerLocation(int n2, int n3) {
        ((JideSplitPaneLayout)this.getLayout()).p(n2, n3, true);
        this.validate();
    }

    public int getDividerLocation(int n2) {
        return ((JideSplitPaneLayout)this.getLayout()).m(n2);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        containerEvent.getChild().addComponentListener(this);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.addExtraDividers();
            if (this.isOneTouchExpandable()) {
                containerEvent.getChild().setMinimumSize(new Dimension(0, 0));
            }
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        containerEvent.getChild().removeComponentListener(this);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.removeExtraDividers();
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    protected boolean removeExtraDividers() {
        int n2 = 0;
        if (this.getComponentCount() == 0) {
            if (this.o != null) {
                this.setProportions(null);
            }
            return false;
        }
        boolean bl = false;
        if (this.getComponent(0) instanceof JideSplitPaneDivider) {
            ((JideSplitPaneDivider)this.getComponent(0)).setJideSplitPane(null);
            this.remove(0);
            this.removeProportion(0);
            bl = true;
        }
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component component = this.getComponent(i2);
            if (component instanceof JideSplitPaneDivider) {
                if (++n2 != 2) continue;
                component = this.getComponent(i2 - 1);
                ((JideSplitPaneDivider)component).setJideSplitPane(null);
                this.remove(component);
                if (this.o != null && this.getPaneCount() == this.o.length) {
                    this.removeProportion(i2 / 2);
                }
                bl = true;
                --n2;
                --i2;
                continue;
            }
            n2 = 0;
        }
        if (n2 == 1 && this.getComponent(this.getComponentCount() - 1) instanceof JideSplitPaneDivider) {
            ((JideSplitPaneDivider)this.getComponent(this.getComponentCount() - 1)).setJideSplitPane(null);
            this.remove(this.getComponentCount() - 1);
            this.removeProportion((this.getComponentCount() + 1) / 2);
            bl = true;
        }
        return bl;
    }

    protected void removeProportion(int n2) {
        int n3;
        double d2;
        double[] dArray = this.o;
        if (dArray == null) {
            return;
        }
        if (dArray.length <= 1) {
            this.setProportions(null);
            return;
        }
        double[] dArray2 = new double[dArray.length - 1];
        if (n2 < dArray.length) {
            d2 = dArray[n2];
        } else {
            d2 = 1.0;
            double[] dArray3 = dArray;
            int n4 = dArray3.length;
            for (n3 = 0; n3 < n4; ++n3) {
                double d3 = dArray3[n3];
                d2 -= d3;
            }
        }
        double d4 = 1.0 - d2;
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            int n5 = n3 < n2 ? n3 : n3 + 1;
            dArray2[n3] = dArray[n5] / d4;
        }
        if (dArray2.length == 1) {
            // empty if block
        }
        this.setProportions(dArray2);
    }

    protected void addExtraDividers() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component component = this.getComponent(i2);
            if (!(component instanceof JideSplitPaneDivider)) {
                if (++n2 != 2) continue;
                this.add(this.createSplitPaneDivider(), "fix", i2);
                if (this.o != null && this.getPaneCount() == this.o.length + 2) {
                    this.addProportion((i2 + 1) / 2);
                }
                n2 = 0;
                continue;
            }
            n2 = 0;
        }
    }

    protected void addProportion(int n2) {
        double[] dArray = this.o;
        if (dArray == null) {
            return;
        }
        double[] dArray2 = new double[dArray.length + 1];
        double d2 = 1.0 / (double)(dArray2.length + 1);
        double d3 = 1.0 - d2;
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            if (i2 == n2) {
                dArray2[i2] = d2;
                continue;
            }
            int n3 = i2 < n2 ? i2 : i2 - 1;
            dArray2[i2] = n3 < dArray.length ? dArray[n3] * d3 : d2;
        }
        this.setProportions(dArray2);
    }

    public void setVisible(boolean bl) {
        this.p = false;
        super.setVisible(bl);
    }

    protected void setDividersVisible() {
        boolean bl = false;
        if (this.getComponentCount() == 1) {
            bl = this.getComponent(0).isVisible();
        } else if (this.getComponentCount() > 1) {
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                boolean bl3;
                Component component = this.getComponent(i2);
                if (!(component instanceof JideSplitPaneDivider)) {
                    if (!component.isVisible() || bl) continue;
                    bl = true;
                    continue;
                }
                boolean bl4 = i2 - 1 >= 0 && this.getComponent(i2 - 1).isVisible();
                boolean bl5 = bl3 = i2 + 1 < this.getComponentCount() && this.getComponent(i2 + 1).isVisible();
                if (bl4 && bl3) {
                    component.setVisible(true);
                    continue;
                }
                if (!bl4 && !bl3) {
                    component.setVisible(false);
                    continue;
                }
                if (bl4 && !bl3) {
                    component.setVisible(false);
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    component.setVisible(true);
                    bl2 = false;
                    continue;
                }
                component.setVisible(false);
            }
        }
        if (!bl) {
            super.setVisible(false);
            this.p = true;
        } else if (this.p) {
            super.setVisible(true);
        }
    }

    protected JideSplitPaneDivider createSplitPaneDivider() {
        return new JideSplitPaneDivider(this);
    }

    protected int getPreviousDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl, boolean bl2) {
        int n2 = this.indexOfDivider(jideSplitPaneDivider);
        int n3 = -1;
        if (bl2) {
            if ((n2 + 1) * 2 + 1 <= this.getComponentCount()) {
                int n4 = n2 + 1;
                while (n4 * 2 + 1 < this.getComponentCount()) {
                    if (bl || this.getDividerAt(n4).isVisible()) {
                        n3 = this.d == 1 ? this.getDividerAt((int)n4).getBounds().x : this.getDividerAt((int)n4).getBounds().y;
                        break;
                    }
                    ++n4;
                }
            }
        } else if (n2 > 0) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (!bl && !this.getDividerAt(i2).isVisible()) continue;
                n3 = this.d == 1 ? this.getDividerAt((int)i2).getBounds().x : this.getDividerAt((int)i2).getBounds().y;
                break;
            }
        }
        if (n3 != -1) {
            return n3 + this.getDividerSize();
        }
        return 0;
    }

    public int getNextDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl, boolean bl2) {
        int n2 = this.indexOfDivider(jideSplitPaneDivider);
        int n3 = -1;
        if (!bl2) {
            if ((n2 + 1) * 2 + 1 <= this.getComponentCount()) {
                int n4 = n2 + 1;
                while (n4 * 2 + 1 < this.getComponentCount()) {
                    if (bl || this.getDividerAt(n4).isVisible()) {
                        n3 = this.d == 1 ? this.getDividerAt((int)n4).getBounds().x : this.getDividerAt((int)n4).getBounds().y;
                        break;
                    }
                    ++n4;
                }
            }
        } else if (n2 > 0) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (!bl && !this.getDividerAt(i2).isVisible()) continue;
                n3 = this.d == 1 ? this.getDividerAt((int)i2).getBounds().x : this.getDividerAt((int)i2).getBounds().y;
                break;
            }
        }
        if (n3 != -1) {
            return n3 - this.getDividerSize();
        }
        return this.getOrientation() == 1 ? this.getWidth() - this.getDividerSize() : this.getHeight() - this.getDividerSize();
    }

    public boolean isShowGripper() {
        return this.c;
    }

    public void setShowGripper(boolean bl) {
        boolean bl2 = this.c;
        if (bl2 != bl) {
            this.c = bl;
            this.firePropertyChange(GRIPPER_PROPERTY, bl2, this.c);
        }
    }

    public void doLayout() {
        if (this.removeExtraDividers()) {
            ((JideSplitPaneLayout)this.getLayout()).invalidateLayout(this);
        }
        super.doLayout();
    }

    public boolean isContinuousLayout() {
        return this.h;
    }

    public void setContinuousLayout(boolean bl) {
        boolean bl2 = this.h;
        this.h = bl;
        this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, bl2, bl);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJideSplitPane();
        }
        return this.accessibleContext;
    }

    public boolean isDragResizable() {
        return this.n;
    }

    public void setDragResizable(boolean bl) {
        this.n = bl;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this.f;
    }

    public void setHeavyweightComponentEnabled(boolean bl) {
        boolean bl2 = this.f;
        if (this.f != bl) {
            this.f = bl;
            this.firePropertyChange(PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED, bl2, this.f);
        }
    }

    public void setOneTouchExpandable(boolean bl) {
        boolean bl2 = this.g;
        if (bl2 != bl) {
            this.g = bl;
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
            }
            if (bl) {
                this.setDividerSize(this.k);
            } else {
                this.setDividerSize(UIDefaultsLookup.getInt("JideSplitPane.dividerSize"));
            }
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, bl2, this.g);
            this.revalidate();
            this.repaint();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(false);
            }
        }
    }

    public boolean isOneTouchExpandable() {
        return this.g;
    }

    public void setLeftOneTouchButtonImageIcon(ImageIcon imageIcon) {
        this.s = imageIcon;
    }

    public ImageIcon getLeftOneTouchButtonImageIcon() {
        return this.s;
    }

    public void setRightOneTouchButtonImageIcon(ImageIcon imageIcon) {
        this.e = imageIcon;
    }

    public ImageIcon getRightOneTouchButtonImageIcon() {
        return this.e;
    }

    public void setDividerLocations(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            this.setDividerLocation(i2, n2);
        }
    }

    public int[] getDividerLocations() {
        int n2 = this.getPaneCount();
        if (this.getPaneCount() == 0) {
            return new int[0];
        }
        int[] nArray = new int[n2 - 1];
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            nArray[i2] = this.getDividerLocation(i2);
        }
        return nArray;
    }

    private class _b
    extends HeavyweightWrapper {
        public _b(Component component) {
            super(component);
        }
    }

    private class _c
    extends Contour {
        public _c() {
        }

        public _c(int n2) {
            super(n2);
        }
    }

    protected class AccessibleJideSplitPane
    extends JComponent.AccessibleJComponent {
        private static final long b = -6167624875135108683L;

        protected AccessibleJideSplitPane() {
            super(JideSplitPane.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JideSplitPane.this.getOrientation() == 0) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }
}

