/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.GripperUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.DraggableHandle;
import java.awt.Cursor;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class Gripper
extends JComponent
implements SwingConstants,
Alignable,
DraggableHandle,
UIResource {
    private static final String hc = "GripperUI";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    private boolean lc = false;
    private boolean jc;
    public static final String ROLLOVER_PROPERTY = "ROLLOVER";
    public static final String SELECTED_PROPERTY = "SELECTED";
    private int kc;
    private boolean ic;

    public Gripper() {
        this(0);
    }

    public Gripper(int n2) {
        this.setOrientation(n2);
        this.setFocusable(false);
        this.updateUI();
    }

    public GripperUI getUI() {
        return (GripperUI)this.ui;
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(hc) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    public String getUIClassID() {
        return hc;
    }

    public boolean supportVerticalOrientation() {
        return true;
    }

    public boolean supportHorizontalOrientation() {
        return true;
    }

    public void setOrientation(int n2) {
        int n3 = this.kc;
        if (n3 != n2) {
            this.kc = n2;
            this.firePropertyChange("orientation", n3, n2);
        }
    }

    public int getOrientation() {
        return this.kc;
    }

    public Cursor getCursor() {
        if (this.isEnabled()) {
            return Cursor.getPredefinedCursor(13);
        }
        return super.getCursor();
    }

    public boolean isRolloverEnabled() {
        return this.lc;
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.lc;
        if (bl != bl2) {
            this.lc = bl;
            this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, bl2, this.lc);
            this.repaint();
        }
    }

    public boolean isRollover() {
        return this.jc;
    }

    public void setRollover(boolean bl) {
        boolean bl2 = this.jc;
        if (bl != bl2) {
            this.jc = bl;
            this.firePropertyChange(ROLLOVER_PROPERTY, bl2, bl);
            this.repaint();
        }
    }

    public boolean isSelected() {
        return this.ic;
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.ic;
        if (bl != bl2) {
            this.ic = bl;
            this.firePropertyChange(SELECTED_PROPERTY, bl2, this.ic);
            this.repaint();
        }
    }
}

