/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboBoxSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener,
PopupMenuListener {
    private boolean hb = false;
    private boolean gb = true;

    public ComboBoxSearchable(final JComboBox jComboBox) {
        super(jComboBox);
        jComboBox.setKeySelectionManager(new JComboBox.KeySelectionManager(){

            public int selectionForKey(char c2, ComboBoxModel comboBoxModel) {
                return -1;
            }
        });
        jComboBox.getModel().addListDataListener(this);
        jComboBox.addPropertyChangeListener("model", this);
        jComboBox.addPopupMenuListener(this);
        if (jComboBox.isEditable()) {
            Component component = jComboBox.getEditor().getEditorComponent();
            final JTextField jTextField = (JTextField)component;
            jTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() != '\uffff' && keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 27) {
                        String string = jTextField.getText();
                        ComboBoxModel comboBoxModel = jComboBox.getModel();
                        ListDataListener listDataListener = null;
                        if (comboBoxModel instanceof AbstractListModel) {
                            ListDataListener[] listDataListenerArray;
                            for (ListDataListener listDataListener2 : listDataListenerArray = ((AbstractListModel)((Object)comboBoxModel)).getListDataListeners()) {
                                if (listDataListener2.getClass().toString().indexOf("BasicComboBoxUI") == -1) continue;
                                listDataListener = listDataListener2;
                                comboBoxModel.removeListDataListener(listDataListener2);
                            }
                        }
                        ComboBoxSearchable.this.textChanged(string);
                        if (listDataListener != null) {
                            comboBoxModel.addListDataListener(listDataListener);
                        }
                        if (ComboBoxSearchable.this.isShowPopupDuringSearching()) {
                            if (!jComboBox.getUI().getClass().getName().contains("ExComboBoxUI")) {
                                jComboBox.hidePopup();
                            }
                            jComboBox.showPopup();
                        }
                    }
                }
            });
            this.setSearchableProvider(new SearchableProvider(){

                public String getSearchingText() {
                    return jTextField.getText();
                }

                public boolean isPassive() {
                    return true;
                }

                public void processKeyEvent(KeyEvent keyEvent) {
                }
            });
        }
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JComboBox) {
            ((JComboBox)this._component).getModel().removeListDataListener(this);
            ((JComboBox)this._component).removePopupMenuListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    public boolean isShowPopupDuringSearching() {
        return this.gb;
    }

    public void setShowPopupDuringSearching(boolean bl) {
        this.gb = bl;
    }

    public boolean isRefreshPopupDuringSearching() {
        return this.hb;
    }

    public void setRefreshPopupDuringSearching(boolean bl) {
        this.hb = bl;
    }

    protected void setSelectedIndex(int n2, boolean bl) {
        if (((JComboBox)this._component).getSelectedIndex() != n2) {
            ((JComboBox)this._component).setSelectedIndex(n2);
        }
        if (this.isShowPopupDuringSearching() || this.isRefreshPopupDuringSearching()) {
            if (this._component.getClientProperty("ShrinkSearchableSupport") != null && ((JComboBox)this._component).isPopupVisible()) {
                boolean bl2 = this.isHideSearchPopupOnEvent();
                this.setHideSearchPopupOnEvent(false);
                ((JComboBox)this._component).hidePopup();
                this.setHideSearchPopupOnEvent(bl2);
            }
            try {
                if (!((JComboBox)this._component).isPopupVisible() && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() != null && SwingUtilities.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), this._component)) {
                    ((JComboBox)this._component).showPopup();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected int getSelectedIndex() {
        return ((JComboBox)this._component).getSelectedIndex();
    }

    protected Object getElementAt(int n2) {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getElementAt(n2);
    }

    protected int getElementCount() {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getSize();
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        if (listDataEvent.getIndex0() != -1 || listDataEvent.getIndex1() != -1) {
            this.hidePopup();
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)propertyChangeEvent.getOldValue()).removeListDataListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)propertyChangeEvent.getNewValue()).addListDataListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (this.isHideSearchPopupOnEvent()) {
            this.hidePopup();
        }
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }
}

