/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class TintFilter
extends RGBImageFilter {
    private int d;
    private int h;
    private int c;
    private int g;
    private int b;
    private int e;
    private Insets f;

    public TintFilter(Color color, int n2, int n3, Insets insets) {
        this.d = color.getAlpha();
        this.h = color.getRed();
        this.c = color.getGreen();
        this.g = color.getBlue();
        this.b = n2;
        this.e = n3;
        this.f = insets;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int n2, int n3, int n4) {
        if (this.f != null && (n2 < this.f.left || n2 > this.b - this.f.right - 1 || n3 < this.f.top || n3 > this.e - this.f.bottom - 1)) {
            return n4;
        }
        Color color = new Color(n4, true);
        int n5 = Math.min(Math.max(color.getRed() + color.getRed() * this.h / 100, 0), 255);
        int n6 = Math.min(Math.max(color.getGreen() + color.getGreen() * this.c / 100, 0), 255);
        int n7 = Math.min(Math.max(color.getBlue() + color.getBlue() * this.g / 100, 0), 255);
        int n8 = Math.min(Math.max(color.getAlpha() + color.getAlpha() * this.d / 100, 0), 255);
        return n8 << 24 | n5 << 16 | n6 << 8 | n7;
    }

    public static Image createTintedImage(Image image, Color color, Insets insets) {
        TintFilter tintFilter = new TintFilter(color, image.getWidth(null), image.getHeight(null), insets);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), tintFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }
}

