/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grouper;

import com.jidesoft.grouper.GrouperContext;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.grouper.date.DateMonthGrouper;
import com.jidesoft.grouper.date.DateYearGrouper;
import com.jidesoft.utils.CacheMap;
import com.jidesoft.utils.RegistrationListener;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectGrouperManager {
    private static CacheMap<ObjectGrouper, GrouperContext> e = new CacheMap(GrouperContext.DEFAULT_CONTEXT);
    private static ObjectGrouper f = null;
    private static boolean c = false;
    private static boolean b = false;
    private static boolean d = true;

    public static void registerGrouper(Class<?> clazz, ObjectGrouper objectGrouper, GrouperContext grouperContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter class cannot be null");
        }
        if (grouperContext == null) {
            grouperContext = GrouperContext.DEFAULT_CONTEXT;
        }
        if (ObjectGrouperManager.isAutoInit() && !c && !b) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        e.register(clazz, objectGrouper, grouperContext);
    }

    public static void registerGrouper(Class<?> clazz, ObjectGrouper objectGrouper) {
        ObjectGrouperManager.registerGrouper(clazz, objectGrouper, GrouperContext.DEFAULT_CONTEXT);
    }

    public static void unregisterGrouper(Class<?> clazz, GrouperContext grouperContext) {
        if (grouperContext == null) {
            grouperContext = GrouperContext.DEFAULT_CONTEXT;
        }
        if (ObjectGrouperManager.isAutoInit() && !c && !b) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        e.unregister(clazz, grouperContext);
    }

    public static void unregisterGrouper(Class<?> clazz) {
        ObjectGrouperManager.unregisterGrouper(clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static void unregisterAllGroupers(Class<?> clazz) {
        e.remove(clazz);
    }

    public static void unregisterAllGroupers() {
        e.clear();
    }

    public static ObjectGrouper getGrouper(Class<?> clazz, GrouperContext grouperContext) {
        ObjectGrouper objectGrouper;
        if (ObjectGrouperManager.isAutoInit() && !c && !b) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        if (grouperContext == null) {
            grouperContext = GrouperContext.DEFAULT_CONTEXT;
        }
        if ((objectGrouper = e.getRegisteredObject(clazz, grouperContext)) != null) {
            return objectGrouper;
        }
        return f;
    }

    public static ObjectGrouper getGrouper(Class<?> clazz) {
        return ObjectGrouperManager.getGrouper(clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static Object getGroupValue(Object object) {
        if (object != null) {
            return ObjectGrouperManager.getGroupValue(object, object.getClass(), GrouperContext.DEFAULT_CONTEXT);
        }
        return null;
    }

    public static Object getGroupValue(Object object, Class<?> clazz) {
        return ObjectGrouperManager.getGroupValue(object, clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static Object getGroupValue(Object object, Class<?> clazz, GrouperContext grouperContext) {
        ObjectGrouper objectGrouper = ObjectGrouperManager.getGrouper(clazz, grouperContext);
        if (objectGrouper != null) {
            return objectGrouper.getValue(object);
        }
        return null;
    }

    public static boolean isAutoInit() {
        return d;
    }

    public static void setAutoInit(boolean bl) {
        d = bl;
    }

    public static void addRegistrationListener(RegistrationListener registrationListener) {
        e.addRegistrationListener(registrationListener);
    }

    public static void removeRegistrationListener(RegistrationListener registrationListener) {
        e.removeRegistrationListener(registrationListener);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return e.getRegistrationListeners();
    }

    public static GrouperContext[] getGrouperContexts(Class<?> clazz) {
        return e.getKeys(clazz, (GrouperContext[])new GrouperContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultGrouper() {
        if (c) {
            return;
        }
        b = true;
        try {
            DateYearGrouper dateYearGrouper = new DateYearGrouper();
            ObjectGrouperManager.registerGrouper(Date.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Calendar.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Long.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            DateMonthGrouper dateMonthGrouper = new DateMonthGrouper();
            ObjectGrouperManager.registerGrouper(Date.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Calendar.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Long.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
        }
        finally {
            b = false;
            c = true;
        }
    }

    public static void resetInit() {
        c = false;
    }

    public static void clear() {
        ObjectGrouperManager.resetInit();
        e.clear();
    }
}

