/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.Refocusable;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.plaf.UIResource;

public class Workspace
extends JPanel
implements DockableHolder,
Refocusable {
    private static final Logger ad = Logger.getLogger(DefaultDockingManager.class.getName() + ".focus");
    private DockingManager yc;
    private boolean cd = true;
    private WeakReference<Component> zc;
    private WeakReference<Component> bd;
    private String dd = null;
    private boolean xc = false;

    public Workspace() {
        this((DockingManager)null);
    }

    public Workspace(DockingManager dockingManager) {
        super(new BorderLayout());
        this.setDockingManager(dockingManager);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        JideFocusTracker jideFocusTracker = new JideFocusTracker(this);
        jideFocusTracker.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    Workspace.this.setLastFocusedComponent(focusEvent.getComponent());
                }
            }
        });
        this.setOpaque(false);
        this.updateUI();
    }

    public boolean isAdjustOpacityOnFly() {
        return this.xc;
    }

    public void setAdjustOpacityOnFly(boolean bl) {
        this.xc = bl;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.isOpaque() && this.isAdjustOpacityOnFly() && this.p(this)) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private boolean p(Container container) {
        return container.getComponentCount() == 0 || container.getComponentCount() == 1 && container.getComponent(0) instanceof JideSplitPane && this.p((Container)container.getComponent(0));
    }

    public void updateUI() {
        super.updateUI();
        if (this.getBackground() == null || this.getBackground() instanceof UIResource) {
            this.setBackground(UIDefaultsLookup.getColor("Workspace.background"));
        }
    }

    public boolean isAcceptDockableFrame() {
        return this.cd;
    }

    public void setAcceptDockableFrame(boolean bl) {
        this.cd = bl;
    }

    public boolean requestFocusInInternalWindow() {
        Component component;
        if (this.getDockingManager() == null) {
            ad.fine("Workspace :requestFocusInInternalWindow: returning false DockingManager == null.");
            return false;
        }
        if (this.getComponentCount() == 0) {
            return this.requestFocusInWindow();
        }
        if (this != this.getFocusedComponent() && this.isAncestorOf(component = this.getFocusedComponent()) && JideSwingUtilities.passesFocusabilityTest(component)) {
            return component.requestFocusInWindow();
        }
        component = this.getDefaultFocusComponent();
        if (this != component && this.isAncestorOf(component) && JideSwingUtilities.passesFocusabilityTest(component)) {
            return component.requestFocusInWindow();
        }
        if (!JideSwingUtilities.compositeRequestFocus(this.getComponent(0))) {
            return this.requestFocusInWindow();
        }
        return true;
    }

    public boolean requestFocusInInternalWindowNew() {
        if (this.getDockingManager() == null) {
            return false;
        }
        Component component = this.getFocusedComponent();
        boolean bl = JideSwingUtilities.passesFocusabilityTest(component);
        if (bl) {
            component.requestFocus();
            return true;
        }
        bl = JideSwingUtilities.compositeRequestFocus(this);
        return bl;
    }

    public Component getFocusedComponent() {
        if (this.bd == null) {
            return this.getDefaultFocusComponent();
        }
        return (Component)this.bd.get();
    }

    protected void setLastFocusedComponent(Component component) {
        if (component == this) {
            component = null;
        }
        this.bd = new WeakReference<Component>(component);
    }

    public Component getDefaultFocusComponent() {
        return this.zc != null ? (Component)this.zc.get() : null;
    }

    public void setDefaultFocusComponent(Component component) {
        this.zc = new WeakReference<Component>(component);
    }

    protected void addImpl(Component component, Object object, int n2) {
        if (!(component instanceof ContainerContainer)) {
            this.setAcceptDockableFrame(false);
        }
        super.addImpl(component, object, n2);
    }

    public void setDockingManager(DockingManager dockingManager) {
        this.yc = dockingManager;
    }

    public DockingManager getDockingManager() {
        return this.yc;
    }

    public String getLayoutConstraint() {
        if (this.dd == null || !"vary".equals(this.dd) && !"flexible".equals(this.dd) && !"fix".equals(this.dd)) {
            return SecurityUtils.getProperty("jide.workspaceConstraints", "vary");
        }
        return this.dd;
    }

    public void setLayoutConstraint(String string) {
        this.dd = string;
    }
}

