/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.h;
import com.jidesoft.docking.k;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public class FrameFloatingContainer
extends ResizableFrame
implements FloatingContainer {
    private final DockingManager sg;
    private final FloatingContainer.FloatingContainerManager rg;
    private int qg = 0;

    FrameFloatingContainer() throws HeadlessException {
        this((DockingManager)null, (FloatingContainer.FloatingContainerManager)null);
    }

    public FrameFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager) throws HeadlessException {
        this(dockingManager, floatingContainerManager, "");
    }

    public FrameFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, String string) throws HeadlessException {
        super(string);
        this.sg = dockingManager;
        this.rg = floatingContainerManager;
        this.setName("Dialog");
        this.setFocusableWindowState(true);
        this.setFocusCycleRoot(true);
        this.setRoutingKeyStrokes(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.initListeners();
        this.resetDockID();
    }

    protected void initListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                super.windowActivated(windowEvent);
                if (!(windowEvent.getOppositeWindow() instanceof FloatingContainer) && FrameFloatingContainer.this.rg != null) {
                    FrameFloatingContainer.this.rg.floatingFrameActivated(windowEvent);
                }
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                super.windowDeactivated(windowEvent);
                if (FrameFloatingContainer.this.rg != null) {
                    FrameFloatingContainer.this.rg.floatingFrameDeactivated(windowEvent);
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                FrameFloatingContainer.this.doHideFloatingFrame();
            }

            public void windowClosed(WindowEvent windowEvent) {
                super.windowClosed(windowEvent);
                FrameFloatingContainer.this.doHideFloatingFrame();
            }
        });
    }

    protected void doHideFloatingFrame() {
        DockableFrame dockableFrame;
        if (this.getDockingManager() == null || !this.getDockingManager().isHidable()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        DockableFrame dockableFrame2 = this.getDockingManager().getFrame(this.getDockingManager().getActiveFrameKey());
        if (dockableFrame2 != null && SwingUtilities.isDescendingFrom(dockableFrame2, this) && !dockableFrame2.isHidden() && dockableFrame2.isHidable() && !dockableFrame2.shouldVetoHiding() && !arrayList.contains(dockableFrame2.getKey())) {
            arrayList.add(dockableFrame2.getKey());
        }
        List<String> list = this.getDockingManager().getAllFrameNames();
        for (String string : list) {
            dockableFrame = this.getDockingManager().getFrame(string);
            if (dockableFrame == null || !SwingUtilities.isDescendingFrom(dockableFrame, this) || dockableFrame.isHidden() || !dockableFrame.isHidable() || dockableFrame.shouldVetoHiding() || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.hide"));
            for (String string : arrayList) {
                dockableFrame = this.getDockingManager().getFrame(string);
                if (dockableFrame == null || dockableFrame.getCloseAction() == null || !dockableFrame.getCloseAction().isEnabled()) continue;
                ActionEvent actionEvent = new ActionEvent(this, 1001, "hiddenByParentContainer");
                dockableFrame.getCloseAction().actionPerformed(actionEvent);
            }
        }
    }

    public boolean hasTitleBar() {
        return !this.isUndecorated() || UIManager.getLookAndFeel().getSupportsWindowDecorations() && this.getRootPane().getWindowDecorationStyle() != 0;
    }

    public Rectangle getInitialBounds(Rectangle rectangle) {
        return rectangle;
    }

    public void updateUndecorated() {
        boolean bl = false;
        boolean bl2 = this.isVisible();
        if (k.tb(this.getDockingManager(), this.getContentPane())) {
            if (!JFrame.isDefaultLookAndFeelDecorated() && this.isUndecorated()) {
                bl = true;
                this.setVisible(false);
                this.setUndecorated(false);
                this.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder()));
            }
            if (this.isUndecorated()) {
                this.getRootPane().setWindowDecorationStyle(1);
            } else {
                this.getRootPane().setWindowDecorationStyle(0);
            }
        } else {
            if (JFrame.isDefaultLookAndFeelDecorated() && this.isUndecorated()) {
                bl = true;
                this.setVisible(false);
                this.setUndecorated(true);
                this.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
            }
            this.getRootPane().setWindowDecorationStyle(0);
        }
        if (bl) {
            this.updateBorders();
        }
        if (this.getDockingManager().getMainContainer().isShowing() && (bl2 || !this.getDockingManager().isUseDecoratedFloatingContainer())) {
            this.setVisible(true);
        }
        this.updateTitle();
    }

    public void updateBorders() {
        if (k.tb(this.getDockingManager(), this.getContentPane())) {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            k.qb(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.border");
            k.jb(this.getContentPane(), border);
            this.getResizable().setResizableCorners(0);
            if (this.sg.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        } else {
            Border border = new BorderUIResource(BorderFactory.createEmptyBorder());
            k.qb(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.floatingBorder");
            k.jb(this.getContentPane(), border);
            this.getResizable().setResizableCorners(255);
            if (this.sg.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        }
    }

    public Component getRoutingComponent() {
        return this.sg.getMainContainer();
    }

    public DockingManager getDockingManager() {
        return this.sg;
    }

    public Component asComponent() {
        return this;
    }

    public void hideItselfIfEmpty() {
        List<DockableFrame> list = k.ac(this.getContentPane());
        if (list == null || list.size() == 0) {
            this.setVisible(false);
        }
    }

    public void updateTitle() {
        Component[] componentArray = this.getContentPane().getComponents();
        Component component = null;
        for (Component component2 : componentArray) {
            if (!(component2 instanceof ContainerContainer) && !(component2 instanceof FrameContainer)) continue;
            if (component == null) {
                component = component2;
                continue;
            }
            component = null;
            break;
        }
        Object object = null;
        int n2 = 0;
        if (component != null) {
            if (component instanceof ContainerContainer) {
                Component component2;
                List<Component> list = k.p((ContainerContainer)component);
                n2 = list.size();
                if (n2 == 1) {
                    component2 = list.get(0);
                    if (component2 instanceof DockableFrame) {
                        object = ((DockableFrame)component2).getTitle();
                    }
                } else if (n2 > 1 && (component2 = list.get(0)) instanceof DockableFrame) {
                    object = ((DockableFrame)component2).getTitle();
                }
            } else {
                n2 = ((FrameContainer)component).getTabCount();
                if (n2 == 1) {
                    object = ((FrameContainer)component).getSelectedFrame() == null ? "" : ((FrameContainer)component).getSelectedFrame().getTitle();
                } else if (n2 > 1) {
                    object = ((FrameContainer)component).getFrame(0).getTitle();
                }
            }
        }
        if (object == null) {
            object = "";
        } else {
            String string = new File((String)object).getName();
            if (string.equals(object)) {
                object = "[#] " + (String)object;
                if (n2 > 1) {
                    object = (String)object + " (" + n2 + ")";
                }
            } else {
                object = "[#] " + string + " [" + (String)object + "]";
                if (n2 > 1) {
                    object = (String)object + " (" + n2 + ")";
                }
            }
        }
        if (!((String)object).equals(this.getTitle())) {
            this.setTitle((String)object);
        }
    }

    public int getDockID() {
        return this.qg;
    }

    public void setDockID(int n2) {
        this.qg = n2;
    }

    public void resetDockID() {
        this.qg = -1;
        if (this.sg != null) {
            this.qg = h.f(this.sg).h(this.getDockID());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getMostRecentFocusOwner() {
        Component component;
        if (this.getContentPane().getComponentCount() < 1) return super.getMostRecentFocusOwner();
        Component component2 = this.getContentPane().getComponent(0);
        List<Component> list = null;
        if (component2 instanceof ContainerContainer) {
            list = k.p((ContainerContainer)component2);
        } else if (component2 instanceof FrameContainer) {
            list = k.pc((FrameContainer)component2);
        }
        if (list == null || list.size() <= 0 || !((component = list.get(0)) instanceof DockableFrame)) return super.getMostRecentFocusOwner();
        DockableFrame dockableFrame = (DockableFrame)component;
        Container container = dockableFrame.getParent();
        if (container != null && container instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)container;
            DockableFrame dockableFrame2 = frameContainer.getSelectedFrame();
            if (dockableFrame2 == null) return frameContainer;
            Component component3 = dockableFrame2.getFocusedComponent();
            if (component3 == null || component3 == dockableFrame2) {
                component3 = dockableFrame2.getDefaultFocusComponent();
            }
            if (component3 == dockableFrame2) return super.getMostRecentFocusOwner();
            return component3;
        }
        Component component4 = dockableFrame.getFocusedComponent();
        if (component4 == dockableFrame) {
            component4 = dockableFrame.getDefaultFocusComponent();
        }
        if (component4 == dockableFrame) return super.getMostRecentFocusOwner();
        return component4;
    }

    public void setResizable(boolean bl) {
        super.setResizable(bl);
        this.getResizable().setResizableCorners(bl ? 255 : 0);
    }

    protected void beginResizing() {
        this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.resizing"));
        super.beginResizing();
    }
}

