/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.utils.ReflectionUtils;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConverter
implements ObjectConverter {
    private String p;
    private Object n;
    private Class<?> q;
    private Object[] r;
    private String[] t;
    private boolean s = true;
    private transient ConverterContext o;

    public EnumConverter(Class<? extends Enum> clazz) {
        if (clazz == null || !clazz.isEnum()) {
            throw new IllegalArgumentException("To use this constructor, the type has to be an enum type.");
        }
        String string = clazz.getName();
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Empty enum type name.");
        }
        int n2 = string.lastIndexOf("$");
        this.p = n2 >= 0 ? string.substring(n2 + 1) : string;
        this.q = clazz;
        try {
            Object object = ReflectionUtils.callStatic(clazz, "values", null, null);
            if (!object.getClass().isArray()) {
                throw new IllegalArgumentException("Illegal enum type.");
            }
            int n3 = Array.getLength(object);
            this.r = new Object[n3];
            this.t = new String[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                this.r[i2] = Array.get(object, i2);
                this.t[i2] = "" + this.r[i2];
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Illegal enum type.");
        }
    }

    public EnumConverter(String string, Object[] objectArray, String[] stringArray) {
        this(string, objectArray[0] == null ? (objectArray.length > 1 ? objectArray[1].getClass() : Object.class) : objectArray[0].getClass(), objectArray, stringArray);
    }

    public EnumConverter(String string, Class<?> clazz, Object[] objectArray, String[] stringArray) {
        this(string, clazz, objectArray, stringArray, null);
    }

    public EnumConverter(String string, Class<?> clazz, Object[] objectArray, String[] stringArray, Object object) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null or empty. Please use a unique string to represent the name of the converter.");
        }
        this.p = string;
        if (objectArray == null) {
            throw new IllegalArgumentException("The \"objects\" parameter cannot be null.");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("The \"strings\" parameter cannot be null.");
        }
        if (stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("The \"objects\" and \"strings\" parameters should have the same length.");
        }
        this.q = clazz;
        this.r = objectArray;
        this.t = stringArray;
        this.n = object;
    }

    public ConverterContext getContext() {
        if (this.o == null) {
            this.o = new ConverterContext(this.p);
        }
        return this.o;
    }

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        for (int i2 = 0; i2 < this.r.length; ++i2) {
            if ((this.r[i2] != null || object != null) && (this.r[i2] == null || !this.r[i2].equals(object)) || i2 >= this.t.length) continue;
            return this.t[i2];
        }
        return this.isStrict() ? null : "" + object;
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        for (int i2 = 0; i2 < this.t.length; ++i2) {
            if (!this.t[i2].equals(string) || i2 >= this.r.length) continue;
            return this.r[i2];
        }
        return this.isStrict() ? this.n : string;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public String getName() {
        return this.p;
    }

    public Class<?> getType() {
        return this.q;
    }

    public Object getDefault() {
        return this.n;
    }

    public Object[] getObjects() {
        return this.r;
    }

    public String[] getStrings() {
        return this.t;
    }

    public static String[] toStrings(Object[] objectArray) {
        return EnumConverter.toStrings(objectArray, null);
    }

    public static String[] toStrings(Object[] objectArray, ConverterContext converterContext) {
        String[] stringArray = new String[objectArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = ObjectConverterManager.toString(objectArray[i2], objectArray[i2].getClass(), converterContext);
        }
        return stringArray;
    }

    public boolean isStrict() {
        return this.s;
    }

    public void setStrict(boolean bl) {
        this.s = bl;
    }
}

