/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.AlphanumComparator;
import com.jidesoft.comparator.BooleanComparator;
import com.jidesoft.comparator.CalendarComparator;
import com.jidesoft.comparator.CharSequenceComparator;
import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.DateComparator;
import com.jidesoft.comparator.DefaultComparator;
import com.jidesoft.comparator.FastComparableComparator;
import com.jidesoft.comparator.NumberComparator;
import com.jidesoft.utils.CacheMap;
import com.jidesoft.utils.RegistrationListener;
import java.text.Collator;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectComparatorManager {
    private static final CacheMap<Comparator<?>, ComparatorContext> f = new CacheMap(new ComparatorContext(""));
    private static final Comparator<Object> c = new DefaultComparator();
    private static boolean d = false;
    private static boolean b = false;
    private static boolean e = true;

    public static void registerComparator(Class<?> clazz, Comparator comparator) {
        ObjectComparatorManager.registerComparator(clazz, comparator, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static void registerComparator(Class<?> clazz, Comparator comparator, ComparatorContext comparatorContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        if (comparatorContext == null) {
            comparatorContext = ComparatorContext.DEFAULT_CONTEXT;
        }
        if (ObjectComparatorManager.isAutoInit() && !d && !b) {
            ObjectComparatorManager.initDefaultComparator();
        }
        f.register(clazz, comparator, comparatorContext);
    }

    public static void unregisterComparator(Class<?> clazz) {
        ObjectComparatorManager.unregisterComparator(clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static void unregisterComparator(Class<?> clazz, ComparatorContext comparatorContext) {
        if (comparatorContext == null) {
            comparatorContext = ComparatorContext.DEFAULT_CONTEXT;
        }
        if (ObjectComparatorManager.isAutoInit() && !d && !b) {
            ObjectComparatorManager.initDefaultComparator();
        }
        f.unregister(clazz, comparatorContext);
    }

    public static void unregisterAllComparators(Class<?> clazz) {
        f.remove(clazz);
    }

    public static void unregisterAllComparators() {
        f.clear();
    }

    public static Comparator getComparator(Class<?> clazz) {
        return ObjectComparatorManager.getComparator(clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static Comparator getComparator(Class<?> clazz, ComparatorContext comparatorContext) {
        Comparator<?> comparator;
        if (ObjectComparatorManager.isAutoInit() && !d && !b) {
            ObjectComparatorManager.initDefaultComparator();
        }
        if (comparatorContext == null) {
            comparatorContext = ComparatorContext.DEFAULT_CONTEXT;
        }
        if ((comparator = f.getRegisteredObject(clazz, comparatorContext)) != null) {
            return comparator;
        }
        return c;
    }

    public static int compare(Object object, Object object2) {
        return ObjectComparatorManager.compare(object, object2, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static int compare(Object object, Object object2, ComparatorContext comparatorContext) {
        Class<?> clazz;
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Class<?> clazz2 = object.getClass();
        Class<Object> clazz3 = clazz2 == (clazz = object2.getClass()) ? clazz2 : (clazz2.isAssignableFrom(clazz) ? clazz2 : (clazz.isAssignableFrom(clazz2) ? clazz : (clazz2.isAssignableFrom(Comparable.class) && clazz.isAssignableFrom(Comparable.class) ? Comparable.class : Object.class)));
        return ObjectComparatorManager.compare(object, object2, clazz3, comparatorContext);
    }

    public static int compare(Object object, Object object2, Class<?> clazz) {
        return ObjectComparatorManager.compare(object, object2, clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static int compare(Object object, Object object2, Class<?> clazz, ComparatorContext comparatorContext) {
        Comparator comparator = ObjectComparatorManager.getComparator(clazz, comparatorContext);
        if (comparator != null) {
            try {
                return comparator.compare(object, object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return object.toString().compareTo(object2.toString());
    }

    public static boolean isAutoInit() {
        return e;
    }

    public static void setAutoInit(boolean bl) {
        e = bl;
    }

    public static void addRegistrationListener(RegistrationListener registrationListener) {
        f.addRegistrationListener(registrationListener);
    }

    public static void removeRegistrationListener(RegistrationListener registrationListener) {
        f.removeRegistrationListener(registrationListener);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return f.getRegistrationListeners();
    }

    public static ComparatorContext[] getComparatorContexts(Class<?> clazz) {
        return f.getKeys(clazz, (ComparatorContext[])new ComparatorContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultComparator() {
        if (d) {
            return;
        }
        b = true;
        try {
            ObjectComparatorManager.registerComparator(Object.class, new DefaultComparator());
            ObjectComparatorManager.registerComparator(Boolean.class, new BooleanComparator());
            ObjectComparatorManager.registerComparator(Calendar.class, new CalendarComparator());
            ObjectComparatorManager.registerComparator(Date.class, new DateComparator());
            NumberComparator numberComparator = new NumberComparator();
            ObjectComparatorManager.registerComparator(Number.class, numberComparator);
            ObjectComparatorManager.registerComparator(Double.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Float.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Long.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Integer.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Short.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Byte.TYPE, numberComparator);
            NumberComparator numberComparator2 = new NumberComparator();
            numberComparator2.setAbsolute(true);
            ObjectComparatorManager.registerComparator(Number.class, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Double.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Float.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Long.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Integer.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Short.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Byte.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Comparable.class, new FastComparableComparator());
            ObjectComparatorManager.registerComparator(String.class, Collator.getInstance());
            Collator collator = Collator.getInstance();
            collator.setStrength(0);
            ObjectComparatorManager.registerComparator(String.class, collator, new ComparatorContext("Ignorecase"));
            Collator collator2 = Collator.getInstance();
            collator2.setStrength(1);
            ObjectComparatorManager.registerComparator(String.class, collator2, new ComparatorContext("Secondary"));
            ObjectComparatorManager.registerComparator(CharSequence.class, new CharSequenceComparator(), CharSequenceComparator.CONTEXT);
            ObjectComparatorManager.registerComparator(CharSequence.class, new CharSequenceComparator(false), CharSequenceComparator.CONTEXT_IGNORE_CASE);
            ObjectComparatorManager.registerComparator(CharSequence.class, new AlphanumComparator(), AlphanumComparator.CONTEXT);
            ObjectComparatorManager.registerComparator(CharSequence.class, new AlphanumComparator(false), AlphanumComparator.CONTEXT_IGNORE_CASE);
        }
        finally {
            b = false;
            d = true;
        }
    }

    public static void resetInit() {
        d = false;
    }

    public static void clear() {
        ObjectComparatorManager.resetInit();
        f.clear();
    }
}

