/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class JreLocator {
    public static final int DEFAULT_TIMEOUT = 15000;
    private static final String PRODUCT_ID = "productVersion=";
    private static final String PLATFORM_ID = "platformVersion=";

    public static JREInfo getVersion(File file) {
        return JreLocator.getVersion(file, 15000);
    }

    public static JREInfo getVersion(File file, int n) {
        String string = Environment.getDeploymentHomePath() + File.separator + "lib" + File.separator + "deploy.jar";
        String[] stringArray = JreLocator.execute(new String[]{file.getPath(), "-classpath", string, JreLocator.class.getName()}, n);
        JREInfo jREInfo = null;
        if (stringArray != null) {
            jREInfo = JreLocator.extractVersion(file.getPath(), stringArray[0]);
            if (jREInfo == null) {
                jREInfo = JreLocator.extractVersion(file.getPath(), stringArray[1]);
            }
            if (jREInfo != null && jREInfo.getPlatform().equals("1.2") && (stringArray = JreLocator.execute(new String[]{file.getPath(), "-fullversion"}, n)) != null && (jREInfo = JreLocator.extractVersionFor12(file.getPath(), stringArray[0])) == null) {
                jREInfo = JreLocator.extractVersionFor12(file.getPath(), stringArray[1]);
            }
        }
        if (Trace.isEnabled(TraceLevel.BASIC)) {
            Trace.println("\tjre search returning: " + jREInfo, TraceLevel.BASIC);
        }
        return jREInfo;
    }

    private static String[] execute(String[] stringArray, int n) {
        Process process = null;
        boolean bl = false;
        Trace.println("jre search executing", TraceLevel.BASIC);
        for (int i = 0; i < stringArray.length; ++i) {
            Trace.println(i + ": " + stringArray[i], TraceLevel.BASIC);
        }
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            bl = true;
        }
        int n2 = -1;
        int n3 = n / 100;
        while (!bl) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                n2 = process.exitValue();
                bl = true;
                Trace.println("\tfinished executing " + n2, TraceLevel.BASIC);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (--n3 != 0) continue;
                bl = true;
                Trace.println("\tfailed " + n2, TraceLevel.BASIC);
                process.destroy();
            }
        }
        if (bl && n2 == 0) {
            String[] stringArray2 = new String[]{JreLocator.readFromStream(process.getErrorStream()), JreLocator.readFromStream(process.getInputStream())};
            Trace.println("result: " + stringArray2[0], TraceLevel.BASIC);
            Trace.println("result: " + stringArray2[1], TraceLevel.BASIC);
            return stringArray2;
        }
        return null;
    }

    private static String readFromStream(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            byte[] byArray = new byte[80];
            boolean bl = false;
            while (!bl) {
                int n = inputStream.read(byArray, 0, 80);
                if (n == -1) {
                    bl = true;
                    continue;
                }
                if (n <= 0) continue;
                stringBuffer.append(new String(byArray, 0, n));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private static JREInfo extractVersion(String string, String string2) {
        String string3 = JreLocator.extractString(PLATFORM_ID, string2);
        String string4 = JreLocator.extractString(PRODUCT_ID, string2);
        if (string3 != null && string4 != null) {
            return new JREInfo(string3, string4, null, string, null, Config.getOSName(), Config.getOSArch(), true, false);
        }
        return null;
    }

    private static String extractString(String string, String string2) {
        int n = string2.indexOf(string);
        if (n != -1) {
            int n2 = string2.indexOf(10, n);
            String string3 = n2 != -1 ? string2.substring(n + string.length(), n2) : string2.substring(n + string.length());
            if (string3.length() > 0 && string3.charAt(string3.length() - 1) == '\r') {
                string3 = string3.substring(0, string3.length() - 1);
            }
            return string3;
        }
        return null;
    }

    private static JREInfo extractVersionFor12(String string, String string2) {
        int n;
        int n2 = string2.indexOf("1.2");
        int n3 = string2.length();
        if (n2 != -1 && n2 < n3 - 1 && (n = string2.indexOf(34, n2)) != -1) {
            String string3 = string2.substring(n2, n);
            return new JREInfo("1.2", string3, null, string, null, Config.getOSName(), Config.getOSArch(), true, false);
        }
        return null;
    }

    private static String getClassPath(File file) {
        File file2 = file;
        if ((file2 = file2.getParentFile()) != null && (file2 = file2.getParentFile()) != null && (file2 = new File(file2, "lib")) != null && file2.exists() && (file2 = new File(file2, "classes.zip")) != null && file2.exists()) {
            return JreLocator.getThisPath() + File.pathSeparator + file2.getPath();
        }
        return JreLocator.getThisPath();
    }

    public static void main(String[] stringArray) {
        JreLocator.write(PLATFORM_ID, System.getProperty("java.specification.version"));
        JreLocator.write(PRODUCT_ID, System.getProperty("java.version"));
    }

    private static void write(String string, String string2) {
        if (string2 != null) {
            System.out.println(string + string2);
        }
    }

    private static String getThisPath() {
        return Environment.getDeploymentHomePath() + File.separator + "lib" + File.separator + "javaws.jar";
    }
}

