/* libmutter.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Meta", gir_namespace = "Meta", gir_version = "3.0", lower_case_cprefix = "meta_")]
namespace Meta {
	namespace Prefs {
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void add_listener (Meta.PrefsChangedFunc func);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool bell_is_audible ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void change_workspace_name (int i, string name);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.TitlebarAction get_action_double_click_titlebar ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.TitlebarAction get_action_middle_click_titlebar ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.TitlebarAction get_action_right_click_titlebar ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_attach_modal_dialogs ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_auto_maximize ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_auto_raise ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_auto_raise_delay ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static Meta.ButtonLayout get_button_layout ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_center_new_windows ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static uint get_check_alive_timeout ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_compositing_manager ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_cursor_size ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static unowned string get_cursor_theme ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_disable_workarounds ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_drag_threshold ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_draggable_border_width ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_dynamic_workspaces ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_edge_tiling ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_focus_change_on_pointer_rest ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.FocusMode get_focus_mode ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.FocusNewWindows get_focus_new_windows ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_force_fullscreen ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_gnome_accessibility ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_gnome_animations ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static Meta.KeyBindingAction get_keybinding_action (string name);
#if HAS_MUTTER45
		[CCode (cheader_filename = "meta/prefs.h")]
		public static string? get_keybinding_label (string name);
#endif
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_mouse_button_menu ();
		[CCode (cheader_filename = "meta/prefs.h")]
#if HAS_MUTTER44
		public static Clutter.ModifierType get_mouse_button_mods ();
#else
		public static Meta.VirtualModifier get_mouse_button_mods ();
#endif
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_mouse_button_resize ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static int get_num_workspaces ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_raise_on_click ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_show_fallback_app_menu ();
#if !HAS_MUTTER45
		[CCode (cheader_filename = "meta/prefs.h")]
		public static unowned Pango.FontDescription get_titlebar_font ();
#endif
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_visual_bell ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static GDesktop.VisualBellType get_visual_bell_type ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static unowned string get_workspace_name (int i);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static bool get_workspaces_only_on_primary ();
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void remove_listener (Meta.PrefsChangedFunc func);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void set_force_fullscreen (bool whether);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void set_num_workspaces (int n_workspaces);
		[CCode (cheader_filename = "meta/prefs.h")]
		public static void set_show_fallback_app_menu (bool whether);
	}
	namespace Util {
		[CCode (cheader_filename = "meta/util.h", cname = "meta_add_verbose_topic")]
		public static void add_verbose_topic (Meta.DebugTopic topic);
		[CCode (cheader_filename = "meta/util.h", cname = "meta_bug")]
		public static void bug (string format, ...);
		[CCode (cheader_filename = "meta/util.h", cname = "meta_external_binding_name_for_action")]
		public static string external_binding_name_for_action (uint keybinding_action);
		[CCode (cheader_filename = "meta/util.h", cname = "meta_fatal")]
		public static void fatal (string format, ...);
#if !HAS_MUTTER47
		[CCode (cheader_filename = "meta/util.h", cname = "meta_get_locale_direction")]
		public static Meta.LocaleDirection get_locale_direction ();
#endif
#if !HAS_MUTTER43
		[CCode (cheader_filename = "meta/util.h", cname = "meta_is_syncing")]
		public static bool is_syncing ();
#endif
		[CCode (cheader_filename = "meta/util.h", cname = "meta_is_verbose")]
		public static bool is_verbose ();
		[CCode (cheader_filename = "meta/util.h", cname = "meta_is_wayland_compositor")]
		public static bool is_wayland_compositor ();
#if !HAS_MUTTER44
		[CCode (cheader_filename = "meta/util.h", cname = "meta_later_add")]
		public static uint later_add (Meta.LaterType when, owned GLib.SourceFunc func);
		[CCode (cheader_filename = "meta/util.h", cname = "meta_later_remove")]
		public static void later_remove (uint later_id);
#endif
		[CCode (cheader_filename = "meta/util.h", cname = "meta_pop_no_msg_prefix")]
		public static void pop_no_msg_prefix ();
		[CCode (cheader_filename = "meta/util.h", cname = "meta_push_no_msg_prefix")]
		public static void push_no_msg_prefix ();
		[CCode (cheader_filename = "meta/util.h", cname = "meta_remove_verbose_topic")]
		public static void remove_verbose_topic (Meta.DebugTopic topic);
#if !HAS_MUTTER43
		[CCode (cheader_filename = "meta/util.h", cname = "meta_show_dialog")]
		public static GLib.Pid show_dialog (string type, string message, string? timeout = null, string? display = null, string? ok_text = null, string? cancel_text = null, string? icon_name = null, int transient_for = 0, GLib.SList<string>? columns = null, GLib.SList<string>? entries = null);
#endif
		[CCode (cheader_filename = "meta/util.h", cname = "meta_unsigned_long_equal")]
		public static int ulong_equal ([CCode (type = "gconstpointer")] ulong? v1, [CCode (type = "gconstpointer")] ulong? v2);
		[CCode (cheader_filename = "meta/util.h", cname = "meta_unsigned_long_hash")]
		public static uint ulong_hash ([CCode (type = "gconstpointer")] ulong? v);
		[CCode (cheader_filename = "meta/util.h", cname = "meta_warning")]
		public static void warning (string format, ...);
	}
	[CCode (cheader_filename = "meta/meta-backend.h", type_id = "meta_backend_get_type ()")]
	public abstract class Backend : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Backend ();
#if HAS_MUTTER46
		public void freeze_keyboard (uint32 timestamp);
#endif
#if !HAS_MUTTER44
		[CCode (cheader_filename = "meta/meta-backend.h", cname = "meta_get_backend")]
		public static unowned Meta.Backend get_backend ();
#endif
#if HAS_MUTTER43
		public Meta.BackendCapabilities get_capabilities ();
#endif
		public unowned Meta.Context get_context ();
		public unowned Meta.IdleMonitor get_core_idle_monitor ();
		public unowned Meta.Dnd get_dnd ();
		public unowned Meta.MonitorManager get_monitor_manager ();
#if HAS_MUTTER47
		public unowned Meta.OrientationManager get_orientation_manager ();
#endif
		public unowned Meta.RemoteAccessController get_remote_access_controller ();
		public unowned Meta.Settings get_settings ();
		public unowned Clutter.Actor get_stage ();
		public bool is_headless ();
		public bool is_rendering_hardware_accelerated ();
		public void lock_layout_group (uint idx);
#if HAS_MUTTER46
		public void set_keymap (string layouts, string variants, string options, string model);
		public void unfreeze_keyboard (uint32 timestamp);
		public void ungrab_keyboard (uint32 timestamp);
#else
		public void set_keymap (string layouts, string variants, string options);
#endif
#if HAS_MUTTER43
		public Meta.BackendCapabilities capabilities { get; }
#endif
		public Meta.Context context { get; construct; }
		public signal void keymap_changed ();
		public signal void keymap_layout_group_changed (uint object);
		public signal void last_device_changed (Clutter.InputDevice object);
		public signal void lid_is_closed_changed (bool object);
		public signal void prepare_shutdown ();
	}
	[CCode (cheader_filename = "meta/meta-background.h", type_id = "meta_background_get_type ()")]
	public sealed class Background : GLib.Object {
		[CCode (has_construct_function = false)]
		public Background (Meta.Display display);
		public static void refresh_all ();
		public void set_blend (GLib.File file1, GLib.File file2, double blend_factor, GDesktop.BackgroundStyle style);
#if HAS_MUTTER47
		public void set_color (Cogl.Color color);
#else
		public void set_color (Clutter.Color color);
#endif
		public void set_file (GLib.File? file, GDesktop.BackgroundStyle style);
#if HAS_MUTTER47
		public void set_gradient (GDesktop.BackgroundShading shading_direction, Cogl.Color color, Cogl.Color second_color);
#else
		public void set_gradient (GDesktop.BackgroundShading shading_direction, Clutter.Color color, Clutter.Color second_color);
#endif
		[NoAccessorMethod]
		public Meta.Display meta_display { owned get; construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "meta/meta-background-actor.h", type_id = "meta_background_actor_get_type ()")]
#if HAS_MUTTER46
	public sealed class BackgroundActor : Clutter.Actor, Atk.Implementor, Clutter.Animatable {
#else
	public sealed class BackgroundActor : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
#endif
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public BackgroundActor (Meta.Display display, int monitor);
		[NoAccessorMethod]
		public Meta.Display meta_display { owned get; construct; }
		[NoAccessorMethod]
		public int monitor { get; construct; }
	}
	[CCode (cheader_filename = "meta/meta-background-content.h", type_id = "meta_background_content_get_type ()")]
	public sealed class BackgroundContent : GLib.Object, Clutter.Content {
		[CCode (has_construct_function = false, type = "ClutterContent*")]
		public BackgroundContent (Meta.Display display, int monitor);
		public void set_background (Meta.Background background);
		public void set_gradient (bool enabled, int height, double tone_start);
		public void set_rounded_clip_bounds (Graphene.Rect? bounds);
		public void set_rounded_clip_radius (float radius);
		public void set_vignette (bool enabled, double brightness, double sharpness);
		[NoAccessorMethod]
		public Meta.Background background { owned get; set; }
		[NoAccessorMethod]
		public double brightness { get; set; }
		[NoAccessorMethod]
		public bool gradient { get; set; }
		[NoAccessorMethod]
		public int gradient_height { get; set; }
		[NoAccessorMethod]
		public double gradient_max_darkness { get; set; }
		[NoAccessorMethod]
		public Meta.Display meta_display { owned get; construct; }
		[NoAccessorMethod]
		public int monitor { get; construct; }
		[NoAccessorMethod]
		public float rounded_clip_radius { get; set; }
		[NoAccessorMethod]
		public bool vignette { get; set; }
		[NoAccessorMethod]
		public double vignette_sharpness { get; set; }
	}
	[CCode (cheader_filename = "meta/meta-background-group.h", type_id = "meta_background_group_get_type ()")]
#if HAS_MUTTER46
	public class BackgroundGroup : Clutter.Actor, Atk.Implementor, Clutter.Animatable {
#else
	public class BackgroundGroup : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
#endif
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public BackgroundGroup ();
	}
	[CCode (cheader_filename = "meta/meta-background-image.h", type_id = "meta_background_image_get_type ()")]
	public sealed class BackgroundImage : GLib.Object {
		[CCode (has_construct_function = false)]
		protected BackgroundImage ();
		public bool get_success ();
		public unowned Cogl.Texture get_texture ();
		public bool is_loaded ();
		public signal void loaded ();
	}
	[CCode (cheader_filename = "meta/meta-background-image.h", type_id = "meta_background_image_cache_get_type ()")]
	public sealed class BackgroundImageCache : GLib.Object {
		[CCode (has_construct_function = false)]
		protected BackgroundImageCache ();
		public static unowned Meta.BackgroundImageCache get_default ();
		public Meta.BackgroundImage load (GLib.File file);
		public void purge (GLib.File file);
	}
	[CCode (cheader_filename = "meta/barrier.h", type_id = "meta_barrier_get_type ()")]
#if HAS_MUTTER43
	public class Barrier : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
#if HAS_MUTTER45
		public Barrier (Meta.Backend backend, int x1, int y1, int x2, int y2, Meta.BarrierDirection directions, Meta.BarrierFlags flags) throws GLib.Error;
#else
		public Barrier (Meta.Backend backend, int x1, int y1, int x2, int y2, Meta.BarrierDirection directions) throws GLib.Error;
#endif
#else
	public class Barrier : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Barrier ();
#endif
		public void destroy ();
		public bool is_active ();
		public void release (Meta.BarrierEvent event);
#if HAS_MUTTER43
		[NoAccessorMethod]
		public Meta.Backend backend { owned get; construct; }
#endif
		[NoAccessorMethod]
		public Meta.BarrierDirection directions { get; construct; }
#if !HAS_MUTTER46
		[NoAccessorMethod]
		public Meta.Display display { owned get; construct; }
#endif
#if HAS_MUTTER45
		[NoAccessorMethod]
		public Meta.BarrierFlags flags { get; construct; }
#endif
		[NoAccessorMethod]
		public int x1 { get; construct; }
		[NoAccessorMethod]
		public int x2 { get; construct; }
		[NoAccessorMethod]
		public int y1 { get; construct; }
		[NoAccessorMethod]
		public int y2 { get; construct; }
		public signal void hit (Meta.BarrierEvent event);
		public signal void left (Meta.BarrierEvent event);
	}
	[CCode (cheader_filename = "meta/barrier.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "meta_barrier_event_get_type ()")]
	[Compact]
	public class BarrierEvent {
		public int dt;
		public double dx;
		public double dy;
		public int event_id;
		public bool grabbed;
		public uint ref_count;
		public bool released;
		public uint32 time;
		public double x;
		public double y;
	}
	[CCode (cheader_filename = "meta/compositor.h", type_id = "meta_compositor_get_type ()")]
	public abstract class Compositor : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Compositor ();
#if HAS_MUTTER44
		public unowned Clutter.Actor get_feedback_group ();
#else
		public void add_window (Meta.Window window);
		public void destroy ();
		public bool filter_keybinding (Meta.KeyBinding binding);
		public void flash_display (Meta.Display display);
#endif
		public unowned Meta.Laters get_laters ();
#if !HAS_MUTTER44
		public void hide_tile_preview ();
		public void hide_window (Meta.Window window, Meta.CompEffect effect);
		public void manage ();
		public void queue_frame_drawn (Meta.Window window, bool no_delay_frame);
		public void remove_window (Meta.Window window);
		public void show_tile_preview (Meta.Window window, Meta.Rectangle tile_rect, int tile_monitor_number);
		public void show_window (Meta.Window window, Meta.CompEffect effect);
		public void show_window_menu (Meta.Window window, Meta.WindowMenuType menu, int x, int y);
		public void show_window_menu_for_rect (Meta.Window window, Meta.WindowMenuType menu, Meta.Rectangle rect);
		public void size_change_window (Meta.Window window, Meta.SizeChange which_change, Meta.Rectangle old_frame_rect, Meta.Rectangle old_buffer_rect);
		public void switch_workspace (Meta.Workspace from, Meta.Workspace to, Meta.MotionDirection direction);
		public void sync_stack (GLib.List<Meta.Window> stack);
		public void sync_updates_frozen (Meta.Window window);
		public void sync_window_geometry (Meta.Window window, bool did_placement);
		public void unmanage ();
		public void window_opacity_changed (Meta.Window window);
		public void window_shape_changed (Meta.Window window);
#endif
		[NoAccessorMethod]
		public Meta.Backend backend { owned get; construct; }
		[NoAccessorMethod]
		public Meta.Display display { owned get; construct; }
	}
	[CCode (cheader_filename = "meta/meta-context.h", type_id = "meta_context_get_type ()")]
	public class Context : GLib.Object {
		[CCode (cheader_filename = "meta/meta-context.h", cname = "meta_create_context", has_construct_function = false)]
		public Context (string name);
		public void add_option_entries ([CCode (array_length = false, array_null_terminated = true)] GLib.OptionEntry[] entries, string? translation_domain);
		public void add_option_group (owned GLib.OptionGroup group);
		public bool configure ([CCode (array_length_cname = "argc", array_length_pos = 0.5)] ref unowned string[]? argv) throws GLib.Error;
		public void destroy ();
		public unowned Meta.Backend get_backend ();
		public Meta.CompositorType get_compositor_type ();
#if HAS_MUTTER47
		public unowned Meta.DebugControl get_debug_control ();
#endif
		public unowned Meta.Display get_display ();
#if HAS_MUTTER45
		public unowned Meta.WaylandCompositor? get_wayland_compositor ();
#endif
		public bool is_replacing ();
		public void notify_ready ();
		public bool raise_rlimit_nofile () throws GLib.Error;
		public bool restore_rlimit_nofile () throws GLib.Error;
		public bool run_main_loop () throws GLib.Error;
		public void set_gnome_wm_keybindings (string wm_keybindings);
		public void set_plugin_gtype (GLib.Type plugin_gtype);
		public void set_plugin_name (string plugin_name);
		public bool setup () throws GLib.Error;
		public bool start () throws GLib.Error;
		public void terminate ();
		public void terminate_with_error (GLib.Error error);
		[NoAccessorMethod]
		public string name { owned get; construct; }
#if HAS_MUTTER47
		[NoAccessorMethod]
		public string nick { owned get; construct; }
#endif
		[NoAccessorMethod]
		public bool unsafe_mode { get; set; }
#if HAS_MUTTER44
		public signal void prepare_shutdown ();
		public signal void started ();
#endif
	}
	[CCode (cheader_filename = "meta/meta-cursor-tracker.h", type_id = "meta_cursor_tracker_get_type ()")]
	public class CursorTracker : GLib.Object {
		[CCode (has_construct_function = false)]
		protected CursorTracker ();
		public void get_hot (out int x, out int y);
		public void get_pointer (out Graphene.Point coords, out Clutter.ModifierType mods);
		public bool get_pointer_visible ();
		public float get_scale ();
		public unowned Cogl.Texture? get_sprite ();
		public void set_pointer_visible (bool visible);
		[NoAccessorMethod]
		public Meta.Backend backend { owned get; construct; }
		public signal void cursor_changed ();
		public signal void position_invalidated ();
		public signal void visibility_changed ();
	}
#if HAS_MUTTER47
	[CCode (cheader_filename = "meta/meta-debug-control.h", type_id = "meta_debug_control_get_type ()")]
	public class DebugControl : GLib.DBusInterfaceSkeleton, GLib.DBusInterface {
		[CCode (has_construct_function = false)]
		protected DebugControl ();
		public void set_exported (bool exported);
		[NoAccessorMethod]
		public Meta.Context context { owned get; construct; }
		[NoAccessorMethod]
		public bool exported { get; set; }
	}
#endif
	[CCode (cheader_filename = "meta/display.h", type_id = "meta_display_get_type ()")]
	public class Display : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Display ();
#if !HAS_MUTTER44
		public void add_ignored_crossing_serial (ulong serial);
#endif
		public uint add_keybinding (string name, GLib.Settings settings, Meta.KeyBindingFlags flags, owned Meta.KeyHandlerFunc handler);
#if !HAS_MUTTER44
		public bool begin_grab_op (Meta.Window window, Meta.GrabOp op, bool pointer_already_grabbed, bool frame_action, int button, ulong modmask, uint32 timestamp, int root_x, int root_y);
#endif
		public void clear_mouse_mode ();
		public void close (uint32 timestamp);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_disable_unredirect_for_display")]
		public void disable_unredirect ();
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_enable_unredirect_for_display")]
		public void enable_unredirect ();
#if !HAS_MUTTER44
		public void end_grab_op (uint32 timestamp);
#endif
		public void focus_default_window (uint32 timestamp);
#if !HAS_MUTTER46
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_focus_stage_window")]
		public void focus_stage_window (uint32 timestamp);
		public void freeze_keyboard (uint32 timestamp);
#endif
		public unowned Meta.Compositor get_compositor ();
		public Clutter.ModifierType get_compositor_modifiers ();
		public unowned Meta.Context get_context ();
		public int get_current_monitor ();
		public uint32 get_current_time ();
		public uint32 get_current_time_roundtrip ();
		[CCode (cname = "meta_cursor_tracker_get_for_display")]
		public unowned Meta.CursorTracker get_cursor_tracker ();
#if !HAS_MUTTER46
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_get_feedback_group_for_display")]
		public unowned Clutter.Actor get_feedback_group ();
#endif
		public unowned Meta.Window get_focus_window ();
#if !HAS_MUTTER44
		public Meta.GrabOp get_grab_op ();
#endif
		public uint get_keybinding_action (uint keycode, ulong mask);
		public uint32 get_last_user_time ();
#if HAS_MUTTER45
		public Mtk.Rectangle get_monitor_geometry (int monitor);
#else
		public Meta.Rectangle get_monitor_geometry (int monitor);
#endif
		public bool get_monitor_in_fullscreen (int monitor);
#if HAS_MUTTER45
		public int get_monitor_index_for_rect (Mtk.Rectangle rect);
#else
		public int get_monitor_index_for_rect (Meta.Rectangle rect);
#endif
		public int get_monitor_neighbor_index (int which_monitor, Meta.DisplayDirection dir);
		public float get_monitor_scale (int monitor);
		public int get_n_monitors ();
#if HAS_MUTTER45
		public string get_pad_button_label (Clutter.InputDevice pad, int button_number);
		public string get_pad_feature_label (Clutter.InputDevice pad, Meta.PadFeatureType feature, Meta.PadDirection direction, int feature_number);
#else
		public string get_pad_action_label (Clutter.InputDevice pad, Meta.PadActionType action_type, uint action_number);
#endif
		public int get_primary_monitor ();
		public unowned Meta.Selection get_selection ();
		public void get_size (out int width, out int height);
		public unowned Meta.SoundPlayer get_sound_player ();
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_get_stage_for_display")]
		public unowned Clutter.Actor get_stage ();
		public unowned Meta.StartupNotification get_startup_notification ();
		public unowned Meta.Window get_tab_current (Meta.TabList type, Meta.Workspace workspace);
		public GLib.List<weak Meta.Window> get_tab_list (Meta.TabList type, Meta.Workspace? workspace);
		public unowned Meta.Window get_tab_next (Meta.TabList type, Meta.Workspace workspace, Meta.Window? window, bool backward);
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_get_top_window_group_for_display")]
		public unowned Clutter.Actor get_top_window_group ();
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_get_window_actors")]
		public unowned GLib.List<Meta.WindowActor> get_window_actors ();
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_get_window_group_for_display")]
		public unowned Clutter.Actor get_window_group ();
		public unowned Meta.WorkspaceManager get_workspace_manager ();
		public unowned Meta.X11Display get_x11_display ();
		public uint grab_accelerator (string accelerator, Meta.KeyBindingFlags flags);
#if HAS_MUTTER44
		public bool is_grabbed ();
#endif
		public bool is_pointer_emulating_sequence (Clutter.EventSequence? sequence);
		public GLib.List<weak Meta.Window> list_all_windows ();
		public bool remove_keybinding (string name);
		public void request_pad_osd (Clutter.InputDevice pad, bool edition_mode);
		public void set_cursor (Meta.Cursor cursor);
#if HAS_MUTTER46
		public void set_input_focus (Meta.Window window, uint32 timestamp);
#else
		public void set_input_focus (Meta.Window window, bool focus_frame, uint32 timestamp);
#endif
		public GLib.SList<weak Meta.Window> sort_windows_by_stacking (GLib.SList<Meta.Window> windows);
#if !HAS_MUTTER46
		[CCode (cheader_filename = "meta/compositor-mutter.h", cname = "meta_stage_is_focused")]
		public bool stage_is_focused ();
		public bool supports_extended_barriers ();
		public void unfreeze_keyboard (uint32 timestamp);
#endif
		public bool ungrab_accelerator (uint action_id);
#if !HAS_MUTTER46
		public void ungrab_keyboard (uint32 timestamp);
#endif
		public void unset_input_focus (uint32 timestamp);
		public bool xserver_time_is_before (uint32 time1, uint32 time2);
		public Clutter.ModifierType compositor_modifiers { get; }
		public Meta.Window focus_window { get; }
		public signal void accelerator_activated (uint object, Clutter.InputDevice p0, uint p1);
#if HAS_MUTTER47
		public signal void accelerator_deactivated (uint object, Clutter.InputDevice p0, uint p1);
#endif
		public signal void closing ();
		public signal void cursor_updated ();
		[CCode (cname = "focus-window")]
		public signal void do_focus_window (Meta.Window object, int64 p0);
		public signal void gl_video_memory_purged ();
		public signal void grab_op_begin (Meta.Window object, Meta.GrabOp p0);
		public signal void grab_op_end (Meta.Window object, Meta.GrabOp p0);
		public signal void in_fullscreen_changed ();
		public signal bool init_xserver (GLib.Task object);
		public signal bool modifiers_accelerator_activated ();
		public signal void overlay_key ();
		public signal void pad_mode_switch (Clutter.InputDevice object, uint p0, uint p1);
		public signal void restacked ();
		public signal bool restart ();
		public signal void show_osd (int object, string p0, string p1);
		public signal unowned Clutter.Actor? show_pad_osd (Clutter.InputDevice pad, GLib.Settings settings, string layout_path, bool edition_mode, int monitor_idx);
#if HAS_MUTTER45
		public signal bool show_resize_popup (bool object, Mtk.Rectangle p0, int p1, int p2);
#else
		public signal bool show_resize_popup (bool object, Meta.Rectangle p0, int p1, int p2);
#endif
		public signal bool show_restart_message (string? message);
		public signal void showing_desktop_changed ();
		public signal void window_created (Meta.Window object);
		public signal void window_demands_attention (Meta.Window object);
		public signal void window_entered_monitor (int object, Meta.Window p0);
		public signal void window_left_monitor (int object, Meta.Window p0);
		public signal void window_marked_urgent (Meta.Window object);
		public signal void window_visibility_updated ([CCode (type = "gpointer")] GLib.List<weak Meta.Window> unplaced, [CCode (type = "gpointer")] GLib.List<weak Meta.Window> should_show, [CCode (type = "gpointer")] GLib.List<weak Meta.Window> should_hide);
		public signal void workareas_changed ();
		public signal void x11_display_closing ();
		public signal void x11_display_opened ();
		public signal void x11_display_setup ();
	}
	[CCode (cheader_filename = "meta/meta-dnd.h", type_id = "meta_dnd_get_type ()")]
	public sealed class Dnd : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Dnd ();
		public signal void dnd_enter ();
		public signal void dnd_leave ();
		public signal void dnd_position_change (int object, int p0);
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "meta/types.h", has_type_id = false)]
	[Compact]
	public class Frame {
	}
#endif
#if HAS_MUTTER47
	[CCode (cheader_filename = "meta/meta-x11-types.h", has_type_id = false)]
#else
	[CCode (cheader_filename = "meta/group.h", has_type_id = false)]
#endif
	[Compact]
	public class Group {
#if !HAS_MUTTER47
		public int get_size ();
		public unowned string get_startup_id ();
#endif
#if HAS_MUTTER47
		[CCode (cheader_filename = "meta/meta-x11-group.h")]
#endif
		public GLib.SList<weak Meta.Window> list_windows ();
#if !HAS_MUTTER47
		public bool property_notify ([CCode (type = "XEvent*")] ref X.Event event);
		public void update_layers ();
#endif
	}
	[CCode (cheader_filename = "meta/meta-idle-monitor.h", type_id = "meta_idle_monitor_get_type ()")]
	public sealed class IdleMonitor : GLib.Object {
		[CCode (has_construct_function = false)]
		protected IdleMonitor ();
		public uint add_idle_watch (uint64 interval_msec, owned Meta.IdleMonitorWatchFunc? callback);
		public uint add_user_active_watch (owned Meta.IdleMonitorWatchFunc? callback);
		public int64 get_idletime ();
		public void remove_watch (uint id);
		[NoAccessorMethod]
		public Clutter.InputDevice device { owned get; construct; }
	}
	[CCode (cheader_filename = "meta/keybindings.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "meta_key_binding_get_type ()")]
	[Compact]
	public class KeyBinding {
		public uint get_mask ();
#if HAS_MUTTER44
		public Clutter.ModifierType get_modifiers ();
#else
		public Meta.VirtualModifier get_modifiers ();
#endif
		public unowned string get_name ();
		public bool is_builtin ();
		public bool is_reversed ();
		[CCode (cheader_filename = "meta/keybindings.h", cname = "meta_keybindings_set_custom_handler")]
		public static bool set_custom_handler (string name, owned Meta.KeyHandlerFunc? handler);
	}
#if HAS_MUTTER44
	[CCode (cheader_filename = "meta/types.h", type_id = "meta_laters_get_type ()")]
	public class Laters : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Laters ();
#else
	[CCode (cheader_filename = "meta/types.h", has_type_id = false)]
	[Compact]
	public class Laters {
#endif
		public uint add (Meta.LaterType when, owned GLib.SourceFunc func);
		public void remove (uint later_id);
	}
	[CCode (cheader_filename = "meta/meta-launch-context.h", type_id = "meta_launch_context_get_type ()")]
	public sealed class LaunchContext : GLib.AppLaunchContext {
		[CCode (has_construct_function = false)]
		protected LaunchContext ();
		public void set_timestamp (uint32 timestamp);
		public void set_workspace (Meta.Workspace workspace);
		[NoAccessorMethod]
		public Meta.Display display { owned get; construct; }
		[NoAccessorMethod]
		public uint timestamp { get; set; }
		[NoAccessorMethod]
		public Meta.Workspace workspace { owned get; set; }
	}
	[CCode (cheader_filename = "meta/meta-monitor-manager.h", type_id = "meta_monitor_manager_get_type ()")]
	public class MonitorManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MonitorManager ();
		public bool can_switch_config ();
#if HAS_MUTTER44
		public int get_display_configuration_timeout ();
#else
		public static unowned Meta.MonitorManager @get ();
		public static int get_display_configuration_timeout ();
#endif
		public bool get_is_builtin_display_on ();
		public int get_monitor_for_connector (string connector);
		public bool get_panel_orientation_managed ();
		public Meta.MonitorSwitchConfigType get_switch_config ();
		public void switch_config (Meta.MonitorSwitchConfigType config_type);
		[NoAccessorMethod]
		public Meta.Backend backend { owned get; construct; }
#if HAS_MUTTER45
		[NoAccessorMethod]
		public string experimental_hdr { owned get; set; }
#endif
		[NoAccessorMethod]
		public bool has_builtin_panel { get; }
#if HAS_MUTTER43
		[NoAccessorMethod]
		public bool night_light_supported { get; }
#endif
		public bool panel_orientation_managed { get; }
		public signal void confirm_display_change ();
		public signal void monitors_changed ();
		public signal void monitors_changed_internal ();
#if HAS_MUTTER45
		public signal void power_save_mode_changed (Meta.PowerSaveChangeReason object);
#else
		public signal void power_save_mode_changed ();
#endif
	}
#if HAS_MUTTER45
	[CCode (cheader_filename = "meta/meta-multi-texture.h", type_id = "meta_multi_texture_get_type ()")]
	public class MultiTexture : GLib.Object {
		[CCode (has_construct_function = false)]
		public MultiTexture (Meta.MultiTextureFormat format, owned Cogl.Texture planes, int n_planes);
		public Meta.MultiTextureFormat get_format ();
		public int get_height ();
		public int get_n_planes ();
		public unowned Cogl.Texture get_plane (int index);
		public int get_width ();
		public bool is_simple ();
		[CCode (has_construct_function = false)]
		public MultiTexture.simple (owned Cogl.Texture plane);
		public string to_string ();
	}
#endif
#if HAS_MUTTER47
	[CCode (cheader_filename = "meta/meta-orientation-manager.h", type_id = "meta_orientation_manager_get_type ()")]
	public class OrientationManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected OrientationManager ();
		public Meta.Orientation get_orientation ();
		[NoAccessorMethod]
		public bool has_accelerometer { get; }
		public signal void orientation_changed ();
	}
#endif
	[CCode (cheader_filename = "meta/meta-plugin.h", type_id = "meta_plugin_get_type ()")]
	public abstract class Plugin : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Plugin ();
		public void complete_display_change (bool ok);
		[NoWrapper]
		public virtual void confirm_display_change ();
		[NoWrapper]
		public virtual Meta.CloseDialog? create_close_dialog (Meta.Window window);
		[NoWrapper]
		public virtual Meta.InhibitShortcutsDialog create_inhibit_shortcuts_dialog (Meta.Window window);
		[NoWrapper]
		public virtual void destroy (Meta.WindowActor actor);
		public void destroy_completed (Meta.WindowActor actor);
		public unowned Meta.Display get_display ();
		public unowned Meta.PluginInfo? get_info ();
		[NoWrapper]
		public virtual void hide_tile_preview ();
		[NoWrapper]
		public virtual bool keybinding_filter (Meta.KeyBinding binding);
		[NoWrapper]
		public virtual void kill_switch_workspace ();
		[NoWrapper]
		public virtual void kill_window_effects (Meta.WindowActor actor);
		[NoWrapper]
		public virtual void locate_pointer ();
		public static void manager_set_plugin_type (GLib.Type gtype);
		[NoWrapper]
		public virtual void map (Meta.WindowActor actor);
		public void map_completed (Meta.WindowActor actor);
		[NoWrapper]
		public virtual void minimize (Meta.WindowActor actor);
		public void minimize_completed (Meta.WindowActor actor);
		[NoWrapper]
		public virtual unowned Meta.PluginInfo? plugin_info ();
		[NoWrapper]
#if HAS_MUTTER45
		public virtual void show_tile_preview (Meta.Window window, Mtk.Rectangle tile_rect, int tile_monitor_number);
#else
		public virtual void show_tile_preview (Meta.Window window, Meta.Rectangle tile_rect, int tile_monitor_number);
#endif
		[NoWrapper]
		public virtual void show_window_menu (Meta.Window window, Meta.WindowMenuType menu, int x, int y);
		[NoWrapper]
#if HAS_MUTTER45
		public virtual void show_window_menu_for_rect (Meta.Window window, Meta.WindowMenuType menu, Mtk.Rectangle rect);
		[NoWrapper]
		public virtual void size_change (Meta.WindowActor actor, Meta.SizeChange which_change, Mtk.Rectangle old_frame_rect, Mtk.Rectangle old_buffer_rect);
#else
		public virtual void show_window_menu_for_rect (Meta.Window window, Meta.WindowMenuType menu, Meta.Rectangle rect);
		[NoWrapper]
		public virtual void size_change (Meta.WindowActor actor, Meta.SizeChange which_change, Meta.Rectangle old_frame_rect, Meta.Rectangle old_buffer_rect);
#endif
		public void size_change_completed (Meta.WindowActor actor);
		[NoWrapper]
		public virtual void size_changed (Meta.WindowActor actor);
		[NoWrapper]
		public virtual void start ();
		[NoWrapper]
		public virtual void switch_workspace (int from, int to, Meta.MotionDirection direction);
		public void switch_workspace_completed ();
		[NoWrapper]
		public virtual void unminimize (Meta.WindowActor actor);
		public void unminimize_completed (Meta.WindowActor actor);
#if !HAS_MUTTER46
		[NoWrapper]
		public virtual bool xevent_filter ([CCode (type = "XEvent*")] ref X.Event event);
#endif
	}
	[CCode (cheader_filename = "meta/meta-remote-access-controller.h", type_id = "meta_remote_access_controller_get_type ()")]
	public sealed class RemoteAccessController : GLib.Object {
		[CCode (has_construct_function = false)]
		protected RemoteAccessController ();
		public void inhibit_remote_access ();
		public void uninhibit_remote_access ();
		public signal void new_handle (Meta.RemoteAccessHandle object);
	}
	[CCode (cheader_filename = "meta/meta-remote-access-controller.h", type_id = "meta_remote_access_handle_get_type ()")]
	public class RemoteAccessHandle : GLib.Object {
		[CCode (has_construct_function = false)]
		protected RemoteAccessHandle ();
		public bool get_disable_animations ();
		public virtual void stop ();
		[NoAccessorMethod]
		public bool is_recording { get; construct; }
		public signal void stopped ();
	}
	[CCode (cheader_filename = "meta/meta-selection.h", type_id = "meta_selection_get_type ()")]
	public sealed class Selection : GLib.Object {
		[CCode (has_construct_function = false)]
		public Selection (Meta.Display display);
		public GLib.List<string> get_mimetypes (Meta.SelectionType selection_type);
		public void set_owner (Meta.SelectionType selection_type, Meta.SelectionSource owner);
		public async bool transfer_async (Meta.SelectionType selection_type, string mimetype, ssize_t size, GLib.OutputStream output, GLib.Cancellable? cancellable) throws GLib.Error;
		public void unset_owner (Meta.SelectionType selection_type, Meta.SelectionSource owner);
		public signal void owner_changed (uint object, Meta.SelectionSource p0);
	}
	[CCode (cheader_filename = "meta/meta-selection-source.h", type_id = "meta_selection_source_get_type ()")]
	public class SelectionSource : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SelectionSource ();
		public virtual GLib.List<string> get_mimetypes ();
		public bool is_active ();
		public virtual async GLib.InputStream read_async (string mimetype, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual signal void activated ();
		public virtual signal void deactivated ();
	}
	[CCode (cheader_filename = "meta/meta-selection-source-memory.h", type_id = "meta_selection_source_memory_get_type ()")]
	public sealed class SelectionSourceMemory : Meta.SelectionSource {
		[CCode (has_construct_function = false, type = "MetaSelectionSource*")]
#if HAS_MUTTER46
		public SelectionSourceMemory (string mimetype, GLib.Bytes content) throws GLib.Error;
#else
		public SelectionSourceMemory (string mimetype, GLib.Bytes content);
#endif
	}
	[CCode (cheader_filename = "meta/meta-settings.h", has_type_id = false)]
	[Compact]
	public class Settings {
		public int get_font_dpi ();
		public int get_ui_scaling_factor ();
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "meta/meta-shadow-factory.h", ref_function = "meta_shadow_ref", type_id = "meta_shadow_get_type ()", unref_function = "meta_shadow_unref")]
	[Compact]
	public class Shadow {
#if HAS_MUTTER45
		public void get_bounds (int window_x, int window_y, int window_width, int window_height, Mtk.Rectangle bounds);
#else
		public void get_bounds (int window_x, int window_y, int window_width, int window_height, Cairo.RectangleInt bounds);
#endif
#if HAS_MUTTER46
		public void paint (Cogl.Framebuffer framebuffer, int window_x, int window_y, int window_width, int window_height, uint8 opacity, Mtk.Region? clip, bool clip_strictly);
#else
		public void paint (Cogl.Framebuffer framebuffer, int window_x, int window_y, int window_width, int window_height, uint8 opacity, Cairo.Region? clip, bool clip_strictly);
#endif
		public Meta.Shadow @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "meta/meta-shadow-factory.h", type_id = "meta_shadow_factory_get_type ()")]
	public sealed class ShadowFactory : GLib.Object {
		[CCode (has_construct_function = false)]
		public ShadowFactory ();
		public static unowned Meta.ShadowFactory get_default ();
		public Meta.ShadowParams get_params (string class_name, bool focused);
		public Meta.Shadow get_shadow (Meta.WindowShape shape, int width, int height, string class_name, bool focused);
		public void set_params (string class_name, bool focused, Meta.ShadowParams @params);
		public signal void changed ();
	}
#endif
	[CCode (cheader_filename = "meta/meta-shaped-texture.h", type_id = "meta_shaped_texture_get_type ()")]
	public sealed class ShapedTexture : GLib.Object, Clutter.Content {
		[CCode (has_construct_function = false)]
		protected ShapedTexture ();
#if HAS_MUTTER45
		public Cairo.Surface? get_image (Mtk.Rectangle? clip);
		public unowned Meta.MultiTexture get_texture ();
#else
		public Cairo.Surface? get_image (Cairo.RectangleInt? clip);
		public unowned Cogl.Texture get_texture ();
#endif
		public void set_create_mipmaps (bool create_mipmaps);
		public void set_mask_texture (Cogl.Texture mask_texture);
#if HAS_MUTTER47
		[NoAccessorMethod]
		public Clutter.Context clutter_context { owned get; construct; }
		[NoAccessorMethod]
		public Clutter.ColorState color_state { owned get; construct; }
#endif
		public signal void size_changed ();
	}
	[CCode (cheader_filename = "meta/meta-sound-player.h", type_id = "meta_sound_player_get_type ()")]
	public sealed class SoundPlayer : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SoundPlayer ();
		public void play_from_file (GLib.File file, string description, GLib.Cancellable? cancellable = null);
		public void play_from_theme (string name, string description, GLib.Cancellable? cancellable = null);
	}
	[CCode (cheader_filename = "meta/meta-stage.h", type_id = "meta_stage_get_type ()")]
#if HAS_MUTTER46
	public sealed class Stage : Clutter.Stage, Atk.Implementor, Clutter.Animatable {
#else
	public sealed class Stage : Clutter.Stage, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
#endif
		[CCode (has_construct_function = false)]
		protected Stage ();
#if !HAS_MUTTER45
		public signal void actors_painted ();
#endif
	}
	[CCode (cheader_filename = "meta/meta-startup-notification.h", type_id = "meta_startup_notification_get_type ()")]
	public sealed class StartupNotification : GLib.Object {
		[CCode (has_construct_function = false)]
		protected StartupNotification ();
		public Meta.LaunchContext create_launcher ();
		public unowned GLib.SList<Meta.StartupSequence> get_sequences ();
		[NoAccessorMethod]
		public Meta.Display display { owned get; construct; }
		public signal void changed (Meta.StartupSequence object);
	}
	[CCode (cheader_filename = "meta/meta-startup-notification.h", type_id = "meta_startup_sequence_get_type ()")]
	public class StartupSequence : GLib.Object {
		[CCode (has_construct_function = false)]
		protected StartupSequence ();
		public unowned string? get_application_id ();
		public bool get_completed ();
		public unowned string? get_icon_name ();
		public unowned string get_id ();
		public unowned string get_name ();
		public uint64 get_timestamp ();
		public unowned string? get_wmclass ();
		public int get_workspace ();
		public string application_id { get; construct; }
#if HAS_MUTTER44
		[NoAccessorMethod]
		public Meta.Display display { owned get; construct; }
#endif
		public string icon_name { get; construct; }
		public string id { get; construct; }
		public string name { get; construct; }
		public uint64 timestamp { get; construct; }
		public string wmclass { get; construct; }
		public int workspace { get; construct; }
		[HasEmitter]
		public signal void complete ();
		public signal void timeout ();
	}
#if !HAS_MUTTER45
	[CCode (cheader_filename = "meta/theme.h", has_type_id = false)]
	[Compact]
	public class Theme {
		public void free ();
		[CCode (cheader_filename = "meta/theme.h")]
		public static unowned Meta.Theme get_default ();
		[CCode (cheader_filename = "meta/theme.h")]
		public static unowned Meta.Theme @new ();
	}
#endif
	[CCode (cheader_filename = "meta/meta-wayland-client.h", type_id = "meta_wayland_client_get_type ()")]
	public sealed class WaylandClient : GLib.Object {
		[CCode (has_construct_function = false)]
#if HAS_MUTTER44
		public WaylandClient (Meta.Context context, GLib.SubprocessLauncher launcher) throws GLib.Error;
#else
		public WaylandClient (GLib.SubprocessLauncher launcher) throws GLib.Error;
#endif
		public void hide_from_window_list (Meta.Window window);
#if HAS_MUTTER45
		public void make_desktop (Meta.Window window);
#endif
#if HAS_MUTTER46
		public void make_dock (Meta.Window window);
#endif
		public bool owns_window (Meta.Window window);
		public void show_in_window_list (Meta.Window window);
		public GLib.Subprocess spawn (Meta.Display display, GLib.Error? error, string argv0, ...);
		public GLib.Subprocess spawnv (Meta.Display display, [CCode (array_length = false, array_null_terminated = true)] string[] argv) throws GLib.Error;
#if HAS_MUTTER44
		public signal void client_destroyed ();
#endif
	}
#if HAS_MUTTER45
	[CCode (cheader_filename = "meta/meta-wayland-compositor.h", type_id = "meta_wayland_compositor_get_type ()")]
	public class WaylandCompositor : GLib.Object {
		[CCode (has_construct_function = false)]
		protected WaylandCompositor ();
		public void* get_wayland_display ();
		public signal void prepare_shutdown ();
	}
#endif
#if HAS_MUTTER46
	[CCode (cheader_filename = "meta/main.h", type_id = "meta_wayland_surface_get_type ()")]
	public class WaylandSurface : GLib.Object {
		[CCode (has_construct_function = false)]
		protected WaylandSurface ();
		public unowned Meta.Window? get_window ();
		public Meta.Window window { get; }
		public signal void actor_changed ();
		public signal void configure ();
		public signal void destroy ();
		public signal void geometry_changed ();
		public signal void pre_state_applied ();
		public signal void shortcuts_inhibited ();
		public signal void shortcuts_restored ();
		public signal void unmapped ();
	}
#endif
	[CCode (cheader_filename = "meta/window.h", type_id = "meta_window_get_type ()")]
#if HAS_MUTTER44
	public abstract class Window : GLib.Object, GLib.Initable {
#else
	public abstract class Window : GLib.Object {
#endif
		[CCode (has_construct_function = false)]
		protected Window ();
		public void activate (uint32 current_time);
		public void activate_with_workspace (uint32 current_time, Meta.Workspace workspace);
		public bool allows_move ();
		public bool allows_resize ();
#if HAS_MUTTER46
		public bool begin_grab_op (Meta.GrabOp op, Clutter.InputDevice? device, Clutter.EventSequence? sequence, uint32 timestamp, Graphene.Point? pos_hint);
#elif HAS_MUTTER44
		public bool begin_grab_op (Meta.GrabOp op, Clutter.InputDevice? device, Clutter.EventSequence? sequence, uint32 timestamp);
#else
		public void begin_grab_op (Meta.GrabOp op, bool frame_action, uint32 timestamp);
#endif
		public bool can_close ();
		public bool can_maximize ();
		public bool can_minimize ();
#if !HAS_MUTTER45
		public bool can_shade ();
#endif
		public void change_workspace (Meta.Workspace workspace);
		public void change_workspace_by_index (int space_index, bool append);
		public void check_alive (uint32 timestamp);
#if HAS_MUTTER45
		public Mtk.Rectangle client_rect_to_frame_rect (Mtk.Rectangle client_rect);
#else
		public Meta.Rectangle client_rect_to_frame_rect (Meta.Rectangle client_rect);
#endif
#if !HAS_MUTTER46
		public void compute_group ();
#endif
		public void @delete (uint32 timestamp);
		public unowned Meta.Window find_root_ancestor ();
		public void focus (uint32 timestamp);
		public void foreach_ancestor (Meta.WindowForeachFunc func);
		public void foreach_transient (Meta.WindowForeachFunc func);
#if HAS_MUTTER45
		public Mtk.Rectangle frame_rect_to_client_rect (Mtk.Rectangle frame_rect);
		public Mtk.Rectangle get_buffer_rect ();
#else
		public Meta.Rectangle frame_rect_to_client_rect (Meta.Rectangle frame_rect);
		public Meta.Rectangle get_buffer_rect ();
#endif
#if !HAS_MUTTER46
		public unowned string? get_client_machine ();
#endif
		public Meta.WindowClientType get_client_type ();
		public unowned GLib.Object get_compositor_private ();
		public unowned string get_description ();
		public unowned Meta.Display get_display ();
#if !HAS_MUTTER46
		public unowned Meta.Frame get_frame ();
#endif
#if HAS_MUTTER46
		public unowned Mtk.Region? get_frame_bounds ();
#else
		public unowned Cairo.Region? get_frame_bounds ();
#endif
#if HAS_MUTTER45
		public Mtk.Rectangle get_frame_rect ();
#else
		public Meta.Rectangle get_frame_rect ();
#endif
		public Meta.FrameType get_frame_type ();
#if !HAS_MUTTER46
		public unowned Meta.Group? get_group ();
#endif
		public unowned string? get_gtk_app_menu_object_path ();
		public unowned string? get_gtk_application_id ();
		public unowned string? get_gtk_application_object_path ();
		public unowned string? get_gtk_menubar_object_path ();
		public unowned string? get_gtk_theme_variant ();
		public unowned string? get_gtk_unique_bus_name ();
		public unowned string? get_gtk_window_object_path ();
#if HAS_MUTTER45
		public bool get_icon_geometry (out Mtk.Rectangle rect);
#else
		public bool get_icon_geometry (out Meta.Rectangle rect);
#endif
		public uint64 get_id ();
		public Meta.StackLayer get_layer ();
		public Meta.MaximizeFlags get_maximized ();
		public int get_monitor ();
		public unowned string? get_mutter_hints ();
		public pid_t get_pid ();
		public unowned string get_role ();
		public unowned string? get_sandboxed_app_id ();
		public uint get_stable_sequence ();
		public unowned string? get_startup_id ();
		public unowned Meta.Window? get_tile_match ();
		public unowned string get_title ();
		public unowned Meta.Window? get_transient_for ();
		public uint32 get_user_time ();
		public Meta.WindowType get_window_type ();
		public unowned string? get_wm_class ();
		public unowned string? get_wm_class_instance ();
#if HAS_MUTTER45
		public Mtk.Rectangle get_work_area_all_monitors ();
		public Mtk.Rectangle get_work_area_current_monitor ();
		public Mtk.Rectangle get_work_area_for_monitor (int which_monitor);
#else
		public Meta.Rectangle get_work_area_all_monitors ();
		public Meta.Rectangle get_work_area_current_monitor ();
		public Meta.Rectangle get_work_area_for_monitor (int which_monitor);
#endif
		public unowned Meta.Workspace get_workspace ();
#if !HAS_MUTTER46
		public X.Window get_xwindow ();
		public void group_leader_changed ();
#endif
		public bool has_attached_dialogs ();
		public bool has_focus ();
#if HAS_MUTTER45
		public bool has_pointer ();
#endif
		public bool is_above ();
		public bool is_always_on_all_workspaces ();
		public bool is_ancestor_of_transient (Meta.Window transient);
		public bool is_attached_dialog ();
#if !HAS_MUTTER47
		public bool is_client_decorated ();
#endif
		public bool is_fullscreen ();
		public bool is_hidden ();
		public bool is_monitor_sized ();
		public bool is_on_all_workspaces ();
		public bool is_on_primary_monitor ();
		public bool is_override_redirect ();
		public bool is_remote ();
		public bool is_screen_sized ();
#if !HAS_MUTTER45
		public bool is_shaded ();
#endif
		public bool is_skip_taskbar ();
		public void kill ();
		public bool located_on_workspace (Meta.Workspace workspace);
		public void lower ();
		public void lower_with_transients (uint32 timestamp);
		public void make_above ();
		public void make_fullscreen ();
		public void maximize (Meta.MaximizeFlags directions);
		public void minimize ();
		public void move_frame (bool user_op, int root_x_nw, int root_y_nw);
		public void move_resize_frame (bool user_op, int root_x_nw, int root_y_nw, int w, int h);
		public void move_to_monitor (int monitor);
#if HAS_MUTTER47
		public Mtk.Rectangle protocol_to_stage_rect (Mtk.Rectangle protocol_rect);
#endif
		public void raise ();
#if HAS_MUTTER46
		public void raise_and_make_recent_on_workspace (Meta.Workspace workspace);
#elif HAS_MUTTER45
		public void raise_and_make_recent ();
#endif
		public void set_compositor_private (GLib.Object priv);
		public void set_demands_attention ();
#if HAS_MUTTER45
		public void set_icon_geometry (Mtk.Rectangle? rect);
#else
		public void set_icon_geometry (Meta.Rectangle? rect);
		public void shade (uint32 timestamp);
#endif
#if !HAS_MUTTER47
		public void shove_titlebar_onscreen ();
#endif
		public bool showing_on_its_workspace ();
#if !HAS_MUTTER46
		public void shutdown_group ();
#endif
#if HAS_MUTTER47
		public Mtk.Rectangle stage_to_protocol_rect (Mtk.Rectangle stage_rect);
#endif
		public void stick ();
		public bool titlebar_is_onscreen ();
		public void unmake_above ();
		public void unmake_fullscreen ();
		public void unmaximize (Meta.MaximizeFlags directions);
		public void unminimize ();
		public void unset_demands_attention ();
#if !HAS_MUTTER45
		public void unshade (uint32 timestamp);
#endif
		public void unstick ();
#if HAS_MUTTER46
#if HAS_MUTTER47
		[CCode (cheader_filename = "meta/meta-x11-group.h")]
#endif
		public unowned Meta.Group? x11_get_group ();
#endif
		[NoAccessorMethod]
		public bool above { get; }
		[NoAccessorMethod]
		public bool appears_focused { get; }
		[NoAccessorMethod]
		public bool decorated { get; }
		[NoAccessorMethod]
		public bool demands_attention { get; }
#if HAS_MUTTER44
		public Meta.Display display { get; construct; }
		[NoAccessorMethod]
		public int effect { get; construct; }
#endif
		[NoAccessorMethod]
		public bool fullscreen { get; }
		public string gtk_app_menu_object_path { get; }
		public string gtk_application_id { get; }
		public string gtk_application_object_path { get; }
		public string gtk_menubar_object_path { get; }
		public string gtk_unique_bus_name { get; }
		public string gtk_window_object_path { get; }
#if !HAS_MUTTER46
		[NoAccessorMethod]
		public Cairo.Surface icon { owned get; }
#endif
		[NoAccessorMethod]
		public bool is_alive { get; }
#if HAS_MUTTER47
		[NoAccessorMethod]
		public bool mapped { get; }
#endif
		[NoAccessorMethod]
		public bool maximized_horizontally { get; }
		[NoAccessorMethod]
		public bool maximized_vertically { get; }
#if !HAS_MUTTER46
		[NoAccessorMethod]
		public Cairo.Surface mini_icon { owned get; }
#endif
		[NoAccessorMethod]
		public bool minimized { get; }
		public string mutter_hints { get; }
		[NoAccessorMethod]
		public bool on_all_workspaces { get; }
		[NoAccessorMethod]
		public bool resizeable { get; }
		[NoAccessorMethod]
		public bool skip_taskbar { get; }
		public string title { get; }
		[NoAccessorMethod]
		public bool urgent { get; }
		public uint user_time { get; }
		public Meta.WindowType window_type { get; }
		public string wm_class { get; }
#if HAS_MUTTER44 && !HAS_MUTTER47
		public ulong xwindow { get; construct; }
#endif
		[CCode (cname = "focus")]
		public signal void focused ();
#if HAS_MUTTER45
		public signal void highest_scale_monitor_changed ();
#endif
		public signal void position_changed ();
		public signal void raised ();
		public signal void shown ();
		public signal void size_changed ();
		public signal void unmanaged ();
		public signal void unmanaging ();
		public signal void workspace_changed ();
	}
	[CCode (cheader_filename = "meta/meta-window-actor.h", type_id = "meta_window_actor_get_type ()")]
#if HAS_MUTTER46
	public abstract class WindowActor : Clutter.Actor, Atk.Implementor, Clutter.Animatable {
#else
	public abstract class WindowActor : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
#endif
		[CCode (has_construct_function = false)]
		protected WindowActor ();
		public void freeze ();
#if HAS_MUTTER45
		public Cairo.Surface? get_image (Mtk.Rectangle? clip);
#else
		public Cairo.Surface? get_image (Cairo.RectangleInt? clip);
#endif
		public unowned Meta.Window? get_meta_window ();
		public unowned Meta.ShapedTexture? get_texture ();
		public bool is_destroyed ();
#if HAS_MUTTER45
		public Clutter.Content? paint_to_content (Mtk.Rectangle? clip) throws GLib.Error;
#else
		public Clutter.Content? paint_to_content (Meta.Rectangle? clip) throws GLib.Error;
#endif
		public void sync_visibility ();
		public void thaw ();
		public Meta.Window meta_window { get; construct; }
		public signal void damaged ();
		public signal void effects_completed ();
		public signal void first_frame ();
		public signal void thawed ();
	}
	[CCode (cheader_filename = "meta/meta-window-group.h", type_id = "meta_window_group_get_type ()")]
#if HAS_MUTTER46
	public sealed class WindowGroup : Clutter.Actor, Atk.Implementor, Clutter.Animatable {
#else
	public sealed class WindowGroup : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
#endif
		[CCode (has_construct_function = false)]
		protected WindowGroup ();
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "meta/meta-window-shape.h", ref_function = "meta_window_shape_ref", type_id = "meta_window_shape_get_type ()", unref_function = "meta_window_shape_unref")]
	[Compact]
	public class WindowShape {
		[CCode (has_construct_function = false)]
#if HAS_MUTTER46
		public WindowShape (Mtk.Region region);
#else
		public WindowShape (Cairo.Region region);
#endif
		public bool equal (Meta.WindowShape shape_b);
		public void get_borders (int border_top, int border_right, int border_bottom, int border_left);
		public uint hash ();
		public Meta.WindowShape @ref ();
#if HAS_MUTTER46
		public Mtk.Region to_region (int center_width, int center_height);
#else
		public Cairo.Region to_region (int center_width, int center_height);
#endif
		public void unref ();
	}
#endif
	[CCode (cheader_filename = "meta/workspace.h", type_id = "meta_workspace_get_type ()")]
	public class Workspace : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Workspace ();
		public void activate (uint32 timestamp);
		public void activate_with_focus (Meta.Window focus_this, uint32 timestamp);
		public unowned Meta.Display get_display ();
		public unowned Meta.Workspace get_neighbor (Meta.MotionDirection direction);
#if HAS_MUTTER45
		public Mtk.Rectangle get_work_area_all_monitors ();
		public Mtk.Rectangle get_work_area_for_monitor (int which_monitor);
#else
		public Meta.Rectangle get_work_area_all_monitors ();
		public Meta.Rectangle get_work_area_for_monitor (int which_monitor);
#endif
		public int index ();
		public GLib.List<weak Meta.Window> list_windows ();
		public void set_builtin_struts (GLib.SList<Meta.Strut?> struts);
		[NoAccessorMethod]
		public bool active { get; }
		[NoAccessorMethod]
		public uint n_windows { get; }
		[NoAccessorMethod]
		public uint workspace_index { get; }
		public signal void window_added (Meta.Window object);
		public signal void window_removed (Meta.Window object);
	}
	[CCode (cheader_filename = "meta/meta-workspace-manager.h", type_id = "meta_workspace_manager_get_type ()")]
	public sealed class WorkspaceManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected WorkspaceManager ();
		public unowned Meta.Workspace append_new_workspace (bool activate, uint32 timestamp);
		public unowned Meta.Workspace get_active_workspace ();
		public int get_active_workspace_index ();
#if HAS_MUTTER46
		public int get_layout_columns ();
		public int get_layout_rows ();
#endif
		public int get_n_workspaces ();
		public unowned Meta.Workspace? get_workspace_by_index (int index);
		public unowned GLib.List<Meta.Workspace> get_workspaces ();
		public void override_workspace_layout (Meta.DisplayCorner starting_corner, bool vertical_layout, int n_rows, int n_columns);
		public void remove_workspace (Meta.Workspace workspace, uint32 timestamp);
		public void reorder_workspace (Meta.Workspace workspace, int new_index);
#if !HAS_MUTTER46
		[NoAccessorMethod]
#endif
		public int layout_columns { get; }
#if !HAS_MUTTER46
		[NoAccessorMethod]
#endif
		public int layout_rows { get; }
		public int n_workspaces { get; }
		public signal void active_workspace_changed ();
		public signal void showing_desktop_changed ();
		public signal void workspace_added (int object);
		public signal void workspace_removed (int object);
		public signal void workspace_switched (int object, int p0, Meta.MotionDirection p1);
		public signal void workspaces_reordered ();
	}
	[CCode (cheader_filename = "meta/meta-x11-display.h", type_id = "meta_x11_display_get_type ()")]
	public sealed class X11Display : GLib.Object {
		[CCode (has_construct_function = false)]
		protected X11Display ();
#if !HAS_MUTTER44
		public void clear_stage_input_region ();
#endif
#if !HAS_MUTTER47
		[CCode (cheader_filename = "meta/meta-x11-errors.h", cname = "meta_x11_error_trap_pop")]
		public void error_trap_pop ();
		[CCode (cheader_filename = "meta/meta-x11-errors.h", cname = "meta_x11_error_trap_pop_with_return")]
		public int error_trap_pop_with_return ();
		[CCode (cheader_filename = "meta/meta-x11-errors.h", cname = "meta_x11_error_trap_push")]
		public void error_trap_push ();
#endif
#if !HAS_MUTTER45
		public int get_damage_event_base ();
		public int get_screen_number ();
		public int get_shape_event_base ();
#endif
		public unowned X.Display get_xdisplay ();
#if !HAS_MUTTER45
		public int get_xinput_opcode ();
#endif
		public X.Window get_xroot ();
#if !HAS_MUTTER45
		public bool has_shape ();
#endif
		public unowned Meta.Group lookup_group (X.Window group_leader);
#if HAS_MUTTER46
		public X.Window lookup_xwindow (Meta.Window window);
#endif
#if HAS_MUTTER45
		public void redirect_windows (Meta.Display display);
		public void remove_event_func (uint id);
#endif
#if !HAS_MUTTER45
		public void set_cm_selection ();
#endif
#if HAS_MUTTER47
		public void set_stage_input_region ([CCode (array_length_cname = "n_rects", array_length_pos = 1.1, type = "XRectangle*")] X.Xrectangle[] rects);
#else
		public void set_stage_input_region (X.XserverRegion region);
#endif
#if !HAS_MUTTER44
		[CCode (cheader_filename = "meta/meta-x11-display.h", cname = "meta_x11_init_gdk_display")]
		public static bool x11_init_gdk_display () throws GLib.Error;
#endif
#if !HAS_MUTTER45
		public bool xwindow_is_a_no_focus_window (X.Window xwindow);
#endif
	}
	[CCode (cheader_filename = "meta/meta-close-dialog.h", type_cname = "MetaCloseDialogInterface", type_id = "meta_close_dialog_get_type ()")]
	public interface CloseDialog : GLib.Object {
		public abstract void focus ();
		public abstract void hide ();
		public bool is_visible ();
		public abstract void show ();
		[NoAccessorMethod]
		public abstract Meta.Window window { owned get; construct; }
		[HasEmitter]
		public signal void response (Meta.CloseDialogResponse response);
	}
	[CCode (cheader_filename = "meta/meta-inhibit-shortcuts-dialog.h", type_cname = "MetaInhibitShortcutsDialogInterface", type_id = "meta_inhibit_shortcuts_dialog_get_type ()")]
	public interface InhibitShortcutsDialog : GLib.Object {
		public abstract void hide ();
		public abstract void show ();
		[NoAccessorMethod]
		public abstract Meta.Window window { owned get; construct; }
		[HasEmitter]
		public signal void response (Meta.InhibitShortcutsDialogResponse response);
	}
	[CCode (cheader_filename = "meta/common.h", has_type_id = false)]
	public struct ButtonLayout {
		[CCode (array_length = false)]
		public weak Meta.ButtonFunction left_buttons[4];
		[CCode (array_length = false)]
		public weak bool left_buttons_has_spacer[4];
		[CCode (array_length = false)]
		public weak Meta.ButtonFunction right_buttons[4];
		[CCode (array_length = false)]
		public weak bool right_buttons_has_spacer[4];
	}
	[CCode (cheader_filename = "meta/boxes.h", has_type_id = false)]
	public struct Edge {
#if HAS_MUTTER45
		public Mtk.Rectangle rect;
#else
		public Meta.Rectangle rect;
#endif
		public Meta.Side side_type;
		public Meta.EdgeType edge_type;
	}
#if HAS_MUTTER44
	[CCode (cheader_filename = "meta/main.h", has_type_id = false)]
	public struct FrameBorder {
		public int16 left;
		public int16 right;
		public int16 top;
		public int16 bottom;
	}
#endif
	[CCode (cheader_filename = "meta/common.h", has_type_id = false)]
	public struct FrameBorders {
#if HAS_MUTTER44
		public Meta.FrameBorder visible;
		public Meta.FrameBorder invisible;
		public Meta.FrameBorder total;
#else
		public Gtk.Border visible;
		public Gtk.Border invisible;
		public Gtk.Border total;
#endif
		public void clear ();
	}
	[CCode (cheader_filename = "meta/meta-plugin.h", has_type_id = false)]
	public struct PluginInfo {
		public weak string name;
		public weak string version;
		public weak string author;
		public weak string license;
		public weak string description;
	}
#if !HAS_MUTTER45
	[CCode (cheader_filename = "meta/boxes.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "meta_rectangle_get_type ()")]
	public struct Rectangle {
		public int x;
		public int y;
		public int width;
		public int height;
		public int area ();
		public bool contains_rect (Meta.Rectangle inner_rect);
		public Meta.Rectangle? copy ();
		public bool could_fit_rect (Meta.Rectangle inner_rect);
		public bool equal (Meta.Rectangle src2);
		public void free ();
		public bool horiz_overlap (Meta.Rectangle rect2);
		public bool intersect (Meta.Rectangle src2, out Meta.Rectangle dest);
		public bool overlap (Meta.Rectangle rect2);
		public Meta.Rectangle union (Meta.Rectangle rect2);
		public bool vert_overlap (Meta.Rectangle rect2);
	}
#endif
#if !HAS_MUTTER47
	[CCode (cheader_filename = "meta/meta-shadow-factory.h", has_type_id = false)]
	public struct ShadowParams {
		public int radius;
		public int top_fade;
		public int x_offset;
		public int y_offset;
		public uint8 opacity;
	}
#endif
	[CCode (cheader_filename = "meta/boxes.h", has_type_id = false)]
	public struct Strut {
#if HAS_MUTTER45
		public Mtk.Rectangle rect;
#else
		public Meta.Rectangle rect;
#endif
		public Meta.Side side;
	}
#if HAS_MUTTER43
	[CCode (cheader_filename = "meta/main.h", cprefix = "META_BACKEND_CAPABILITY_", type_id = "meta_backend_capabilities_get_type ()")]
	[Flags]
	public enum BackendCapabilities {
		NONE,
		BARRIERS
	}
#endif
	[CCode (cheader_filename = "meta/barrier.h", cprefix = "META_BARRIER_DIRECTION_", type_id = "meta_barrier_direction_get_type ()")]
	[Flags]
	public enum BarrierDirection {
		POSITIVE_X,
		POSITIVE_Y,
		NEGATIVE_X,
		NEGATIVE_Y
	}
#if HAS_MUTTER45
	[CCode (cheader_filename = "meta/barrier.h", cprefix = "META_BARRIER_FLAG_", type_id = "meta_barrier_flags_get_type ()")]
	[Flags]
	public enum BarrierFlags {
		NONE,
		STICKY
	}
#endif
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_BUTTON_FUNCTION_", type_id = "meta_button_function_get_type ()")]
	public enum ButtonFunction {
		MENU,
		MINIMIZE,
		MAXIMIZE,
		CLOSE,
		LAST
	}
	[CCode (cheader_filename = "meta/meta-close-dialog.h", cprefix = "META_CLOSE_DIALOG_RESPONSE_", type_id = "meta_close_dialog_response_get_type ()")]
	public enum CloseDialogResponse {
		WAIT,
		FORCE_CLOSE
	}
	[CCode (cheader_filename = "meta/compositor.h", cprefix = "META_COMP_EFFECT_", type_id = "meta_comp_effect_get_type ()")]
	public enum CompEffect {
		CREATE,
		UNMINIMIZE,
		DESTROY,
		MINIMIZE,
		NONE
	}
	[CCode (cheader_filename = "meta/meta-enums.h", cprefix = "META_COMPOSITOR_TYPE_", type_id = "meta_compositor_type_get_type ()")]
	public enum CompositorType {
		WAYLAND,
		X11
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_CURSOR_", type_id = "meta_cursor_get_type ()")]
	public enum Cursor {
		NONE,
		DEFAULT,
		NORTH_RESIZE,
		SOUTH_RESIZE,
		WEST_RESIZE,
		EAST_RESIZE,
		SE_RESIZE,
		SW_RESIZE,
		NE_RESIZE,
		NW_RESIZE,
		MOVE_OR_RESIZE_WINDOW,
		BUSY,
		DND_IN_DRAG,
		DND_MOVE,
		DND_COPY,
		DND_UNSUPPORTED_TARGET,
		POINTING_HAND,
		CROSSHAIR,
		IBEAM,
		BLANK,
		LAST
	}
	[CCode (cheader_filename = "meta/util.h", cprefix = "META_DEBUG_PAINT_", type_id = "meta_debug_paint_flag_get_type ()")]
	[Flags]
	public enum DebugPaintFlag {
		NONE,
#if HAS_MUTTER47
		SYNC_CURSOR_PRIMARY,
		DISABLE_DIRECT_SCANOUT,
#endif
		OPAQUE_REGION
	}
	[CCode (cheader_filename = "meta/util.h", cprefix = "META_DEBUG_", type_id = "meta_debug_topic_get_type ()")]
	[Flags]
	public enum DebugTopic {
		VERBOSE,
		FOCUS,
		WORKAREA,
		STACK,
		SM,
		EVENTS,
		WINDOW_STATE,
		WINDOW_OPS,
		GEOMETRY,
		PLACEMENT,
		PING,
		KEYBINDINGS,
		SYNC,
		STARTUP,
		PREFS,
		GROUPS,
		RESIZING,
		SHAPES,
		EDGE_RESISTANCE,
		DBUS,
		INPUT,
		WAYLAND,
		KMS,
		SCREEN_CAST,
		REMOTE_DESKTOP,
		BACKEND,
#if HAS_MUTTER43
		COLOR,
#endif
#if HAS_MUTTER45
		INPUT_EVENTS,
		EIS,
#endif
#if HAS_MUTTER47
		KMS_DEADLINE,
		SESSION_MANAGEMENT,
#endif
		RENDER;
		[CCode (cheader_filename = "meta/util.h", cname = "meta_topic_to_string")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_DIRECTION_", type_id = "meta_direction_get_type ()")]
	[Flags]
	public enum Direction {
		LEFT,
		RIGHT,
		TOP,
		BOTTOM,
		UP,
		DOWN,
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cheader_filename = "meta/display.h", cprefix = "META_DISPLAY_", type_id = "meta_display_corner_get_type ()")]
	public enum DisplayCorner {
		TOPLEFT,
		TOPRIGHT,
		BOTTOMLEFT,
		BOTTOMRIGHT
	}
	[CCode (cheader_filename = "meta/display.h", cprefix = "META_DISPLAY_", type_id = "meta_display_direction_get_type ()")]
	public enum DisplayDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "meta/boxes.h", cprefix = "META_EDGE_", type_id = "meta_edge_type_get_type ()")]
	public enum EdgeType {
		WINDOW,
		MONITOR,
		SCREEN
	}
	[CCode (cheader_filename = "meta/main.h", cprefix = "META_EXIT_", type_id = "meta_exit_code_get_type ()")]
	public enum ExitCode {
		SUCCESS,
		ERROR
	}
#if !HAS_MUTTER45
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_FRAME_", type_id = "meta_frame_flags_get_type ()")]
	[Flags]
	public enum FrameFlags {
		ALLOWS_DELETE,
		ALLOWS_MENU,
		ALLOWS_MINIMIZE,
		ALLOWS_MAXIMIZE,
		ALLOWS_VERTICAL_RESIZE,
		ALLOWS_HORIZONTAL_RESIZE,
		HAS_FOCUS,
		SHADED,
		STUCK,
		MAXIMIZED,
		ALLOWS_SHADE,
		ALLOWS_MOVE,
		FULLSCREEN,
		ABOVE,
		TILED_LEFT,
		TILED_RIGHT
	}
#endif
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_FRAME_TYPE_", type_id = "meta_frame_type_get_type ()")]
	public enum FrameType {
		NORMAL,
		DIALOG,
		MODAL_DIALOG,
		UTILITY,
		MENU,
		BORDER,
		ATTACHED,
		LAST;
		[CCode (cheader_filename = "meta/util.h")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_GRAB_OP_", type_id = "meta_grab_op_get_type ()")]
	public enum GrabOp {
		NONE,
		WINDOW_BASE,
#if !HAS_MUTTER44
		WAYLAND_POPUP,
		FRAME_BUTTON,
#endif
		MOVING,
#if HAS_MUTTER44
		MOVING_UNCONSTRAINED,
#endif
		RESIZING_NW,
		RESIZING_N,
		RESIZING_NE,
		RESIZING_E,
		RESIZING_SW,
		RESIZING_S,
		RESIZING_SE,
		RESIZING_W,
		KEYBOARD_MOVING,
		KEYBOARD_RESIZING_UNKNOWN,
		KEYBOARD_RESIZING_NW,
		KEYBOARD_RESIZING_N,
		KEYBOARD_RESIZING_NE,
		KEYBOARD_RESIZING_E,
		KEYBOARD_RESIZING_SW,
		KEYBOARD_RESIZING_S,
		KEYBOARD_RESIZING_SE,
		KEYBOARD_RESIZING_W
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_GRAVITY_", type_id = "meta_gravity_get_type ()")]
	public enum Gravity {
		NONE,
		NORTH_WEST,
		NORTH,
		NORTH_EAST,
		WEST,
		CENTER,
		EAST,
		SOUTH_WEST,
		SOUTH,
		SOUTH_EAST,
		STATIC;
		[CCode (cheader_filename = "meta/util.h")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "meta/meta-inhibit-shortcuts-dialog.h", cprefix = "META_INHIBIT_SHORTCUTS_DIALOG_RESPONSE_", type_id = "meta_inhibit_shortcuts_dialog_response_get_type ()")]
	public enum InhibitShortcutsDialogResponse {
		ALLOW,
		DENY
	}
	[CCode (cheader_filename = "meta/prefs.h", cprefix = "META_KEYBINDING_ACTION_", type_id = "meta_key_binding_action_get_type ()")]
	public enum KeyBindingAction {
		NONE,
		WORKSPACE_1,
		WORKSPACE_2,
		WORKSPACE_3,
		WORKSPACE_4,
		WORKSPACE_5,
		WORKSPACE_6,
		WORKSPACE_7,
		WORKSPACE_8,
		WORKSPACE_9,
		WORKSPACE_10,
		WORKSPACE_11,
		WORKSPACE_12,
		WORKSPACE_LEFT,
		WORKSPACE_RIGHT,
		WORKSPACE_UP,
		WORKSPACE_DOWN,
		WORKSPACE_LAST,
		SWITCH_APPLICATIONS,
		SWITCH_APPLICATIONS_BACKWARD,
		SWITCH_GROUP,
		SWITCH_GROUP_BACKWARD,
		SWITCH_WINDOWS,
		SWITCH_WINDOWS_BACKWARD,
		SWITCH_PANELS,
		SWITCH_PANELS_BACKWARD,
		CYCLE_GROUP,
		CYCLE_GROUP_BACKWARD,
		CYCLE_WINDOWS,
		CYCLE_WINDOWS_BACKWARD,
		CYCLE_PANELS,
		CYCLE_PANELS_BACKWARD,
		SHOW_DESKTOP,
		PANEL_RUN_DIALOG,
		TOGGLE_RECORDING,
		SET_SPEW_MARK,
		ACTIVATE_WINDOW_MENU,
		TOGGLE_FULLSCREEN,
		TOGGLE_MAXIMIZED,
		TOGGLE_TILED_LEFT,
		TOGGLE_TILED_RIGHT,
		TOGGLE_ABOVE,
		MAXIMIZE,
		UNMAXIMIZE,
		TOGGLE_SHADED,
		MINIMIZE,
		CLOSE,
		BEGIN_MOVE,
		BEGIN_RESIZE,
		TOGGLE_ON_ALL_WORKSPACES,
		MOVE_TO_WORKSPACE_1,
		MOVE_TO_WORKSPACE_2,
		MOVE_TO_WORKSPACE_3,
		MOVE_TO_WORKSPACE_4,
		MOVE_TO_WORKSPACE_5,
		MOVE_TO_WORKSPACE_6,
		MOVE_TO_WORKSPACE_7,
		MOVE_TO_WORKSPACE_8,
		MOVE_TO_WORKSPACE_9,
		MOVE_TO_WORKSPACE_10,
		MOVE_TO_WORKSPACE_11,
		MOVE_TO_WORKSPACE_12,
		MOVE_TO_WORKSPACE_LEFT,
		MOVE_TO_WORKSPACE_RIGHT,
		MOVE_TO_WORKSPACE_UP,
		MOVE_TO_WORKSPACE_DOWN,
		MOVE_TO_WORKSPACE_LAST,
		MOVE_TO_MONITOR_LEFT,
		MOVE_TO_MONITOR_RIGHT,
		MOVE_TO_MONITOR_UP,
		MOVE_TO_MONITOR_DOWN,
		RAISE_OR_LOWER,
		RAISE,
		LOWER,
		MAXIMIZE_VERTICALLY,
		MAXIMIZE_HORIZONTALLY,
		MOVE_TO_CORNER_NW,
		MOVE_TO_CORNER_NE,
		MOVE_TO_CORNER_SW,
		MOVE_TO_CORNER_SE,
		MOVE_TO_SIDE_N,
		MOVE_TO_SIDE_S,
		MOVE_TO_SIDE_E,
		MOVE_TO_SIDE_W,
		MOVE_TO_CENTER,
		OVERLAY_KEY,
		LOCATE_POINTER_KEY,
		ISO_NEXT_GROUP,
		ALWAYS_ON_TOP,
		SWITCH_MONITOR,
		ROTATE_MONITOR,
		LAST
	}
	[CCode (cheader_filename = "meta/prefs.h", cprefix = "META_KEY_BINDING_", type_id = "meta_key_binding_flags_get_type ()")]
	[Flags]
	public enum KeyBindingFlags {
		NONE,
		PER_WINDOW,
		BUILTIN,
		IS_REVERSED,
		NON_MASKABLE,
		IGNORE_AUTOREPEAT,
#if HAS_MUTTER45
		CUSTOM_TRIGGER,
#endif
#if HAS_MUTTER47
		TRIGGER_RELEASE,
#endif
		NO_AUTO_GRAB
	}
#if HAS_MUTTER43
	[CCode (cheader_filename = "meta/meta-enums.h", cprefix = "META_A11Y_", type_id = "meta_keyboard_a11y_flags_get_type ()")]
	[Flags]
	public enum KeyboardA11yFlags {
		KEYBOARD_ENABLED,
		TIMEOUT_ENABLED,
		MOUSE_KEYS_ENABLED,
		SLOW_KEYS_ENABLED,
		SLOW_KEYS_BEEP_PRESS,
		SLOW_KEYS_BEEP_ACCEPT,
		SLOW_KEYS_BEEP_REJECT,
		BOUNCE_KEYS_ENABLED,
		BOUNCE_KEYS_BEEP_REJECT,
		TOGGLE_KEYS_ENABLED,
		STICKY_KEYS_ENABLED,
		STICKY_KEYS_TWO_KEY_OFF,
		STICKY_KEYS_BEEP,
		FEATURE_STATE_CHANGE_BEEP
	}
#endif
	[CCode (cheader_filename = "meta/util.h", cprefix = "META_LATER_", type_id = "meta_later_type_get_type ()")]
	public enum LaterType {
		RESIZE,
		CALC_SHOWING,
		CHECK_FULLSCREEN,
		SYNC_STACK,
		BEFORE_REDRAW,
		IDLE
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "meta/util.h", cprefix = "META_LOCALE_DIRECTION_", type_id = "meta_locale_direction_get_type ()")]
	public enum LocaleDirection {
		LTR,
		RTL
	}
#endif
	[CCode (cheader_filename = "meta/window.h", cprefix = "META_MAXIMIZE_", type_id = "meta_maximize_flags_get_type ()")]
	[Flags]
	public enum MaximizeFlags {
		HORIZONTAL,
		VERTICAL,
		BOTH
	}
	[CCode (cheader_filename = "meta/meta-monitor-manager.h", cprefix = "META_MONITOR_SWITCH_CONFIG_", type_id = "meta_monitor_switch_config_type_get_type ()")]
	public enum MonitorSwitchConfigType {
		ALL_MIRROR,
		ALL_LINEAR,
		EXTERNAL,
		BUILTIN,
		UNKNOWN
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_MOTION_", type_id = "meta_motion_direction_get_type ()")]
	public enum MotionDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT,
		UP_LEFT,
		UP_RIGHT,
		DOWN_LEFT,
		DOWN_RIGHT
	}
#if HAS_MUTTER45
	[CCode (cheader_filename = "meta/meta-multi-texture-format.h", cprefix = "META_MULTI_TEXTURE_FORMAT_", type_id = "meta_multi_texture_format_get_type ()")]
	public enum MultiTextureFormat {
		INVALID,
		SIMPLE,
		YUYV,
		NV12,
#if HAS_MUTTER46
		P010,
#endif
		YUV420
	}
#if HAS_MUTTER47
	[CCode (cheader_filename = "meta/meta-orientation-manager.h", cprefix = "META_ORIENTATION_", type_id = "meta_orientation_get_type ()")]
	public enum Orientation {
		UNDEFINED,
		NORMAL,
		BOTTOM_UP,
		LEFT_UP,
		RIGHT_UP;
		public Mtk.MonitorTransform to_transform ();
	}
#endif
	[CCode (cheader_filename = "meta/display.h", cprefix = "META_PAD_DIRECTION_", type_id = "meta_pad_direction_get_type ()")]
	public enum PadDirection {
		UP,
		DOWN,
		CW,
		CCW
	}
	[CCode (cheader_filename = "meta/display.h", cprefix = "META_PAD_FEATURE_", type_id = "meta_pad_feature_type_get_type ()")]
	public enum PadFeatureType {
		RING,
		STRIP
	}
#else
	[CCode (cheader_filename = "meta/display.h", cprefix = "META_PAD_ACTION_", type_id = "meta_pad_action_type_get_type ()")]
	public enum PadActionType {
		BUTTON,
		RING,
		STRIP
	}
#endif
#if HAS_MUTTER45
	[CCode (cheader_filename = "meta/meta-monitor-manager.h", cprefix = "META_POWER_SAVE_CHANGE_REASON_", type_id = "meta_power_save_change_reason_get_type ()")]
	public enum PowerSaveChangeReason {
		MODE_CHANGE,
		HOTPLUG
	}
#endif
	[CCode (cheader_filename = "meta/prefs.h", cprefix = "META_PREF_", type_id = "meta_preference_get_type ()")]
	public enum Preference {
		MOUSE_BUTTON_MODS,
		FOCUS_MODE,
		FOCUS_NEW_WINDOWS,
		ATTACH_MODAL_DIALOGS,
		RAISE_ON_CLICK,
		ACTION_DOUBLE_CLICK_TITLEBAR,
		ACTION_MIDDLE_CLICK_TITLEBAR,
		ACTION_RIGHT_CLICK_TITLEBAR,
		AUTO_RAISE,
		AUTO_RAISE_DELAY,
		FOCUS_CHANGE_ON_POINTER_REST,
#if !HAS_MUTTER45
		TITLEBAR_FONT,
#endif
		NUM_WORKSPACES,
		DYNAMIC_WORKSPACES,
		KEYBINDINGS,
		DISABLE_WORKAROUNDS,
		BUTTON_LAYOUT,
		WORKSPACE_NAMES,
		VISUAL_BELL,
		AUDIBLE_BELL,
		VISUAL_BELL_TYPE,
		GNOME_ACCESSIBILITY,
		GNOME_ANIMATIONS,
		CURSOR_THEME,
		CURSOR_SIZE,
		RESIZE_WITH_RIGHT_BUTTON,
		EDGE_TILING,
		FORCE_FULLSCREEN,
		WORKSPACES_ONLY_ON_PRIMARY,
		DRAGGABLE_BORDER_WIDTH,
		AUTO_MAXIMIZE,
		CENTER_NEW_WINDOWS,
		DRAG_THRESHOLD,
		LOCATE_POINTER,
		CHECK_ALIVE_TIMEOUT;
		[CCode (cheader_filename = "meta/prefs.h")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "meta/meta-selection-source.h", cprefix = "META_", type_id = "meta_selection_type_get_type ()")]
	public enum SelectionType {
		SELECTION_PRIMARY,
		SELECTION_CLIPBOARD,
		SELECTION_DND,
		N_SELECTION_TYPES
	}
#if !HAS_MUTTER47
	[CCode (cheader_filename = "meta/meta-window-actor.h", cprefix = "META_SHADOW_MODE_", type_id = "meta_shadow_mode_get_type ()")]
	public enum ShadowMode {
		AUTO,
		FORCED_OFF,
		FORCED_ON
	}
#endif
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_SIDE_", type_id = "meta_side_get_type ()")]
	public enum Side {
		LEFT,
		RIGHT,
		TOP,
		BOTTOM
	}
	[CCode (cheader_filename = "meta/compositor.h", cprefix = "META_SIZE_CHANGE_", type_id = "meta_size_change_get_type ()")]
	public enum SizeChange {
		MAXIMIZE,
		UNMAXIMIZE,
		FULLSCREEN,
#if HAS_MUTTER43
		MONITOR_MOVE,
#endif
		UNFULLSCREEN
	}
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_LAYER_", type_id = "meta_stack_layer_get_type ()")]
	public enum StackLayer {
		DESKTOP,
		BOTTOM,
		NORMAL,
		TOP,
		DOCK,
		OVERRIDE_REDIRECT,
		LAST
	}
	[CCode (cheader_filename = "meta/display.h", cprefix = "META_TAB_LIST_", type_id = "meta_tab_list_get_type ()")]
	public enum TabList {
		NORMAL,
		DOCKS,
		GROUP,
		NORMAL_ALL
	}
	[CCode (cheader_filename = "meta/display.h", cprefix = "META_TAB_SHOW_", type_id = "meta_tab_show_type_get_type ()")]
	public enum TabShowType {
		ICON,
		INSTANTLY
	}
#if !HAS_MUTTER46
	[CCode (cheader_filename = "meta/common.h", cprefix = "META_VIRTUAL_", type_id = "meta_virtual_modifier_get_type ()")]
	[Flags]
	public enum VirtualModifier {
		SHIFT_MASK,
		CONTROL_MASK,
		ALT_MASK,
		META_MASK,
		SUPER_MASK,
		HYPER_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK
	}
#endif
	[CCode (cheader_filename = "meta/window.h", cprefix = "META_WINDOW_CLIENT_TYPE_", type_id = "meta_window_client_type_get_type ()")]
	public enum WindowClientType {
		WAYLAND,
		X11
	}
	[CCode (cheader_filename = "meta/compositor.h", cprefix = "META_WINDOW_MENU_", type_id = "meta_window_menu_type_get_type ()")]
	public enum WindowMenuType {
		WM,
		APP
	}
	[CCode (cheader_filename = "meta/window.h", cprefix = "META_WINDOW_", type_id = "meta_window_type_get_type ()")]
	public enum WindowType {
		NORMAL,
		DESKTOP,
		DOCK,
		DIALOG,
		MODAL_DIALOG,
		TOOLBAR,
		MENU,
		UTILITY,
		SPLASHSCREEN,
		DROPDOWN_MENU,
		POPUP_MENU,
		TOOLTIP,
		NOTIFICATION,
		COMBO,
		DND,
		OVERRIDE_OTHER
	}
	[CCode (cheader_filename = "meta/meta-idle-monitor.h", instance_pos = 2.9)]
	public delegate void IdleMonitorWatchFunc (Meta.IdleMonitor monitor, uint watch_id);
	[CCode (cheader_filename = "meta/prefs.h", instance_pos = 4.9)]
	public delegate void KeyHandlerFunc (Meta.Display display, Meta.Window? window, [CCode (type = "const ClutterKeyEvent*")] Clutter.KeyEvent? event, Meta.KeyBinding binding);
	[CCode (cheader_filename = "meta/prefs.h", instance_pos = 1.9)]
	public delegate void PrefsChangedFunc (Meta.Preference pref);
	[CCode (cheader_filename = "meta/window.h", instance_pos = 1.9)]
	public delegate bool WindowForeachFunc (Meta.Window window);
	[CCode (cheader_filename = "meta/common.h", cname = "META_CURRENT_TIME")]
	public const int CURRENT_TIME;
	[CCode (cheader_filename = "meta/common.h", cname = "META_PRIORITY_BEFORE_REDRAW")]
	public const int PRIORITY_BEFORE_REDRAW;
	[CCode (cheader_filename = "meta/common.h", cname = "META_PRIORITY_PREFS_NOTIFY")]
	public const int PRIORITY_PREFS_NOTIFY;
	[CCode (cheader_filename = "meta/common.h", cname = "META_PRIORITY_REDRAW")]
	public const int PRIORITY_REDRAW;
	[CCode (cheader_filename = "meta/common.h", cname = "META_PRIORITY_RESIZE")]
	public const int PRIORITY_RESIZE;
	[CCode (cheader_filename = "meta/common.h", cname = "META_VIRTUAL_CORE_KEYBOARD_ID")]
	public const int VIRTUAL_CORE_KEYBOARD_ID;
	[CCode (cheader_filename = "meta/common.h", cname = "META_VIRTUAL_CORE_POINTER_ID")]
	public const int VIRTUAL_CORE_POINTER_ID;
#if HAS_MUTTER44
	[CCode (cheader_filename = "meta/main.h")]
	public static string accelerator_name (Clutter.ModifierType accelerator_mods, uint accelerator_key);
#endif
	[CCode (cheader_filename = "meta/main.h")]
	public static void add_clutter_debug_flags (Clutter.DebugFlag debug_flags, Clutter.DrawDebugFlag draw_flags, Clutter.PickDebugFlag pick_flags);
	[CCode (cheader_filename = "meta/main.h")]
	public static void add_debug_paint_flag (Meta.DebugPaintFlag flag);
#if !HAS_MUTTER46
	[CCode (cheader_filename = "meta/main.h")]
	public static void clutter_init ();
#endif
	[CCode (cheader_filename = "meta/main.h")]
	public static void exit (Meta.ExitCode code);
#if HAS_MUTTER44
	[CCode (cheader_filename = "meta/main.h")]
	public static void get_clutter_debug_flags (out Clutter.DebugFlag debug_flags, out Clutter.DrawDebugFlag draw_flags, out Clutter.PickDebugFlag pick_flags);
#endif
	[CCode (cheader_filename = "meta/main.h")]
	public static Meta.DebugPaintFlag get_debug_paint_flags ();
	[CCode (cheader_filename = "meta/main.h")]
	public static bool is_restart ();
	[CCode (cheader_filename = "meta/main.h")]
	public static bool is_topic_enabled (Meta.DebugTopic topic);
#if HAS_MUTTER44
	[CCode (cheader_filename = "meta/main.h")]
	public static void log (string format, ...);
#endif
	[CCode (cheader_filename = "meta/main.h")]
	public static void remove_clutter_debug_flags (Clutter.DebugFlag debug_flags, Clutter.DrawDebugFlag draw_flags, Clutter.PickDebugFlag pick_flags);
	[CCode (cheader_filename = "meta/main.h")]
	public static void remove_debug_paint_flag (Meta.DebugPaintFlag flag);
	[CCode (cheader_filename = "meta/main.h")]
#if HAS_MUTTER43
	public static void restart (string? message, Meta.Context context);
#else
	public static void restart (string? message);
#endif
}

