/* libical.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "")]
namespace ICal {
	[CCode (cheader_filename = "libical/ical.h", free_function = "icalarray_free", cname = "icalarray")]
	[Compact]
	public class Array<G> {
		public G data;
		public size_t element_size;
		public size_t increment_size;
		public size_t num_elements;
		public size_t space_allocated;
		[CCode (cname = "icalarray_new", has_construct_function = false)]
		public Array (size_t element_size, size_t increment_size);
		[CCode (cname = "icalarray_append")]
		public void append (G element);
		[CCode (cname = "icalarray_element_at")]
		public G element_at (size_t position);
		[CCode (cname = "icalarray_remove_element_at")]
		public void remove_element_at (size_t position);
		[CCode (cname = "icalarray_sort")]
		public void sort (GLib.Callback compare);
		[CCode (cname = "_vala_icalarray_size")]
		public int size () {
			return (int) num_elements;
		}
	}
	[CCode (cheader_filename = "libical/ical.h", ref_function = "icalattach_ref", ref_function_void = true, unref_function = "icalattach_unref", cname = "icalattach")]
	[Compact]
	public class Attach {
		[CCode (cname = "icalattach_new_from_data", has_construct_function = false)]
		public Attach.from_data (uint data, ICal.icalattach_free_fn_t free_fn, void* free_fn_data);
		[CCode (cname = "icalattach_new_from_url", has_construct_function = false)]
		public Attach.from_url (string url);
		[CCode (cname = "icalattach_get_data")]
		public uint get_data ();
		[CCode (cname = "icalattach_get_is_url")]
		public int get_is_url ();
		[CCode (cname = "icalattach_get_url")]
		public unowned string get_url ();
	}
	[CCode (cheader_filename = "libical/ical.h", cname = "icalcompiter")]
	[Compact]
	public class Compiter {
		public weak ICal.PvlElement iter;
		public ICal.ComponentKind kind;
		[CCode (cname = "icalcompiter_deref")]
		public unowned ICal.Component deref ();
		[CCode (cname = "icalcompiter_next")]
		public unowned ICal.Component next ();
		[CCode (cname = "icalcompiter_prior")]
		public unowned ICal.Component prior ();
	}
	[CCode (cheader_filename = "libical/ical.h", copy_function = "icalcomponent_new_clone", free_function = "icalcomponent_free", cname = "icalcomponent")]
	[Compact]
	public class Component {
		[CCode (cname = "icalcomponent_new", has_construct_function = false)]
		public Component (ICal.ComponentKind kind);
		[CCode (cname = "icalcomponent_add_component")]
		public void add_component (ICal.Component child);
		[CCode (cname = "icalcomponent_add_property")]
		public void add_property (ICal.Property property);
		[CCode (cname = "icalcomponent_as_ical_string")]
		public unowned string as_ical_string ();
		[CCode (cname = "icalcomponent_as_ical_string_r")]
		public unowned string as_ical_string_r ();
		[CCode (cname = "icalcomponent_begin_component")]
		public unowned ICal.Compiter begin_component (ICal.ComponentKind kind);
		[CCode (cname = "icalcomponent_check_restrictions")]
		public int check_restrictions ();
		[CCode (cname = "icalcomponent_new_clone")]
		public ICal.Component clone ();
		[CCode (cname = "icalcomponent_convert_errors")]
		public void convert_errors ();
		[CCode (cname = "icalcomponent_count_components")]
		public int count_components (ICal.ComponentKind kind);
		[CCode (cname = "icalcomponent_count_errors")]
		public int count_errors ();
		[CCode (cname = "icalcomponent_count_properties")]
		public int count_properties (ICal.PropertyKind kind);
		[CCode (cname = "icalcomponent_end_component")]
		public unowned ICal.Compiter end_component (ICal.ComponentKind kind);
		[CCode (cname = "icalcomponent_foreach_recurrence")]
		public void foreach_recurrence (ICal.Time start, ICal.Time end, ICal.ForeachRecurrenceCb cb);
		[CCode (cname = "icalcomponent_foreach_tzid")]
		public void foreach_tzid (GLib.Callback callback, void* callback_data);
		[CCode (cname = "icalcomponent_new_from_string", has_construct_function = false)]
		public Component.from_string (string str);
		[CCode (cname = "icalcomponent_get_comment")]
		public unowned string get_comment ();
		[CCode (cname = "icalcomponent_get_current_component")]
		public unowned ICal.Component get_current_component ();
		[CCode (cname = "icalcomponent_get_current_property")]
		public unowned ICal.Property get_current_property ();
		[CCode (cname = "icalcomponent_get_description")]
		public unowned string get_description ();
		[CCode (cname = "icalcomponent_get_dtend")]
		public ICal.Time get_dtend ();
		[CCode (cname = "icalcomponent_get_dtstamp")]
		public ICal.Time get_dtstamp ();
		[CCode (cname = "icalcomponent_get_dtstart")]
		public ICal.Time get_dtstart ();
		[CCode (cname = "icalcomponent_get_due")]
		public ICal.Time get_due ();
		[CCode (cname = "icalcomponent_get_duration")]
		public unowned ICal.Duration get_duration ();
		[CCode (cname = "icalcomponent_get_first_component")]
		public unowned ICal.Component  get_first_component (ICal.ComponentKind kind);
		[CCode (cname = "icalcomponent_get_first_property")]
		public unowned ICal.Property get_first_property (ICal.PropertyKind kind);
		[CCode (cname = "icalcomponent_get_first_real_component")]
		public unowned ICal.Component  get_first_real_component ();
		[CCode (cname = "icalcomponent_get_inner")]
		public unowned ICal.Component  get_inner ();
		[CCode (cname = "icalcomponent_get_location")]
		public unowned string get_location ();
		[CCode (cname = "icalcomponent_get_method")]
		public ICal.PropertyMethod get_method ();
		[CCode (cname = "icalcomponent_get_next_component")]
		public unowned ICal.Component  get_next_component (ICal.ComponentKind kind);
		[CCode (cname = "icalcomponent_get_next_property")]
		public unowned ICal.Property get_next_property (ICal.PropertyKind kind);
		[CCode (cname = "icalcomponent_get_parent")]
		public unowned ICal.Component  get_parent ();
		[CCode (cname = "icalcomponent_get_recurrenceid")]
		public ICal.Time get_recurrenceid ();
		[CCode (cname = "icalcomponent_get_relcalid")]
		public unowned string get_relcalid ();
		[CCode (cname = "icalcomponent_get_sequence")]
		public int get_sequence ();
		[CCode (cname = "icalcomponent_get_span")]
		public unowned ICal.TimeSpan get_span ();
		[CCode (cname = "icalcomponent_get_status")]
		public ICal.PropertyStatus get_status ();
		[CCode (cname = "icalcomponent_get_summary")]
		public unowned string get_summary ();
		[CCode (cname = "icalcomponent_get_timezone")]
		public unowned ICal.Timezone get_timezone (string tzid);
		[CCode (cname = "icalcomponent_get_uid")]
		public unowned string get_uid ();
		[CCode (cname = "icalcomponent_is_valid")]
		private int _is_valid ();
		[CCode (cname = "_vala_icalcomponent_is_valid")]
		public bool is_valid () {
			return _is_valid () != 0;
		}
		[CCode (cname = "icalcomponent_isa")]
		public ICal.ComponentKind isa ();
		[CCode (cname = "icalcomponent_isa_component")]
		public static int isa_component (void* component);
		[CCode (cname = "icalcomponent_kind_is_valid")]
		public static int kind_is_valid (ICal.ComponentKind kind);
		[CCode (cname = "icalcomponent_kind_to_string")]
		public static unowned string kind_to_string (ICal.ComponentKind kind);
		[CCode (cname = "icalcomponent_merge_component")]
		public void merge_component (ICal.Component  comp_to_merge);
		[CCode (cname = "icalcomponent_remove_component")]
		public void remove_component (ICal.Component  child);
		[CCode (cname = "icalcomponent_remove_property")]
		public void remove_property (ICal.Property property);
		[CCode (cname = "icalcomponent_set_comment")]
		public void set_comment (string v);
		[CCode (cname = "icalcomponent_set_description")]
		public void set_description (string v);
		[CCode (cname = "icalcomponent_set_dtend")]
		public void set_dtend (ICal.Time v);
		[CCode (cname = "icalcomponent_set_dtstamp")]
		public void set_dtstamp (ICal.Time v);
		[CCode (cname = "icalcomponent_set_dtstart")]
		public void set_dtstart (ICal.Time v);
		[CCode (cname = "icalcomponent_set_due")]
		public void set_due (ICal.Time v);
		[CCode (cname = "icalcomponent_set_duration")]
		public void set_duration (ICal.Duration v);
		[CCode (cname = "icalcomponent_set_location")]
		public void set_location (string v);
		[CCode (cname = "icalcomponent_set_method")]
		public void set_method (ICal.PropertyMethod method);
		[CCode (cname = "icalcomponent_set_parent")]
		public void set_parent (ICal.Component  parent);
		[CCode (cname = "icalcomponent_set_recurrenceid")]
		public void set_recurrenceid (ICal.Time v);
		[CCode (cname = "icalcomponent_set_relcalid")]
		public void set_relcalid (string v);
		[CCode (cname = "icalcomponent_set_sequence")]
		public void set_sequence (int v);
		[CCode (cname = "icalcomponent_set_status")]
		public void set_status (ICal.PropertyStatus v);
		[CCode (cname = "icalcomponent_set_summary")]
		public void set_summary (string v);
		[CCode (cname = "icalcomponent_set_uid")]
		public void set_uid (string v);
		[CCode (cname = "icalcomponent_string_to_kind")]
		public static ICal.ComponentKind string_to_kind (string str);
		[CCode (cname = "icalcomponent_strip_errors")]
		public void strip_errors ();
		[CCode (cname = "icalcomponent_new_vagenda", has_construct_function = false)]
		public Component.vagenda ();
		[CCode (cname = "icalcomponent_new_valarm", has_construct_function = false)]
		public Component.valarm ();
		[CCode (cname = "icalcomponent_vanew")]
		public static unowned ICal.Component  vanew (ICal.ComponentKind kind);
		[CCode (cname = "icalcomponent_new_vcalendar", has_construct_function = false)]
		public Component.vcalendar ();
		[CCode (cname = "icalcomponent_new_vevent", has_construct_function = false)]
		public Component.vevent ();
		[CCode (cname = "icalcomponent_new_vfreebusy", has_construct_function = false)]
		public Component.vfreebusy ();
		[CCode (cname = "icalcomponent_new_vjournal", has_construct_function = false)]
		public Component.vjournal ();
		[CCode (cname = "icalcomponent_new_vquery", has_construct_function = false)]
		public Component.vquery ();
		[CCode (cname = "icalcomponent_new_vtimezone", has_construct_function = false)]
		public Component.vtimezone ();
		[CCode (cname = "icalcomponent_new_vtodo", has_construct_function = false)]
		public Component.vtodo ();
		[CCode (cname = "icalcomponent_new_x", has_construct_function = false)]
		public Component.x (string x_name);
		[CCode (cname = "icalcomponent_new_xdaylight", has_construct_function = false)]
		public Component.xdaylight ();
		[CCode (cname = "icalcomponent_new_xstandard", has_construct_function = false)]
		public Component.xstandard ();
	}
	[SimpleType]
	[CCode (cheader_filename = "libical/ical.h", cname = "struct icaldurationtype", has_type_id = false)]
	public struct Duration {
		public uint days;
		public uint hours;
		public int is_neg;
		public uint minutes;
		public uint seconds;
		public uint weeks;
		[CCode (cname = "icaldurationtype_as_ical_string")]
		public unowned string as_ical_string ();
		[CCode (cname = "icaldurationtype_as_ical_string_r")]
		public unowned string as_ical_string_r ();
		[CCode (cname = "icaldurationtype_as_int")]
		public int as_int ();
		[CCode (cname = "icaldurationtype_bad_duration")]
		public static ICal.Duration bad_duration ();
		[CCode (cname = "icaldurationtype_from_int")]
		public static ICal.Duration from_int (int t);
		[CCode (cname = "icaldurationtype_from_string")]
		public static ICal.Duration from_string (string p1);
		[CCode (cname = "icaldurationtype_is_bad_duration")]
		public int is_bad_duration ();
		[CCode (cname = "icaldurationtype_is_null_duration")]
		private int _is_null_duration ();
		[CCode (cname = "_vala_icaldurationtype_is_null_duration")]
		public bool is_null_duration () {
			return _is_null_duration () != 0;
		}
		[CCode (cname = "icaldurationtype_null_duration")]
		public static ICal.Duration null_duration ();
		[CCode (cname = "_vala_icaldurationtype_get_days")]
		public uint get_days () {
			return days;
		}
		[CCode (cname = "_vala_icaldurationtype_get_hours")]
		public uint get_hours () {
			return hours;
		}
		[CCode (cname = "_vala_icaldurationtype_get_minutes")]
		public uint get_minutes () {
			return minutes;
		}
		[CCode (cname = "_vala_icaldurationtype_get_seconds")]
		public uint get_seconds () {
			return seconds;
		}
		[CCode (cname = "_vala_icaldurationtype_get_weeks")]
		public uint get_weeks () {
			return weeks;
		}
	}
	[CCode (cheader_filename = "libical/ical.h", copy_function = "icalparameter_new_clone", free_function = "icalparameter_free", cname = "icalparameter")]
	[Compact]
	public class Parameter {
		[CCode (cname = "icalparameter_new", has_construct_function = false)]
		public Parameter (ICal.ParameterKind kind);
		[CCode (cname = "icalparameter_new_actionparam", has_construct_function = false)]
		public Parameter.actionparam (ICal.ParameterAction v);
		[CCode (cname = "icalparameter_new_altrep", has_construct_function = false)]
		public Parameter.altrep (string v);
		[CCode (cname = "icalparameter_as_ical_string")]
		public unowned string as_ical_string ();
		[CCode (cname = "icalparameter_as_ical_string_r")]
		public unowned string as_ical_string_r ();
		[CCode (cname = "icalparameter_new_charset", has_construct_function = false)]
		public Parameter.charset (string v);
		[CCode (cname = "icalparameter_new_cn", has_construct_function = false)]
		public Parameter.cn (string v);
		[CCode (cname = "icalparameter_new_cutype", has_construct_function = false)]
		public Parameter.cutype (ICal.ParameterCutype v);
		[CCode (cname = "icalparameter_new_delegatedfrom", has_construct_function = false)]
		public Parameter.delegatedfrom (string v);
		[CCode (cname = "icalparameter_new_delegatedto", has_construct_function = false)]
		public Parameter.delegatedto (string v);
		[CCode (cname = "icalparameter_new_dir", has_construct_function = false)]
		public Parameter.dir (string v);
		[CCode (cname = "icalparameter_new_enable", has_construct_function = false)]
		public Parameter.enable (ICal.ParameterEnable v);
		[CCode (cname = "icalparameter_new_encoding", has_construct_function = false)]
		public Parameter.encoding (ICal.ParameterEncoding v);
		[CCode (cname = "icalparameter_enum_to_string")]
		public static unowned string enum_to_string (int e);
		[CCode (cname = "icalparameter_new_fbtype", has_construct_function = false)]
		public Parameter.fbtype (ICal.ParameterFbType v);
		[CCode (cname = "icalparameter_new_fmttype", has_construct_function = false)]
		public Parameter.fmttype (string v);
		[CCode (cname = "icalparameter_new_from_string", has_construct_function = false)]
		public Parameter.from_string (string value);
		[CCode (cname = "icalparameter_new_from_value_string", has_construct_function = false)]
		public Parameter.from_value_string (ICal.ParameterKind kind, string value);
		[CCode (cname = "icalparameter_new_clone")]
		public Parameter clone ();
		[CCode (cname = "icalparameter_get_actionparam")]
		public ICal.ParameterAction get_actionparam ();
		[CCode (cname = "icalparameter_get_altrep")]
		public unowned string get_altrep ();
		[CCode (cname = "icalparameter_get_charset")]
		public unowned string get_charset ();
		[CCode (cname = "icalparameter_get_cn")]
		public unowned string get_cn ();
		[CCode (cname = "icalparameter_get_cutype")]
		public ICal.ParameterCutype get_cutype ();
		[CCode (cname = "icalparameter_get_delegatedfrom")]
		public unowned string get_delegatedfrom ();
		[CCode (cname = "icalparameter_get_delegatedto")]
		public unowned string get_delegatedto ();
		[CCode (cname = "icalparameter_get_dir")]
		public unowned string get_dir ();
		[CCode (cname = "icalparameter_get_enable")]
		public ICal.ParameterEnable get_enable ();
		[CCode (cname = "icalparameter_get_encoding")]
		public ICal.ParameterEncoding get_encoding ();
		[CCode (cname = "icalparameter_get_fbtype")]
		public ICal.ParameterFbType get_fbtype ();
		[CCode (cname = "icalparameter_get_fmttype")]
		public unowned string get_fmttype ();
		[CCode (cname = "icalparameter_get_id")]
		public unowned string get_id ();
		[CCode (cname = "icalparameter_get_language")]
		public unowned string get_language ();
		[CCode (cname = "icalparameter_get_latency")]
		public unowned string get_latency ();
		[CCode (cname = "icalparameter_get_local")]
		public ICal.ParameterLocal get_local ();
		[CCode (cname = "icalparameter_get_localize")]
		public unowned string get_localize ();
		[CCode (cname = "icalparameter_get_member")]
		public unowned string get_member ();
		[CCode (cname = "icalparameter_get_options")]
		public unowned string get_options ();
		[CCode (cname = "icalparameter_get_partstat")]
		public ICal.ParameterPartstat get_partstat ();
		[CCode (cname = "icalparameter_get_range")]
		public ICal.ParameterRange get_range ();
		[CCode (cname = "icalparameter_get_related")]
		public ICal.ParameterRelated get_related ();
		[CCode (cname = "icalparameter_get_reltype")]
		public ICal.ParameterRelationType get_relation_type ();
		[CCode (cname = "icalparameter_get_role")]
		public ICal.ParameterRole get_role ();
		[CCode (cname = "icalparameter_get_rsvp")]
		public ICal.ParameterRsvp get_rsvp ();
		[CCode (cname = "icalparameter_get_sentby")]
		public unowned string get_sentby ();
		[CCode (cname = "icalparameter_get_tzid")]
		public unowned string get_tzid ();
		[CCode (cname = "icalparameter_get_value")]
		public ICal.ParameterValue get_value ();
		[CCode (cname = "icalparameter_get_x")]
		public unowned string get_x ();
		[CCode (cname = "icalparameter_get_xliccomparetype")]
		public ICal.ParameterXlicCompareType get_xliccomparetype ();
		[CCode (cname = "icalparameter_get_xlicerrortype")]
		public ICal.ParameterXlicErrorType get_xlicerrortype ();
		[CCode (cname = "icalparameter_get_xname")]
		public unowned string get_xname ();
		[CCode (cname = "icalparameter_get_xvalue")]
		public unowned string get_xvalue ();
		[CCode (cname = "icalparameter_new_id", has_construct_function = false)]
		public Parameter.id (string v);
		[CCode (cname = "icalparameter_is_valid")]
		public int is_valid ();
		[CCode (cname = "icalparameter_isa")]
		public ICal.ParameterKind isa ();
		[CCode (cname = "icalparameter_isa_parameter")]
		public static int isa_parameter (void* param);
		[CCode (cname = "icalparameter_kind_to_string")]
		public static unowned string kind_to_string (ICal.ParameterKind kind);
		[CCode (cname = "icalparameter_new_language", has_construct_function = false)]
		public Parameter.language (string v);
		[CCode (cname = "icalparameter_new_latency", has_construct_function = false)]
		public Parameter.latency (string v);
		[CCode (cname = "icalparameter_new_local", has_construct_function = false)]
		public Parameter.local (ICal.ParameterLocal v);
		[CCode (cname = "icalparameter_new_localize", has_construct_function = false)]
		public Parameter.localize (string v);
		[CCode (cname = "icalparameter_new_member", has_construct_function = false)]
		public Parameter.member (string v);
		[CCode (cname = "icalparameter_new_options", has_construct_function = false)]
		public Parameter.options (string v);
		[CCode (cname = "icalparameter_new_partstat", has_construct_function = false)]
		public Parameter.partstat (ICal.ParameterPartstat v);
		[CCode (cname = "icalparameter_new_range", has_construct_function = false)]
		public Parameter.range (ICal.ParameterRange v);
		[CCode (cname = "icalparameter_new_related", has_construct_function = false)]
		public Parameter.related (ICal.ParameterRelated v);
		[CCode (cname = "icalparameter_new_reltype", has_construct_function = false)]
		public Parameter.relation_type (ICal.ParameterRelationType v);
		[CCode (cname = "icalparameter_new_role", has_construct_function = false)]
		public Parameter.role (ICal.ParameterRole v);
		[CCode (cname = "icalparameter_new_rsvp", has_construct_function = false)]
		public Parameter.rsvp (ICal.ParameterRsvp v);
		[CCode (cname = "icalparameter_new_sentby", has_construct_function = false)]
		public Parameter.sentby (string v);
		[CCode (cname = "icalparameter_set_actionparam")]
		public void set_actionparam (ICal.ParameterAction v);
		[CCode (cname = "icalparameter_set_altrep")]
		public void set_altrep (string v);
		[CCode (cname = "icalparameter_set_charset")]
		public void set_charset (string v);
		[CCode (cname = "icalparameter_set_cn")]
		public void set_cn (string v);
		[CCode (cname = "icalparameter_set_cutype")]
		public void set_cutype (ICal.ParameterCutype v);
		[CCode (cname = "icalparameter_set_delegatedfrom")]
		public void set_delegatedfrom (string v);
		[CCode (cname = "icalparameter_set_delegatedto")]
		public void set_delegatedto (string v);
		[CCode (cname = "icalparameter_set_dir")]
		public void set_dir (string v);
		[CCode (cname = "icalparameter_set_enable")]
		public void set_enable (ICal.ParameterEnable v);
		[CCode (cname = "icalparameter_set_encoding")]
		public void set_encoding (ICal.ParameterEncoding v);
		[CCode (cname = "icalparameter_set_fbtype")]
		public void set_fbtype (ICal.ParameterFbType v);
		[CCode (cname = "icalparameter_set_fmttype")]
		public void set_fmttype (string v);
		[CCode (cname = "icalparameter_set_id")]
		public void set_id (string v);
		[CCode (cname = "icalparameter_set_language")]
		public void set_language (string v);
		[CCode (cname = "icalparameter_set_latency")]
		public void set_latency (string v);
		[CCode (cname = "icalparameter_set_local")]
		public void set_local (ICal.ParameterLocal v);
		[CCode (cname = "icalparameter_set_localize")]
		public void set_localize (string v);
		[CCode (cname = "icalparameter_set_member")]
		public void set_member (string v);
		[CCode (cname = "icalparameter_set_options")]
		public void set_options (string v);
		[CCode (cname = "icalparameter_set_partstat")]
		public void set_partstat (ICal.ParameterPartstat v);
		[CCode (cname = "icalparameter_set_range")]
		public void set_range (ICal.ParameterRange v);
		[CCode (cname = "icalparameter_set_related")]
		public void set_related (ICal.ParameterRelated v);
		[CCode (cname = "icalparameter_set_reltype")]
		public void set_relation_type (ICal.ParameterRelationType v);
		[CCode (cname = "icalparameter_set_role")]
		public void set_role (ICal.ParameterRole v);
		[CCode (cname = "icalparameter_set_rsvp")]
		public void set_rsvp (ICal.ParameterRsvp v);
		[CCode (cname = "icalparameter_set_sentby")]
		public void set_sentby (string v);
		[CCode (cname = "icalparameter_set_tzid")]
		public void set_tzid (string v);
		[CCode (cname = "icalparameter_set_value")]
		public void set_value (ICal.ParameterValue v);
		[CCode (cname = "icalparameter_set_x")]
		public void set_x (string v);
		[CCode (cname = "icalparameter_set_xliccomparetype")]
		public void set_xliccomparetype (ICal.ParameterXlicCompareType v);
		[CCode (cname = "icalparameter_set_xlicerrortype")]
		public void set_xlicerrortype (ICal.ParameterXlicErrorType v);
		[CCode (cname = "icalparameter_set_xname")]
		public void set_xname (string v);
		[CCode (cname = "icalparameter_set_xvalue")]
		public void set_xvalue (string v);
		[CCode (cname = "icalparameter_string_to_enum")]
		public static int string_to_enum (string str);
		[CCode (cname = "icalparameter_string_to_kind")]
		public static ICal.ParameterKind string_to_kind (string str);
		[CCode (cname = "icalparameter_new_tzid", has_construct_function = false)]
		public Parameter.tzid (string v);
		[CCode (cname = "icalparameter_new_value", has_construct_function = false)]
		public Parameter.value (ICal.ParameterValue v);
		[CCode (cname = "icalparameter_value_to_value_kind")]
		public static ICal.ValueKind value_to_value_kind (ICal.ParameterValue value);
		[CCode (cname = "icalparameter_new_x", has_construct_function = false)]
		public Parameter.x (string v);
		[CCode (cname = "icalparameter_new_xliccomparetype", has_construct_function = false)]
		public Parameter.xliccomparetype (ICal.ParameterXlicCompareType v);
		[CCode (cname = "icalparameter_new_xlicerrortype", has_construct_function = false)]
		public Parameter.xlicerrortype (ICal.ParameterXlicErrorType v);
	}
	[CCode (cheader_filename = "libical/ical.h", free_function = "icalparser_free", cname = "icalparser")]
	[Compact]
	public class Parser {
		[CCode (cname = "icalparser_new", has_construct_function = false)]
		public Parser ();
		[CCode (cname = "icalparser_add_line")]
		public unowned ICal.Component add_line (string str);
		[CCode (cname = "icalparser_clean")]
		public unowned ICal.Component clean ();
		[CCode (cname = "icalparser_get_line")]
		public unowned string get_line (GLib.Callback line_gen_func);
		[CCode (cname = "icalparser_get_state")]
		public ICal.ParserState get_state ();
		[CCode (cname = "icalparser_parse")]
		public unowned ICal.Component  parse (GLib.Callback line_gen_func);
		[CCode (cname = "icalparser_parse_string")]
		public static unowned ICal.Component  parse_string (string str);
		[CCode (cname = "icalparser_parse_value")]
		public static unowned ICal.Value parse_value (ICal.ValueKind kind, string str, out unowned ICal.Component  errors);
		[CCode (cname = "icalparser_set_gen_data")]
		public void set_gen_data (void* data);
		[CCode (cname = "icalparser_string_line_generator")]
		public static unowned string string_line_generator (string @out, size_t buf_size, void* d);
	}
	[CCode (cheader_filename = "libical/ical.h", copy_function = "icalproperty_new_clone", free_function = "icalproperty_free", cname = "icalproperty")]
	[Compact]
	public class Property {
		[CCode (cname = "icalproperty_new", has_construct_function = false)]
		public Property (ICal.PropertyKind kind);
		[CCode (cname = "icalproperty_new_action", has_construct_function = false)]
		public Property.action (ICal.PropertyAction v);
		[CCode (cname = "icalproperty_add_parameter")]
		public void add_parameter (ICal.Parameter parameter);
		[CCode (cname = "icalproperty_add_parameters")]
		public static void add_parameters (ICal.Property prop, void* args);
		[CCode (cname = "icalproperty_new_allowconflict", has_construct_function = false)]
		public Property.allowconflict (string v);
		[CCode (cname = "icalproperty_as_ical_string")]
		public unowned string as_ical_string ();
		[CCode (cname = "icalproperty_as_ical_string_r")]
		public unowned string as_ical_string_r ();
		[CCode (cname = "icalproperty_new_attach", has_construct_function = false)]
		public Property.attach (ICal.Attach v);
		[CCode (cname = "icalproperty_new_attendee", has_construct_function = false)]
		public Property.attendee (string v);
		[CCode (cname = "icalproperty_new_calid", has_construct_function = false)]
		public Property.calid (string v);
		[CCode (cname = "icalproperty_new_calmaster", has_construct_function = false)]
		public Property.calmaster (string v);
		[CCode (cname = "icalproperty_new_calscale", has_construct_function = false)]
		public Property.calscale (string v);
		[CCode (cname = "icalproperty_new_capversion", has_construct_function = false)]
		public Property.capversion (string v);
		[CCode (cname = "icalproperty_new_carid", has_construct_function = false)]
		public Property.carid (string v);
		[CCode (cname = "icalproperty_new_carlevel", has_construct_function = false)]
		public Property.carlevel (ICal.PropertyCarlevel v);
		[CCode (cname = "icalproperty_new_categories", has_construct_function = false)]
		public Property.categories (string v);
		[CCode (cname = "icalproperty_new_class", has_construct_function = false)]
		public Property.@class (ICal.PropertyClass v);
		[CCode (cname = "icalproperty_new_cmd", has_construct_function = false)]
		public Property.cmd (ICal.PropertyCmd v);
		[CCode (cname = "icalproperty_new_comment", has_construct_function = false)]
		public Property.comment (string v);
		[CCode (cname = "icalproperty_new_completed", has_construct_function = false)]
		public Property.completed (ICal.Time v);
		[CCode (cname = "icalproperty_new_components", has_construct_function = false)]
		public Property.components (string v);
		[CCode (cname = "icalproperty_new_contact", has_construct_function = false)]
		public Property.contact (string v);
		[CCode (cname = "icalproperty_count_parameters")]
		public int count_parameters ();
		[CCode (cname = "icalproperty_new_created", has_construct_function = false)]
		public Property.created (ICal.Time v);
		[CCode (cname = "icalproperty_new_csid", has_construct_function = false)]
		public Property.csid (string v);
		[CCode (cname = "icalproperty_new_datemax", has_construct_function = false)]
		public Property.datemax (ICal.Time v);
		[CCode (cname = "icalproperty_new_datemin", has_construct_function = false)]
		public Property.datemin (ICal.Time v);
		[CCode (cname = "icalproperty_new_decreed", has_construct_function = false)]
		public Property.decreed (string v);
		[CCode (cname = "icalproperty_new_defaultcharset", has_construct_function = false)]
		public Property.defaultcharset (string v);
		[CCode (cname = "icalproperty_new_defaultlocale", has_construct_function = false)]
		public Property.defaultlocale (string v);
		[CCode (cname = "icalproperty_new_defaulttzid", has_construct_function = false)]
		public Property.defaulttzid (string v);
		[CCode (cname = "icalproperty_new_defaultvcars", has_construct_function = false)]
		public Property.defaultvcars (string v);
		[CCode (cname = "icalproperty_new_deny", has_construct_function = false)]
		public Property.deny (string v);
		[CCode (cname = "icalproperty_new_description", has_construct_function = false)]
		public Property.description (string v);
		[CCode (cname = "icalproperty_new_dtend", has_construct_function = false)]
		public Property.dtend (ICal.Time v);
		[CCode (cname = "icalproperty_new_dtstamp", has_construct_function = false)]
		public Property.dtstamp (ICal.Time v);
		[CCode (cname = "icalproperty_new_dtstart", has_construct_function = false)]
		public Property.dtstart (ICal.Time v);
		[CCode (cname = "icalproperty_new_due", has_construct_function = false)]
		public Property.due (ICal.Time v);
		[CCode (cname = "icalproperty_new_duration", has_construct_function = false)]
		public Property.duration (ICal.Duration v);
		[CCode (cname = "icalproperty_enum_belongs_to_property")]
		public static int enum_belongs_to_property (ICal.PropertyKind kind, int e);
		[CCode (cname = "icalproperty_enum_to_string")]
		public static unowned string enum_to_string (int e);
		[CCode (cname = "icalproperty_enum_to_string_r")]
		public static unowned string enum_to_string_r (int e);
		[CCode (cname = "icalproperty_new_exdate", has_construct_function = false)]
		public Property.exdate (ICal.Time v);
		[CCode (cname = "icalproperty_new_expand", has_construct_function = false)]
		public Property.expand (int v);
		[CCode (cname = "icalproperty_new_exrule", has_construct_function = false)]
		public Property.exrule (ICal.Recurrence v);
		[CCode (cname = "icalproperty_new_freebusy", has_construct_function = false)]
		public Property.freebusy (ICal.PeriodType v);
		[CCode (cname = "icalproperty_new_from_string", has_construct_function = false)]
		public Property.from_string (string str);
		[CCode (cname = "icalproperty_new_geo", has_construct_function = false)]
		public Property.geo (ICal.Geo v);
		[CCode (cname = "icalproperty_new_clone")]
		public Property clone ();
		[CCode (cname = "icalproperty_get_action")]
		public ICal.PropertyAction get_action ();
		[CCode (cname = "icalproperty_get_allowconflict")]
		public unowned string get_allowconflict ();
		[CCode (cname = "icalproperty_get_attach")]
		public unowned ICal.Attach get_attach ();
		[CCode (cname = "icalproperty_get_attendee")]
		public unowned string get_attendee ();
		[CCode (cname = "icalproperty_get_calid")]
		public unowned string get_calid ();
		[CCode (cname = "icalproperty_get_calmaster")]
		public unowned string get_calmaster ();
		[CCode (cname = "icalproperty_get_calscale")]
		public unowned string get_calscale ();
		[CCode (cname = "icalproperty_get_capversion")]
		public unowned string get_capversion ();
		[CCode (cname = "icalproperty_get_carid")]
		public unowned string get_carid ();
		[CCode (cname = "icalproperty_get_carlevel")]
		public ICal.PropertyCarlevel get_carlevel ();
		[CCode (cname = "icalproperty_get_categories")]
		public unowned string get_categories ();
		[CCode (cname = "icalproperty_get_class")]
		public ICal.PropertyClass get_class ();
		[CCode (cname = "icalproperty_get_cmd")]
		public ICal.PropertyCmd get_cmd ();
		[CCode (cname = "icalproperty_get_comment")]
		public unowned string get_comment ();
		[CCode (cname = "icalproperty_get_completed")]
		public ICal.Time get_completed ();
		[CCode (cname = "icalproperty_get_components")]
		public unowned string get_components ();
		[CCode (cname = "icalproperty_get_contact")]
		public unowned string get_contact ();
		[CCode (cname = "icalproperty_get_created")]
		public ICal.Time get_created ();
		[CCode (cname = "icalproperty_get_csid")]
		public unowned string get_csid ();
		[CCode (cname = "icalproperty_get_datemax")]
		public ICal.Time get_datemax ();
		[CCode (cname = "icalproperty_get_datemin")]
		public ICal.Time get_datemin ();
		[CCode (cname = "icalproperty_get_decreed")]
		public unowned string get_decreed ();
		[CCode (cname = "icalproperty_get_defaultcharset")]
		public unowned string get_defaultcharset ();
		[CCode (cname = "icalproperty_get_defaultlocale")]
		public unowned string get_defaultlocale ();
		[CCode (cname = "icalproperty_get_defaulttzid")]
		public unowned string get_defaulttzid ();
		[CCode (cname = "icalproperty_get_defaultvcars")]
		public unowned string get_defaultvcars ();
		[CCode (cname = "icalproperty_get_deny")]
		public unowned string get_deny ();
		[CCode (cname = "icalproperty_get_description")]
		public unowned string get_description ();
		[CCode (cname = "icalproperty_get_dtend")]
		public ICal.Time get_dtend ();
		[CCode (cname = "icalproperty_get_dtstamp")]
		public ICal.Time get_dtstamp ();
		[CCode (cname = "icalproperty_get_dtstart")]
		public ICal.Time get_dtstart ();
		[CCode (cname = "icalproperty_get_due")]
		public ICal.Time get_due ();
		[CCode (cname = "icalproperty_get_duration")]
		public unowned ICal.Duration get_duration ();
		[CCode (cname = "icalproperty_get_exdate")]
		public ICal.Time get_exdate ();
		[CCode (cname = "icalproperty_get_expand")]
		public int get_expand ();
		[CCode (cname = "icalproperty_get_exrule")]
		public ICal.Recurrence get_exrule ();
		[CCode (cname = "icalproperty_get_first_parameter")]
		public unowned ICal.Parameter get_first_parameter (ICal.ParameterKind kind);
		[CCode (cname = "icalproperty_get_freebusy")]
		public ICal.PeriodType get_freebusy ();
		[CCode (cname = "icalproperty_get_geo")]
		public ICal.Geo get_geo ();
		[CCode (cname = "icalproperty_get_grant")]
		public unowned string get_grant ();
		[CCode (cname = "icalproperty_get_itipversion")]
		public unowned string get_itipversion ();
		[CCode (cname = "icalproperty_get_lastmodified")]
		public ICal.Time get_lastmodified ();
		[CCode (cname = "icalproperty_get_location")]
		public unowned string get_location ();
		[CCode (cname = "icalproperty_get_maxcomponentsize")]
		public int get_maxcomponentsize ();
		[CCode (cname = "icalproperty_get_maxdate")]
		public ICal.Time get_maxdate ();
		[CCode (cname = "icalproperty_get_maxresults")]
		public int get_maxresults ();
		[CCode (cname = "icalproperty_get_maxresultssize")]
		public int get_maxresultssize ();
		[CCode (cname = "icalproperty_get_method")]
		public ICal.PropertyMethod get_method ();
		[CCode (cname = "icalproperty_get_mindate")]
		public ICal.Time get_mindate ();
		[CCode (cname = "icalproperty_get_multipart")]
		public unowned string get_multipart ();
		[CCode (cname = "icalproperty_get_name")]
		public unowned string get_name ();
		[CCode (cname = "icalproperty_get_next_parameter")]
		public unowned ICal.Parameter get_next_parameter (ICal.ParameterKind kind);
		[CCode (cname = "icalproperty_get_organizer")]
		public unowned string get_organizer ();
		[CCode (cname = "icalproperty_get_owner")]
		public unowned string get_owner ();
		[CCode (cname = "icalproperty_get_parameter_as_string")]
		public unowned string get_parameter_as_string (string name);
		[CCode (cname = "icalproperty_get_parameter_as_string_r")]
		public unowned string get_parameter_as_string_r (string name);
		[CCode (cname = "icalproperty_get_percentcomplete")]
		public int get_percentcomplete ();
		[CCode (cname = "icalproperty_get_permission")]
		public unowned string get_permission ();
		[CCode (cname = "icalproperty_get_priority")]
		public int get_priority ();
		[CCode (cname = "icalproperty_get_prodid")]
		public unowned string get_prodid ();
		[CCode (cname = "icalproperty_get_property_name")]
		public unowned string get_property_name ();
		[CCode (cname = "icalproperty_get_property_name_r")]
		public unowned string get_property_name_r ();
		[CCode (cname = "icalproperty_get_query")]
		public unowned string get_query ();
		[CCode (cname = "icalproperty_get_queryid")]
		public unowned string get_queryid ();
		[CCode (cname = "icalproperty_get_querylevel")]
		public ICal.PropertyQueryLevel get_querylevel ();
		[CCode (cname = "icalproperty_get_queryname")]
		public unowned string get_queryname ();
		[CCode (cname = "icalproperty_get_rdate")]
		public ICal.DateTimePeriodType get_rdate ();
		[CCode (cname = "icalproperty_get_recuraccepted")]
		public unowned string get_recuraccepted ();
		[CCode (cname = "icalproperty_get_recurexpand")]
		public unowned string get_recurexpand ();
		[CCode (cname = "icalproperty_get_recurlimit")]
		public unowned string get_recurlimit ();
		[CCode (cname = "icalproperty_get_recurrenceid")]
		public ICal.Time get_recurrenceid ();
		[CCode (cname = "icalproperty_get_relatedto")]
		public unowned string get_relatedto ();
		[CCode (cname = "icalproperty_get_relcalid")]
		public unowned string get_relcalid ();
		[CCode (cname = "icalproperty_get_repeat")]
		public int get_repeat ();
		[CCode (cname = "icalproperty_get_requeststatus")]
		public ICal.RequestStatusType get_requeststatus ();
		[CCode (cname = "icalproperty_get_resources")]
		public unowned string get_resources ();
		[CCode (cname = "icalproperty_get_restriction")]
		public unowned string get_restriction ();
		[CCode (cname = "icalproperty_get_rrule")]
		public ICal.Recurrence get_rrule ();
		[CCode (cname = "icalproperty_get_scope")]
		public unowned string get_scope ();
		[CCode (cname = "icalproperty_get_sequence")]
		public int get_sequence ();
		[CCode (cname = "icalproperty_get_status")]
		public ICal.PropertyStatus get_status ();
		[CCode (cname = "icalproperty_get_storesexpanded")]
		public unowned string get_storesexpanded ();
		[CCode (cname = "icalproperty_get_summary")]
		public unowned string get_summary ();
		[CCode (cname = "icalproperty_get_target")]
		public unowned string get_target ();
		[CCode (cname = "icalproperty_get_transp")]
		public ICal.PropertyTransparency get_transparency ();
		[CCode (cname = "icalproperty_get_trigger")]
		public ICal.TriggerType get_trigger ();
		[CCode (cname = "icalproperty_get_tzid")]
		public unowned string get_tzid ();
		[CCode (cname = "icalproperty_get_tzname")]
		public unowned string get_tzname ();
		[CCode (cname = "icalproperty_get_tzoffsetfrom")]
		public int get_tzoffsetfrom ();
		[CCode (cname = "icalproperty_get_tzoffsetto")]
		public int get_tzoffsetto ();
		[CCode (cname = "icalproperty_get_tzurl")]
		public unowned string get_tzurl ();
		[CCode (cname = "icalproperty_get_uid")]
		public unowned string get_uid ();
		[CCode (cname = "icalproperty_get_url")]
		public unowned string get_url ();
		[CCode (cname = "icalproperty_get_value")]
		public unowned ICal.Value get_value ();
		[CCode (cname = "icalproperty_get_value_as_string")]
		public unowned string get_value_as_string ();
		[CCode (cname = "icalproperty_get_value_as_string_r")]
		public unowned string get_value_as_string_r ();
		[CCode (cname = "icalproperty_get_version")]
		public unowned string get_version ();
		[CCode (cname = "icalproperty_get_x")]
		public unowned string get_x ();
		[CCode (cname = "icalproperty_get_x_name")]
		public unowned string get_x_name ();
		[CCode (cname = "icalproperty_get_xlicclass")]
		public ICal.PropertyXlicClass get_xlicclass ();
		[CCode (cname = "icalproperty_get_xlicclustercount")]
		public unowned string get_xlicclustercount ();
		[CCode (cname = "icalproperty_get_xlicerror")]
		public unowned string get_xlicerror ();
		[CCode (cname = "icalproperty_get_xlicmimecharset")]
		public unowned string get_xlicmimecharset ();
		[CCode (cname = "icalproperty_get_xlicmimecid")]
		public unowned string get_xlicmimecid ();
		[CCode (cname = "icalproperty_get_xlicmimecontenttype")]
		public unowned string get_xlicmimecontenttype ();
		[CCode (cname = "icalproperty_get_xlicmimeencoding")]
		public unowned string get_xlicmimeencoding ();
		[CCode (cname = "icalproperty_get_xlicmimefilename")]
		public unowned string get_xlicmimefilename ();
		[CCode (cname = "icalproperty_get_xlicmimeoptinfo")]
		public unowned string get_xlicmimeoptinfo ();
		[CCode (cname = "icalproperty_new_grant", has_construct_function = false)]
		public Property.grant (string v);
		[CCode (cname = "icalproperty_isa")]
		public ICal.PropertyKind isa ();
		[CCode (cname = "icalproperty_isa_property")]
		public static int isa_property (void* property);
		[CCode (cname = "icalproperty_new_itipversion", has_construct_function = false)]
		public Property.itipversion (string v);
		[CCode (cname = "icalproperty_kind_and_string_to_enum")]
		public static int kind_and_string_to_enum (int kind, string str);
		[CCode (cname = "icalproperty_kind_is_valid")]
		public static int kind_is_valid (ICal.PropertyKind kind);
		[CCode (cname = "icalproperty_kind_to_string")]
		public static unowned string kind_to_string (ICal.PropertyKind kind);
		[CCode (cname = "icalproperty_kind_to_value_kind")]
		public static ICal.ValueKind kind_to_value_kind (ICal.PropertyKind kind);
		[CCode (cname = "icalproperty_new_lastmodified", has_construct_function = false)]
		public Property.lastmodified (ICal.Time v);
		[CCode (cname = "icalproperty_new_location", has_construct_function = false)]
		public Property.location (string v);
		[CCode (cname = "icalproperty_new_maxcomponentsize", has_construct_function = false)]
		public Property.maxcomponentsize (int v);
		[CCode (cname = "icalproperty_new_maxdate", has_construct_function = false)]
		public Property.maxdate (ICal.Time v);
		[CCode (cname = "icalproperty_new_maxresults", has_construct_function = false)]
		public Property.maxresults (int v);
		[CCode (cname = "icalproperty_new_maxresultssize", has_construct_function = false)]
		public Property.maxresultssize (int v);
		[CCode (cname = "icalproperty_new_method", has_construct_function = false)]
		public Property.method (ICal.PropertyMethod v);
		[CCode (cname = "icalproperty_method_to_string")]
		public static unowned string method_to_string (ICal.PropertyMethod method);
		[CCode (cname = "icalproperty_new_mindate", has_construct_function = false)]
		public Property.mindate (ICal.Time v);
		[CCode (cname = "icalproperty_new_multipart", has_construct_function = false)]
		public Property.multipart (string v);
		[CCode (cname = "icalproperty_new_name", has_construct_function = false)]
		public Property.name (string v);
		[CCode (cname = "icalproperty_new_organizer", has_construct_function = false)]
		public Property.organizer (string v);
		[CCode (cname = "icalproperty_new_owner", has_construct_function = false)]
		public Property.owner (string v);
		[CCode (cname = "icalproperty_new_percentcomplete", has_construct_function = false)]
		public Property.percentcomplete (int v);
		[CCode (cname = "icalproperty_new_permission", has_construct_function = false)]
		public Property.permission (string v);
		[CCode (cname = "icalproperty_new_priority", has_construct_function = false)]
		public Property.priority (int v);
		[CCode (cname = "icalproperty_new_prodid", has_construct_function = false)]
		public Property.prodid (string v);
		[CCode (cname = "icalproperty_new_query", has_construct_function = false)]
		public Property.query (string v);
		[CCode (cname = "icalproperty_new_queryid", has_construct_function = false)]
		public Property.queryid (string v);
		[CCode (cname = "icalproperty_new_querylevel", has_construct_function = false)]
		public Property.querylevel (ICal.PropertyQueryLevel v);
		[CCode (cname = "icalproperty_new_queryname", has_construct_function = false)]
		public Property.queryname (string v);
		[CCode (cname = "icalproperty_new_rdate", has_construct_function = false)]
		public Property.rdate (ICal.DateTimePeriodType v);
		[CCode (cname = "icalproperty_new_recuraccepted", has_construct_function = false)]
		public Property.recuraccepted (string v);
		[CCode (cname = "icalproperty_new_recurexpand", has_construct_function = false)]
		public Property.recurexpand (string v);
		[CCode (cname = "icalproperty_new_recurlimit", has_construct_function = false)]
		public Property.recurlimit (string v);
		[CCode (cname = "icalproperty_recurrence_is_excluded")]
		public static int recurrence_is_excluded (ICal.Component  comp, ICal.Time dtstart, ICal.Time recurtime);
		[CCode (cname = "icalproperty_new_recurrenceid", has_construct_function = false)]
		public Property.recurrenceid (ICal.Time v);
		[CCode (cname = "icalproperty_new_relatedto", has_construct_function = false)]
		public Property.relatedto (string v);
		[CCode (cname = "icalproperty_new_relcalid", has_construct_function = false)]
		public Property.relcalid (string v);
		[CCode (cname = "icalproperty_remove_parameter")]
		public void remove_parameter (ICal.ParameterKind kind);
		[CCode (cname = "icalproperty_remove_parameter_by_kind")]
		public void remove_parameter_by_kind (ICal.ParameterKind kind);
		[CCode (cname = "icalproperty_remove_parameter_by_name")]
		public void remove_parameter_by_name (string name);
		[CCode (cname = "icalproperty_remove_parameter_by_ref")]
		public void remove_parameter_by_ref (ICal.Parameter param);
		[CCode (cname = "icalproperty_new_repeat", has_construct_function = false)]
		public Property.repeat (int v);
		[CCode (cname = "icalproperty_new_requeststatus", has_construct_function = false)]
		public Property.requeststatus (ICal.RequestStatusType v);
		[CCode (cname = "icalproperty_new_resources", has_construct_function = false)]
		public Property.resources (string v);
		[CCode (cname = "icalproperty_new_restriction", has_construct_function = false)]
		public Property.restriction (string v);
		[CCode (cname = "icalproperty_new_rrule", has_construct_function = false)]
		public Property.rrule (ICal.Recurrence v);
		[CCode (cname = "icalproperty_new_scope", has_construct_function = false)]
		public Property.scope (string v);
		[CCode (cname = "icalproperty_new_sequence", has_construct_function = false)]
		public Property.sequence (int v);
		[CCode (cname = "icalproperty_set_action")]
		public void set_action (ICal.PropertyAction v);
		[CCode (cname = "icalproperty_set_allowconflict")]
		public void set_allowconflict (string v);
		[CCode (cname = "icalproperty_set_attach")]
		public void set_attach (ICal.Attach v);
		[CCode (cname = "icalproperty_set_attendee")]
		public void set_attendee (string v);
		[CCode (cname = "icalproperty_set_calid")]
		public void set_calid (string v);
		[CCode (cname = "icalproperty_set_calmaster")]
		public void set_calmaster (string v);
		[CCode (cname = "icalproperty_set_calscale")]
		public void set_calscale (string v);
		[CCode (cname = "icalproperty_set_capversion")]
		public void set_capversion (string v);
		[CCode (cname = "icalproperty_set_carid")]
		public void set_carid (string v);
		[CCode (cname = "icalproperty_set_carlevel")]
		public void set_carlevel (ICal.PropertyCarlevel v);
		[CCode (cname = "icalproperty_set_categories")]
		public void set_categories (string v);
		[CCode (cname = "icalproperty_set_class")]
		public void set_class (ICal.PropertyClass v);
		[CCode (cname = "icalproperty_set_cmd")]
		public void set_cmd (ICal.PropertyCmd v);
		[CCode (cname = "icalproperty_set_comment")]
		public void set_comment (string v);
		[CCode (cname = "icalproperty_set_completed")]
		public void set_completed (ICal.Time v);
		[CCode (cname = "icalproperty_set_components")]
		public void set_components (string v);
		[CCode (cname = "icalproperty_set_contact")]
		public void set_contact (string v);
		[CCode (cname = "icalproperty_set_created")]
		public void set_created (ICal.Time v);
		[CCode (cname = "icalproperty_set_csid")]
		public void set_csid (string v);
		[CCode (cname = "icalproperty_set_datemax")]
		public void set_datemax (ICal.Time v);
		[CCode (cname = "icalproperty_set_datemin")]
		public void set_datemin (ICal.Time v);
		[CCode (cname = "icalproperty_set_decreed")]
		public void set_decreed (string v);
		[CCode (cname = "icalproperty_set_defaultcharset")]
		public void set_defaultcharset (string v);
		[CCode (cname = "icalproperty_set_defaultlocale")]
		public void set_defaultlocale (string v);
		[CCode (cname = "icalproperty_set_defaulttzid")]
		public void set_defaulttzid (string v);
		[CCode (cname = "icalproperty_set_defaultvcars")]
		public void set_defaultvcars (string v);
		[CCode (cname = "icalproperty_set_deny")]
		public void set_deny (string v);
		[CCode (cname = "icalproperty_set_description")]
		public void set_description (string v);
		[CCode (cname = "icalproperty_set_dtend")]
		public void set_dtend (ICal.Time v);
		[CCode (cname = "icalproperty_set_dtstamp")]
		public void set_dtstamp (ICal.Time v);
		[CCode (cname = "icalproperty_set_dtstart")]
		public void set_dtstart (ICal.Time v);
		[CCode (cname = "icalproperty_set_due")]
		public void set_due (ICal.Time v);
		[CCode (cname = "icalproperty_set_duration")]
		public void set_duration (ICal.Duration v);
		[CCode (cname = "icalproperty_set_exdate")]
		public void set_exdate (ICal.Time v);
		[CCode (cname = "icalproperty_set_expand")]
		public void set_expand (int v);
		[CCode (cname = "icalproperty_set_exrule")]
		public void set_exrule (ICal.Recurrence v);
		[CCode (cname = "icalproperty_set_freebusy")]
		public void set_freebusy (ICal.PeriodType v);
		[CCode (cname = "icalproperty_set_geo")]
		public void set_geo (ICal.Geo v);
		[CCode (cname = "icalproperty_set_grant")]
		public void set_grant (string v);
		[CCode (cname = "icalproperty_set_itipversion")]
		public void set_itipversion (string v);
		[CCode (cname = "icalproperty_set_lastmodified")]
		public void set_lastmodified (ICal.Time v);
		[CCode (cname = "icalproperty_set_location")]
		public void set_location (string v);
		[CCode (cname = "icalproperty_set_maxcomponentsize")]
		public void set_maxcomponentsize (int v);
		[CCode (cname = "icalproperty_set_maxdate")]
		public void set_maxdate (ICal.Time v);
		[CCode (cname = "icalproperty_set_maxresults")]
		public void set_maxresults (int v);
		[CCode (cname = "icalproperty_set_maxresultssize")]
		public void set_maxresultssize (int v);
		[CCode (cname = "icalproperty_set_method")]
		public void set_method (ICal.PropertyMethod v);
		[CCode (cname = "icalproperty_set_mindate")]
		public void set_mindate (ICal.Time v);
		[CCode (cname = "icalproperty_set_multipart")]
		public void set_multipart (string v);
		[CCode (cname = "icalproperty_set_name")]
		public void set_name (string v);
		[CCode (cname = "icalproperty_set_organizer")]
		public void set_organizer (string v);
		[CCode (cname = "icalproperty_set_owner")]
		public void set_owner (string v);
		[CCode (cname = "icalproperty_set_parameter")]
		public void set_parameter (ICal.Parameter parameter);
		[CCode (cname = "icalproperty_set_parameter_from_string")]
		public void set_parameter_from_string (string name, string value);
		[CCode (cname = "icalproperty_set_percentcomplete")]
		public void set_percentcomplete (int v);
		[CCode (cname = "icalproperty_set_permission")]
		public void set_permission (string v);
		[CCode (cname = "icalproperty_set_priority")]
		public void set_priority (int v);
		[CCode (cname = "icalproperty_set_prodid")]
		public void set_prodid (string v);
		[CCode (cname = "icalproperty_set_query")]
		public void set_query (string v);
		[CCode (cname = "icalproperty_set_queryid")]
		public void set_queryid (string v);
		[CCode (cname = "icalproperty_set_querylevel")]
		public void set_querylevel (ICal.PropertyQueryLevel v);
		[CCode (cname = "icalproperty_set_queryname")]
		public void set_queryname (string v);
		[CCode (cname = "icalproperty_set_rdate")]
		public void set_rdate (ICal.DateTimePeriodType v);
		[CCode (cname = "icalproperty_set_recuraccepted")]
		public void set_recuraccepted (string v);
		[CCode (cname = "icalproperty_set_recurexpand")]
		public void set_recurexpand (string v);
		[CCode (cname = "icalproperty_set_recurlimit")]
		public void set_recurlimit (string v);
		[CCode (cname = "icalproperty_set_recurrenceid")]
		public void set_recurrenceid (ICal.Time v);
		[CCode (cname = "icalproperty_set_relatedto")]
		public void set_relatedto (string v);
		[CCode (cname = "icalproperty_set_relcalid")]
		public void set_relcalid (string v);
		[CCode (cname = "icalproperty_set_repeat")]
		public void set_repeat (int v);
		[CCode (cname = "icalproperty_set_requeststatus")]
		public void set_requeststatus (ICal.RequestStatusType v);
		[CCode (cname = "icalproperty_set_resources")]
		public void set_resources (string v);
		[CCode (cname = "icalproperty_set_restriction")]
		public void set_restriction (string v);
		[CCode (cname = "icalproperty_set_rrule")]
		public void set_rrule (ICal.Recurrence v);
		[CCode (cname = "icalproperty_set_scope")]
		public void set_scope (string v);
		[CCode (cname = "icalproperty_set_sequence")]
		public void set_sequence (int v);
		[CCode (cname = "icalproperty_set_status")]
		public void set_status (ICal.PropertyStatus v);
		[CCode (cname = "icalproperty_set_storesexpanded")]
		public void set_storesexpanded (string v);
		[CCode (cname = "icalproperty_set_summary")]
		public void set_summary (string v);
		[CCode (cname = "icalproperty_set_target")]
		public void set_target (string v);
		[CCode (cname = "icalproperty_set_transp")]
		public void set_transparency (ICal.PropertyTransparency v);
		[CCode (cname = "icalproperty_set_trigger")]
		public void set_trigger (ICal.TriggerType v);
		[CCode (cname = "icalproperty_set_tzid")]
		public void set_tzid (string v);
		[CCode (cname = "icalproperty_set_tzname")]
		public void set_tzname (string v);
		[CCode (cname = "icalproperty_set_tzoffsetfrom")]
		public void set_tzoffsetfrom (int v);
		[CCode (cname = "icalproperty_set_tzoffsetto")]
		public void set_tzoffsetto (int v);
		[CCode (cname = "icalproperty_set_tzurl")]
		public void set_tzurl (string v);
		[CCode (cname = "icalproperty_set_uid")]
		public void set_uid (string v);
		[CCode (cname = "icalproperty_set_url")]
		public void set_url (string v);
		[CCode (cname = "icalproperty_set_value")]
		public void set_value (ICal.Value value);
		[CCode (cname = "icalproperty_set_value_from_string")]
		public void set_value_from_string (string value, string kind);
		[CCode (cname = "icalproperty_set_version")]
		public void set_version (string v);
		[CCode (cname = "icalproperty_set_x")]
		public void set_x (string v);
		[CCode (cname = "icalproperty_set_x_name")]
		public void set_x_name (string name);
		[CCode (cname = "icalproperty_set_xlicclass")]
		public void set_xlicclass (ICal.PropertyXlicClass v);
		[CCode (cname = "icalproperty_set_xlicclustercount")]
		public void set_xlicclustercount (string v);
		[CCode (cname = "icalproperty_set_xlicerror")]
		public void set_xlicerror (string v);
		[CCode (cname = "icalproperty_set_xlicmimecharset")]
		public void set_xlicmimecharset (string v);
		[CCode (cname = "icalproperty_set_xlicmimecid")]
		public void set_xlicmimecid (string v);
		[CCode (cname = "icalproperty_set_xlicmimecontenttype")]
		public void set_xlicmimecontenttype (string v);
		[CCode (cname = "icalproperty_set_xlicmimeencoding")]
		public void set_xlicmimeencoding (string v);
		[CCode (cname = "icalproperty_set_xlicmimefilename")]
		public void set_xlicmimefilename (string v);
		[CCode (cname = "icalproperty_set_xlicmimeoptinfo")]
		public void set_xlicmimeoptinfo (string v);
		[CCode (cname = "icalproperty_new_status", has_construct_function = false)]
		public Property.status (ICal.PropertyStatus v);
		[CCode (cname = "icalproperty_status_to_string")]
		public static unowned string status_to_string (ICal.PropertyStatus p1);
		[CCode (cname = "icalproperty_new_storesexpanded", has_construct_function = false)]
		public Property.storesexpanded (string v);
		[CCode (cname = "icalproperty_string_to_enum")]
		public static int string_to_enum (string str);
		[CCode (cname = "icalproperty_string_to_kind")]
		public static ICal.PropertyKind string_to_kind (string str);
		[CCode (cname = "icalproperty_string_to_method")]
		public static ICal.PropertyMethod string_to_method (string str);
		[CCode (cname = "icalproperty_string_to_status")]
		public static ICal.PropertyStatus string_to_status (string str);
		[CCode (cname = "icalproperty_new_summary", has_construct_function = false)]
		public Property.summary (string v);
		[CCode (cname = "icalproperty_new_target", has_construct_function = false)]
		public Property.target (string v);
		[CCode (cname = "icalproperty_new_transp", has_construct_function = false)]
		public Property.transparency (ICal.PropertyTransparency v);
		[CCode (cname = "icalproperty_new_trigger", has_construct_function = false)]
		public Property.trigger (ICal.TriggerType v);
		[CCode (cname = "icalproperty_new_tzid", has_construct_function = false)]
		public Property.tzid (string v);
		[CCode (cname = "icalproperty_new_tzname", has_construct_function = false)]
		public Property.tzname (string v);
		[CCode (cname = "icalproperty_new_tzoffsetfrom", has_construct_function = false)]
		public Property.tzoffsetfrom (int v);
		[CCode (cname = "icalproperty_new_tzoffsetto", has_construct_function = false)]
		public Property.tzoffsetto (int v);
		[CCode (cname = "icalproperty_new_tzurl", has_construct_function = false)]
		public Property.tzurl (string v);
		[CCode (cname = "icalproperty_new_uid", has_construct_function = false)]
		public Property.uid (string v);
		[CCode (cname = "icalproperty_new_url", has_construct_function = false)]
		public Property.url (string v);
		[CCode (cname = "icalproperty_value_kind_to_kind")]
		public static ICal.PropertyKind value_kind_to_kind (ICal.ValueKind kind);
		[CCode (cname = "icalproperty_vanew_action")]
		public static unowned ICal.Property vanew_action (ICal.PropertyAction v);
		[CCode (cname = "icalproperty_vanew_allowconflict")]
		public static unowned ICal.Property vanew_allowconflict (string v);
		[CCode (cname = "icalproperty_vanew_attach")]
		public static unowned ICal.Property vanew_attach (ICal.Attach v);
		[CCode (cname = "icalproperty_vanew_attendee")]
		public static unowned ICal.Property vanew_attendee (string v);
		[CCode (cname = "icalproperty_vanew_calid")]
		public static unowned ICal.Property vanew_calid (string v);
		[CCode (cname = "icalproperty_vanew_calmaster")]
		public static unowned ICal.Property vanew_calmaster (string v);
		[CCode (cname = "icalproperty_vanew_calscale")]
		public static unowned ICal.Property vanew_calscale (string v);
		[CCode (cname = "icalproperty_vanew_capversion")]
		public static unowned ICal.Property vanew_capversion (string v);
		[CCode (cname = "icalproperty_vanew_carid")]
		public static unowned ICal.Property vanew_carid (string v);
		[CCode (cname = "icalproperty_vanew_carlevel")]
		public static unowned ICal.Property vanew_carlevel (ICal.PropertyCarlevel v);
		[CCode (cname = "icalproperty_vanew_categories")]
		public static unowned ICal.Property vanew_categories (string v);
		[CCode (cname = "icalproperty_vanew_class")]
		public static unowned ICal.Property vanew_class (ICal.PropertyClass v);
		[CCode (cname = "icalproperty_vanew_cmd")]
		public static unowned ICal.Property vanew_cmd (ICal.PropertyCmd v);
		[CCode (cname = "icalproperty_vanew_comment")]
		public static unowned ICal.Property vanew_comment (string v);
		[CCode (cname = "icalproperty_vanew_completed")]
		public static unowned ICal.Property vanew_completed (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_components")]
		public static unowned ICal.Property vanew_components (string v);
		[CCode (cname = "icalproperty_vanew_contact")]
		public static unowned ICal.Property vanew_contact (string v);
		[CCode (cname = "icalproperty_vanew_created")]
		public static unowned ICal.Property vanew_created (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_csid")]
		public static unowned ICal.Property vanew_csid (string v);
		[CCode (cname = "icalproperty_vanew_datemax")]
		public static unowned ICal.Property vanew_datemax (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_datemin")]
		public static unowned ICal.Property vanew_datemin (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_decreed")]
		public static unowned ICal.Property vanew_decreed (string v);
		[CCode (cname = "icalproperty_vanew_defaultcharset")]
		public static unowned ICal.Property vanew_defaultcharset (string v);
		[CCode (cname = "icalproperty_vanew_defaultlocale")]
		public static unowned ICal.Property vanew_defaultlocale (string v);
		[CCode (cname = "icalproperty_vanew_defaulttzid")]
		public static unowned ICal.Property vanew_defaulttzid (string v);
		[CCode (cname = "icalproperty_vanew_defaultvcars")]
		public static unowned ICal.Property vanew_defaultvcars (string v);
		[CCode (cname = "icalproperty_vanew_deny")]
		public static unowned ICal.Property vanew_deny (string v);
		[CCode (cname = "icalproperty_vanew_description")]
		public static unowned ICal.Property vanew_description (string v);
		[CCode (cname = "icalproperty_vanew_dtend")]
		public static unowned ICal.Property vanew_dtend (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_dtstamp")]
		public static unowned ICal.Property vanew_dtstamp (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_dtstart")]
		public static unowned ICal.Property vanew_dtstart (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_due")]
		public static unowned ICal.Property vanew_due (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_duration")]
		public static unowned ICal.Property vanew_duration (ICal.Duration v);
		[CCode (cname = "icalproperty_vanew_exdate")]
		public static unowned ICal.Property vanew_exdate (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_expand")]
		public static unowned ICal.Property vanew_expand (int v);
		[CCode (cname = "icalproperty_vanew_exrule")]
		public static unowned ICal.Property vanew_exrule (ICal.Recurrence v);
		[CCode (cname = "icalproperty_vanew_freebusy")]
		public static unowned ICal.Property vanew_freebusy (ICal.PeriodType v);
		[CCode (cname = "icalproperty_vanew_geo")]
		public static unowned ICal.Property vanew_geo (ICal.Geo v);
		[CCode (cname = "icalproperty_vanew_grant")]
		public static unowned ICal.Property vanew_grant (string v);
		[CCode (cname = "icalproperty_vanew_itipversion")]
		public static unowned ICal.Property vanew_itipversion (string v);
		[CCode (cname = "icalproperty_vanew_lastmodified")]
		public static unowned ICal.Property vanew_lastmodified (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_location")]
		public static unowned ICal.Property vanew_location (string v);
		[CCode (cname = "icalproperty_vanew_maxcomponentsize")]
		public static unowned ICal.Property vanew_maxcomponentsize (int v);
		[CCode (cname = "icalproperty_vanew_maxdate")]
		public static unowned ICal.Property vanew_maxdate (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_maxresults")]
		public static unowned ICal.Property vanew_maxresults (int v);
		[CCode (cname = "icalproperty_vanew_maxresultssize")]
		public static unowned ICal.Property vanew_maxresultssize (int v);
		[CCode (cname = "icalproperty_vanew_method")]
		public static unowned ICal.Property vanew_method (ICal.PropertyMethod v);
		[CCode (cname = "icalproperty_vanew_mindate")]
		public static unowned ICal.Property vanew_mindate (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_multipart")]
		public static unowned ICal.Property vanew_multipart (string v);
		[CCode (cname = "icalproperty_vanew_name")]
		public static unowned ICal.Property vanew_name (string v);
		[CCode (cname = "icalproperty_vanew_organizer")]
		public static unowned ICal.Property vanew_organizer (string v);
		[CCode (cname = "icalproperty_vanew_owner")]
		public static unowned ICal.Property vanew_owner (string v);
		[CCode (cname = "icalproperty_vanew_percentcomplete")]
		public static unowned ICal.Property vanew_percentcomplete (int v);
		[CCode (cname = "icalproperty_vanew_permission")]
		public static unowned ICal.Property vanew_permission (string v);
		[CCode (cname = "icalproperty_vanew_priority")]
		public static unowned ICal.Property vanew_priority (int v);
		[CCode (cname = "icalproperty_vanew_prodid")]
		public static unowned ICal.Property vanew_prodid (string v);
		[CCode (cname = "icalproperty_vanew_query")]
		public static unowned ICal.Property vanew_query (string v);
		[CCode (cname = "icalproperty_vanew_queryid")]
		public static unowned ICal.Property vanew_queryid (string v);
		[CCode (cname = "icalproperty_vanew_querylevel")]
		public static unowned ICal.Property vanew_querylevel (ICal.PropertyQueryLevel v);
		[CCode (cname = "icalproperty_vanew_queryname")]
		public static unowned ICal.Property vanew_queryname (string v);
		[CCode (cname = "icalproperty_vanew_rdate")]
		public static unowned ICal.Property vanew_rdate (ICal.DateTimePeriodType v);
		[CCode (cname = "icalproperty_vanew_recuraccepted")]
		public static unowned ICal.Property vanew_recuraccepted (string v);
		[CCode (cname = "icalproperty_vanew_recurexpand")]
		public static unowned ICal.Property vanew_recurexpand (string v);
		[CCode (cname = "icalproperty_vanew_recurlimit")]
		public static unowned ICal.Property vanew_recurlimit (string v);
		[CCode (cname = "icalproperty_vanew_recurrenceid")]
		public static unowned ICal.Property vanew_recurrenceid (ICal.Time v);
		[CCode (cname = "icalproperty_vanew_relatedto")]
		public static unowned ICal.Property vanew_relatedto (string v);
		[CCode (cname = "icalproperty_vanew_relcalid")]
		public static unowned ICal.Property vanew_relcalid (string v);
		[CCode (cname = "icalproperty_vanew_repeat")]
		public static unowned ICal.Property vanew_repeat (int v);
		[CCode (cname = "icalproperty_vanew_requeststatus")]
		public static unowned ICal.Property vanew_requeststatus (ICal.RequestStatusType v);
		[CCode (cname = "icalproperty_vanew_resources")]
		public static unowned ICal.Property vanew_resources (string v);
		[CCode (cname = "icalproperty_vanew_restriction")]
		public static unowned ICal.Property vanew_restriction (string v);
		[CCode (cname = "icalproperty_vanew_rrule")]
		public static unowned ICal.Property vanew_rrule (ICal.Recurrence v);
		[CCode (cname = "icalproperty_vanew_scope")]
		public static unowned ICal.Property vanew_scope (string v);
		[CCode (cname = "icalproperty_vanew_sequence")]
		public static unowned ICal.Property vanew_sequence (int v);
		[CCode (cname = "icalproperty_vanew_status")]
		public static unowned ICal.Property vanew_status (ICal.PropertyStatus v);
		[CCode (cname = "icalproperty_vanew_storesexpanded")]
		public static unowned ICal.Property vanew_storesexpanded (string v);
		[CCode (cname = "icalproperty_vanew_summary")]
		public static unowned ICal.Property vanew_summary (string v);
		[CCode (cname = "icalproperty_vanew_target")]
		public static unowned ICal.Property vanew_target (string v);
		[CCode (cname = "icalproperty_vanew_transp")]
		public static unowned ICal.Property vanew_transparency (ICal.PropertyTransparency v);
		[CCode (cname = "icalproperty_vanew_trigger")]
		public static unowned ICal.Property vanew_trigger (ICal.TriggerType v);
		[CCode (cname = "icalproperty_vanew_tzid")]
		public static unowned ICal.Property vanew_tzid (string v);
		[CCode (cname = "icalproperty_vanew_tzname")]
		public static unowned ICal.Property vanew_tzname (string v);
		[CCode (cname = "icalproperty_vanew_tzoffsetfrom")]
		public static unowned ICal.Property vanew_tzoffsetfrom (int v);
		[CCode (cname = "icalproperty_vanew_tzoffsetto")]
		public static unowned ICal.Property vanew_tzoffsetto (int v);
		[CCode (cname = "icalproperty_vanew_tzurl")]
		public static unowned ICal.Property vanew_tzurl (string v);
		[CCode (cname = "icalproperty_vanew_uid")]
		public static unowned ICal.Property vanew_uid (string v);
		[CCode (cname = "icalproperty_vanew_url")]
		public static unowned ICal.Property vanew_url (string v);
		[CCode (cname = "icalproperty_vanew_version")]
		public static unowned ICal.Property vanew_version (string v);
		[CCode (cname = "icalproperty_vanew_x")]
		public static unowned ICal.Property vanew_x (string v);
		[CCode (cname = "icalproperty_vanew_xlicclass")]
		public static unowned ICal.Property vanew_xlicclass (ICal.PropertyXlicClass v);
		[CCode (cname = "icalproperty_vanew_xlicclustercount")]
		public static unowned ICal.Property vanew_xlicclustercount (string v);
		[CCode (cname = "icalproperty_vanew_xlicerror")]
		public static unowned ICal.Property vanew_xlicerror (string v);
		[CCode (cname = "icalproperty_vanew_xlicmimecharset")]
		public static unowned ICal.Property vanew_xlicmimecharset (string v);
		[CCode (cname = "icalproperty_vanew_xlicmimecid")]
		public static unowned ICal.Property vanew_xlicmimecid (string v);
		[CCode (cname = "icalproperty_vanew_xlicmimecontenttype")]
		public static unowned ICal.Property vanew_xlicmimecontenttype (string v);
		[CCode (cname = "icalproperty_vanew_xlicmimeencoding")]
		public static unowned ICal.Property vanew_xlicmimeencoding (string v);
		[CCode (cname = "icalproperty_vanew_xlicmimefilename")]
		public static unowned ICal.Property vanew_xlicmimefilename (string v);
		[CCode (cname = "icalproperty_vanew_xlicmimeoptinfo")]
		public static unowned ICal.Property vanew_xlicmimeoptinfo (string v);
		[CCode (cname = "icalproperty_new_version", has_construct_function = false)]
		public Property.version (string v);
		[CCode (cname = "icalproperty_new_x", has_construct_function = false)]
		public Property.x (string v);
		[CCode (cname = "icalproperty_new_xlicclass", has_construct_function = false)]
		public Property.xlicclass (ICal.PropertyXlicClass v);
		[CCode (cname = "icalproperty_new_xlicclustercount", has_construct_function = false)]
		public Property.xlicclustercount (string v);
		[CCode (cname = "icalproperty_new_xlicerror", has_construct_function = false)]
		public Property.xlicerror (string v);
		[CCode (cname = "icalproperty_new_xlicmimecharset", has_construct_function = false)]
		public Property.xlicmimecharset (string v);
		[CCode (cname = "icalproperty_new_xlicmimecid", has_construct_function = false)]
		public Property.xlicmimecid (string v);
		[CCode (cname = "icalproperty_new_xlicmimecontenttype", has_construct_function = false)]
		public Property.xlicmimecontenttype (string v);
		[CCode (cname = "icalproperty_new_xlicmimeencoding", has_construct_function = false)]
		public Property.xlicmimeencoding (string v);
		[CCode (cname = "icalproperty_new_xlicmimefilename", has_construct_function = false)]
		public Property.xlicmimefilename (string v);
		[CCode (cname = "icalproperty_new_xlicmimeoptinfo", has_construct_function = false)]
		public Property.xlicmimeoptinfo (string v);
	}
	[CCode (cheader_filename = "libical/ical.h", free_function = "icalrecur_iterator_free", cname = "icalrecur_iterator")]
	[Compact]
	public class RecurIterator {
		[CCode (cname = "icalrecur_iterator_new", has_construct_function = false)]
		public RecurIterator (ICal.Recurrence rule, ICal.Time dtstart);
		[CCode (cname = "icalrecur_iterator_next")]
		public ICal.Time next ();
		[CCode (cname = "icalrecur_iterator_set_start")]
		public int set_start (ICal.Time start);
	}
	[CCode (cheader_filename = "libical/ical.h", cname = "icaltime_span")]
	[Compact]
	public class TimeSpan {
		[CCode (cname = "icaltime_span_new", has_construct_function = false)]
		public TimeSpan (ICal.Time dtstart, ICal.Time dtend, int is_busy);
		public ulong end;
		public int is_busy;
		public ulong start;
		[CCode (cname = "icaltime_span_contains")]
		public int contains (ICal.TimeSpan container);
		[CCode (cname = "icaltime_span_overlaps")]
		public int overlaps (ICal.TimeSpan second);
	}
	[CCode (cheader_filename = "libical/ical.h", copy_function = "icaltimezone_copy", free_function = "icaltimezone_free", cname = "icaltimezone")]
	[Compact]
	public class Timezone {
		[CCode (cname = "icaltimezone_new", has_construct_function = false)]
		public Timezone ();
		[CCode (cname = "icaltimezone_array_append_from_vtimezone")]
		public static void array_append_from_vtimezone (ICal.Array<unowned ICal.Timezone> timezones, ICal.Component  child);
		[CCode (cname = "icaltimezone_array_free")]
		public static void array_free (ICal.Array<unowned ICal.Timezone> timezones);
		[CCode (cname = "icaltimezone_array_new")]
		public static unowned ICal.Array<unowned ICal.Timezone> array_new ();
		[CCode (cname = "icaltimezone_convert_time")]
		public static void convert_time (ICal.Time tt, ICal.Timezone from_zone, ICal.Timezone to_zone);
		[CCode (cname = "icaltimezone_copy")]
		public unowned ICal.Timezone copy ();
		[CCode (cname = "icaltimezone_dump_changes")]
		public int dump_changes (int max_year, GLib.FileStream fp);
		[CCode (cname = "icaltimezone_free_builtin_timezones")]
		public static void free_builtin_timezones ();
		[CCode (cname = "icaltimezone_get_builtin_timezone")]
		public static unowned ICal.Timezone get_builtin_timezone (string location);
		[CCode (cname = "icaltimezone_get_builtin_timezone_from_offset")]
		public static unowned ICal.Timezone get_builtin_timezone_from_offset (int64 offset, string? tzname);
		[CCode (cname = "icaltimezone_get_builtin_timezone_from_tzid")]
		public static unowned ICal.Timezone get_builtin_timezone_from_tzid (string? tzid);
		[CCode (cname = "icaltimezone_get_builtin_timezones")]
		public static unowned ICal.Array<unowned ICal.Timezone> get_builtin_timezones ();
		[CCode (cname = "icaltimezone_get_component")]
		public unowned ICal.Component get_component ();
		[CCode (cname = "icaltimezone_get_display_name")]
		public unowned string get_display_name ();
		[CCode (cname = "icaltimezone_get_latitude")]
		public double get_latitude ();
		[CCode (cname = "icaltimezone_get_location")]
		public unowned string get_location ();
		[CCode (cname = "icaltimezone_get_longitude")]
		public double get_longitude ();
		[CCode (cname = "icaltimezone_get_tzid")]
		public unowned string get_tzid ();
		[CCode (cname = "icaltimezone_get_tznames")]
		public unowned string get_tznames ();
		[CCode (cname = "icaltimezone_get_utc_offset")]
		public int get_utc_offset (ICal.Time? tt, out int is_daylight);
		[CCode (cname = "icaltimezone_get_utc_offset_of_utc_time")]
		public int get_utc_offset_of_utc_time (ICal.Time tt, out int is_daylight);
		[CCode (cname = "icaltimezone_get_utc_timezone")]
		public static unowned ICal.Timezone get_utc_timezone ();
		[CCode (cname = "icaltimezone_release_zone_tab")]
		public static void release_zone_tab ();
		[CCode (cname = "icaltimezone_set_component")]
		public int set_component (ICal.Component comp);
		[CCode (cname = "icaltimezone_set_tzid_prefix")]
		public static void set_tzid_prefix (string new_prefix);
	}
	[CCode (cheader_filename = "libical/ical.h", copy_function = "icalvalue_new_clone", free_function = "icalvalue_free", cname = "icalvalue")]
	[Compact]
	public class Value {
		[CCode (cname = "icalvalue_new", has_construct_function = false)]
		public Value (ICal.ValueKind kind);
		[CCode (cname = "icalvalue_new_action", has_construct_function = false)]
		public Value.action (ICal.PropertyAction v);
		[CCode (cname = "icalvalue_as_ical_string")]
		public unowned global::string as_ical_string ();
		[CCode (cname = "icalvalue_as_ical_string_r")]
		public unowned global::string as_ical_string_r ();
		[CCode (cname = "icalvalue_new_attach", has_construct_function = false)]
		public Value.attach (ICal.Attach attach);
		[CCode (cname = "icalvalue_new_binary", has_construct_function = false)]
		public Value.binary (global::string v);
		[CCode (cname = "icalvalue_new_boolean", has_construct_function = false)]
		public Value.boolean (int v);
		[CCode (cname = "icalvalue_new_caladdress", has_construct_function = false)]
		public Value.caladdress (global::string v);
		[CCode (cname = "icalvalue_new_carlevel", has_construct_function = false)]
		public Value.carlevel (ICal.PropertyCarlevel v);
		[CCode (cname = "icalvalue_new_class", has_construct_function = false)]
		public Value.@class (ICal.PropertyClass v);
		[CCode (cname = "icalvalue_new_cmd", has_construct_function = false)]
		public Value.cmd (ICal.PropertyCmd v);
		[CCode (cname = "icalvalue_compare")]
		public ICal.ParameterXlicCompareType compare (ICal.Value b);
		[CCode (cname = "icalvalue_new_date", has_construct_function = false)]
		public Value.date (ICal.Time v);
		[CCode (cname = "icalvalue_new_datetime", has_construct_function = false)]
		public Value.datetime (ICal.Time v);
		[CCode (cname = "icalvalue_new_datetimeperiod", has_construct_function = false)]
		public Value.datetimeperiod (ICal.DateTimePeriodType v);
		[CCode (cname = "icalvalue_decode_ical_string")]
		public static int decode_ical_string (global::string szText, global::string szDecText, int nMaxBufferLen);
		[CCode (cname = "icalvalue_new_duration", has_construct_function = false)]
		public Value.duration (ICal.Duration v);
		[CCode (cname = "icalvalue_encode_ical_string")]
		public static int encode_ical_string (global::string szText, global::string szEncText, int MaxBufferLen);
		[CCode (cname = "icalvalue_new_float", has_construct_function = false)]
		public Value.float (global::float v);
		[CCode (cname = "icalvalue_new_from_string", has_construct_function = false)]
		public Value.from_string (ICal.ValueKind kind, global::string str);
		[CCode (cname = "icalvalue_new_geo", has_construct_function = false)]
		public Value.geo (ICal.Geo v);
		[CCode (cname = "icalvalue_new_clone")]
		public Value clone ();
		[CCode (cname = "icalvalue_get_action")]
		public ICal.PropertyAction get_action ();
		[CCode (cname = "icalvalue_get_attach")]
		public unowned ICal.Attach get_attach ();
		[CCode (cname = "icalvalue_get_binary")]
		public unowned global::string get_binary ();
		[CCode (cname = "icalvalue_get_boolean")]
		public int get_boolean ();
		[CCode (cname = "icalvalue_get_caladdress")]
		public unowned global::string get_caladdress ();
		[CCode (cname = "icalvalue_get_carlevel")]
		public ICal.PropertyCarlevel get_carlevel ();
		[CCode (cname = "icalvalue_get_class")]
		public ICal.PropertyClass get_class ();
		[CCode (cname = "icalvalue_get_cmd")]
		public ICal.PropertyCmd get_cmd ();
		[CCode (cname = "icalvalue_get_date")]
		public ICal.Time get_date ();
		[CCode (cname = "icalvalue_get_datetime")]
		public ICal.Time get_datetime ();
		[CCode (cname = "icalvalue_get_datetimeperiod")]
		public ICal.DateTimePeriodType get_datetimeperiod ();
		[CCode (cname = "icalvalue_get_duration")]
		public unowned ICal.Duration get_duration ();
		[CCode (cname = "icalvalue_get_float")]
		public global::float get_float ();
		[CCode (cname = "icalvalue_get_geo")]
		public ICal.Geo get_geo ();
		[CCode (cname = "icalvalue_get_integer")]
		public int get_integer ();
		[CCode (cname = "icalvalue_get_method")]
		public ICal.PropertyMethod get_method ();
		[CCode (cname = "icalvalue_get_period")]
		public ICal.PeriodType get_period ();
		[CCode (cname = "icalvalue_get_query")]
		public unowned global::string get_query ();
		[CCode (cname = "icalvalue_get_querylevel")]
		public ICal.PropertyQueryLevel get_querylevel ();
		[CCode (cname = "icalvalue_get_recur")]
		public ICal.Recurrence get_recur ();
		[CCode (cname = "icalvalue_get_requeststatus")]
		public ICal.RequestStatusType get_requeststatus ();
		[CCode (cname = "icalvalue_get_status")]
		public ICal.PropertyStatus get_status ();
		[CCode (cname = "icalvalue_get_string")]
		public unowned global::string get_string ();
		[CCode (cname = "icalvalue_get_text")]
		public unowned global::string get_text ();
		[CCode (cname = "icalvalue_get_transp")]
		public ICal.PropertyTransparency get_transparency ();
		[CCode (cname = "icalvalue_get_trigger")]
		public ICal.TriggerType get_trigger ();
		[CCode (cname = "icalvalue_get_uri")]
		public unowned global::string get_uri ();
		[CCode (cname = "icalvalue_get_utcoffset")]
		public int get_utcoffset ();
		[CCode (cname = "icalvalue_get_x")]
		public unowned global::string get_x ();
		[CCode (cname = "icalvalue_get_xlicclass")]
		public ICal.PropertyXlicClass get_xlicclass ();
		[CCode (cname = "icalvalue_new_integer", has_construct_function = false)]
		public Value.integer (int v);
		[CCode (cname = "icalvalue_is_valid")]
		public int is_valid ();
		[CCode (cname = "icalvalue_isa")]
		public ICal.ValueKind isa ();
		[CCode (cname = "icalvalue_isa_value")]
		public static int isa_value (void* p1);
		[CCode (cname = "icalvalue_kind_is_valid")]
		public static int kind_is_valid (ICal.ValueKind kind);
		[CCode (cname = "icalvalue_kind_to_string")]
		public static unowned global::string kind_to_string (ICal.ValueKind kind);
		[CCode (cname = "icalvalue_new_method", has_construct_function = false)]
		public Value.method (ICal.PropertyMethod v);
		[CCode (cname = "icalvalue_new_period", has_construct_function = false)]
		public Value.period (ICal.PeriodType v);
		[CCode (cname = "icalvalue_new_query", has_construct_function = false)]
		public Value.query (global::string v);
		[CCode (cname = "icalvalue_new_querylevel", has_construct_function = false)]
		public Value.querylevel (ICal.PropertyQueryLevel v);
		[CCode (cname = "icalvalue_new_recur", has_construct_function = false)]
		public Value.recur (ICal.Recurrence v);
		[CCode (cname = "icalvalue_new_requeststatus", has_construct_function = false)]
		public Value.requeststatus (ICal.RequestStatusType v);
		[CCode (cname = "icalvalue_reset_kind")]
		public void reset_kind ();
		[CCode (cname = "icalvalue_set_action")]
		public void set_action (ICal.PropertyAction v);
		[CCode (cname = "icalvalue_set_attach")]
		public void set_attach (ICal.Attach attach);
		[CCode (cname = "icalvalue_set_binary")]
		public void set_binary (global::string v);
		[CCode (cname = "icalvalue_set_boolean")]
		public void set_boolean (int v);
		[CCode (cname = "icalvalue_set_caladdress")]
		public void set_caladdress (global::string v);
		[CCode (cname = "icalvalue_set_carlevel")]
		public void set_carlevel (ICal.PropertyCarlevel v);
		[CCode (cname = "icalvalue_set_class")]
		public void set_class (ICal.PropertyClass v);
		[CCode (cname = "icalvalue_set_cmd")]
		public void set_cmd (ICal.PropertyCmd v);
		[CCode (cname = "icalvalue_set_date")]
		public void set_date (ICal.Time v);
		[CCode (cname = "icalvalue_set_datetime")]
		public void set_datetime (ICal.Time v);
		[CCode (cname = "icalvalue_set_datetimeperiod")]
		public void set_datetimeperiod (ICal.DateTimePeriodType v);
		[CCode (cname = "icalvalue_set_duration")]
		public void set_duration (ICal.Duration v);
		[CCode (cname = "icalvalue_set_float")]
		public void set_float (global::float v);
		[CCode (cname = "icalvalue_set_geo")]
		public void set_geo (ICal.Geo v);
		[CCode (cname = "icalvalue_set_integer")]
		public void set_integer (int v);
		[CCode (cname = "icalvalue_set_method")]
		public void set_method (ICal.PropertyMethod v);
		[CCode (cname = "icalvalue_set_period")]
		public void set_period (ICal.PeriodType v);
		[CCode (cname = "icalvalue_set_query")]
		public void set_query (global::string v);
		[CCode (cname = "icalvalue_set_querylevel")]
		public void set_querylevel (ICal.PropertyQueryLevel v);
		[CCode (cname = "icalvalue_set_recur")]
		public void set_recur (ICal.Recurrence v);
		[CCode (cname = "icalvalue_set_requeststatus")]
		public void set_requeststatus (ICal.RequestStatusType v);
		[CCode (cname = "icalvalue_set_status")]
		public void set_status (ICal.PropertyStatus v);
		[CCode (cname = "icalvalue_set_string")]
		public void set_string (global::string v);
		[CCode (cname = "icalvalue_set_text")]
		public void set_text (global::string v);
		[CCode (cname = "icalvalue_set_transp")]
		public void set_transparency (ICal.PropertyTransparency v);
		[CCode (cname = "icalvalue_set_trigger")]
		public void set_trigger (ICal.TriggerType v);
		[CCode (cname = "icalvalue_set_uri")]
		public void set_uri (global::string v);
		[CCode (cname = "icalvalue_set_utcoffset")]
		public void set_utcoffset (int v);
		[CCode (cname = "icalvalue_set_x")]
		public void set_x (global::string v);
		[CCode (cname = "icalvalue_set_xlicclass")]
		public void set_xlicclass (ICal.PropertyXlicClass v);
		[CCode (cname = "icalvalue_new_status", has_construct_function = false)]
		public Value.status (ICal.PropertyStatus v);
		[CCode (cname = "icalvalue_new_string", has_construct_function = false)]
		public Value.string (global::string v);
		[CCode (cname = "icalvalue_string_to_kind")]
		public static ICal.ValueKind string_to_kind (global::string str);
		[CCode (cname = "icalvalue_new_text", has_construct_function = false)]
		public Value.text (global::string v);
		[CCode (cname = "icalvalue_new_transp", has_construct_function = false)]
		public Value.transparency (ICal.PropertyTransparency v);
		[CCode (cname = "icalvalue_new_trigger", has_construct_function = false)]
		public Value.trigger (ICal.TriggerType v);
		[CCode (cname = "icalvalue_new_uri", has_construct_function = false)]
		public Value.uri (global::string v);
		[CCode (cname = "icalvalue_new_utcoffset", has_construct_function = false)]
		public Value.utcoffset (int v);
		[CCode (cname = "icalvalue_new_x", has_construct_function = false)]
		public Value.x (global::string v);
		[CCode (cname = "icalvalue_new_xlicclass", has_construct_function = false)]
		public Value.xlicclass (ICal.PropertyXlicClass v);
	}
	[CCode (cheader_filename = "libical/ical.h", cname = "pvl_elem")]
	[Compact]
	public class PvlElement {
		public int MAGIC;
		public void* d;
		public weak ICal.PvlElement next;
		public weak ICal.PvlElement prior;
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_new_element")]
		public PvlElement (void* d, ICal.PvlElement next, ICal.PvlElement prior);
	}
	[CCode (cheader_filename = "libical/ical.h", free_function = "pvl_free", cname = "pvl_list")]
	[Compact]
	public class PvlList {
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_apply")]
		public void apply (ICal.pvl_applyf f, void* v);
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_clear")]
		public void clear ();
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_count")]
		public int count ();
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_data")]
		public static void* data (ICal.PvlElement p1);
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_find")]
		public unowned ICal.PvlElement find (ICal.pvl_findf f, void* v);
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_find_next")]
		public unowned ICal.PvlElement find_next (ICal.pvl_findf f, void* v);
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_free")]
		public void free ();
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_head")]
		public unowned ICal.PvlElement head ();
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_insert_after")]
		public void insert_after (ICal.PvlElement e, void* d);
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_insert_before")]
		public void insert_before (ICal.PvlElement e, void* d);
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_insert_ordered")]
		public void insert_ordered (ICal.pvl_comparef f, void* d);
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_newlist")]
		public PvlList.newlist ();
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_pop")]
		public void* pop ();
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_push")]
		public void push (void* d);
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_remove")]
		public void* remove (ICal.PvlElement p2);
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_shift")]
		public void* shift ();
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_tail")]
		public unowned ICal.PvlElement tail ();
		[CCode (cheader_filename = "libical/ical.h", cname = "pvl_unshift")]
		public void unshift (void* d);
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "SSPM_", has_type_id = false)]
	[Compact]
	public enum sspm_encoding {
		[CCode (cname = "SSPM_NO_ENCODING")]
		NO,
		[CCode (cname = "SSPM_QUOTED_PRINTABLE_ENCODING")]
		QUOTED_PRINTABLE,
		[CCode (cname = "SSPM_8BIT_ENCODING")]
		8BIT,
		[CCode (cname = "SSPM_7BIT_ENCODING")]
		7BIT,
		[CCode (cname = "SSPM_BINARY_ENCODING")]
		BINARY,
		[CCode (cname = "SSPM_BASE64_ENCODING")]
		BASE64,
		[CCode (cname = "SSPM_UNKNOWN_ENCODING")]
		UNKNOWN;
		[CCode (cheader_filename = "libical/ical.h", cname = "sspm_encoding_string")]
		public static unowned string to_string (sspm_encoding type);
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "SSPM_", has_type_id = false)]
	public enum sspm_error {
		[CCode (cname = "SSPM_NO_ERROR")]
		NO,
		[CCode (cname = "SSPM_UNEXPECTED_BOUNDARY_ERROR")]
		UNEXPECTED_BOUNDARY,
		[CCode (cname = "SSPM_WRONG_BOUNDARY_ERROR")]
		WRONG_BOUNDARY,
		[CCode (cname = "SSPM_NO_BOUNDARY_ERROR")]
		NO_BOUNDARY,
		[CCode (cname = "SSPM_NO_HEADER_ERROR")]
		NO_HEADER,
		[CCode (cname = "SSPM_MALFORMED_HEADER_ERROR")]
		MALFORMED_HEADER
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "SSPM_", has_type_id = false)]
	public enum sspm_major_type {
		[CCode (cname = "SSPM_NO_MAJOR_TYPE")]
		NO,
		[CCode (cname = "SSPM_TEXT_MAJOR_TYPE")]
		TEXT,
		[CCode (cname = "SSPM_IMAGE_MAJOR_TYPE")]
		IMAGE,
		[CCode (cname = "SSPM_AUDIO_MAJOR_TYPE")]
		AUDIO,
		[CCode (cname = "SSPM_VIDEO_MAJOR_TYPE")]
		VIDEO,
		[CCode (cname = "SSPM_APPLICATION_MAJOR_TYPE")]
		APPLICATION,
		[CCode (cname = "SSPM_MULTIPART_MAJOR_TYPE")]
		MULTIPART,
		[CCode (cname = "SSPM_MESSAGE_MAJOR_TYPE")]
		MESSAGE,
		[CCode (cname = "SSPM_UNKNOWN_MAJOR_TYPE")]
		UNKNOWN;
		[CCode (cheader_filename = "libical/ical.h", cname = "sspm_major_type_string")]
		public static unowned string to_string (sspm_major_type type);
		[CCode (cheader_filename = "libical/ical.h", cname = "sspm_free_parts")]
		public static void free_parts (sspm_major_type type, size_t max_parts);
		[CCode (cheader_filename = "libical/ical.h", cname = "sspm_write_mime")]
		public static int write_mime (sspm_major_type type, size_t num_parts, out unowned string output_string, string header);
		[CCode (cheader_filename = "libical/ical.h", cname = "sspm_parse_mime")]
		public static int parse_mime (sspm_major_type type, size_t max_parts, ICal.sspm_action_map actions, GLib.Callback get_string, void* get_string_data, ...);
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "SSPM_", has_type_id = false)]
	public enum sspm_minor_type {
		[CCode (cname = "SSPM_NO_MINOR_TYPE")]
		NO,
		[CCode (cname = "SSPM_ANY_MINOR_TYPE")]
		ANY,
		[CCode (cname = "SSPM_PLAIN_MINOR_TYPE")]
		PLAIN,
		[CCode (cname = "SSPM_RFC822_MINOR_TYPE")]
		RFC822,
		[CCode (cname = "SSPM_DIGEST_MINOR_TYPE")]
		DIGEST,
		[CCode (cname = "SSPM_CALENDAR_MINOR_TYPE")]
		CALENDAR,
		[CCode (cname = "SSPM_MIXED_MINOR_TYPE")]
		MIXED,
		[CCode (cname = "SSPM_RELATED_MINOR_TYPE")]
		RELATED,
		[CCode (cname = "SSPM_ALTERNATIVE_MINOR_TYPE")]
		ALTERNATIVE,
		[CCode (cname = "SSPM_PARALLEL_MINOR_TYPE")]
		PARALLEL,
		[CCode (cname = "SSPM_UNKNOWN_MINOR_TYPE")]
		UNKNOWN;
		[CCode (cheader_filename = "libical/ical.h", cname = "sspm_minor_type_string")]
		public static unowned string to_string (ICal.sspm_minor_type type);
	}
	[CCode (cheader_filename = "libical/ical.h", cname = "icaldatetimeperiodtype")]
	public struct DateTimePeriodType {
		public ICal.Time time;
		public ICal.PeriodType period;
	}
	[SimpleType]
	[CCode (cheader_filename = "libical/ical.h", cname = "struct icalgeotype", has_type_id = false)]
	public struct Geo {
		public double lat;
		public double lon;
		[CCode (cname = "_vala_icalgeotype_get_lat")]
		public double get_lat () {
			return this.lat;
		}
		[CCode (cname = "_vala_icalgeotype_get_lon")]
		public double get_lon () {
			return this.lon;
		}
	}
	[SimpleType]
	[CCode (cheader_filename = "libical/ical.h", cname = "struct icalperiodtype", has_type_id = false)]
	public struct PeriodType {
		public ICal.Time start;
		public ICal.Time end;
		public weak ICal.Duration duration;
		[CCode (cname = "icalperiodtype_as_ical_string")]
		public unowned string as_ical_string ();
		[CCode (cname = "icalperiodtype_as_ical_string_r")]
		public unowned string as_ical_string_r ();
		[CCode (cname = "icalperiodtype_from_string")]
		public static ICal.PeriodType from_string (string str);
		[CCode (cname = "icalperiodtype_is_null_period")]
		public int is_null ();
		[CCode (cname = "icalperiodtype_is_valid_period")]
		public int is_valid ();
		[CCode (cname = "icalperiodtype_null_period")]
		public static ICal.PeriodType null ();
	}
	[SimpleType]
	[CCode (cheader_filename = "libical/ical.h", cname = "struct icalrecurrencetype", has_type_id = false)]
	public struct Recurrence {
		public ICal.RecurrenceFrequency freq;
		public ICal.Time until;
		public int count;
		public short interval;
		public ICal.RecurrenceWeekday week_start;
		[CCode (array_length = false)]
		public weak short[] by_second;
		[CCode (array_length = false)]
		public weak short[] by_minute;
		[CCode (array_length = false)]
		public weak short[] by_hour;
		[CCode (array_length = false)]
		public weak short[] by_day;
		[CCode (array_length = false)]
		public weak short[] by_month_day;
		[CCode (array_length = false)]
		public weak short[] by_year_day;
		[CCode (array_length = false)]
		public weak short[] by_week_no;
		[CCode (array_length = false)]
		public weak short[] by_month;
		[CCode (array_length = false)]
		public weak short[] by_set_pos;
		[CCode (cname = "icalrecurrencetype_as_string")]
		public unowned string as_string ();
		[CCode (cname = "icalrecurrencetype_as_string_r")]
		public unowned string as_string_r ();
		[CCode (cname = "icalrecurrencetype_clear")]
		public void clear ();
		[CCode (cname = "icalrecurrencetype_day_day_of_week")]
		public static ICal.RecurrenceWeekday day_day_of_week (short day);
		[CCode (cname = "icalrecurrencetype_day_position")]
		public static int day_position (short day);
		[CCode (cname = "icalrecurrencetype_from_string")]
		public static ICal.Recurrence from_string (string str);
		[CCode (cname = "_vala_icalrecurrencetype_get_freq")]
		public ICal.RecurrenceFrequency get_freq () {
			return this.freq;
		}
		[CCode (cname = "_vala_icalrecurrencetype_get_until")]
		public unowned ICal.Time get_until () {
			return this.until;
		}
		[CCode (cname = "_vala_icalrecurrencetype_get_count")]
		public int get_count () {
			return this.count;
		}
		[CCode (cname = "_vala_icalrecurrencetype_get_interval")]
		public short get_interval () {
			return this.interval;
		}
		[CCode (cname = "_vala_icalrecurrencetype_get_by_day_array")]
		public GLib.Array<short> get_by_day_array () {
			var array = new GLib.Array<short> (false, false, sizeof (short));
			array.append_vals (by_day, ICal.Size.BY_DAY);
			return array;
		}
		[CCode (cname = "_vala_icalrecurrencetype_set_by_day_array")]
		public static void set_by_day_array (ref ICal.Recurrence self, GLib.Array<short> values) {
			int ii = 0;
			for (ii = 0; ii < values.length && ii < ICal.Size.BY_DAY; ii++) {
				self.by_day[ii] = values.index (ii);
			}

			if (ii < ICal.Size.BY_DAY) {
				self.by_day[ii] = ICal.RecurrenceArrayMaxValues.RECURRENCE_ARRAY_MAX;
			}
		}
		[CCode (cname = "_vala_icalrecurrencetype_get_by_month")]
		public short get_by_month (uint index) {
			if (index > ICal.Size.BY_MONTH) {
				return ICal.RecurrenceArrayMaxValues.RECURRENCE_ARRAY_MAX;
			}

			return by_month[index];
		}
		[CCode (cname = "_vala_icalrecurrencetype_get_by_month_array")]
		public GLib.Array<short> get_by_month_array () {
			var array = new GLib.Array<short> (false, false, sizeof (short));
			array.append_vals (by_day, ICal.Size.BY_MONTH);
			return array;
		}
		[CCode (cname = "_vala_icalrecurrencetype_set_by_month_array")]
		public static void set_by_month_array (ref ICal.Recurrence self, GLib.Array<short> values) {
			int ii = 0;
			for (ii = 0; ii < values.length && ii < ICal.Size.BY_MONTH; ii++) {
				self.by_month[ii] = values.index (ii);
			}

			if (ii < ICal.Size.BY_MONTH) {
				self.by_month[ii] = ICal.RecurrenceArrayMaxValues.RECURRENCE_ARRAY_MAX;
			}
		}
	}
	[CCode (cheader_filename = "libical/ical.h", cname = "icalreqstattype")]
	public struct RequestStatusType {
		public ICal.RequestStatus code;
		public weak string desc;
		public weak string debug;
		[CCode (cname = "icalreqstattype_as_string")]
		public unowned string as_string ();
		[CCode (cname = "icalreqstattype_as_string_r")]
		public unowned string as_string_r ();
		[CCode (cname = "icalreqstattype_from_string")]
		public static ICal.RequestStatusType from_string (string str);
	}
	[CCode (cheader_filename = "libical/ical.h", cname = "struct icaltimetype")]
	[SimpleType]
	public struct Time {
		public int year;
		public int month;
		public int day;
		public int hour;
		public int minute;
		public int second;
		public int is_utc;
		[CCode (cname = "is_date")]
		public int _is_date;
		public int is_daylight;
		public weak ICal.Timezone? zone;
		[CCode (cname = "icaltime_today", has_construct_function = false)]
		public ICal.Time.today ();
		[CCode (cname = "icaltime_from_day_of_year", has_construct_function = false)]
		public ICal.Time.from_day_of_year (int doy, int year);
		[CCode (cname = "icaltime_from_string", has_construct_function = false)]
		public ICal.Time.from_string (string str);
		[CCode (cname = "icaltime_from_string_with_zone", has_construct_function = false)]
		public ICal.Time.from_string_with_zone (string str, ICal.Timezone zone);
		[CCode (cname = "icaltime_from_timet_with_zone", has_construct_function = false)]
		public ICal.Time.from_timet_with_zone (time_t tm, int is_date, ICal.Timezone? zone);
		[CCode (cname = "icaltime_from_week_number", has_construct_function = false)]
		public ICal.Time.from_week_number (int week_number, int year);
		[CCode (cname = "icaltime_current_time_with_zone", has_construct_function = false)]
		public ICal.Time.current_time_with_zone (ICal.Timezone zone);
		[CCode (cname = "icaltime_null_date", has_construct_function = false)]
		public ICal.Time.null_date ();
		[CCode (cname = "icaltime_null_time", has_construct_function = false)]
		public ICal.Time.null_time ();
		[CCode (cname = "_vala_icaltime_clone")]
		public ICal.Time clone () {
			return ICal.Time.from_timet_with_zone (this.as_timet_with_zone (this.zone), this._is_date, this.zone);
		}
		[CCode (cname = "icaltime_add")]
		public ICal.Time add (ICal.Duration d);
		[CCode (cname = "icaltime_adjust")]
		public static void adjust (out ICal.Time time_type, int days, int hours, int minutes, int seconds);
		[CCode (cname = "icaltime_as_ical_string")]
		public unowned string as_ical_string ();
		[CCode (cname = "icaltime_as_ical_string_r")]
		public unowned string as_ical_string_r ();
		[CCode (cname = "icaltime_as_timet")]
		public time_t as_timet ();
		[CCode (cname = "icaltime_as_timet_with_zone")]
		public time_t as_timet_with_zone (ICal.Timezone zone);
		[CCode (cname = "icaltime_compare")]
		public int compare (ICal.Time b);
		[CCode (cname = "icaltime_compare_date_only")]
		public int compare_date_only (ICal.Time b);
		[CCode (cname = "icaltime_compare_date_only_tz")]
		public int compare_date_only_tz (ICal.Time b, ICal.Timezone tz);
		[CCode (cname = "icaltime_compare_with_zone")]
		public int compare_with_zone (ICal.Time b);
		[CCode (cname = "icaltime_convert_to_zone")]
		public ICal.Time convert_to_zone (ICal.Timezone zone);
		[CCode (cname = "icaltime_day_of_week")]
		public int day_of_week ();
		[CCode (cname = "icaltime_day_of_year")]
		public int day_of_year ();
		[CCode (cname = "icaltime_days_in_month")]
		public int days_in_month (int month, int year);
		[CCode (cname = "icaltime_days_in_year")]
		public int days_in_year (int year);
		[CCode (cname = "icaltime_get_timezone")]
		public unowned ICal.Timezone get_timezone ();
		[CCode (cname = "icaltime_get_tzid")]
		public unowned string get_tzid ();
		[CCode (cname = "icaltime_is_date")]
		private int is_it_date ();
		[CCode (cname = "_vala_icaltime_is_date")]
		public bool is_date () {
			return is_it_date () != 0;
		}
		[CCode (cname = "icaltime_is_floating")]
		public int is_floating ();
		[CCode (cname = "icaltime_is_leap_year")]
		public int is_leap_year (int year);
		[CCode (cname = "icaltime_is_null_time")]
		private int is_it_null_time ();
		[CCode (cname = "_vala_icaltime_is_null_time")]
		public bool is_null_time () {
			return is_it_null_time () != 0;
		}
		[CCode (cname = "icaltime_is_utc")]
		public int is_it_utc ();
		[CCode (cname = "icaltime_is_valid_time")]
		public int is_valid_time ();
		[CCode (cname = "icaltime_normalize")]
		public ICal.Time normalize ();
		[CCode (cname = "icaltime_start_doy_of_week")]
		public int start_doy_of_week ();
		[CCode (cname = "icaltime_start_doy_week")]
		public int start_doy_week (int fdow);
		[CCode (cname = "icaltime_subtract")]
		public unowned ICal.Duration subtract (ICal.Time t2);
		[CCode (cname = "icaltime_week_number")]
		public int week_number ();
		[CCode (cname = "_vala_icaltime_get_day")]
		public int get_day () {
			return this.day;
		}
	}
	[CCode (cheader_filename = "libical/ical.h", cname = "icalperiodtype")]
	public struct TriggerType {
		public ICal.Time time;
		public weak ICal.Duration duration;
		[CCode (cname = "icaltriggertype_from_int")]
		public static ICal.TriggerType from_int (int reltime);
		[CCode (cname = "icaltriggertype_from_string")]
		public static ICal.TriggerType from_string (string str);
		[CCode (cname = "icaltriggertype_is_bad_trigger")]
		public int is_bad ();
		[CCode (cname = "icaltriggertype_is_null_trigger")]
		public int is_null ();
	}
	[CCode (cheader_filename = "libical/ical.h")]
	public struct sspm_action_map {
		public weak ICal.sspm_major_type major;
		public weak ICal.sspm_minor_type minor;
		public weak GLib.Callback new_part;
		public weak GLib.Callback add_line;
		public weak GLib.Callback end_part;
		public weak GLib.Callback free_part;
	}
	[CCode (cheader_filename = "libical/ical.h")]
	public struct sspm_header {
		public int def;
		public weak string boundary;
		public weak ICal.sspm_major_type major;
		public weak ICal.sspm_minor_type minor;
		public weak string minor_text;
		public weak string content_type_params;
		public weak string charset;
		public weak ICal.sspm_encoding encoding;
		public weak string filename;
		public weak string content_id;
		public weak ICal.sspm_error error;
		public weak string error_text;
	}
	[CCode (cheader_filename = "libical/ical.h")]
	public struct sspm_part {
		public ICal.sspm_header header;
		public int level;
		public size_t data_size;
		public void* data;
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_", has_type_id = false)]
	public enum ComponentKind {
		NO_COMPONENT,
		ANY_COMPONENT,
		XROOT_COMPONENT,
		XATTACH_COMPONENT,
		VEVENT_COMPONENT,
		VTODO_COMPONENT,
		VJOURNAL_COMPONENT,
		VCALENDAR_COMPONENT,
		VAGENDA_COMPONENT,
		VFREEBUSY_COMPONENT,
		VALARM_COMPONENT,
		XAUDIOALARM_COMPONENT,
		XDISPLAYALARM_COMPONENT,
		XEMAILALARM_COMPONENT,
		XPROCEDUREALARM_COMPONENT,
		VTIMEZONE_COMPONENT,
		XSTANDARD_COMPONENT,
		XDAYLIGHT_COMPONENT,
		X_COMPONENT,
		VSCHEDULE_COMPONENT,
		VQUERY_COMPONENT,
		VREPLY_COMPONENT,
		VCAR_COMPONENT,
		VCOMMAND_COMPONENT,
		XLICINVALID_COMPONENT,
		XLICMIMEPART_COMPONENT,
		VAVAILABILITY_COMPONENT,
		XAVAILABLE_COMPONENT,
		VPOLL_COMPONENT,
		VVOTER_COMPONENT,
		XVOTE_COMPONENT;
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_", has_type_id = false)]
	public enum Error {
		[CCode (cname = "ICAL_NO_ERROR")]
		NO,
		[CCode (cname = "ICAL_BADARG_ERROR")]
		BADARG,
		[CCode (cname = "ICAL_NEWFAILED_ERROR")]
		NEWFAILED,
		[CCode (cname = "ICAL_ALLOCATION_ERROR")]
		ALLOCATION,
		[CCode (cname = "ICAL_MALFORMEDDATA_ERROR")]
		MALFORMEDDATA,
		[CCode (cname = "ICAL_PARSE_ERROR")]
		PARSE,
		[CCode (cname = "ICAL_INTERNAL_ERROR")]
		INTERNAL,
		[CCode (cname = "ICAL_FILE_ERROR")]
		FILE,
		[CCode (cname = "ICAL_USAGE_ERROR")]
		USAGE,
		[CCode (cname = "ICAL_UNIMPLEMENTED_ERROR")]
		UNIMPLEMENTED,
		[CCode (cname = "ICAL_UNKNOWN_ERROR")]
		UNKNOWN
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_ERROR_", has_type_id = false)]
	public enum ErrorState {
		FATAL,
		NONFATAL,
		DEFAULT,
		UNKNOWN
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_ACTIONPARAM_", has_type_id = false)]
	public enum ParameterAction {
		X,
		ASK,
		ABORT,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_CUTYPE_", has_type_id = false)]
	public enum ParameterCutype {
		X,
		INDIVIDUAL,
		GROUP,
		RESOURCE,
		ROOM,
		UNKNOWN,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_ENABLE_", has_type_id = false)]
	public enum ParameterEnable {
		X,
		TRUE,
		FALSE,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_ENCODING_", has_type_id = false)]
	public enum ParameterEncoding {
		X,
		@8BIT,
		BASE64,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_FBTYPE_", has_type_id = false)]
	public enum ParameterFbType {
		X,
		FREE,
		BUSY,
		BUSYUNAVAILABLE,
		BUSYTENTATIVE,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_", has_type_id = false)]
	public enum ParameterKind {
		ANY_PARAMETER,
		ACTIONPARAM_PARAMETER,
		ALTREP_PARAMETER,
		CHARSET_PARAMETER,
		CN_PARAMETER,
		CUTYPE_PARAMETER,
		DELEGATEDFROM_PARAMETER,
		DELEGATEDTO_PARAMETER,
		DIR_PARAMETER,
		ENABLE_PARAMETER,
		ENCODING_PARAMETER,
		FBTYPE_PARAMETER,
		FILENAME_PARAMETER,
		FMTTYPE_PARAMETER,
		IANA_PARAMETER,
		ID_PARAMETER,
		LANGUAGE_PARAMETER,
		LATENCY_PARAMETER,
		LOCAL_PARAMETER,
		LOCALIZE_PARAMETER,
		MANAGEDID_PARAMETER,
		MEMBER_PARAMETER,
		MODIFIED_PARAMETER,
		OPTIONS_PARAMETER,
		PARTSTAT_PARAMETER,
		PUBLICCOMMENT_PARAMETER,
		RANGE_PARAMETER,
		REASON_PARAMETER,
		RELATED_PARAMETER,
		RELTYPE_PARAMETER,
		REQUIRED_PARAMETER,
		RESPONSE_PARAMETER,
		ROLE_PARAMETER,
		RSVP_PARAMETER,
		SCHEDULEAGENT_PARAMETER,
		SCHEDULEFORCESEND_PARAMETER,
		SCHEDULESTATUS_PARAMETER,
		SENTBY_PARAMETER,
		SIZE_PARAMETER,
		STAYINFORMED_PARAMETER,
		SUBSTATE_PARAMETER,
		TZID_PARAMETER,
		VALUE_PARAMETER,
		X_PARAMETER,
		XLICCOMPARETYPE_PARAMETER,
		XLICERRORTYPE_PARAMETER,
		NO_PARAMETER;
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_LOCAL_", has_type_id = false)]
	public enum ParameterLocal {
		X,
		TRUE,
		FALSE,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_PARTSTAT_", has_type_id = false, cname = "icalproperty_status")]
	public enum ParameterPartstat {
		X,
		NEEDSACTION,
		ACCEPTED,
		DECLINED,
		TENTATIVE,
		DELEGATED,
		COMPLETED,
		INPROCESS,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_RANGE_", has_type_id = false)]
	public enum ParameterRange {
		X,
		THISANDPRIOR,
		THISANDFUTURE,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_RELATED_", has_type_id = false)]
	public enum ParameterRelated {
		X,
		START,
		END,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_RELTYPE_", has_type_id = false)]
	public enum ParameterRelationType {
		X,
		PARENT,
		CHILD,
		SIBLING,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_ROLE_", has_type_id = false)]
	public enum ParameterRole {
		X,
		CHAIR,
		REQPARTICIPANT,
		OPTPARTICIPANT,
		NONPARTICIPANT,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_RSVP_", has_type_id = false)]
	public enum ParameterRsvp {
		X,
		TRUE,
		FALSE,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_VALUE_", has_type_id = false)]
	public enum ParameterValue {
		X,
		BINARY,
		BOOLEAN,
		DATE,
		DURATION,
		FLOAT,
		INTEGER,
		PERIOD,
		RECUR,
		TEXT,
		URI,
		ERROR,
		DATETIME,
		UTCOFFSET,
		CALADDRESS,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_XLICCOMPARETYPE_", has_type_id = false)]
	public enum ParameterXlicCompareType {
		X,
		EQUAL,
		NOTEQUAL,
		LESS,
		GREATER,
		LESSEQUAL,
		GREATEREQUAL,
		REGEX,
		ISNULL,
		ISNOTNULL,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_XLICERRORTYPE_", has_type_id = false)]
	public enum ParameterXlicErrorType {
		X,
		[CCode (cname = "ICAL_XLICERRORTYPE_COMPONENTPARSEERROR")]
		COMPONENT_PARSE,
		[CCode (cname = "ICAL_XLICERRORTYPE_PROPERTYPARSEERROR")]
		PROPERTY_PARSE,
		[CCode (cname = "ICAL_XLICERRORTYPE_PARAMETERNAMEPARSEERROR")]
		PARAMETER_NAME_PARSE,
		[CCode (cname = "ICAL_XLICERRORTYPE_PARAMETERVALUEPARSEERROR")]
		PARAMETER_VALUE_PARSE,
		[CCode (cname = "ICAL_XLICERRORTYPE_VALUEPARSEERROR")]
		VALUE_PARSE,
		[CCode (cname = "ICAL_XLICERRORTYPE_INVALIDITIP")]
		INVALID_ITIP,
		[CCode (cname = "ICAL_XLICERRORTYPE_UNKNOWNVCALPROPERROR")]
		UNKNOWN_VCAL_PROPERTY,
		[CCode (cname = "ICAL_XLICERRORTYPE_MIMEPARSEERROR")]
		MIME_PARSE,
		[CCode (cname = "ICAL_XLICERRORTYPE_VCALPROPPARSEERROR")]
		VCAL_PROPERTY_PARSE,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICALPARSER_", has_type_id = false)]
	public enum ParserState {
		ERROR,
		SUCCESS,
		BEGIN_COMP,
		END_COMP,
		IN_PROGRESS
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_ACTION_", has_type_id = false, cname = "icalproperty_action")]
	public enum PropertyAction {
		X,
		AUDIO,
		DISPLAY,
		EMAIL,
		PROCEDURE,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_CARLEVEL_", has_type_id = false, cname = "icalproperty_carlevel")]
	public enum PropertyCarlevel {
		X,
		CARNONE,
		CARMIN,
		CARFULL1,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_CLASS_", has_type_id = false, cname = "icalproperty_class")]
	public enum PropertyClass {
		X,
		PUBLIC,
		PRIVATE,
		CONFIDENTIAL,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_CMD_", has_type_id = false, cname = "icalproperty_cmd")]
	public enum PropertyCmd {
		X,
		ABORT,
		CONTINUE,
		CREATE,
		DELETE,
		GENERATEUID,
		GETCAPABILITY,
		IDENTIFY,
		MODIFY,
		MOVE,
		REPLY,
		SEARCH,
		SETLOCALE,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_", has_type_id = false, cname = "icalproperty_kind")]
	public enum PropertyKind {
		ANY_PROPERTY,
		ACCEPTRESPONSE_PROPERTY,
		ACKNOWLEDGED_PROPERTY,
		ACTION_PROPERTY,
		ALLOWCONFLICT_PROPERTY,
		ATTACH_PROPERTY,
		ATTENDEE_PROPERTY,
		BUSYTYPE_PROPERTY,
		CALID_PROPERTY,
		CALMASTER_PROPERTY,
		CALSCALE_PROPERTY,
		CAPVERSION_PROPERTY,
		CARLEVEL_PROPERTY,
		CARID_PROPERTY,
		CATEGORIES_PROPERTY,
		CLASS_PROPERTY,
		CMD_PROPERTY,
		COLOR_PROPERTY,
		COMMENT_PROPERTY,
		COMPLETED_PROPERTY,
		COMPONENTS_PROPERTY,
		CONTACT_PROPERTY,
		CREATED_PROPERTY,
		CSID_PROPERTY,
		DATEMAX_PROPERTY,
		DATEMIN_PROPERTY,
		DECREED_PROPERTY,
		DEFAULTCHARSET_PROPERTY,
		DEFAULTLOCALE_PROPERTY,
		DEFAULTTZID_PROPERTY,
		DEFAULTVCARS_PROPERTY,
		DENY_PROPERTY,
		DESCRIPTION_PROPERTY,
		DTEND_PROPERTY,
		DTSTAMP_PROPERTY,
		DTSTART_PROPERTY,
		DUE_PROPERTY,
		DURATION_PROPERTY,
		ESTIMATEDDURATION_PROPERTY,
		EXDATE_PROPERTY,
		EXPAND_PROPERTY,
		EXRULE_PROPERTY,
		FREEBUSY_PROPERTY,
		GEO_PROPERTY,
		GRANT_PROPERTY,
		ITIPVERSION_PROPERTY,
		LASTMODIFIED_PROPERTY,
		LOCATION_PROPERTY,
		MAXCOMPONENTSIZE_PROPERTY,
		MAXDATE_PROPERTY,
		MAXRESULTS_PROPERTY,
		MAXRESULTSSIZE_PROPERTY,
		METHOD_PROPERTY,
		MINDATE_PROPERTY,
		MULTIPART_PROPERTY,
		NAME_PROPERTY,
		ORGANIZER_PROPERTY,
		OWNER_PROPERTY,
		PERCENTCOMPLETE_PROPERTY,
		PERMISSION_PROPERTY,
		POLLCOMPLETION_PROPERTY,
		POLLITEMID_PROPERTY,
		POLLMODE_PROPERTY,
		POLLPROPERTIES_PROPERTY,
		POLLWINNER_PROPERTY,
		PRIORITY_PROPERTY,
		PRODID_PROPERTY,
		QUERY_PROPERTY,
		QUERYLEVEL_PROPERTY,
		QUERYID_PROPERTY,
		QUERYNAME_PROPERTY,
		RDATE_PROPERTY,
		RECURACCEPTED_PROPERTY,
		RECUREXPAND_PROPERTY,
		RECURLIMIT_PROPERTY,
		RECURRENCEID_PROPERTY,
		RELATEDTO_PROPERTY,
		RELCALID_PROPERTY,
		REPEAT_PROPERTY,
		REPLYURL_PROPERTY,
		REQUESTSTATUS_PROPERTY,
		RESOURCES_PROPERTY,
		RESPONSE_PROPERTY,
		RESTRICTION_PROPERTY,
		RRULE_PROPERTY,
		SCOPE_PROPERTY,
		SEQUENCE_PROPERTY,
		STATUS_PROPERTY,
		STORESEXPANDED_PROPERTY,
		SUMMARY_PROPERTY,
		TARGET_PROPERTY,
		TASKMODE_PROPERTY,
		TRANSP_PROPERTY,
		TRIGGER_PROPERTY,
		TZID_PROPERTY,
		TZIDALIASOF_PROPERTY,
		TZNAME_PROPERTY,
		TZOFFSETFROM_PROPERTY,
		TZOFFSETTO_PROPERTY,
		TZUNTIL_PROPERTY,
		TZURL_PROPERTY,
		UID_PROPERTY,
		URL_PROPERTY,
		VERSION_PROPERTY,
		VOTER_PROPERTY,
		X_PROPERTY,
		XLICCLASS_PROPERTY,
		XLICCLUSTERCOUNT_PROPERTY,
		XLICERROR_PROPERTY,
		XLICMIMECHARSET_PROPERTY,
		XLICMIMECID_PROPERTY,
		XLICMIMECONTENTTYPE_PROPERTY,
		XLICMIMEENCODING_PROPERTY,
		XLICMIMEFILENAME_PROPERTY,
		XLICMIMEOPTINFO_PROPERTY,
		NO_PROPERTY
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_METHOD_", has_type_id = false, cname = "icalproperty_method")]
	public enum PropertyMethod {
		X,
		PUBLISH,
		REQUEST,
		REPLY,
		ADD,
		CANCEL,
		REFRESH,
		COUNTER,
		DECLINECOUNTER,
		CREATE,
		READ,
		RESPONSE,
		MOVE,
		MODIFY,
		GENERATEUID,
		DELETE,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_QUERYLEVEL_", has_type_id = false, cname = "icalproperty_querylevel")]
	public enum PropertyQueryLevel {
		X,
		CALQL1,
		CALQLNONE,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_STATUS_", has_type_id = false, cname = "icalproperty_status")]
	public enum PropertyStatus {
		X,
		TENTATIVE,
		CONFIRMED,
		COMPLETED,
		NEEDSACTION,
		CANCELLED,
		INPROCESS,
		DRAFT,
		FINAL,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_TRANSP_", has_type_id = false, cname = "icalproperty_transp")]
	public enum PropertyTransparency {
		X,
		OPAQUE,
		OPAQUENOCONFLICT,
		TRANSPARENT,
		TRANSPARENTNOCONFLICT,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_XLICCLASS_", has_type_id = false, cname = "icalproperty_xlicclass")]
	public enum PropertyXlicClass {
		X,
		PUBLISHNEW,
		PUBLISHUPDATE,
		PUBLISHFREEBUSY,
		REQUESTNEW,
		REQUESTUPDATE,
		REQUESTRESCHEDULE,
		REQUESTDELEGATE,
		REQUESTNEWORGANIZER,
		REQUESTFORWARD,
		REQUESTSTATUS,
		REQUESTFREEBUSY,
		REPLYACCEPT,
		REPLYDECLINE,
		REPLYDELEGATE,
		REPLYCRASHERACCEPT,
		REPLYCRASHERDECLINE,
		ADDINSTANCE,
		CANCELEVENT,
		CANCELINSTANCE,
		CANCELALL,
		REFRESH,
		COUNTER,
		DECLINECOUNTER,
		MALFORMED,
		OBSOLETE,
		MISSEQUENCED,
		UNKNOWN,
		NONE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_", has_type_id = false)]
	public enum RecurrenceArrayMaxValues {
		[CCode (cname = "ICAL_RECURRENCE_ARRAY_MAX")]
		RECURRENCE_ARRAY_MAX
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_", cname = "icalrecurrencetype_frequency")]
	public enum RecurrenceFrequency {
		SECONDLY_RECURRENCE,
		MINUTELY_RECURRENCE,
		HOURLY_RECURRENCE,
		DAILY_RECURRENCE,
		WEEKLY_RECURRENCE,
		MONTHLY_RECURRENCE,
		YEARLY_RECURRENCE,
		NO_RECURRENCE
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_", cname = "icalrecurrencetype_weekday")]
	public enum RecurrenceWeekday {
		NO_WEEKDAY,
		SUNDAY_WEEKDAY,
		MONDAY_WEEKDAY,
		TUESDAY_WEEKDAY,
		WEDNESDAY_WEEKDAY,
		THURSDAY_WEEKDAY,
		FRIDAY_WEEKDAY,
		SATURDAY_WEEKDAY
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_", has_type_id = false)]
	public enum RequestStatus {
		UNKNOWN_STATUS,
		@2_0_SUCCESS_STATUS,
		@2_1_FALLBACK_STATUS,
		@2_2_IGPROP_STATUS,
		@2_3_IGPARAM_STATUS,
		@2_4_IGXPROP_STATUS,
		@2_5_IGXPARAM_STATUS,
		@2_6_IGCOMP_STATUS,
		@2_7_FORWARD_STATUS,
		@2_8_ONEEVENT_STATUS,
		@2_9_TRUNC_STATUS,
		@2_10_ONETODO_STATUS,
		@2_11_TRUNCRRULE_STATUS,
		@3_0_INVPROPNAME_STATUS,
		@3_1_INVPROPVAL_STATUS,
		@3_2_INVPARAM_STATUS,
		@3_3_INVPARAMVAL_STATUS,
		@3_4_INVCOMP_STATUS,
		@3_5_INVTIME_STATUS,
		@3_6_INVRULE_STATUS,
		@3_7_INVCU_STATUS,
		@3_8_NOAUTH_STATUS,
		@3_9_BADVERSION_STATUS,
		@3_10_TOOBIG_STATUS,
		@3_11_MISSREQCOMP_STATUS,
		@3_12_UNKCOMP_STATUS,
		@3_13_BADCOMP_STATUS,
		@3_14_NOCAP_STATUS,
		@3_15_INVCOMMAND,
		@4_0_BUSY_STATUS,
		@4_1_STORE_ACCESS_DENIED,
		@4_2_STORE_FAILED,
		@4_3_STORE_NOT_FOUND,
		@5_0_MAYBE_STATUS,
		@5_1_UNAVAIL_STATUS,
		@5_2_NOSERVICE_STATUS,
		@5_3_NOSCHED_STATUS,
		@6_1_CONTAINER_NOT_FOUND,
		@9_0_UNRECOGNIZED_COMMAND;
		[CCode (cheader_filename = "libical/ical.h", cname = "icalenum_num_to_reqstat")]
		public static ICal.RequestStatus num_to_reqstat (short major, short minor);
		[CCode (cheader_filename = "libical/ical.h", cname = "icalenum_reqstat_code")]
		public static unowned string code (ICal.RequestStatus stat);
		[CCode (cheader_filename = "libical/ical.h", cname = "icalenum_reqstat_code_r")]
		public static unowned string code_r (ICal.RequestStatus stat);
		[CCode (cheader_filename = "libical/ical.h", cname = "icalenum_reqstat_desc")]
		public static unowned string description (ICal.RequestStatus stat);
		[CCode (cheader_filename = "libical/ical.h", cname = "icalenum_reqstat_major")]
		public static short major (ICal.RequestStatus stat);
		[CCode (cheader_filename = "libical/ical.h", cname = "icalenum_reqstat_minor")]
		public static short minor (ICal.RequestStatus stat);
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_RESTRICTION_", has_type_id = false)]
	public enum RestrictionKind {
		NONE,
		ZERO,
		ONE,
		ZEROPLUS,
		ONEPLUS,
		ZEROORONE,
		ONEEXCLUSIVE,
		ONEMUTUAL,
		UNKNOWN;
		[CCode (cheader_filename = "libical/ical.h", cname = "icalrestriction_check")]
		public static int check (ICal.Component  comp);
		[CCode (cheader_filename = "libical/ical.h", cname = "icalrestriction_compare")]
		public static int compare (ICal.RestrictionKind restr, int count);
		[CCode (cheader_filename = "libical/ical.h", cname = "icalrestriction_is_parameter_allowed")]
		public static int is_parameter_allowed (ICal.PropertyKind property, ICal.ParameterKind parameter);
	}
	[CCode (cheader_filename = "libical/ical.h", cprefix = "ICAL_", has_type_id = false)]
	public enum ValueKind {
		ANY_VALUE,
		QUERY_VALUE,
		DATE_VALUE,
		ATTACH_VALUE,
		GEO_VALUE,
		STATUS_VALUE,
		TRANSP_VALUE,
		STRING_VALUE,
		TEXT_VALUE,
		REQUESTSTATUS_VALUE,
		CMD_VALUE,
		BINARY_VALUE,
		QUERYLEVEL_VALUE,
		PERIOD_VALUE,
		FLOAT_VALUE,
		DATETIMEPERIOD_VALUE,
		CARLEVEL_VALUE,
		INTEGER_VALUE,
		CLASS_VALUE,
		URI_VALUE,
		DURATION_VALUE,
		BOOLEAN_VALUE,
		X_VALUE,
		CALADDRESS_VALUE,
		TRIGGER_VALUE,
		XLICCLASS_VALUE,
		RECUR_VALUE,
		ACTION_VALUE,
		DATETIME_VALUE,
		UTCOFFSET_VALUE,
		METHOD_VALUE,
		NO_VALUE
	}
	public delegate void ForeachRecurrenceCb (ICal.Component comp, ICal.TimeSpan span);
	[CCode (cheader_filename = "libical/ical.h")]
	public delegate void icalattach_free_fn_t (uint data);
	[CCode (cheader_filename = "libical/ical.h", has_target = false)]
	public delegate void pvl_applyf (void* a, void* b);
	[CCode (cheader_filename = "libical/ical.h", has_target = false)]
	public delegate int pvl_comparef (void* a, void* b);
	[CCode (cheader_filename = "libical/ical.h", has_target = false)]
	public delegate int pvl_findf (void* a, void* b);
	[CCode (cheader_filename = "libical/ical.h")]
	public const int ICALPARAMETER_FIRST_ENUM;
	[CCode (cheader_filename = "libical/ical.h")]
	public const int ICALPARAMETER_LAST_ENUM;
	[CCode (cheader_filename = "libical/ical.h")]
	public const int ICALPROPERTY_FIRST_ENUM;
	[CCode (cheader_filename = "libical/ical.h")]
	public const int ICALPROPERTY_LAST_ENUM;
	[CCode (cheader_filename = "libical/ical.h")]
	public const string PACKAGE;
	[CCode (cheader_filename = "libical/ical.h")]
	public const string VERSION;
	[CCode (cheader_filename = "libical/ical.h", cname = "decode_base64")]
	public static unowned string decode_base64 (string dest, string src, size_t size);
	[CCode (cheader_filename = "libical/ical.h", cname = "decode_quoted_printable")]
	public static unowned string decode_quoted_printable (string dest, string src, size_t size);
	[CCode (cheader_filename = "libical/ical.h", cname = "free_zone_directory")]
	public static void free_zone_directory ();
	[CCode (cheader_filename = "libical/ical.h", cname = "ical_bt")]
	public static void ical_bt ();
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerrno_return")]
	public static ICal.Error errno_return ();
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerror_clear_errno")]
	public static void error_clear_errno ();
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerror_crash_here")]
	public static void error_crash_here ();
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerror_get_error_state")]
	public static ICal.ErrorState error_get_error_state (ICal.Error error);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerror_perror")]
	public static unowned string error_perror ();
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerror_restore")]
	public static void error_restore (string error, ICal.ErrorState es);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerror_set_errno")]
	public static void error_set_errno (ICal.Error x);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerror_set_error_state")]
	public static void error_set_error_state (ICal.Error error, ICal.ErrorState p2);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerror_stop_here")]
	public static void error_stop_here ();
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerror_strerror")]
	public static unowned string error_strerror (ICal.Error e);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalerror_supress")]
	public static ICal.ErrorState error_supress (string error);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_access_array")]
	public static int langbind_access_array (int array, int index);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_free_array")]
	public static void langbind_free_array (int array);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_get_component")]
	public static unowned ICal.Component  langbind_get_component (ICal.Component  c, string comp);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_get_first_component")]
	public static unowned ICal.Component  langbind_get_first_component (ICal.Component  c, string comp);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_get_first_parameter")]
	public static unowned ICal.Parameter langbind_get_first_parameter (ICal.Property prop);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_get_first_property")]
	public static unowned ICal.Property langbind_get_first_property (ICal.Component  c, string prop);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_get_next_component")]
	public static unowned ICal.Component  langbind_get_next_component (ICal.Component  c, string comp);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_get_next_parameter")]
	public static unowned ICal.Parameter langbind_get_next_parameter (ICal.Property prop);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_get_next_property")]
	public static unowned ICal.Property langbind_get_next_property (ICal.Component  c, string prop);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_get_parameter")]
	public static unowned string langbind_get_parameter (ICal.Property p, string parameter);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_get_property")]
	public static unowned ICal.Property langbind_get_property (ICal.Component  c, int n, string prop);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_get_property_val")]
	public static unowned string langbind_get_property_val (ICal.Property p);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_new_array")]
	public static int langbind_new_array (int size);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_property_eval_string")]
	public static unowned string langbind_property_eval_string (ICal.Property prop, string sep);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_property_eval_string_r")]
	public static unowned string langbind_property_eval_string_r (ICal.Property prop, string sep);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_quote_as_ical")]
	public static unowned string langbind_quote_as_ical (string str);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_quote_as_ical_r")]
	public static unowned string langbind_quote_as_ical_r (string str);
	[CCode (cheader_filename = "libical/ical.h", cname = "icallangbind_string_to_open_flag")]
	public static int langbind_string_to_open_flag (string str);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmemory_add_tmp_buffer")]
	public static void memory_add_tmp_buffer (void* p1);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmemory_append_char")]
	public static void memory_append_char (out unowned string buf, out unowned string pos, size_t buf_size, GLib.ObjectPath ch);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmemory_append_string")]
	public static void memory_append_string (out unowned string buf, out unowned string pos, size_t buf_size, string str);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmemory_free_buffer")]
	public static void memory_free_buffer (void* buf);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmemory_free_ring")]
	public static void memory_free_ring ();
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmemory_new_buffer")]
	public static void* memory_new_buffer (size_t size);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmemory_resize_buffer")]
	public static void* memory_resize_buffer (void* buf, size_t size);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmemory_strdup")]
	public static unowned string memory_strdup (string s);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmemory_tmp_buffer")]
	public static void* memory_tmp_buffer (size_t size);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmemory_tmp_copy")]
	public static unowned string memory_tmp_copy (string str);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmime_as_mime_string")]
	public static unowned string mime_as_mime_string (string component);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalmime_parse")]
	public static unowned ICal.Component mime_parse (GLib.Callback line_gen_func, void* data);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalrecur_expand_recurrence")]
	public static int recur_expand_recurrence (string rule, time_t start, [CCode (array_length_pos = 2, array_length_type = "int")] time_t[] array);
	[CCode (cheader_filename = "libical/ical.h", cname = "icalrecur_string_to_weekday")]
	public static ICal.RecurrenceWeekday icalrecur_string_to_weekday (string str);
	[CCode (cheader_filename = "libical/ical.h", cname = "set_zone_directory")]
	public static void set_zone_directory (string path);
	
	namespace Size {
		[CCode (cheader_filename = "libical/ical.h", cname = "ICAL_BY_DAY_SIZE")]
		public const int BY_SECOND;
		[CCode (cheader_filename = "libical/ical.h", cname = "ICAL_BY_MINUTE_SIZE")]
		public const int BY_MINUTE;
		[CCode (cheader_filename = "libical/ical.h", cname = "ICAL_BY_HOUR_SIZE")]
		public const int BY_HOUR;
		[CCode (cheader_filename = "libical/ical.h", cname = "ICAL_BY_DAY_SIZE")]
		public const int BY_DAY;
		[CCode (cheader_filename = "libical/ical.h", cname = "ICAL_BY_MONTHDAY_SIZE")]
		public const int BY_MONTHDAY;
		[CCode (cheader_filename = "libical/ical.h", cname = "ICAL_BY_YEARDAY_SIZE")]
		public const int BY_YEARDAY;
		[CCode (cheader_filename = "libical/ical.h", cname = "ICAL_BY_WEEKNO_SIZE")]
		public const int BY_WEEKNO;
		[CCode (cheader_filename = "libical/ical.h", cname = "ICAL_BY_MONTH_SIZE")]
		public const int BY_MONTH;
		[CCode (cheader_filename = "libical/ical.h", cname = "ICAL_BY_SETPOS_SIZE")]
		public const int BY_SETPOS;
	}
}
