use cctk::{
    cosmic_protocols::toplevel_management::v1::client::zcosmic_toplevel_manager_v1,
    toplevel_info::ToplevelInfo, wayland_client::Connection,
    wayland_protocols::ext::foreign_toplevel_list::v1::client::ext_foreign_toplevel_handle_v1,
};
use wayland_backend::protocol::WEnum;

/// Handle events related to managing toplevels
pub trait ToplevelManagerSpace {
    /// Supported capabilities
    fn capabilities(
        &mut self,
        _: &Connection,
        _: Vec<WEnum<zcosmic_toplevel_manager_v1::ZcosmicToplelevelManagementCapabilitiesV1>>,
    );
}

/// handle events related to toplevels
pub trait ToplevelInfoSpace {
    /// A new toplevel was created
    fn new_toplevel(&mut self, _conn: &Connection, info: &ToplevelInfo);

    /// A toplevel was updated
    fn update_toplevel(&mut self, _conn: &Connection, info: &ToplevelInfo);

    /// A toplevel was closed
    fn toplevel_closed(
        &mut self,
        _conn: &Connection,
        toplevel: &ext_foreign_toplevel_handle_v1::ExtForeignToplevelHandleV1,
    );
}
