// Copyright 2023 System76 <info@system76.com>
// SPDX-License-Identifier: GPL-3.0-only
//! # DBus interface proxy for: `org.gnome.SessionManager`
//!
//! This code was generated by `zbus-xmlgen` `2.0.1` from DBus introspection data.
//! Source: `Interface '/org/gnome/SessionManager' from service 'org.gnome.SessionManager' on session bus`.
//!
//! You may prefer to adapt it, instead of using it verbatim.
//!
//! More information can be found in the
//! [Writing a client proxy](https://dbus.pages.freedesktop.org/zbus/client.html)
//! section of the zbus documentation.
//!
//! This DBus object implements
//! [standard DBus interfaces](https://dbus.freedesktop.org/doc/dbus-specification.html),
//! (`org.freedesktop.DBus.*`) for which the following zbus proxies can be used:
//!
//! * [`zbus::fdo::PropertiesProxy`]
//! * [`zbus::fdo::IntrospectableProxy`]
//! * [`zbus::fdo::PeerProxy`]
//!
//! …consequently `zbus-xmlgen` did not generate code for the above interfaces.

use zbus::proxy;

#[proxy(interface = "org.gnome.SessionManager", assume_defaults = true)]
pub trait SessionManager {
    /// CanRebootToFirmwareSetup method
    fn can_reboot_to_firmware_setup(&self) -> zbus::Result<bool>;

    /// CanShutdown method
    fn can_shutdown(&self) -> zbus::Result<bool>;

    /// GetClients method
    fn get_clients(&self) -> zbus::Result<Vec<zbus::zvariant::OwnedObjectPath>>;

    /// GetInhibitors method
    fn get_inhibitors(&self) -> zbus::Result<Vec<zbus::zvariant::OwnedObjectPath>>;

    /// GetLocale method
    fn get_locale(&self, category: i32) -> zbus::Result<String>;

    /// Inhibit method
    fn inhibit(
        &self,
        app_id: &str,
        toplevel_xid: u32,
        reason: &str,
        flags: u32,
    ) -> zbus::Result<u32>;

    /// InitializationError method
    fn initialization_error(&self, message: &str, fatal: bool) -> zbus::Result<()>;

    /// Initialized method
    fn initialized(&self) -> zbus::Result<()>;

    /// IsAutostartConditionHandled method
    fn is_autostart_condition_handled(&self, condition: &str) -> zbus::Result<bool>;

    /// IsInhibited method
    fn is_inhibited(&self, flags: u32) -> zbus::Result<bool>;

    /// IsSessionRunning method
    fn is_session_running(&self) -> zbus::Result<bool>;

    /// Logout method
    fn logout(&self, mode: u32) -> zbus::Result<()>;

    /// Reboot method
    fn reboot(&self) -> zbus::Result<()>;

    /// RegisterClient method
    fn register_client(
        &self,
        app_id: &str,
        client_startup_id: &str,
    ) -> zbus::Result<zbus::zvariant::OwnedObjectPath>;

    /// RequestReboot method
    fn request_reboot(&self) -> zbus::Result<()>;

    /// RequestShutdown method
    fn request_shutdown(&self) -> zbus::Result<()>;

    /// SetRebootToFirmwareSetup method
    fn set_reboot_to_firmware_setup(&self, enable: bool) -> zbus::Result<()>;

    /// Setenv method
    fn setenv(&self, variable: &str, value: &str) -> zbus::Result<()>;

    /// Shutdown method
    fn shutdown(&self) -> zbus::Result<()>;

    /// Uninhibit method
    fn uninhibit(&self, inhibit_cookie: u32) -> zbus::Result<()>;

    /// UnregisterClient method
    fn unregister_client(&self, client_id: &zbus::zvariant::ObjectPath<'_>) -> zbus::Result<()>;

    /// ClientAdded signal
    #[zbus(signal)]
    fn client_added(&self, id: zbus::zvariant::ObjectPath<'_>) -> zbus::Result<()>;

    /// ClientRemoved signal
    #[zbus(signal)]
    fn client_removed(&self, id: zbus::zvariant::ObjectPath<'_>) -> zbus::Result<()>;

    /// InhibitorAdded signal
    #[zbus(signal)]
    fn inhibitor_added(&self, id: zbus::zvariant::ObjectPath<'_>) -> zbus::Result<()>;

    /// InhibitorRemoved signal
    #[zbus(signal)]
    fn inhibitor_removed(&self, id: zbus::zvariant::ObjectPath<'_>) -> zbus::Result<()>;

    /// SessionOver signal
    #[zbus(signal)]
    fn session_over(&self) -> zbus::Result<()>;

    /// SessionRunning signal
    #[zbus(signal)]
    fn session_running(&self) -> zbus::Result<()>;

    /// InhibitedActions property
    #[zbus(property)]
    fn inhibited_actions(&self) -> zbus::Result<u32>;

    /// Renderer property
    #[zbus(property)]
    fn renderer(&self) -> zbus::Result<String>;

    /// SessionIsActive property
    #[zbus(property)]
    fn session_is_active(&self) -> zbus::Result<bool>;

    /// SessionName property
    #[zbus(property)]
    fn session_name(&self) -> zbus::Result<String>;
}
