# getDirectoryToWatchFailedLookupLocationInsubDirNonRecursive

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Unc root: //vda1cs4850/

## RootDirForResolution: //vda1cs4850/

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir                                                     | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir                                                       | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot/folder1

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir                                                         | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot/folder1/folder2

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir                                                 | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | true      |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | true      |                                                                                                          |

## RootDirForResolution: //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                 | getDirectoryToWatchFailedLookupLocation                                                                  | Recursive | Location if not symlink                                                                                  |
| -------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | --------- | -------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/dir/subdir/somefile.d.ts                                                                    |                                                                                                          |           |                                                                                                          |
| //vda1cs4850/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                          |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                          |
| //vda1cs4850/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/users/dir/subdir                                                                            | false     |                                                                                                          |
| //vda1cs4850/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/users/username/dir/subdir                                                                   | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                          |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                          |
| //vda1cs4850/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/user/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/user/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/usr/dir/subdir                                                                              | false     |                                                                                                          |
| //vda1cs4850/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/usr/username/dir/subdir                                                                     | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                          |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                          |
| //vda1cs4850/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/home/dir/subdir                                                                             | false     |                                                                                                          |
| //vda1cs4850/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/home/username/dir/subdir                                                                    | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                          |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                          |
| //vda1cs4850/workspaces/dir/subdir/somefile.d.ts                                                         | //vda1cs4850/workspaces/dir/subdir                                                                       | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | //vda1cs4850/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | //vda1cs4850/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                          |
| //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | //vda1cs4850/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | true      |                                                                                                          |

